<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
})->name('/');


Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth','verified'])->name('dashboard');

Route::get('/profile','App\Http\Controllers\Auth\AuthenticatedSessionController@userprofile')->middleware(['auth'])->name('profile');


Route::post('/profile','App\Http\Controllers\Auth\AuthenticatedSessionController@profile')->middleware(['auth'])->name('profile');


require __DIR__.'/auth.php';
