<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use \App\Mail\SendMail;
use Auth;
use DB;
use Session;

class Balance_info extends Model
{
    protected $fillable = [
        'user_id', 'amount', 'status',
    ];

    public static function get_wallet_balance($user_id)
    {
        $da = Balance_info::where(['user_id' => $user_id])->get();
        if ($da->count() > 0) {
            return number_format($da[0]->amount, 2);
        } else {
            return '0.00';
        }
    }

    public static function update_user_wallet_balance($user_id, $amount)
    {
        $q1 = Balance_info::where(['user_id' => $user_id])->get();
        if ($q1->count() > 0) {
            $old_amount = $q1[0]->amount;
            $tamount = $amount + $old_amount;
            $balance_info = Balance_info::where(['user_id' => $user_id])->update(['amount' => $tamount]);
        } else {
            $data = array('user_id' => $user_id, 'amount' => $amount, 'status' => 1);
            Balance_info::create($data);
        }
        $current_amount = Balance_info::get_wallet_balance($user_id);
        $setting = Setting::general_setting();
        $commission_value = $setting->commission_amount;
        $deduct_amount_value = $setting->deduction_amount;
        return true;
    }

    public static function get_affiliate_profile_pic($email)
    {
        $user = AffiliateRegistration::where('email', $email)->first();
        if (!empty($user->image)) {
            $img = asset('public/images/affiliates/' . $user->image);
        } else {
            $img = asset('public/images/affiliates/1603958653625_1612262104.jpg');
        }
        return '<img src="' . $img . '" style="width:100px;height:100px"  >';
    }

    public static function get_last_sponser_id($user_id, $upline_user_id)
    {
        $userData = User::where(['id' => $user_id])->first();
        if (!empty($userData)) {
            $user_id1 = $userData->sponsor_id;
            if ($user_id1 == 1 || $user_id == 1) {
            } else {
                $upline_user_id[] = $user_id;
                $upline_user_id = Balance_info::get_last_sponser_id($user_id1, $upline_user_id);
            }
        }
        return $upline_user_id;
    }

    public static function update_affiliate_bonus_income($user_id, $plan_id)
    {

        ini_set('max_execution_time', 300);

        $user = User::get_user_info($user_id);
        $sponsor_id = $user->sponsor_id;
        $plan = Plan::where('id', $plan_id)->first();
        $total_days_of_plan_subscribe = Balance_info::get_total_plan_day($sponsor_id);
        if ($total_days_of_plan_subscribe <= 35) {
            $amount = $plan->balance / 2;
        } else {
            $amount = $plan->balance / 2;
        }
        $user1 = User::get_user_info($sponsor_id);
        $sponsor_direct_members = User::where('sponsor_id', $sponsor_id)->count();
        $wallet_data = array(
            'user_id' => $user_id,
            'amount'  => 0,
            'status'  => 1,
        );
        $add_wallet_amount = Balance_info::create($wallet_data);
        $total_direct = $sponsor_direct_members;
        User::where('id', $sponsor_id)->update(array('direct_members' => $total_direct));
        $update_sponsor_wallet = Balance_info::update_user_wallet_balance($sponsor_id, $amount);
        $user = User::where('id', $sponsor_id)->first();
        $nuser = User::where('id', $user_id)->first();
        $newUser = AffiliateRegistration::where('email', $nuser->email)->first();
        $details = AffiliateRegistration::where('email', $user->email)->first();
        $allAffilates = AffiliateRegistration::where('religion', $newUser->religion)->where('email', '!=', $newUser->email)->get();
        $faith = FaithConnection::first();

        $oldEduDetails = EducationDetail::where('user_id', $details->id)->first();
        $newEduDetails = EducationDetail::where('user_id', $newUser->id)->first();
        $allSchlMates = EducationDetail::where('institute_id', $newEduDetails->institute_id)
            ->where('user_id', '!=', $newUser->id)->get();

        if (isset($faith)) {
            if ($faith->fath_religious != 0) {
                $faithAmount = $faith->fath_religious * $amount / 100;
                ////--Religious---///
                if ($details->religion == $newUser->religion) {
                    $update = SettingPages::where('uid', $details->id)->where('upload_type', 'number')->where('page_name', 'my_faith')->first();
                    if (isset($update)) {
                        $finalAmount = $update->description + $faithAmount;
                    } else {
                        $finalAmount = $faithAmount;
                    }
                    Balance_info::update_number('my_faith', $newUser->id, $finalAmount);
                    foreach ($allAffilates as $affliate) {
                        $affuser = User::where('email', $affliate->email)->first();
                        if (isset($affuser)) {
                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                            if ($total_days_of_plan <= 35) {
                                Balance_info::update_number('my_faith', $affliate->id, $faithAmount);
                            }
                        }
                    }
                }
                if ($details->religion != $newUser->religion) {
                    $lstuser = AffiliateRegistration::where('religion', $newUser->religion)->where('email', '!=', $newUser->email)->orderBy('id', 'Desc')->first();
                    if (isset($lstuser)) {
                        $update = SettingPages::where('uid', $lstuser->id)->where('upload_type', 'number')->where('page_name', 'my_faith')->first();
                        if (isset($update)) {
                            $finalAmount = $update->description;
                        } else {
                            $finalAmount = 0;
                        }
                        Balance_info::update_number('my_faith', $newUser->id, $finalAmount);
                    }
                    $detailAffiliates = AffiliateRegistration::where('religion', $details->religion)->get();
                    foreach ($detailAffiliates as $affliate) {
                        $affuser = User::where('email', $affliate->email)->first();
                        if (isset($affuser)) {
                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                            if ($total_days_of_plan <= 35) {
                                Balance_info::update_number('my_faith', $affliate->id, $faithAmount);
                            }
                        }
                    }
                }
            }
            if ($faith->school_value != 0) {

                $schoolAmount = $faith->school_value * $amount / 100;
                ////--schoolmate---///

                if (isset($oldEduDetails)) {
                    if ($oldEduDetails->institute_id == $newEduDetails->institute_id) {
                        $update = SettingPages::where('uid', $details->id)->where('upload_type', 'number')->where('page_name', 'country_tx')->first();
                        if (isset($update)) {
                            $finalAmount = $update->description + $schoolAmount;
                        } else {
                            $finalAmount = $schoolAmount;
                        }
                        Balance_info::update_number('country_tx', $newUser->id, $finalAmount);
                        foreach ($allSchlMates as $schlMate) {
                            $affUserfind = AffiliateRegistration::where('id', $schlMate->user_id)->first();
                            if (isset($affUserfind)) {
                                $affUser = User::where('email', $affUserfind->email)->first();
                                if (isset($affUser)) {
                                    $total_days_of_plan = Balance_info::get_total_plan_day($affUser->id);
                                    if ($total_days_of_plan <= 35) {
                                        Balance_info::update_number('country_tx', $affUserfind->id, $schoolAmount);
                                    }
                                }
                            }
                        }
                    }
                    if ($oldEduDetails->institute_id != $newEduDetails->institute_id) {

                        $prevUser = EducationDetail::where('institute_id', $newEduDetails->institute_id)->where('user_id', '!=', $newUser->id)->first();
                        if (isset($prevUser)) {
                            $update = SettingPages::where('uid', $prevUser->user_id)
                                ->where('upload_type', 'number')->where('page_name', 'country_tx')->first();
                            if (isset($update)) {
                                $finalAmount = $update->description;
                            } else {
                                $finalAmount = 0;
                            }
                            Balance_info::update_number('country_tx', $newUser->id, $finalAmount);
                        }

                        $detailSchlMates = EducationDetail::where('institute_id', $oldEduDetails->institute_id)->get();
                        foreach ($detailSchlMates as $schlMate) {
                            $affUserfind = AffiliateRegistration::where('id', $schlMate->user_id)->first();
                            if (isset($affUserfind)) {
                                $affUser = User::where('email', $affUserfind->email)->first();
                                if (isset($affUser)) {
                                    $total_days_of_plan = Balance_info::get_total_plan_day($affUser->id);
                                    if ($total_days_of_plan <= 35) {
                                        Balance_info::update_number('country_tx', $affUserfind->id, $schoolAmount);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if ($update_sponsor_wallet) {
            $total_uplines = Balance_info::all_upline_users_hwe($sponsor_id, $sponsor_id);
            $total_days_of_plan_subscribe = Balance_info::get_total_plan_day($sponsor_id);
            // if($plan->id!=5){
            if ($plan->id == 5) {
                $amount = 0;
            }
            if ($total_days_of_plan_subscribe <= 35) {
                $table_name = "level_earnings";
                $desc = "Direct Earning";
                $tid = Balance_info::where('user_id', $sponsor_id)->first()->id;
                $data12 = array(
                    'user_id'       => $sponsor_id,
                    'amount'        => $amount,
                    'ref_id'        => $user_id,
                    'description'   => $desc,
                    'status'        => 1
                );
                $q01 = LevelEarning::create($data12);
                $LevelEarning_id = $q01->id;

                ///////////////////////////// new code /////////////////////////////
                session()->forget('city_project');
                session()->forget('arts_and_culture');
                session()->forget('top_city_news');
                session()->forget('country_misc');
                session()->forget('diaspo_connection');
                $country_data = StatusBirth::where('country_birth', $details->birth_country)->first();
                $oldCityUpd = AffiliateRegistration::where(['birth_country' => $newUser->birth_country, 'birth_commune' => $newUser->birth_commune])->where('email', '!=', $newUser->email)->orderBy('id', 'Desc')->first();
                // dd($oldCityUpd);
                if (isset($oldCityUpd)) {
                    $oldCityUpdData = BirthplaceDetails::where('uid', $oldCityUpd->id)->where('upload_type', 'number')->first();
                    if (isset($oldCityUpdData)) {
                        $cityoldAmount = $oldCityUpdData->description;
                        Balance_info::birthplaceSet($newUser->id, $cityoldAmount);
                    }
                    // art and culture
                    $oldArtUpdData = SettingPages::where('uid', $oldCityUpd->id)->where('upload_type', 'number')->where('page_name', 'arts_and_culture')->first();
                    if (isset($oldArtUpdData)) {
                        $artoldAmount = $oldArtUpdData->description;
                        Balance_info::update_number('arts_and_culture', $newUser->id, $artoldAmount);
                    }
                    // city_news
                    $oldCityNewsUpdData = SettingPages::where('uid', $oldCityUpd->id)->where('upload_type', 'number')->where('page_name', 'top_city_news')->first();
                    if (isset($oldCityNewsUpdData)) {
                        $cityNewsoldAmount = $oldCityNewsUpdData->description;
                        Balance_info::update_number('top_city_news', $newUser->id, $cityNewsoldAmount);
                    }
                    // // country_misc
                    $oldCountry_miscUpdData = SettingPages::where('uid', $oldCityUpd->id)->where('upload_type', 'number')->where('page_name', 'country_misc')->first();
                    if (isset($oldCountry_miscUpdData)) {
                        $Country_miscoldAmount = $oldCountry_miscUpdData->description;
                        Balance_info::update_number('country_misc', $newUser->id, $Country_miscoldAmount);
                    }
                    // diaspo_connection
                    $oldMiscUpdData = SettingPages::where('uid', $oldCityUpd->id)->where('upload_type', 'number')->where('page_name', 'diaspo_connection')->first();
                    if (isset($oldMiscUpdData)) {
                        $MiscoldAmount = $oldMiscUpdData->description;
                        Balance_info::update_number('diaspo_connection', $newUser->id, $MiscoldAmount);
                    }
                }
                if (isset($country_data)) {
                    $lvlCountry = AffiliateRegistration::where(['birth_country' => $details->birth_country, 'birth_commune' => $details->birth_commune])->get();
                    if ($country_data->city_project > 0) {
                        $birth = $country_data->city_project * $amount / 100;
                        session()->put('city_project', $country_data->city_project);
                        $acutal_amount = $amount - $birth;
                        foreach ($lvlCountry as $affliate) {
                            $affuser = User::where('email', $affliate->email)->first();
                            if (isset($affuser)) {
                                $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                if ($total_days_of_plan <= 35) {
                                    Balance_info::birthplaceSet($affliate->id, $birth);
                                }
                            }
                        }
                    }
                    if ($country_data->culture > 0) {
                        $arts_and_culture = $country_data->culture * $amount / 100;
                        session()->put('arts_and_culture', $country_data->culture);
                        if ($country_data->city_project > 0) {
                            $acutal_amount = $acutal_amount - $arts_and_culture;
                        } else {
                            $acutal_amount = $amount - $arts_and_culture;
                        }
                        foreach ($lvlCountry as $affliate) {
                            $affuser = User::where('email', $affliate->email)->first();
                            if (isset($affuser)) {
                                $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                if ($total_days_of_plan <= 35) {
                                    Balance_info::update_number('arts_and_culture', $affliate->id, $arts_and_culture);
                                }
                            }
                        }
                    }
                    if ($country_data->city_news > 0) {
                        $city_news = $country_data->city_news * $amount / 100;
                        session()->put('top_city_news', $country_data->city_news);
                        if ($country_data->culture > 0) {
                            $acutal_amount = $acutal_amount - $city_news;
                        } elseif ($country_data->city_project > 0) {
                            $acutal_amount = $acutal_amount - $city_news;
                        } else {
                            $acutal_amount = $amount - $city_news;
                        }
                        foreach ($lvlCountry as $affliate) {
                            $affuser = User::where('email', $affliate->email)->first();
                            if (isset($affuser)) {
                                $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                if ($total_days_of_plan <= 35) {
                                    Balance_info::update_number('top_city_news', $affliate->id, $city_news);
                                }
                            }
                        }
                    }
                    if ($country_data->country_misc > 0) {
                        $countryMisc = $country_data->country_misc * $amount / 100;
                        session()->put('country_misc', $country_data->country_misc);
                        if ($country_data->city_news > 0) {
                            $acutal_amount = $acutal_amount - $countryMisc;
                        } elseif ($country_data->culture > 0) {
                            $acutal_amount = $acutal_amount - $countryMisc;
                        } elseif ($country_data->city_project > 0) {
                            $acutal_amount = $acutal_amount - $countryMisc;
                        } else {
                            $acutal_amount = $amount - $countryMisc;
                        }
                        foreach ($lvlCountry as $affliate) {
                            $affuser = User::where('email', $affliate->email)->first();
                            if (isset($affuser)) {
                                $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                if ($total_days_of_plan <= 35) {
                                    Balance_info::update_number('country_misc', $affliate->id, $countryMisc);
                                }
                            }
                        }
                    }
                    if ($country_data->misc > 0) {
                        $misc = $country_data->misc * $amount / 100;
                        session()->put('diaspo_connection', $country_data->misc);
                        if ($country_data->country_misc > 0) {
                            $acutal_amount = $acutal_amount - $misc;
                        } elseif ($country_data->city_news > 0) {
                            $acutal_amount = $acutal_amount - $misc;
                        } elseif ($country_data->culture > 0) {
                            $acutal_amount = $acutal_amount - $misc;
                        } elseif ($country_data->city_project > 0) {
                            $acutal_amount = $acutal_amount - $misc;
                        } else {
                            $acutal_amount = $amount - $misc;
                        }
                        foreach ($lvlCountry as $affliate) {
                            $affuser = User::where('email', $affliate->email)->first();
                            if (isset($affuser)) {
                                $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                if ($total_days_of_plan <= 35) {
                                    Balance_info::update_number('diaspo_connection', $affliate->id, $misc);
                                }
                            }
                        }
                    }
                } else {
                    $acutal_amount = $amount;
                }
                if (isset($faith)) {
                    if ($faith->fath_religious != 0) {
                        $acutal_amount = $acutal_amount - $faithAmount;
                    }
                    if ($faith->school_value != 0) {
                        $acutal_amount = $acutal_amount - $schoolAmount;
                    }
                } else {
                    $acutal_amount = $acutal_amount;
                }
                // dd($acutal_amount);
                if ($faith) {
                    $acutalamount = $amount / $total_uplines;
                    if (isset($details->sponsor_id)) {
                        $lv2 = User::find($details->sponsor_id);
                        if (isset($lv2->email)) {
                            $lv2u = AffiliateRegistration::where('email', $lv2->email)->first();
                            if (isset($lv2u)) {
                                if ($faith->fath_religious != 0) {
                                    $faithlv2 = $faith->fath_religious * $acutalamount / 100;
                                    $lv2affi = AffiliateRegistration::where('religion', $lv2u->religion)->get();
                                    foreach ($lv2affi as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::update_number('my_faith', $affliate->id, $faithlv2);
                                            }
                                        }
                                    }
                                }
                                if ($faith->school_value != 0) {
                                    $country_txlv2 = $faith->school_value * $acutalamount / 100;
                                    $userInsti = EducationDetail::where('user_id', $lv2u->id)->first();
                                    if (isset($userInsti)) {
                                        $lv2affi = EducationDetail::where('institute_id', $userInsti->institute_id)->get();
                                        foreach ($lv2affi as $affliate) {
                                            $affUserfind = AffiliateRegistration::where('id', $affliate->user_id)->first();
                                            if (isset($affUserfind)) {
                                                $affuser = User::where('email', $affUserfind->email)->first();
                                                if (isset($affuser)) {
                                                    $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                                    if ($total_days_of_plan <= 35) {
                                                        Balance_info::update_number('country_tx', $affUserfind->id, $country_txlv2);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                $lv2uCountry = AffiliateRegistration::where(['birth_country' => $lv2u->birth_country, 'birth_commune' => $lv2u->birth_commune])->get();
                                if (session()->get('city_project')) {
                                    $cityPr = session()->get('city_project') * $acutalamount / 100;
                                    foreach ($lv2uCountry as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::birthplaceSet($affliate->id, $cityPr);
                                            }
                                        }
                                    }
                                }
                                if (session()->get('arts_and_culture')) {
                                    $artsAndclt = session()->get('arts_and_culture') * $acutalamount / 100;
                                    foreach ($lv2uCountry as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::update_number('arts_and_culture', $affliate->id, $artsAndclt);
                                            }
                                        }
                                    }
                                }
                                if (session()->get('top_city_news')) {
                                    $cityNews = session()->get('top_city_news') * $acutalamount / 100;
                                    foreach ($lv2uCountry as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::update_number('top_city_news', $affliate->id, $cityNews);
                                            }
                                        }
                                    }
                                }
                                if (session()->get('country_misc')) {
                                    $countryMisc = session()->get('country_misc') * $acutalamount / 100;
                                    foreach ($lv2uCountry as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::update_number('country_misc', $affliate->id, $countryMisc);
                                            }
                                        }
                                    }
                                }
                                if (session()->get('diaspo_connection')) {
                                    $diaspoMisc = session()->get('diaspo_connection') * $acutalamount / 100;
                                    foreach ($lv2uCountry as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::update_number('diaspo_connection', $affliate->id, $diaspoMisc);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (isset($lv2u->sponsor_id)) {
                        $lv3 = User::find($lv2u->sponsor_id);
                        if (isset($lv3->email)) {
                            $lv3u = AffiliateRegistration::where('email', $lv3->email)->first();
                            if (isset($lv3u)) {
                                if ($faith->fath_religious != 0) {
                                    $faithlv3 = $faith->fath_religious * $acutalamount / 100;
                                    $lv3affi = AffiliateRegistration::where('religion', $lv3u->religion)->get();
                                    foreach ($lv3affi as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::update_number('my_faith', $affliate->id, $faithlv3);
                                            }
                                        }
                                    }
                                }
                                if ($faith->school_value != 0) {
                                    $country_txlv3 = $faith->school_value * $acutalamount / 100;
                                    $user3Insti = EducationDetail::where('user_id', $lv3u->id)->first();
                                    if (isset($user3Insti)) {
                                        $lv3affi = EducationDetail::where('institute_id', $user3Insti->institute_id)->get();
                                        foreach ($lv3affi as $affliate) {
                                            $affUserfind = AffiliateRegistration::where('id', $affliate->user_id)->first();
                                            if (isset($affUserfind)) {
                                                $affuser = User::where('email', $affUserfind->email)->first();
                                                if (isset($affuser)) {
                                                    $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                                    if ($total_days_of_plan <= 35) {
                                                        Balance_info::update_number('country_tx', $affUserfind->id, $country_txlv3);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                $lv3uCountry = AffiliateRegistration::where(['birth_country' => $lv3u->birth_country, 'birth_commune' => $lv3u->birth_commune])->get();
                                if (session()->get('city_project')) {
                                    $cityPr3 = session()->get('city_project') * $acutalamount / 100;
                                    foreach ($lv3uCountry as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::birthplaceSet($affliate->id, $cityPr3);
                                            }
                                        }
                                    }
                                }
                                if (session()->get('arts_and_culture')) {
                                    $artsAndclt3 = session()->get('arts_and_culture') * $acutalamount / 100;
                                    foreach ($lv3uCountry as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::update_number('arts_and_culture', $affliate->id, $artsAndclt3);
                                            }
                                        }
                                    }
                                }
                                if (session()->get('top_city_news')) {
                                    $citynewsAndclt3 = session()->get('top_city_news') * $acutalamount / 100;
                                    foreach ($lv3uCountry as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::update_number('top_city_news', $affliate->id, $citynewsAndclt3);
                                            }
                                        }
                                    }
                                }
                                if (session()->get('country_misc')) {
                                    $countryMiscAndclt3 = session()->get('country_misc') * $acutalamount / 100;
                                    foreach ($lv3uCountry as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::update_number('country_misc', $affliate->id, $countryMiscAndclt3);
                                            }
                                        }
                                    }
                                }
                                if (session()->get('diaspo_connection')) {
                                    $diaspoMiscAndclt3 = session()->get('diaspo_connection') * $acutalamount / 100;
                                    foreach ($lv3uCountry as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::update_number('diaspo_connection', $affliate->id, $diaspoMiscAndclt3);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (isset($lv3u->sponsor_id)) {
                        $lv4 = User::find($lv3u->sponsor_id);
                        if (isset($lv4->email)) {
                            $lv4u = AffiliateRegistration::where('email', $lv4->email)->first();
                            if (isset($lv4u)) {
                                if ($faith->fath_religious != 0) {
                                    $faithlv4 = $faith->fath_religious * $acutalamount / 100;
                                    $lv4affi = AffiliateRegistration::where('religion', $lv4u->religion)->get();
                                    foreach ($lv4affi as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::update_number('my_faith', $affliate->id, $faithlv4);
                                            }
                                        }
                                    }
                                }
                                if ($faith->school_value != 0) {
                                    $country_txlv4 = $faith->school_value * $acutalamount / 100;
                                    $user4Insti = EducationDetail::where('user_id', $lv4u->id)->first();
                                    if (isset($user4Insti)) {
                                        $lv4affi = EducationDetail::where('institute_id', $user4Insti->institute_id)->get();
                                        foreach ($lv4affi as $affliate) {
                                            $affUserfind = AffiliateRegistration::where('id', $affliate->user_id)->first();
                                            if (isset($affUserfind)) {
                                                $affuser = User::where('email', $affUserfind->email)->first();
                                                if (isset($affuser)) {
                                                    $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                                    if ($total_days_of_plan <= 35) {
                                                        Balance_info::update_number('country_tx', $affUserfind->id, $country_txlv4);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                $lv4uCountry = AffiliateRegistration::where(['birth_country' => $lv4u->birth_country, 'birth_commune' => $lv4u->birth_commune])->get();
                                if (session()->get('city_project')) {
                                    $cityPr4 = session()->get('city_project') * $acutalamount / 100;
                                    foreach ($lv4uCountry as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::birthplaceSet($affliate->id, $cityPr4);
                                            }
                                        }
                                    }
                                }
                                if (session()->get('arts_and_culture')) {
                                    $artsAndclt4 = session()->get('arts_and_culture') * $acutalamount / 100;
                                    foreach ($lv4uCountry as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::update_number('arts_and_culture', $affliate->id, $artsAndclt4);
                                            }
                                        }
                                    }
                                }
                                if (session()->get('top_city_news')) {
                                    $citynewsAndclt4 = session()->get('top_city_news') * $acutalamount / 100;
                                    foreach ($lv4uCountry as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::update_number('top_city_news', $affliate->id, $citynewsAndclt4);
                                            }
                                        }
                                    }
                                }
                                if (session()->get('country_misc')) {
                                    $countryMiscAndclt4 = session()->get('country_misc') * $acutalamount / 100;
                                    foreach ($lv4uCountry as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::update_number('country_misc', $affliate->id, $countryMiscAndclt4);
                                            }
                                        }
                                    }
                                }
                                if (session()->get('diaspo_connection')) {
                                    $diaspoMiscAndclt4 = session()->get('diaspo_connection') * $acutalamount / 100;
                                    foreach ($lv4uCountry as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::update_number('diaspo_connection', $affliate->id, $diaspoMiscAndclt4);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (isset($lv4u->sponsor_id)) {
                        $lv5 = User::find($lv4u->sponsor_id);
                        if (isset($lv5->email)) {
                            $lv5u = AffiliateRegistration::where('email', $lv5->email)->first();
                            if (isset($lv5u)) {
                                if ($faith->fath_religious != 0) {
                                    $faithlv5 = $faith->fath_religious * $acutalamount / 100;
                                    $lv5affi = AffiliateRegistration::where('religion', $lv5u->religion)->get();
                                    foreach ($lv5affi as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::update_number('my_faith', $affliate->id, $faithlv5);
                                            }
                                        }
                                    }
                                }
                                if ($faith->school_value != 0) {
                                    $country_txlv5 = $faith->school_value * $acutalamount / 100;
                                    $user5Insti = EducationDetail::where('user_id', $lv5u->id)->first();
                                    if (isset($user5Insti)) {
                                        $lv5affi = EducationDetail::where('institute_id', $user5Insti->institute_id)->get();
                                        foreach ($lv5affi as $affliate) {
                                            $affUserfind = AffiliateRegistration::where('id', $affliate->user_id)->first();
                                            if (isset($affUserfind)) {
                                                $affuser = User::where('email', $affUserfind->email)->first();
                                                if (isset($affuser)) {
                                                    $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                                    if ($total_days_of_plan <= 35) {
                                                        Balance_info::update_number('country_tx', $affUserfind->id, $country_txlv5);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                $lv5Country = AffiliateRegistration::where(['birth_country' => $lv5u->birth_country, 'birth_commune' => $lv5u->birth_commune])->get();
                                if (session()->get('city_project')) {
                                    $cityPr5 = session()->get('city_project') * $acutalamount / 100;
                                    foreach ($lv5Country as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::birthplaceSet($affliate->id, $cityPr5);
                                            }
                                        }
                                    }
                                }
                                if (session()->get('arts_and_culture')) {
                                    $artsAndclt5 = session()->get('arts_and_culture') * $acutalamount / 100;
                                    foreach ($lv5Country as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::update_number('arts_and_culture', $affliate->id, $artsAndclt5);
                                            }
                                        }
                                    }
                                }
                                if (session()->get('top_city_news')) {
                                    $citynewsAndclt5 = session()->get('top_city_news') * $acutalamount / 100;
                                    foreach ($lv5Country as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::update_number('top_city_news', $affliate->id, $citynewsAndclt5);
                                            }
                                        }
                                    }
                                }
                                if (session()->get('country_misc')) {
                                    $countryMiscAndclt5 = session()->get('country_misc') * $acutalamount / 100;
                                    foreach ($lv5Country as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::update_number('country_misc', $affliate->id, $countryMiscAndclt5);
                                            }
                                        }
                                    }
                                }
                                if (session()->get('diaspo_connection')) {
                                    $diaspoMiscAndclt5 = session()->get('diaspo_connection') * $acutalamount / 100;
                                    foreach ($lv5Country as $affliate) {
                                        $affuser = User::where('email', $affliate->email)->first();
                                        if (isset($affuser)) {
                                            $total_days_of_plan = Balance_info::get_total_plan_day($affuser->id);
                                            if ($total_days_of_plan <= 35) {
                                                Balance_info::update_number('diaspo_connection', $affliate->id, $diaspoMiscAndclt5);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                $data1 = array(
                    'user_id'            => $sponsor_id,
                    'tid'                => $tid,
                    'lid'                => $LevelEarning_id,
                    'amount'             => $acutal_amount,
                    'table_name'         => $table_name,
                    'description'        => $desc,
                    'status'             => 1
                );
                $q0 = Mlm_transaction::create($data1);
                ///////////////////////////// end new code /////////////////////////////
            }
            // }
            $admin_email = Setting::get_admin_email();
            $template = AffiliateEmailTemplate::where('id', 1)->first();
            $email_subject = $template->comm_subject;
            $affiliate = AffiliateRegistration::where('email', $user->email)->first();
            $level = 'Level ' . $user->level;
            $country = $affiliate->country;
            $state = $affiliate->state . ' ' . $affiliate->city . ' ' . $affiliate->zip_code;
            $link = '<a href="' . url('/') . '" target="_blank">click</a>';
            $profile_image = Balance_info::get_affiliate_profile_pic($user->email);
            $email_message = str_replace('{sponsor_name}', $user1->name, $template->comm_message);
            $email_message = str_replace('{affiliate_profile_photo}', $profile_image, $email_message);
            $email_message = str_replace('{affiliate_name}', $user->name, $email_message);
            $email_message = str_replace('{level}', $level, $email_message);
            $email_message = str_replace('{country}', $country, $email_message);
            $email_message = str_replace('{state}', $state, $email_message);
            $email_message = str_replace('{transaction_history_link}', $link, $email_message);

            $data2 = array(
                'admin_email'       =>  $admin_email,
                'template'          =>  'email_template',
                'webtitle'          =>  'MAFAMA',
                'subject'           =>  $email_subject,
                'email_message'     =>  $email_message,
            );
            // \Mail::to($user1->email)->send(new SendMail($data2));
            if ($user->level > 4) {
                $bonus_one = 0;
                $bonus_two = 0;
                $bonus_three = 0;
                $bonus_four = 0;
            } else {
                $bonus_one = $plan->bonus_one;
                $bonus_two = $plan->bonus_two;
                $bonus_three = $plan->bonus_three;
                $bonus_four = $plan->bonus_four;
            }
            $prize = $plan->prize;
            $other = $plan->other;
            $old_pool = PoolPrice::where('id', 1)->first();
            $pool_data = array(
                'bonus_one_price'   => $bonus_one + $old_pool->bonus_one_price,
                'bonus_two_price'   => $bonus_two + $old_pool->bonus_two_price,
                'bonus_three_price' => $bonus_three + $old_pool->bonus_three_price,
                'bonus_four_price'  => $bonus_four + $old_pool->bonus_four_price,
                'bonus_prize'       => $prize + $old_pool->bonus_prize,
                'other'             => $other + $old_pool->other,
            );
            $update_pool_table = PoolPrice::where('id', 1)->update($pool_data);
            if ($faith) {
                $namount = $amount / $total_uplines;
                if ($faith->fath_religious != 0) {
                    $faithD = $faith->fath_religious * $namount / 100;
                    $damount = $namount - $faithD;
                }
                if ($faith->school_value != 0) {
                    $schlv = $faith->school_value * $namount / 100;
                    $damount = $namount - $schlv;
                }
            } else {
                $damount = $amount / $total_uplines;
            }
            if (session()->get('city_project')) {
                $cityProjectam = session()->get('city_project') * $damount / 100;
                $damount = $damount - $cityProjectam;
            }
            if (session()->get('arts_and_culture')) {
                $artsProjectam = session()->get('arts_and_culture') * $damount / 100;
                $damount = $damount - $artsProjectam;
            }
            if (session()->get('top_city_news')) {
                $citynewsProjectam = session()->get('top_city_news') * $damount / 100;
                $damount = $damount - $citynewsProjectam;
            }
            if (session()->get('country_misc')) {
                $countryMiscProjectam = session()->get('country_misc') * $damount / 100;
                $damount = $damount - $countryMiscProjectam;
            }
            if (session()->get('diaspo_connection')) {
                $diaspoMiscProjectam = session()->get('diaspo_connection') * $damount / 100;
                $damount = $damount - $diaspoMiscProjectam;
            }

            return Balance_info::sponsor_bonus_for_level($user_id, $user_id, $damount);
        }
    }
    public static function birthplaceSet($id, $amount)
    {
        $user_birthplace_number = BirthplaceDetails::where('uid', $id)->where('upload_type', 'number')->first();

        if (isset($user_birthplace_number)) {
            $birthAmount = $user_birthplace_number->description + $amount;
            $birthplace = array(
                'title' => '',
                'file_url' => '',
                'uid' => $id,
                'upload_type' => 'number',
                'description' => $birthAmount,
                'uploaded_by' => 'admin',
            );
            DB::table('birthplace_details')->where('uid', $id)
                ->where('upload_type', 'number')->update($birthplace);
            $user_birthplace_number = BirthplaceDetails::where('uid', $id)->where('upload_type', 'number')->first();
        } else {
            $birthplace = array(
                'title' => '',
                'file_url' => '',
                'uid' => $id,
                'upload_type' => 'number',
                'description' => $amount,
                'uploaded_by' => 'admin',
            );
            DB::table('birthplace_details')->insert($birthplace);
        }
    }

    public static function update_number($page_name, $user_id, $number = NULL)
    {
        $update = SettingPages::where('uid', $user_id)->where('upload_type', 'number')->where('page_name', $page_name)->first();
        if (!empty($update)) {
            $finalAmount = $update->description + $number;
            $data = array(
                'title'       => '',
                'file_url'    => '',
                'uid'         => $user_id,
                'upload_type' => 'number',
                'description' => $finalAmount,
                'uploaded_by' => 'admin',
                'page_name'   => $page_name,
            );
            DB::table('setting_pages')->where('uid', $user_id)->where('page_name', $page_name)
                ->where('upload_type', 'number')->update($data);
        } else {
            $data = array(
                'title'       => '',
                'file_url'    => '',
                'uid'         => $user_id,
                'upload_type' => 'number',
                'description' => $number,
                'uploaded_by' => 'admin',
                'page_name'   => $page_name,
            );
            DB::table('setting_pages')->insert($data);
        }
    }

    public static function birthPlaceSetAmount($id, $amount)
    {
        $user_birthplace_number = BirthplaceDetails::where('uid', $id)->where('upload_type', 'number')->first();
        if (isset($user_birthplace_number)) {
            $birthplace = array(
                'title' => '',
                'file_url' => '',
                'uid' => $id,
                'upload_type' => 'number',
                'description' => $amount,
                'uploaded_by' => 'admin',
            );
            DB::table('birthplace_details')->where('uid', $id)
                ->where('upload_type', 'number')->update($birthplace);
        } else {
            $birthplace = array(
                'title' => '',
                'file_url' => '',
                'uid' => $id,
                'upload_type' => 'number',
                'description' => $amount,
                'uploaded_by' => 'admin',
            );
            DB::table('birthplace_details')->insert($birthplace);
        }
    }

    public static function updateNumber($page_name, $user_id, $number = NULL)
    {
        $update = SettingPages::where('uid', $user_id)->where('upload_type', 'number')->where('page_name', $page_name)->first();
        if (!empty($update)) {
            $data = array(
                'title'       => '',
                'file_url'    => '',
                'uid'         => $user_id,
                'upload_type' => 'number',
                'description' => $number,
                'uploaded_by' => 'admin',
                'page_name'   => $page_name,
            );
            DB::table('setting_pages')->where('uid', $user_id)->where('page_name', $page_name)
                ->where('upload_type', 'number')->update($data);
        } else {
            $data = array(
                'title'       => '',
                'file_url'    => '',
                'uid'         => $user_id,
                'upload_type' => 'number',
                'description' => $number,
                'uploaded_by' => 'admin',
                'page_name'   => $page_name,
            );
            DB::table('setting_pages')->insert($data);
        }
    }

    public static function update_affiliate_bonus_income_on_plan_renew($user_id, $plan_id)
    {
        $user = User::get_user_info($user_id);
        $sponsor_id = $user->sponsor_id;
        $plan = Plan::where('id', $plan_id)->first();
        Plan_activation::create([
            'user_id' => $user_id,
            'plan_id' => $plan_id,
            'amount' => $plan->monthly_fee
        ]);
        // if($plan->id==5){
        //   $plnId = ActivePlan::where('user_id',$sponsor_id)->first();
        //   if($plnId->plan_id==5){
        //     $plan=Plan::where('id',1)->first();
        //   }else{
        //     $plan=Plan::where('id',$plnId->plan_id)->first();
        //   }
        // }
        $amount = $plan->balance / 2;
        $total_days_of_plan_subscribe = Balance_info::get_total_plan_day($sponsor_id);
        $user1 = User::get_user_info($sponsor_id);
        $sponsor_direct_members = User::where('sponsor_id', $sponsor_id)->count();
        $total_direct = $sponsor_direct_members;
        User::where('id', $sponsor_id)->update(array('direct_members' => $total_direct));
        $update_sponsor_wallet = Balance_info::update_user_wallet_balance($sponsor_id, $amount);
        if ($update_sponsor_wallet) {
            $total_days_of_plan_subscribe = Balance_info::get_total_plan_day($sponsor_id);
            if ($plan->id != 5) {
                if ($total_days_of_plan_subscribe <= 35) {
                    $table_name = "level_earnings";
                    $desc = "Direct Earning";
                    $tid = Balance_info::where('user_id', $sponsor_id)->first()->id;
                    $data12 = array(
                        'user_id'            => $sponsor_id,
                        'amount'             => $amount,
                        'ref_id'             => $user_id,
                        'description'        => $desc,
                        'status'             => 1
                    );
                    $q01 = LevelEarning::create($data12);
                    $levelEarning_id = $q01->id;
                    $data1 = array(
                        'user_id'            => $sponsor_id,
                        'tid'                => $tid,
                        'lid'                => $levelEarning_id,
                        'amount'             => $amount,
                        'table_name'         => $table_name,
                        'description'        => $desc,
                        'status'             => 1
                    );

                    $q0 = Mlm_transaction::create($data1);
                    ///////////////////////////// new code //////////////////////
                    $user = User::where('id', $sponsor_id)->first();
                    $details = AffiliateRegistration::where('email', $user->email)->first();
                    $country_data = StatusBirth::where('country_birth', $details->country)->first();

                    if (isset($country_data)) {
                        $user = User::where('email', $details->email)->first();
                        if ($user) {
                            $birth = $country_data->city_project * $amount / 100;
                            $user_birthplace_number = BirthplaceDetails::where('uid', $details->id)->where('upload_type', 'number')->first();
                            if (!empty($user_birthplace_number)) {
                                $birthAmount = $user_birthplace_number->description + $birth;
                                $birthplace = array(
                                    'title' => '',
                                    'file_url' => '',
                                    'uid' => $details->id,
                                    'upload_type' => 'number',
                                    'description' => $birthAmount,
                                    'uploaded_by' => 'admin',
                                );
                                DB::table('birthplace_details')->where('uid', $details->id)
                                    ->where('upload_type', 'number')->update($birthplace);
                            } else {
                                $birthplace = array(
                                    'title' => '',
                                    'file_url' => '',
                                    'uid' => $details->id,
                                    'upload_type' => 'number',
                                    'description' => $birth,
                                    'uploaded_by' => 'admin',
                                );
                                DB::table('birthplace_details')->insert($birthplace);
                            }
                            $diaspoAmount = $country_data->misc * $amount / 100;
                            $artsAmount = $country_data->culture * $amount / 100;
                            $faithAmount = $country_data->faith_connection * $amount / 100;
                            $topcityAmount = $country_data->city_news * $amount / 100;
                            Balance_info::update_number('diaspo_connection', $details->id, $diaspoAmount);
                            Balance_info::update_number('arts_and_culture', $details->id, $artsAmount);
                            Balance_info::update_number('my_faith', $details->id, $faithAmount);
                            Balance_info::update_number('top_city_news', $details->id, $topcityAmount);
                        }
                    }
                    ///////////////////////////// end new code //////////////////////
                }
            }
            $total_uplines = Balance_info::all_upline_users_hwe($sponsor_id, $sponsor_id);
            $damount = $amount / $total_uplines;
            return Balance_info::sponsor_bonus_for_level($user_id, $user_id, $damount);
        }
    }

    public static function add_user_subscription($user_id, $plan_id)
    {

        $plan = Plan::where('id', $plan_id)->first();
        $amount = $plan->monthly_fee;
        $table_name = "plan_activations";
        $desc = "Plan subscribed";
        $user = User::get_user_info($user_id);
        $request = AffiliateRegistration::where('email', $user->email)->first();
        if ($plan_id == 5) {
            $free_reg = FreeRegistration::where(['country' => $request->country, 'status' => 1])->where('to_date', '<=', $request->joining_date)->where('from_date', '>=', $request->joining_date)->first();
            $reg_id = $free_reg->id;
        } else {
            $reg_id = null;
        }

        $prevRec = Plan_activation::where('user_id', $user_id)
            ->first();

        if (isset($prevRec)) {
            return false;
        }
        // add user subscription plan
        $data = array(
            'user_id'            => $user_id,
            'amount'             => $amount,
            'plan_id'            => $plan_id,
            'reg_id'             => $reg_id
        );
        $q0 = Plan_activation::create($data);


        // create transaction statement
        $data1 = array(
            'user_id'            => $user_id,
            'tid'                => $q0->id,
            'amount'             => $amount,
            'table_name'         => $table_name,
            'description'        => $desc,
            'status'             => 1,
            'reg_id'             => $reg_id
        );
        $q0 = Mlm_transaction::create($data1);

        $admin_email = Setting::get_admin_email();
        $data2 = array(
            'admin_email'       =>  $admin_email,
            'template'          =>  'user_subscription_notification',
            'webtitle'          =>  'MAFAMA',
            'subject'           =>  'Your subscription has been completed',
            'full_name'         =>  $user->name,
            'email'             =>  $user->email,
            'plan'              =>  $plan->name,
            'amount'            =>  number_format($amount, 2) . ' USD'
        );
        // \Mail::to($user->email)->send(new SendMail($data2));
        return true;
    }

    public static function all_upline_users_hwe($user_id, $current_u_id)
    {
        global $all_user;
        $total_upline_hwe = array();
        Balance_info::get_total_upline($user_id, $user_id, $total_upline_hwe, $current_u_id);
        $total_upline = count($total_upline_hwe) - 1;
        if ($total_upline < 6) {
            $all_user[] = $user_id . '_' . $total_upline;
        }
        $user = Network::where(['user_id' => $user_id])->first();
        if (!empty($user)) {
            $user_id1 = $user->sponsor_id;
            Balance_info::all_upline_users_hwe($user_id1, $current_u_id);
        }
        // ravi change 1 to 2  $total=count($all_user)-1;
        if (in_array(1, $all_user)) {
            $total = count($all_user) - 2;
        } else {
            $total = count($all_user) - 1;
        }
        if ($total <= 0) {
            $total = 1;
        }
        return $total;
    }

    public static function all_upline_users($user_id)
    {
        global $all_user;
        $all_user[] = $user_id;
        $user = Network::where(['user_id' => $user_id])->first();
        if (!empty($user)) {
            $user_id1 = $user->sponsor_id;
            Balance_info::all_upline_users($user_id1);
        }
        // ravi change 1 to 2  $total=count($all_user)-1;
        $total = count($all_user) - 1;
        if ($total <= 0) {
            $total = 1;
        }
        return $total;
    }

    public static function sponsor_bonus_for_level($user_id, $ref_id, $amount)
    {
        $userData = User::where(['id' => $user_id])->first();
        if (!empty($userData)) {
            $user_id1 = $userData->sponsor_id;
            if ($user_id1 == 1 || $user_id == 1) {
                $sponsor_id = '';
                Balance_info::distribute_level_bonus_income($user_id1, $sponsor_id, $ref_id, $amount);

                return true;
            } else {
                // bonus level income distributed
                $sponsor_id = User::get_user_info($user_id1)->sponsor_id;
                $team_members = User::get_user_info($user_id1)->team_members;
                $sponsor_id_hwe = User::get_user_info($ref_id)->sponsor_id;
                $total_upline_hwe = array();
                Balance_info::get_total_upline($user_id1, $user_id1, $total_upline_hwe, $ref_id);
                $total_upline = count($total_upline_hwe) - 1;
                if ($sponsor_id_hwe != $user_id1 && $total_upline < 6) {
                    $total_days_of_plan_subscribe =  Balance_info::get_total_plan_day($user_id1);
                    if ($total_days_of_plan_subscribe  <= 35) {
                        Balance_info::distribute_level_bonus_income($user_id1, $sponsor_id, $ref_id, $amount);
                    }
                }
                Balance_info::sponsor_bonus_for_level($user_id1, $ref_id, $amount);
            }
        } else {
            return true;
        }
    }

    public static function get_total_upline($user_id, $user_id_fix, &$is_array, $current_user_id)
    {
        $user = Network::where(['user_id' => $current_user_id])->first();
        if (!empty($user)) {
            $user_id1 = $user->sponsor_id;
            $user_current = $user->user_id;
            if ((!in_array($user_current, $is_array)) &&  ($user_id1 >= $user_id_fix)) {
                $is_array[] = $user_current;
                Balance_info::get_total_upline($user_current, $user_id_fix, $is_array, $user_id1);
            } else {
                if (!in_array($current_user_id, $is_array)) {
                    $is_array[] = $current_user_id;
                }
                return $is_array;
            }
        } else {
            if (!in_array($user_id_fix, $is_array)) {
                $is_array[] = $user_id;
            }
            return $is_array;
        }
    }

    public static function get_total_plan_day($user_id)
    {
        $get_payments_date = DB::table('payments')->where('user_id', $user_id)->orderBy('id', 'desc')->first();
        $get_plan_activations_date = DB::table('plan_activations')->where('user_id', $user_id)->orderBy('id', 'desc')->first();
        if (!empty($get_plan_activations_date)) {
            if ($get_plan_activations_date->plan_id == 5) {
                if ($get_plan_activations_date->status == 1) {
                    $total_days_diff = 1000;
                } else {
                    $total_days_diff = 0;
                }
            } else {
                $plan_date = strtotime($get_plan_activations_date->created_at);
                $now = time();
                $datediff = $now - $plan_date;
                $total_days_diff =  round($datediff / (60 * 60 * 24));
            }
        } else {
            $total_days_diff = 1000;
        }
        if ($total_days_diff > 35) {
            if (!empty($get_payments_date)) {
                $plan_date = strtotime($get_payments_date->created_at);
                $now = time();
                $datediff = $now - $plan_date;
                $total_days_diff =  round($datediff / (60 * 60 * 24));
            }
        }
        return $total_days_diff;
    }

    public static function distribute_level_bonus_income($user_id, $sponsor_id, $ref_id, $amount)
    {
        $table_name = "bonus_incomes";
        $desc = "Downline Earning";
        $spn = User::find($sponsor_id);
        $user_id = isset($user_id) ? $user_id : 1;
        $user = User::get_user_info($user_id);
        $sponsor_id_count = User::where('sponsor_id', $user_id)->count();
        // dd($amount);
        // $amount = $amount-0.3;
        $data2 = array(
            'user_id'            => $user_id,
            'sponsor_id'         => $sponsor_id,
            'ref_id'             => $ref_id,
            'amount'             => $amount,
            'description'        => $desc,
            'status'             => 1
        );
        $q2 = Bonus_income::create($data2);
        $tid = $q2->id;
        $data1 = array(
            'user_id'            => $user_id,
            'tid'                => $tid,
            'amount'             => $amount,
            'table_name'         => $table_name,
            'description'        => $desc,
            'status'             => 1
        );
        $q0 = Mlm_transaction::create($data1);
        $update_sponsor_wallet = Balance_info::update_user_wallet_balance($user_id, $amount);
        $admin_email = Setting::get_admin_email();
        $data3 = array(
            'admin_email'       =>   $admin_email,
            'template'          =>  'user_bonus_level_income_alert',
            'webtitle'          =>  'MAFAMA',
            'subject'           =>  'You have received level commission income for your network',
            'full_name'         =>  $user->name,
            'email'            =>  $user->email,
            'amount'           =>  number_format($amount, 2) . ' USD'
        );
        // \Mail::to($user->email)->send(new SendMail($data3));
        return true;
    }

    public static function get_sponsor_name($user_id = '')
    {
        $da = User::where(['id' => $user_id])->get();
        if ($da->count() > 0) {
            return $da[0]->first_name . ' ' . $da[0]->last_name;
        } else {
            return 'itself';
        }
    }

    public static function deduct_user_wallet_balance($user_id, $amount)
    {
        $data = Balance_info::where('user_id', $user_id)->first();
        $avl_bal = $data->amount;
        $remaining_balance = $avl_bal - $amount;
        $da = array('amount' => $remaining_balance);
        $deduct = Balance_info::where('user_id', $user_id)->update($da);
        return true;
    }

    public static function get_user_plan_name($tid = '')
    {
        $plan_name = "";
        $da = $plan = level::where(['id' => $tid])->get();
        if ($da->count() > 0) {
            $plan_name = $plan[0]->name;
        } else {
            $plan_name = '';
        }
        return $plan_name;
    }

    public static function get_user_tier_name_profile($tid = '')
    {
        $tier_name = "";
        $da = $tier = Tier_level::where(['id' => $tid])->get();
        if ($da->count() > 0) {
            $tier_name = $tier[0]->tier;
        } else {
            $tier_name = 'Investor';
        }
        return $tier_name;
    }

    public static function update_user_tier_plan($user_id)
    {
        $tier_id = '';
        $user = User::get_user_info($user_id);
        $team_size = $user->team_members;
        $personal_deposit = $user->personal_deposit;
        $team_deposit = $user->team_deposit;
        $tier_id = $user->tier_id;
        if (empty($tier_id) && $personal_deposit >= 20) {
            $tier_id = 1;
        } elseif ($team_size >= 2 && $team_size <= 9 && $personal_deposit >= 500 && $team_deposit >= 2500) {
            $tier_id = 2;
            $bonus_tier = 'tier_two_bonus';
        } elseif ($team_size >= 10 && $team_size <= 99 && $personal_deposit >= 1000 && $team_deposit >= 10000) {
            $tier_id = 3;
            $bonus_tier = 'tier_three_bonus';
        } elseif ($team_size >= 100 && $team_size <= 499 && $personal_deposit >= 5000 && $team_deposit >= 50000) {
            $tier_id = 4;
            $bonus_tier = 'tier_four_bonus';
        } elseif ($team_size >= 500 && $personal_deposit >= 10000 && $team_deposit >= 100000) {
            $tier_id = 5;
            $bonus_tier = 'tier_five_bonus';
        }
        if (!empty($tier_id)) {
            $data = array('tier_id' => $tier_id);
            $update_tier = User::where('id', $user_id)->update($data);
            if ($tier_id != 1) {
                $check_bonus = User::where(['id' => $user_id, $bonus_tier => 'No'])->count();
                if ($check_bonus > 0) {
                    $q11 = Tier_level::find($tier_id);
                    $bonus_amount = $q11->one_time_bonus;
                    $old_tier_id = $user->tier_id;
                    $sponsor_id = $user->sponsor_id;
                    $email = $user->email;
                    $full_name = $user->first_name . ' ' . $user->last_name;

                    $new_tier_id = $tier_id;
                    $new_tier_name = Balance_info::get_user_tier_name($new_tier_id);
                    $data1 = array(
                        'user_id'            => $user_id,
                        'sponsor_id'         => $sponsor_id,
                        'bonus_amount'       => $bonus_amount,
                        'old_tier_id'        => $old_tier_id,
                        'new_tier_id'        => $new_tier_id,
                        'status'             => 0
                    );
                    $q0 = Bonus_list::create($data1);
                    $da = array($bonus_tier => 'Yes');
                    $update_plan_bonus = User::where('id', $user_id)->update($da);
                    $admin_email = Setting::get_admin_email();
                    $data = array(
                        'admin_email'       =>  $admin_email,
                        'template'          =>  'user_tier_upgrade_notification',
                        'subject'           =>  'Congratulations  your are promotion to ' . $new_tier_name,
                        'webtitle'          =>  'Aktos Invest',
                        'full_name'         =>  $full_name,
                        'email'            =>  $email,
                        'new_tier'        => $new_tier_name,
                        'bonus_amount'     => number_format($bonus_amount, 2) . ' EUR'
                    );
                    // \Mail::to($email)->send(new SendMail($data));
                    //send to admin email
                    $data = array(
                        'admin_email'       =>  $admin_email,
                        'template'          =>  'admin_tier_upgrade_notification',
                        'subject'           =>  'User upgrade into ' . $new_tier_name . ' ' . $full_name . ' ' . $email,
                        'webtitle'          =>  'Aktos Invest',
                        'full_name'         =>  $full_name,
                        'email'            =>  $email,
                        'new_tier'            => $new_tier_name,
                        'bonus_amount'       => number_format($bonus_amount, 2) . ' EUR'
                    );
                    // \Mail::to($admin_email)->send(new SendMail($data));
                }
            }
        } else {
            return true;
        }
    }

    public static function update_user_wallet_transaction_history($user_id, $amount, $status, $action, $table_name, $transaction_id)
    {
        $q3 = Deposit::update_user_wallet_balance($user_id, $amount);
        $tier_name = Balance_info::get_user_tier_name(User::get_user_info($user_id)->tier_id);
        if ($action == 'bonus') {
            $cmt = 'One-time commission for first Tier upgrade to ' . $tier_name;
        } else {
            $cmt = 'Commission for a deposit in your network';
        }
        $data1 = array(
            'user_id'            => $user_id,
            'transaction_id'     => $transaction_id,
            'amount'             => $amount,
            'currency'           => 'EUR',
            'action'             => $action,
            'table_name'         => $table_name,
            'comment'            => $cmt,
            'status'             => $status
        );
        $q0 = Transaction::create($data1);
    }

    public static function update_level_income($user_id, $sponsor_id, $tier_id, $amount, $i)
    {
        if ($tier_id != 1) {
            $tier = Tier_level::where('id', $tier_id)->first();
            $rate1 = $tier->first_level_comm;
            $rate2 = $tier->second_level_comm;
            $rate3 = $tier->third_level_comm;

            $userData = User::where(['id' => $user_id, 'sponsor_id' => $sponsor_id])->first();
            $user_id1 = $userData->sponsor_id;
            $sponsor_id1 = User::get_user_info($user_id1)->sponsor_id;
            Balance_info::update_level_income($user_id1, $sponsor_id1, $tier_id, $amount, $i);
            if ($parent_id == 1) {
                return true;
            }
        }
    }

    public static function update_total_personal_deposit($user_id, $amount)
    {
        $user = User::get_user_info($user_id);
        $amount1 = $user->personal_deposit + $amount;
        $data = array('personal_deposit' => $amount1);
        return User::where(['id' => $user_id])->update($data);
    }

    public static function update_total_team_deposit($sponsor_id, $user_id, $amount)
    {
        $user = User::get_user_info($sponsor_id);
        if (!empty($user)) {
            $amount1 = $user->team_deposit + $amount;
            $data = array('team_deposit' => $amount1);
            if ($sponsor_id != $user_id) {
                $q = User::where(['id' => $sponsor_id])->update($data);
            }
            $parent_id = $user->sponsor_id;
            $q2 = Balance_info::update_total_team_deposit($parent_id, $user_id, $amount);
            if ($parent_id  == 1) {
                return 1;
            }
        }
    }

    public static function get_total_assest_amount($uid, $i, $asset_id, $year)
    {
        $total = 0;
        $uid = Auth::id();
        $data = DB::table('current_asset_balancesheet')->where('uid', $uid)->whereYear('created_at', $year)->get();
        if ($data->count() > 0) {
            foreach ($data as  $record) {
                $raw_data = json_decode($record->raw_data, true);
                if (array_key_exists($i, $raw_data)) {
                    $total += isset($raw_data) ? $raw_data[$i][$asset_id] : 0;
                }
            }
        }
        return $total;
    }

    public static function get_total_nonassest_amount($uid, $i, $asset_id, $year)
    {
        $total = 0;
        $data = DB::table('noncurrent_asset_balancesheet')->where('uid', $uid)->whereYear('created_at', $year)->get();
        if ($data->count() > 0) {
            foreach ($data as  $record) {
                $raw_data = json_decode($record->raw_data, true);
                if (array_key_exists($i, $raw_data)) {
                    $total += isset($raw_data) ? $raw_data[$i][$asset_id] : 0;
                }
            }
        }
        return $total;
    }

    public static function get_total_liability_amount($uid, $i, $asset_id, $year)
    {
        $total = 0;
        $data = DB::table('current_liability_balancesheet')->where('uid', $uid)->whereYear('created_at', $year)->get();
        if ($data->count() > 0) {
            foreach ($data as  $record) {
                $raw_data = json_decode($record->raw_data, true);
                if (array_key_exists($i, $raw_data)) {
                    $total += isset($raw_data) ? $raw_data[$i][$asset_id] : 0;
                }
            }
        }
        return $total;
    }

    public static function get_total_nonliability_amount($uid, $i, $asset_id, $year)
    {
        $total = 0;
        $data = DB::table('noncurrent_liability_balancesheet')->where('uid', $uid)->whereYear('created_at', $year)->get();
        if ($data->count() > 0) {
            foreach ($data as  $record) {
                $raw_data = json_decode($record->raw_data, true);
                if (array_key_exists($i, $raw_data)) {
                    $total += isset($raw_data) ? $raw_data[$i][$asset_id] : 0;
                }
            }
        }
        return $total;
    }

    public static function get_total_equity_amount($uid, $i, $asset_id, $year)
    {
        $total = 0;
        $data = DB::table('equity_balancesheet')->where('uid', $uid)->whereYear('created_at', $year)->get();
        if ($data->count() > 0) {
            foreach ($data as  $record) {
                $raw_data = json_decode($record->raw_data, true);
                if (array_key_exists($i, $raw_data)) {
                    $total += isset($raw_data) ? $raw_data[$i][$asset_id] : 0;
                }
            }
        }
        return $total;
    }

    public static function get_sum_of_assetsheet($uid, $year)
    {
        $total = 0;
        $data = DB::table('current_asset_balancesheet')->where('uid', $uid)->whereYear('created_at', $year)->get();
        if ($data->count() > 0) {
            foreach ($data as  $record) {
                $raw_data = json_decode($record->raw_data, true);
                foreach ($raw_data as $value) {
                    foreach ($value as  $value1) {
                        $total += $value1;
                    }
                }
            }
        }
        return $total;
    }

    public static function get_sum_of_nonassetsheet($uid, $year)
    {
        $total = 0;
        $data = DB::table('noncurrent_asset_balancesheet')->where('uid', $uid)->whereYear('created_at', $year)->get();
        if ($data->count() > 0) {
            foreach ($data as  $record) {
                $raw_data = json_decode($record->raw_data, true);
                foreach ($raw_data as $value) {
                    foreach ($value as  $value1) {
                        $total += $value1;
                    }
                }
            }
        }
        return $total;
    }

    public static function get_sum_of_liabilitysheet($uid, $year)
    {
        $total = 0;
        $data = DB::table('current_liability_balancesheet')->where('uid', $uid)->whereYear('created_at', $year)->get();
        if ($data->count() > 0) {
            foreach ($data as  $record) {
                $raw_data = json_decode($record->raw_data, true);
                foreach ($raw_data as $value) {
                    foreach ($value as  $value1) {
                        $total += $value1;
                    }
                }
            }
        }
        return $total;
    }

    public static function get_sum_of_nonliabilitysheet($uid, $year)
    {
        $total = 0;
        $data = DB::table('noncurrent_liability_balancesheet')->where('uid', $uid)->whereYear('created_at', $year)->get();
        if ($data->count() > 0) {
            foreach ($data as  $record) {
                $raw_data = json_decode($record->raw_data, true);
                foreach ($raw_data as $value) {
                    foreach ($value as  $value1) {
                        $total += $value1;
                    }
                }
            }
        }
        return $total;
    }

    public static function get_sum_of_equitysheet($uid, $year)
    {
        $total = 0;
        $data = DB::table('equity_balancesheet')->where('uid', $uid)->whereYear('created_at', $year)->get();
        if ($data->count() > 0) {
            foreach ($data as  $record) {
                $raw_data = json_decode($record->raw_data, true);
                foreach ($raw_data as $value) {
                    foreach ($value as  $value1) {
                        $total += $value1;
                    }
                }
            }
        }
        return $total;
    }
}
