<?php
namespace App\Http\Controllers;
use App\Discount;
use App\Plan;
use App\BirthplaceDetails;
use App\SettingPages;
use App\LeadersBoard;
use App\LeaderBoardReports;
use App\AffiliateRegistration;
use App\AppointmentBanner;use App\AppointmentTutorial;use App\ArchivesBanner;use App\ArchiveTutorial;
use App\BusinessCategory;use App\BusinessRegister;use App\CardCategory;use App\Chat;
use App\ClientAppointmentList;use App\ClientManagementBanner;use App\ClientTutorial;use App\Comune;use App\Contacts;
use App\EmailCampaign;use App\EmailManagementBanner;use App\EmailTutorial;use App\FinanceTutorial;use App\FinancialInvoiceSetup;
use App\FinancialManagementBanner;use App\Folders;use App\HomeMainVideo;use App\HomeTopVideo;use App\HomeVideo;
use App\Http\Requests;use App\IntroVideo;use App\LeadsCategory;use App\Levels;use App\LibraryForm;
use App\Mail\SendMail;use App\Menulinks;use App\Mlm_transaction;use App\Payment as Transactionhistory;
use App\PhotoSlides;use App\Religion;use App\ScriptCategory;use App\SendCard;use App\SendEmail;use App\SendSms;
use App\SendVideo;use App\Setting;use App\SettingBanner;use App\SettingTutorial;use App\TempAffiliateRegistration;
use App\TextBanner;use App\TopBanner;use App\UploadCard;use App\UploadScript;use App\User;
use App\User_invite;use Auth;use Carbon\Carbon;use Charts;use DB;use Exception;use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;use Illuminate\Support\Facades\Mail;use Redirect;use Session;use Twilio\Rest\Client;
use URL;use Validator;
use App\Balance_info;

// use Input;
// use PayPal\Rest\ApiContext;
// use PayPal\Auth\OAuthTokenCredential;
// use PayPal\Api\Amount;
// use PayPal\Api\Details;
// use PayPal\Api\Item;
// use PayPal\Api\ItemList;
// use PayPal\Api\Payer;
// use PayPal\Api\Payment;
// use PayPal\Api\RedirectUrls;
// use PayPal\Api\ExecutePayment;
// use PayPal\Api\PaymentExecution;
// use PayPal\Api\Transaction;
class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
      // private $_api_context;
    public function __construct()
    {
        // $paypal_configuration = \Config::get('paypal');
        // $this->_api_context = new ApiContext(new OAuthTokenCredential($paypal_configuration['client_id'], $paypal_configuration['secret']));
        // $this->_api_context->setConfig($paypal_configuration['settings']);
        // $this->middleware('auth');
    }
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
         if(permission_access('dashboard_view')!=1)
           {
              echo '<header class="text-center">
                <h1>Access Denied!</h1>
                </header>';
                 die();
           }
        //  print_r($data);die;
        // if(Auth::id() == NULL){
        //     return redirect('/')->with('status',"Please login or register to access this page.");
        // }
        if (Auth::id() == NULL) {
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        else{
            if(Auth::user()->role != "admin"){
                Auth::logout();
                return redirect('/login');
            }
            else{
                // Session::put('popup', "abc");
                $topbanner = TopBanner::get();
                $topbannercount = count($topbanner);
                Session::put('topbannercount', $topbannercount);
                $textbanner = TextBanner::get();
                $textbannercount = count($textbanner);
                Session::put('textbannercount', $textbannercount);
                $homevideo = HomeVideo::get();
                $homevideocount = count($homevideo);
                Session::put('homevideocount', $homevideocount);
                $hometopvideo = HomeTopVideo::get();
                $hometopvideocount = count($hometopvideo);
                Session::put('hometopvideocount', $hometopvideocount);
                $homemainvideo = HomeMainVideo::get();
                $homemainvideocount = count($homemainvideo);
                Session::put('homemainvideocount', $homemainvideocount);
                $settingbanner = SettingBanner::get();
                $settingbannercount = count($settingbanner);
                Session::put('settingbannercount', $settingbannercount);
                $appointmentbanner = AppointmentBanner::get();
                $appointmentbannercount = count($appointmentbanner);
                Session::put('appointmentbannercount', $appointmentbannercount);
                $clientmanagementbanner = ClientManagementBanner::get();
                $clientmanagementbannercount = count($clientmanagementbanner);
                Session::put('clientmanagementbannercount', $clientmanagementbannercount);
                $emailmanagementbanner = EmailManagementBanner::get();
                $emailmanagementbannercount = count($emailmanagementbanner);
                Session::put('emailmanagementbannercount', $emailmanagementbannercount);
                $financialmanagementbanner = FinancialManagementBanner::get();
                $financialmanagementbannercount = count($financialmanagementbanner);
                Session::put('financialmanagementbannercount', $financialmanagementbannercount);
                $archivesbanner = ArchivesBanner::get();
                $archivesbannercount = count($archivesbanner);
                Session::put('archivesbannercount', $archivesbannercount);
                $data['chat'] = "";
                $data['tools'] = "";
                if(Auth::user()->role == "affiliate_user"){
                    $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
                    if($cdet->chat == "on"){
                        $data['chat'] = "on";
                    }
                    else{
                        $data['chat'] = "off";
                    }
                    if($cdet->tools == "on"){
                        $data['tools'] = "on";
                    }
                    else{
                        $data['tools'] = "off";
                    }
                }
                  $data['total_users']=User::where('status',1)->count();
               $data['user_month']=User::where('status',1)->whereMonth('created_at', Carbon::now()->month)->count();
               $data['user_week']=User::where('status',1)->whereBetween('created_at', [Carbon::now()->startOfWeek(), Carbon::now()->endOfWeek()])->count();
               $data['affiliate_users']=AffiliateRegistration::where('status',1)->count();
               $data['aff_month']=AffiliateRegistration::where('status',1)->whereMonth('created_at', Carbon::now()->month)->count();
               $data['aff_week']=AffiliateRegistration::where('status',1)->whereBetween('created_at', [Carbon::now()->startOfWeek(), Carbon::now()->endOfWeek()])->count();
                return view('admin')->with($data);
            }
        }
    }

    public function myView(Request $request)
    {

        return 123;
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        $changeappointmentid = $request->id;
        Session::put('changeappointmentid', $changeappointmentid);
        $data = DB::table('appointments')->join('client_appointment_lists', 'appointments.appointment_id', 'client_appointment_lists.id')->where('appointments.id', $request->id)->where('appointments.cstatus', "on")->first();
        $first_name = $data->first_name;
        $last_name = $data->last_name;
        $company = $data->company;
        Session::put('first_name', $first_name);
        Session::put('last_name', $last_name);
        Session::put('company', $company);
        Session::put('clientid', $data->appointment_id);
        return redirect('appointment_step3');
    }

    public function mainpage(Request $request)
    {
        MLMHomeController::deduct_commission_amount();
        $today = date('m-d');
        $data['abanner'] = "";
        $data['folders'] = "";
        $data['contacts'] = "";
        $data['popup_setting'] = "";
        $data['popup_mail'] = "";
        if((Auth::id() != "") && (Auth::user()->role == "affiliate")){
            $uid = Auth::id();
            $uemail = Auth::user()->email;
            $data['popup_setting'] = DB::table('popup_settings')->first();
            if($data['popup_setting']->category == 2){
                $category1 = DB::table('affiliate_registrations')->select('lead_category')->where('email', Auth::user()->email)->first();
                $category = DB::table('business_categories')->where('id', $category1->lead_category)->first();
                $data['details'] = DB::table('upload_popup2s')->where('category', $category1->lead_category)->get();
            }
            else{
                $category1 = DB::table('affiliate_registrations')->select('business_category')->where('email', Auth::user()->email)->first();
                if(!empty($category1)){
                $category = DB::table('business_categories')->where('id', $category1->business_category)->first();
                $data['details'] = DB::table('upload_popup1s')->where('category', $category1->business_category)->get();
            }else{
                $data['details']=[];
            }
            }
            $data['birthdays'] = ClientAppointmentList::where('dob', 'like', '%' .$today. '%')->where('uid', $uid)->get();
            $data['meeting_task'] = DB::table('meeting_task')->where('affiliate_id', Auth::id())->where('date', date('Y-m-d'))->get();
            $data['abanner'] = DB::table('affiliate_banner')->where('affiliate_email', $uemail)->first();
            $data['folders'] = DB::table('folders')->where('uid', $uid)->orWhere('uid', "default")->where('folder_name', '!=', "Basket X")->get();
            $data['popup_mail'] = DB::table('popup_mail')->where('uid', Auth::id())->orderBy('id', 'desc')->first();
            $data['contacts'] = Contacts::where('uid', $uid)->where('folder', '!=', '11')->where('status', 1)->get();
            $aaid = "";
            if((Auth::user()->role) == "affiliate"){
                $aaid = Auth::user()->email;
            }
            else{
                $aaid = Auth::user()->affiliate_user_email;
            }
            $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        }
        elseif((Auth::id() != "") && (Auth::user()->role == "affiliate_user")){
            Session::put('popup', "");
            $data['details'] = DB::table('upload_popup1s')->first();
            $data['meeting_task'] = DB::table('meeting_task')->where('date', date('Y-m-d'))->get();
            $data['birthdays'] = ClientAppointmentList::where('dob', 'like', '%' .$today. '%')->get();
            $aaid = "";
            if((Auth::user()->role) == "affiliate"){
                $aaid = Auth::user()->email;
            }
            else{
                $aaid = Auth::user()->affiliate_user_email;
            }
            $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        }
        else{
            Session::put('popup', "");
            $data['details'] = DB::table('upload_popup1s')->first();
            $data['meeting_task'] = DB::table('meeting_task')->where('date', date('Y-m-d'))->get();
            $data['birthdays'] = ClientAppointmentList::where('dob', 'like', '%' .$today. '%')->get();
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $data['top_banners'] = TopBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['slidetime2'] = DB::table('carouselplaytime2')->where('id', 1)->get();
        $data['slides'] = PhotoSlides::select('*')->where('status', "active")->get();
        $data['text_banners'] = TextBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['home_videos'] = HomeVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now]])->get();

        $data['transactions']=Mlm_transaction::get_usertransaction_list($request->year);
        // dd($data['transactions']);
             $data['recent_achievers']=User::get_recent_achievers();

             if (Auth::user()) {
                $data['usr'] = DB::table('affiliate_registrations')->where('email', Auth::user()->email)->first();
             }

            //  dd($usr);



        // dd($data['text_banners']);
        // dd($data['home_videos']);
        $data['communes'] = Comune::get();
        $data['religion'] = Religion::get();
        $data['business_category'] = BusinessCategory::get();
        $data['lead_cats'] = LeadsCategory::orderBy('category','asc')->get();
        $data['plans'] = Plan::where('status',1)->whereNotIn('id',[1])->orderBy('monthly_fee','asc')->get();
        $data['current_plan_total_day'] = Balance_info::get_total_plan_day(Auth::id())?:0;
        $plan_expire_message=DB::table('option_meta')->where('key','plan_expire_message')->first();
        $data['plan_expire_message'] =$plan_expire_message->value?:'';
        $data['transaction_section_one'] = SettingPages::where('upload_type', 'description_one')->where('page_name', 'home_page')->where('section_name', 'transactions')->first();
        $data['transaction_section_two'] = SettingPages::where('upload_type', 'description_two')->where('page_name', 'home_page')->where('section_name', 'transactions')->first();
        // dd($data['plans']);

        return view('main')->with($data);
    }
	public function testmainpage()
    {
        $today = date('m-d');
        $data['abanner'] = "";
        $data['folders'] = "";
        $data['contacts'] = "";
        $data['popup_setting'] = "";
        $data['popup_mail'] = "";
        if((Auth::id() != "") && (Auth::user()->role == "affiliate")){
            $uid = Auth::id();
            $uemail = Auth::user()->email;
            $data['popup_setting'] = DB::table('popup_settings')->first();
            if($data['popup_setting']->category == 2){
                $category1 = DB::table('affiliate_registrations')->select('lead_category')->where('email', Auth::user()->email)->first();
                $category = DB::table('business_categories')->where('id', $category1->lead_category)->first();
                $data['details'] = DB::table('upload_popup2s')->where('category', $category1->lead_category)->get();
            }
            else{
                $category1 = DB::table('affiliate_registrations')->select('business_category')->where('email', Auth::user()->email)->first();
                $category = DB::table('business_categories')->where('id', $category1->business_category)->first();
                $data['details'] = DB::table('upload_popup1s')->where('category', $category1->business_category)->get();
            }
            $data['birthdays'] = ClientAppointmentList::where('dob', 'like', '%' .$today. '%')->where('uid', $uid)->get();
            $data['meeting_task'] = DB::table('meeting_task')->where('affiliate_id', Auth::id())->where('date', date('Y-m-d'))->get();
            $data['abanner'] = DB::table('affiliate_banner')->where('affiliate_email', $uemail)->first();
            $data['folders'] = DB::table('folders')->where('uid', $uid)->orWhere('uid', "default")->where('folder_name', '!=', "Basket X")->get();
            $data['popup_mail'] = DB::table('popup_mail')->where('uid', Auth::id())->orderBy('id', 'desc')->first();
            $data['contacts'] = Contacts::where('uid', $uid)->where('folder', '!=', '11')->where('status', 1)->get();
            $aaid = "";
            if((Auth::user()->role) == "affiliate"){
                $aaid = Auth::user()->email;
            }
            else{
                $aaid = Auth::user()->affiliate_user_email;
            }
            $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        }
        elseif((Auth::id() != "") && (Auth::user()->role == "affiliate_user")){
            Session::put('popup', "");
            $data['details'] = DB::table('upload_popup1s')->first();
            $data['meeting_task'] = DB::table('meeting_task')->where('date', date('Y-m-d'))->get();
            $data['birthdays'] = ClientAppointmentList::where('dob', 'like', '%' .$today. '%')->get();
            $aaid = "";
            if((Auth::user()->role) == "affiliate"){
                $aaid = Auth::user()->email;
            }
            else{
                $aaid = Auth::user()->affiliate_user_email;
            }
            $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        }
        else{
            Session::put('popup', "");
            $data['details'] = DB::table('upload_popup1s')->first();
            $data['meeting_task'] = DB::table('meeting_task')->where('date', date('Y-m-d'))->get();
            $data['birthdays'] = ClientAppointmentList::where('dob', 'like', '%' .$today. '%')->get();
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $data['top_banners'] = TopBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['slidetime2'] = DB::table('carouselplaytime2')->where('id', 1)->get();
        $data['slides'] = PhotoSlides::select('*')->where('status', "active")->get();
        $data['text_banners'] = TextBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['home_videos'] = HomeVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
          $data['transactions']=Mlm_transaction::get_usertransaction_list();
             $data['recent_achievers']=User::get_recent_achievers();
        // echo "<pre>";
        // print_r($data['top_banners']);die();
        return view('testmain')->with($data);
    }
    public function calender_meeting()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
            return redirect('/')->with('status',"Admin can't access this page.");
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        // print_r($data['top_banners']);die();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('calender_meeting')->with($data);
    }
    public function calendarcheck()
    {
        $id = Auth::id();
        // print_r($doctor); die();
        $affiliate = DB::table('meeting_task')
            ->select('*')
            ->where('affiliate_id', $id)
            ->get();
        $events = array();
        for ($i=0; $i < count($affiliate) ; $i++) {
            $title = $affiliate[$i]->title;
            $startdate = $affiliate[$i]->start;
            $enddate= $affiliate[$i]->end;
            $color = "#0173fd";
            $textColor = "white";
            $e = array();
            $e['title'] = $title;
            $e['start'] = $startdate;
            $e['end'] = $enddate;
            $e['color'] = $color;
            $e['textColor'] = $textColor;
            array_push($events, $e);
        }
        echo json_encode($events);
        exit();
    }
    public function addevents(Request $request)
    {
        $id = Auth::id();
        $start = $request->start;
        $end = $request->end;
        $title = $request->title;
        $description = $request->description;
        $datee = explode('T', $start);
        $date = $datee[0];
        $data = DB::table('meeting_task')->insert(
                array('affiliate_id' => $id,
                      'title' => $title,
                      'start' => $start,
                      'end' => $end,
                      'description' => $description,
                      'date' => $date,
                  )
            );
        return redirect('calender_meeting');
    }
    public function profile()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "temp_user")
        {
            return redirect('temp_user_profile');
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uemail = "";
        if((Auth::user()->role) == "affiliate"){
            $uemail = Auth::user()->email;
        }
        else{
            $uemail = Auth::user()->affiliate_user_email;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        // print_r($data['top_banners']);die();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['details'] = AffiliateRegistration::where('email', $uemail)->get();
        // dd($data['details'][0]);
        $data['religion'] = Religion::get();
        $data['communes'] = Comune::get();
        $data['business_category'] = BusinessCategory::get();
        $data['lead_category'] = LeadsCategory::get();
          $aff_data=AffiliateRegistration::where('email',Auth::user()->email)->first();
          $data['my_referral_link'] ='';
          $data['my_profile_link'] ='';
          if(!empty($aff_data->code)){
              $sponsor_link=AffiliateRegistration::get_user_referral_link($aff_data->code,$aff_data->email);
               $data['my_referral_link'] =$sponsor_link;
                $data['my_profile_link']=url('user/'.$aff_data->username);
          }
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $data['is_medical_user'] = BusinessCategory::is_medical_user($aaid);
        return view('profile')->with($data);
    }
    public function chat()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['affiliate_banner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->first();
        $data['affiliate_details'] = DB::table('affiliate_registrations')->where('email', $aaid)->first();
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $data['colors'] = DB::table('background_color')->get();
        $data['attachments'] = Chat::whereNull('video_link')->whereNotNull('attachment')->where('from_user_id',Auth::id())->get();
        $data['videos'] = Chat::whereNull('attachment')->whereNotNull('video_link')->where('from_user_id',Auth::id())->get();
        return view('chat')->with($data);
    }
    public function banner()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uemail = "";
        if((Auth::user()->role) == "affiliate"){
            $uemail = Auth::user()->email;
        }
        else{
            $uemail = Auth::user()->affiliate_user_email;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['affiliate_banner'] = DB::table('affiliate_banner')->where('affiliate_email', $uemail)->first();
        $data['affiliate_details'] = DB::table('affiliate_registrations')->where('email', $uemail)->first();
        // if($data['affiliate_banner'] == null){
        //     $data['affiliate_banner']['background'] = "";
        // }
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('banner')->with($data);
    }




    public function import_contacts()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['folders'] = DB::table('import_contact_folder')->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('import_contacts')->with($data);
    }
    public function client_survey_records()
    {
      if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
         return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
            $uid = Auth::user()->id;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
              $uid = Auth::user()->affiliate_user_id;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['survey'] = DB::table('user_survey_records')->where('client_appointment_lists.uid',$uid)
                          ->join('users', 'users.id', '=', 'user_survey_records.user_id')
                          ->join('client_appointment_lists', 'users.email', '=', 'client_appointment_lists.email')
                         ->select('user_survey_records.*','client_appointment_lists.first_name','client_appointment_lists.last_name','client_appointment_lists.email')
                        ->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('main.client_survey_records')->with($data);
    }
    public function user_access_rights()
    {
      if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
         return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links']=$links = Menulinks::get();
        // echo "<pre>";
        //         print_r($links[19]->main_menu);die;

        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['users'] = DB::table('user_access_role')->where('sponsor_id', Auth::id())->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('user_access_rights')->with($data);
    }
    public function edit_user_access_rights(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $email = base64_decode($request->id);
        $data['users'] = DB::table('user_access_role')->join('user_day_access', 'user_access_role.email', 'user_day_access.uemail')->join('user_menu_access', 'user_access_role.email', 'user_menu_access.uemail')->join('user_menu_access2', 'user_access_role.email', 'user_menu_access2.uemail')->where('email', $email)->first();
        $data['religion'] = Religion::get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('edit_user_access_rights')->with($data);
    }
    public function add_user_access_rights()
    {
         if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['appointment_link'] = DB::table('menulinks')->where('main_menu', "Appointment")->get();
        $data['email_management_link'] = DB::table('menulinks')->where('main_menu', "Email Management")->get();
        $data['financial_management_link'] = DB::table('menulinks')->where('main_menu', "Financial Management")->get();
        $data['archive_link'] = DB::table('menulinks')->where('main_menu', "Archives")->get();
        $data['religion'] = Religion::get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('add_user_access_rights')->with($data);
    }
    public function add_appointment_setting()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uemail = "";
        if((Auth::user()->role) == "affiliate"){
            $uemail = Auth::user()->email;
        }
        else{
            $uemail = Auth::user()->affiliate_user_email;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['users'] = DB::table('appointment_settings')->where('uemail', $uemail)->get();
        $data['excount'] = count($data['users']);
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('add_appointment_setting')->with($data);
    }
    public function block_appointment_date()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['block_appointment'] = DB::table('block_appointment_date')->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('block_appointment_date')->with($data);
    }
    public function manag_date_settings()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('manag_date_settings')->with($data);
    }
    public function client_mgmt_setting()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('client_mgmt_setting')->with($data);
    }
    public function email_mgmt_setting()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('email_mgmt_setting')->with($data);
    }
    public function financial_mgmt_setting()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if(((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")) || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
         $category = AffiliateRegistration::where('email', Auth::user()->email)->first();
        $data['revenue'] = DB::table('revenue_account')->where(['uid'=> $uid,'category'=>$category->business_category])->get();
        $data['expenses'] = DB::table('expenses_account')->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('financial_mgmt_setting')->with($data);
    }
    public function financial_mgmt_expenses_settings()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
         $category = AffiliateRegistration::where('email', Auth::user()->email)->first();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['revenue'] = DB::table('revenue_account')->where(['uid'=> $uid,'category'=>$category->business_category])->get();
        $data['expenses'] = DB::table('expenses_account')->where(['uid'=> $uid,'category'=>$category->business_category])->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('financial_mgmt_expenses_settings')->with($data);
    }
    public function financial_mgmt_invoice_setup()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
         if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['invoice_setup'] = FinancialInvoiceSetup::where('uid', $uid)->first();
        //print_r($data['invoice_setup']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }

        $uid123 = Auth::id();

        $data['disc'] = Discount::where('uid', $uid123)->first();

        // dd($data['disc']);

        return view('financial_mgmt_invoice_setup')->with($data);
        // return view('financial_mgmt_invoice_setup')->with($data);
    }
    public function financial_mgmt_choose_template()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $admin = User::where('role', 'admin')->first();
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $usr = User::where('id', $uid)->first();
        $affiliate = AffiliateRegistration::where('email', $usr->email)->first();
        $business_category = BusinessCategory::where('id', $affiliate->business_category)->first();
      //  $category1 = DB::table('financial_template_categories')->where('category', $business_category->category)->first();
        $category1 = BusinessCategory::where('id', $affiliate->business_category)->first();;
        $category2 = "";
        $data['revenue_account'] = "";
        $data['expenses_account'] = "";
        $data['business_category'] = $affiliate->business_category;
        if($affiliate->lead_category != ""){
            $lead_category = LeadsCategory::where('id', $affiliate->lead_category)->first();
            $category2 = DB::table('financial_template_categories')->where('category', $lead_category->category)->first();
        }
        if(($category1 != "") && ($category2 != "")){
            $data['revenue_account'] = DB::table('revenue_account')->where('uid', $admin->id)->where('category', $category1->id)
           // ->orWhere('category', $category2->id)
            ->get();
            $data['expenses_account'] = DB::table('expenses_account')->where('uid', $admin->id)->where('category', $category1->id)
           // ->orWhere('category', $category2->id)
            ->get();
        }
        elseif(($category1 != "") && ($category2 == "")){
            $data['revenue_account'] = DB::table('revenue_account')->where('uid', $admin->id)->where('category', $category1->id)->get();
            $data['expenses_account'] = DB::table('expenses_account')->where('uid', $admin->id)->where('category', $category1->id)->get();
        }
        elseif(($category1 == "") && ($category2 != "")){
            $data['revenue_account'] = DB::table('revenue_account')->where('uid', $admin->id)->where('category', $category2->id)->get();
            $data['expenses_account'] = DB::table('expenses_account')->where('uid', $admin->id)->where('category', $category2->id)->get();
        }
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('financial_mgmt_choose_template')->with($data);
    }
    public function balancesheet_template1()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $admin = User::where('role', 'admin')->first();
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $affiliate=AffiliateRegistration::where('email',Auth::user()->email)->first();
        $business_category=$affiliate->business_category;
         $data['balancesheet_assets'] = DB::table('balancesheet_account')->where(['uid'=>$uid,'main_category'=>'assets','category'=>$business_category])->get();
         $data['balancesheet_nonassets'] = DB::table('balancesheet_account')->where(['uid'=>$uid,'main_category'=>'non_assets','category'=>$business_category])->get();
         $data['balancesheet_liability'] = DB::table('balancesheet_account')->where(['uid'=>$uid,'main_category'=>'liability','category'=>$business_category])->get();
         $data['balancesheet_nonliability'] = DB::table('balancesheet_account')->where(['uid'=>$uid,'main_category'=>'non_liability','category'=>$business_category])->get();
         $data['balancesheet_equity'] = DB::table('balancesheet_account')->where(['uid'=>$uid,'main_category'=>'equity','category'=>$business_category])->get();
        $data['revenue_amount'] = DB::table('revenue_record')->where('account_description', '!=', "Sales Tax Collected")->where('account_description', '!=', "Shipping Collected")->where('uid', $uid)->sum('balance');
        $data['expense_amount'] = DB::table('expense_record')->where('uid',$uid)->sum('balance');
        $data['receivable_amount']=$data['revenue_amount'];
        $data['record1']=DB::table('current_asset_balancesheet')->where('uid',$uid)->orderBy('id','desc')->first();
        $data['record2']=DB::table('noncurrent_asset_balancesheet')->where('uid',$uid)->orderBy('id','desc')->first();
        $data['record3']=DB::table('current_liability_balancesheet')->where('uid',$uid)->orderBy('id','desc')->first();
        $data['record4']=DB::table('noncurrent_liability_balancesheet')->where('uid',$uid)->orderBy('id','desc')->first();
        $data['record5']=DB::table('equity_balancesheet')->where('uid',$uid)->orderBy('id','desc')->first();
        return view('balancesheet_template1')->with($data);
    }
    public function manage_clients(Request $request)
    {
        $data['mode']='';
       $daily=$request->input('daily');
       $sdate=$request->input('sdate');
       $edate=$request->input('edate');
       $monthly=$request->input('monthly');



        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = ClientManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();

        if(!empty($daily)){
         $data['mode']='daily';

         $data['clients'] = ClientAppointmentList::where('uid', $uid)->where('uid', $uid)->whereDate('created_at', '=', $daily)->get();
        }elseif(!empty($monthly)){
          $data['mode']='monthly';

          $data['clients'] = ClientAppointmentList::where('uid', $uid)->whereMonth('created_at',$monthly)->whereYear('created_at', date('Y'))->get();
        }elseif (!empty($sdate) && !empty($edate)) {
           $data['mode']='weekly';

           $data['clients'] = ClientAppointmentList::where('uid', $uid)->whereBetween('created_at', [$sdate, $edate])->get();
        }else{
        $data['clients'] = ClientAppointmentList::where('uid', $uid)->get();
        }
        $data['category'] = CardCategory::orderBy('category','desc')->get();
        $data['cards'] = UploadCard::groupBy('category')->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('manage_clients')->with($data);
    }

    public function client_list(Request $request)
    {
        $data['mode']='';
       $daily=$request->input('daily');
       $sdate=$request->input('sdate');
       $edate=$request->input('edate');
       $monthly=$request->input('monthly');



        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = ClientManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();

        if(!empty($daily)){
         $data['mode']='daily';

         $data['clients'] = ClientAppointmentList::where('uid', $uid)->where('uid', $uid)->whereDate('created_at', '=', $daily)->get();
        }elseif(!empty($monthly)){
          $data['mode']='monthly';

          $data['clients'] = ClientAppointmentList::where('uid', $uid)->whereMonth('created_at',$monthly)->whereYear('created_at', date('Y'))->get();
        }elseif (!empty($sdate) && !empty($edate)) {
           $data['mode']='weekly';

           $data['clients'] = ClientAppointmentList::where('uid', $uid)->whereBetween('created_at', [$sdate, $edate])->get();
        }else{
        $data['clients'] = ClientAppointmentList::where('uid', $uid)->get();
        }
        $data['category'] = CardCategory::orderBy('category','desc')->get();
        $data['cards'] = UploadCard::groupBy('category')->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('client_list')->with($data);
    }
    public function view_client_profiles()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = ClientManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['clients'] = ClientAppointmentList::where('uid', $uid)->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('view_client_profiles')->with($data);
    }
    public function appointment_step3(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uemail = "";
        if((Auth::user()->role) == "affiliate"){
            $uemail = Auth::user()->email;
        }
        else{
            $uemail = Auth::user()->affiliate_user_email;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = AppointmentBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['id'] = $request->id;
        $data['appointment_settings_day'] = DB::table('appointment_settings')->where('uemail',$uemail)->first();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('appointment_step3')->with($data);
    }
    public function appointment_step2(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        $religion = $request->religion;
        $country = $request->country;
        $state = $request->state;
        $city = $request->city;
        $zipcode = $request->zipcode;
        Session::put('religion', $religion);
        Session::put('country', $country);
        Session::put('state', $state);
        Session::put('city', $city);
        Session::put('zipcode', $zipcode);
        return redirect('appointment_step2_detail');
    }
    public function appointment_step2_detail()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = AppointmentBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $religion = Session::get('religion');
        $country = Session::get('country');
        $state = Session::get('state');
        $city = Session::get('city');
        $zipcode = Session::get('zipcode');
        $data['clients'] = "";
        $data['searchf'] = "";
        $data['affiliates'] = "";
        $data['clients2'] = "";
        $data['users'] = "";
        if(($religion != "all") && ($country != "") && ($state != "") && ($city != "") && ($zipcode != "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['state', '=', $state],['city', '=', $city],['zip_code', '=', $zipcode],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['state', '=', $state],['city', '=', $city],['zip_code', '=', $zipcode],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['users'] = DB::table('user_access_role')->where([['state', '=', $state],['city', '=', $city],['zip_code', '=', $zipcode],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['state', '=', $state],['city', '=', $city],['zip_code', '=', $zipcode],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$country.", ".$state.", ".$city.", ".$zipcode;
        }
        elseif (($religion != "all") && ($country != "") && ($state == "") && ($city != "") && ($zipcode != "")) {
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['city', '=', $city],['zip_code', '=', $zipcode],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['city', '=', $city],['zip_code', '=', $zipcode],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['users'] = DB::table('user_access_role')->where([['city', '=', $city],['zip_code', '=', $zipcode],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['city', '=', $city],['zip_code', '=', $zipcode],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$country.", ".$city.", ".$zipcode;
        }
        elseif (($religion != "all") && ($country != "") && ($state == "") && ($city == "") && ($zipcode != "")) {
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['zip_code', '=', $zipcode],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['zip_code', '=', $zipcode],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['users'] = DB::table('user_access_role')->where([['zip_code', '=', $zipcode],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['zip_code', '=', $zipcode],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$country.", ".$zipcode;
        }
        elseif (($religion != "all") && ($country != "") && ($state == "") && ($city != "") && ($zipcode == "")) {
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['city', '=', $city],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['city', '=', $city],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['users'] = DB::table('user_access_role')->where([['city', '=', $city],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['city', '=', $city],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$country.", ".$city;
        }
        elseif(($religion != "all") && ($country != "") && ($state != "") && ($city == "") && ($zipcode != "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['state', '=', $state],['zip_code', '=', $zipcode],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['state', '=', $state],['zip_code', '=', $zipcode],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['users'] = DB::table('user_access_role')->where([['state', '=', $state],['zip_code', '=', $zipcode],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['state', '=', $state],['zip_code', '=', $zipcode],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$country.", ".$state.", ".$zipcode;
        }
        elseif(($religion != "all") && ($country != "") && ($state != "") && ($city == "") && ($zipcode == "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['state', '=', $state],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['state', '=', $state],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['users'] = DB::table('user_access_role')->where([['state', '=', $state],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['state', '=', $state],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$country.", ".$state;
        }
        elseif(($religion != "all") && ($country != "") && ($state != "") && ($city != "") && ($zipcode == "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['state', '=', $state],['city', '=', $city],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['state', '=', $state],['city', '=', $city],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['users'] = DB::table('user_access_role')->where([['state', '=', $state],['city', '=', $city],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['state', '=', $state],['city', '=', $city],['religion', '=', $religion],['country', '=', $country]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$country.", ".$state.", ".$city;
        }
        elseif(($religion != "all") && ($country != "") && ($state == "") && ($city == "") && ($zipcode == "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['religion', '=', $religion],['country', '=', $country]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['religion', '=', $religion],['country', '=', $country]])->get();
            $data['users'] = DB::table('user_access_role')->where([['religion', '=', $religion],['country', '=', $country]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['religion', '=', $religion],['country', '=', $country]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$country;
        }
        elseif(($religion == "all") && ($country != "") && ($state != "") && ($city != "") && ($zipcode != "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['state', '=', $state],['city', '=', $city],['zip_code', '=', $zipcode],['country', '=', $country]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['state', '=', $state],['city', '=', $city],['zip_code', '=', $zipcode],['country', '=', $country]])->get();
            $data['users'] = DB::table('user_access_role')->where([['state', '=', $state],['city', '=', $city],['zip_code', '=', $zipcode],['country', '=', $country]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['state', '=', $state],['city', '=', $city],['zip_code', '=', $zipcode],['country', '=', $country]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$country.", ".$state.", ".$city.", ".$zipcode;
        }
        elseif (($religion == "all") && ($country != "") && ($state == "") && ($city != "") && ($zipcode != "")) {
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['city', '=', $city],['zip_code', '=', $zipcode],['country', '=', $country]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['city', '=', $city],['zip_code', '=', $zipcode],['country', '=', $country]])->get();
            $data['users'] = DB::table('user_access_role')->where([['city', '=', $city],['zip_code', '=', $zipcode],['country', '=', $country]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['city', '=', $city],['zip_code', '=', $zipcode],['country', '=', $country]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$country.", ".$city.", ".$zipcode;
        }
        elseif (($religion == "all") && ($country != "") && ($state == "") && ($city == "") && ($zipcode != "")) {
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['zip_code', '=', $zipcode],['country', '=', $country]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['zip_code', '=', $zipcode],['country', '=', $country]])->get();
            $data['users'] = DB::table('user_access_role')->where([['zip_code', '=', $zipcode],['country', '=', $country]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['zip_code', '=', $zipcode],['country', '=', $country]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$country.", ".$zipcode;
        }
        elseif (($religion == "all") && ($country != "") && ($state == "") && ($city != "") && ($zipcode == "")) {
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['city', '=', $city],['country', '=', $country]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['city', '=', $city],['country', '=', $country]])->get();
            $data['users'] = DB::table('user_access_role')->where([['city', '=', $city],['country', '=', $country]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['city', '=', $city],['country', '=', $country]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$country.", ".$city;
        }
        elseif(($religion == "all") && ($country != "") && ($state != "") && ($city == "") && ($zipcode != "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['state', '=', $state],['zip_code', '=', $zipcode],['country', '=', $country]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['state', '=', $state],['zip_code', '=', $zipcode],['country', '=', $country]])->get();
            $data['users'] = DB::table('user_access_role')->where([['state', '=', $state],['zip_code', '=', $zipcode],['country', '=', $country]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['state', '=', $state],['zip_code', '=', $zipcode],['country', '=', $country]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$country.", ".$state.", ".$zipcode;
        }
        elseif(($religion == "all") && ($country != "") && ($state != "") && ($city == "") && ($zipcode == "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['state', '=', $state],['country', '=', $country]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['state', '=', $state],['country', '=', $country]])->get();
            $data['users'] = DB::table('user_access_role')->where([['state', '=', $state],['country', '=', $country]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['state', '=', $state],['country', '=', $country]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$country.", ".$state;
        }
        elseif(($religion == "all") && ($country != "") && ($state != "") && ($city != "") && ($zipcode == "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['state', '=', $state],['city', '=', $city],['country', '=', $country]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['state', '=', $state],['city', '=', $city],['country', '=', $country]])->get();
            $data['users'] = DB::table('user_access_role')->where([['state', '=', $state],['city', '=', $city],['country', '=', $country]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['state', '=', $state],['city', '=', $city],['country', '=', $country]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$country.", ".$state.", ".$city;
        }
        elseif(($religion == "all") && ($country != "") && ($state == "") && ($city == "") && ($zipcode == "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['country', '=', $country]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['country', '=', $country]])->get();
            $data['users'] = DB::table('user_access_role')->where([['country', '=', $country]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['country', '=', $country]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$country;
        }
        elseif(($religion != "all") && ($country == "") && ($state != "") && ($city != "") && ($zipcode != "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['state', '=', $state],['city', '=', $city],['zip_code', '=', $zipcode],['religion', '=', $religion]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['state', '=', $state],['city', '=', $city],['zip_code', '=', $zipcode],['religion', '=', $religion]])->get();
            $data['users'] = DB::table('user_access_role')->where([['state', '=', $state],['city', '=', $city],['zip_code', '=', $zipcode],['religion', '=', $religion]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['state', '=', $state],['city', '=', $city],['zip_code', '=', $zipcode],['religion', '=', $religion]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$state.", ".$city.", ".$zipcode;
        }
        elseif (($religion != "all") && ($country == "") && ($state == "") && ($city != "") && ($zipcode != "")) {
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['city', '=', $city],['zip_code', '=', $zipcode],['religion', '=', $religion]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['city', '=', $city],['zip_code', '=', $zipcode],['religion', '=', $religion]])->get();
            $data['users'] = DB::table('user_access_role')->where([['city', '=', $city],['zip_code', '=', $zipcode],['religion', '=', $religion]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['city', '=', $city],['zip_code', '=', $zipcode],['religion', '=', $religion]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$city.", ".$zipcode;
        }
        elseif (($religion != "all") && ($country == "") && ($state == "") && ($city == "") && ($zipcode != "")) {
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['zip_code', '=', $zipcode],['religion', '=', $religion]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['zip_code', '=', $zipcode],['religion', '=', $religion]])->get();
            $data['users'] = DB::table('user_access_role')->where([['zip_code', '=', $zipcode],['religion', '=', $religion]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['zip_code', '=', $zipcode],['religion', '=', $religion]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$zipcode;
        }
        elseif (($religion != "all") && ($country == "") && ($state == "") && ($city != "") && ($zipcode == "")) {
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['city', '=', $city],['religion', '=', $religion]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['city', '=', $city],['religion', '=', $religion]])->get();
            $data['users'] = DB::table('user_access_role')->where([['city', '=', $city],['religion', '=', $religion]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['city', '=', $city],['religion', '=', $religion]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$city;
        }
        elseif(($religion != "all") && ($country == "") && ($state != "") && ($city == "") && ($zipcode != "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['state', '=', $state],['zip_code', '=', $zipcode],['religion', '=', $religion]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['state', '=', $state],['zip_code', '=', $zipcode],['religion', '=', $religion]])->get();
            $data['users'] = DB::table('user_access_role')->where([['state', '=', $state],['zip_code', '=', $zipcode],['religion', '=', $religion]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['state', '=', $state],['zip_code', '=', $zipcode],['religion', '=', $religion]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$state.", ".$zipcode;
        }
        elseif(($religion != "all") && ($country == "") && ($state != "") && ($city == "") && ($zipcode == "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['state', '=', $state],['religion', '=', $religion]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['state', '=', $state],['religion', '=', $religion]])->get();
            $data['users'] = DB::table('user_access_role')->where([['state', '=', $state],['religion', '=', $religion]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['state', '=', $state],['religion', '=', $religion]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$state;
        }
        elseif(($religion != "all") && ($country == "") && ($state != "") && ($city != "") && ($zipcode == "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['state', '=', $state],['city', '=', $city],['religion', '=', $religion]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['state', '=', $state],['city', '=', $city],['religion', '=', $religion]])->get();
            $data['users'] = DB::table('user_access_role')->where([['state', '=', $state],['city', '=', $city],['religion', '=', $religion]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['state', '=', $state],['city', '=', $city],['religion', '=', $religion]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$state.", ".$city;
        }
        elseif(($religion != "all") && ($country == "") && ($state == "") && ($city == "") && ($zipcode == "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['religion', '=', $religion]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['religion', '=', $religion]])->get();
            $data['users'] = DB::table('user_access_role')->where([['religion', '=', $religion]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['religion', '=', $religion]])->get();
            $data['searchf'] = "Search for ".$religion;
        }
        elseif(($religion == "all") && ($country == "") && ($state != "") && ($city != "") && ($zipcode != "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['state', '=', $state],['city', '=', $city],['zip_code', '=', $zipcode]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['state', '=', $state],['city', '=', $city],['zip_code', '=', $zipcode]])->get();
            $data['users'] = DB::table('user_access_role')->where([['state', '=', $state],['city', '=', $city],['zip_code', '=', $zipcode]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['state', '=', $state],['city', '=', $city],['zip_code', '=', $zipcode]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$state.", ".$city.", ".$zipcode;
        }
        elseif (($religion == "all") && ($country == "") && ($state == "") && ($city != "") && ($zipcode != "")) {
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['city', '=', $city],['zip_code', '=', $zipcode]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['city', '=', $city],['zip_code', '=', $zipcode]])->get();
            $data['users'] = DB::table('user_access_role')->where([['city', '=', $city],['zip_code', '=', $zipcode]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['city', '=', $city],['zip_code', '=', $zipcode]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$city.", ".$zipcode;
        }
        elseif (($religion == "all") && ($country == "") && ($state == "") && ($city == "") && ($zipcode != "")) {
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['zip_code', '=', $zipcode]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['zip_code', '=', $zipcode]])->get();
            $data['users'] = DB::table('user_access_role')->where([['zip_code', '=', $zipcode]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['zip_code', '=', $zipcode]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$zipcode;
        }
        elseif (($religion == "all") && ($country == "") && ($state == "") && ($city != "") && ($zipcode == "")) {
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['city', '=', $city]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['city', '=', $city]])->get();
            $data['users'] = DB::table('user_access_role')->where([['city', '=', $city]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['city', '=', $city]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$country.", ".$city;
        }
        elseif(($religion == "all") && ($country == "") && ($state != "") && ($city == "") && ($zipcode != "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['state', '=', $state],['zip_code', '=', $zipcode]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['state', '=', $state],['zip_code', '=', $zipcode]])->get();
            $data['users'] = DB::table('user_access_role')->where([['state', '=', $state],['zip_code', '=', $zipcode]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['state', '=', $state],['zip_code', '=', $zipcode]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$state.", ".$zipcode;
        }
        elseif(($religion == "all") && ($country == "") && ($state != "") && ($city == "") && ($zipcode == "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['state', '=', $state]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['state', '=', $state]])->get();
            $data['users'] = DB::table('user_access_role')->where([['state', '=', $state]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['state', '=', $state]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$state;
        }
        elseif(($religion == "all") && ($country == "") && ($state != "") && ($city != "") && ($zipcode == "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where([['state', '=', $state],['city', '=', $city]])->get();
            $data['affiliates'] = AffiliateRegistration::where([['state', '=', $state],['city', '=', $city]])->get();
            $data['users'] = DB::table('user_access_role')->where([['state', '=', $state],['city', '=', $city]])->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where([['state', '=', $state],['city', '=', $city]])->get();
            $data['searchf'] = "Search for ".$religion.", ".$state.", ".$city;
        }
        elseif(($religion == "all") && ($country == "") && ($state == "") && ($city == "") && ($zipcode == "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->get();
            $data['affiliates'] = AffiliateRegistration::get();
            $data['users'] = DB::table('user_access_role')->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->get();
            $data['searchf'] = "Search for ".$religion;
        }
        // print_r($data['clients']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('appointment_step2')->with($data);
    }
    public function appointment_stepp2(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        $first_name = $request->first_name;
        $last_name = $request->last_name;
        $company = $request->company;
        Session::put('first_name', $first_name);
        Session::put('last_name', $last_name);
        Session::put('company', $company);
        if(($first_name == "") && ($last_name == "") && ($company == "")){
            Session::flash('success', "Success!");
            return redirect()->back()->with('status',"Enter Details.");
        }
        return redirect('appointment_stepp2_detail');
    }
    public function appointment_stepp2_detail()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = AppointmentBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $first_name = Session::get('first_name');
        $last_name = Session::get('last_name');
        $company = Session::get('company');
        $data['clients'] = "";
        $data['searchf'] = "";
        $data['affiliates'] = "";
        $data['clients2'] = "";
        $data['users'] = "";
        if(($first_name != "") && ($last_name != "") && ($company != "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where('first_name', 'like', '%' .$first_name. '%')->where('last_name', 'like', '%' .$last_name. '%')->where('company', 'like', '%' .$company. '%')->get();
             $data['affiliates'] = AffiliateRegistration::where('first_name', 'like', '%' .$first_name. '%')->where('last_name', 'like', '%' .$last_name. '%')->get();
            $data['users'] = DB::table('user_access_role')->where('first_name', 'like', '%' .$first_name. '%')->where('last_name', 'like', '%' .$last_name. '%')->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where('first_name', 'like', '%' .$first_name. '%')->where('last_name', 'like', '%' .$last_name. '%')->where('company', 'like', '%' .$company. '%')->get();
            $data['searchf'] = "Search for ".$first_name.", ".$last_name.", ".$company;
        }
        elseif(($first_name == "") && ($last_name != "") && ($company != "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where('last_name', 'like', '%' .$last_name. '%')->where('company', 'like', '%' .$company. '%')->get();
             $data['affiliates'] = AffiliateRegistration::where('last_name', 'like', '%' .$last_name. '%')->get();
            $data['users'] = DB::table('user_access_role')->where('last_name', 'like', '%' .$last_name. '%')->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where('last_name', 'like', '%' .$last_name. '%')->where('company', 'like', '%' .$company. '%')->get();
            $data['searchf'] = "Search for ".$last_name.", ".$company;
        }
        elseif(($first_name == "") && ($last_name == "") && ($company != "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where('company', 'like', '%' .$company. '%')->get();
             $data['affiliates'] = "";
            $data['users'] = "";
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where('company', 'like', '%' .$company. '%')->get();
            $data['searchf'] = "Search for ".$company;
        }
        elseif(($first_name == "") && ($last_name != "") && ($company == "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where('last_name', 'like', '%' .$last_name. '%')->get();
             $data['affiliates'] = AffiliateRegistration::where('last_name', 'like', '%' .$last_name. '%')->get();
            $data['users'] = DB::table('user_access_role')->where('last_name', 'like', '%' .$last_name. '%')->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where('last_name', 'like', '%' .$last_name. '%')->get();
            $data['searchf'] = "Search for ".$last_name;
        }
        elseif(($first_name != "") && ($last_name == "") && ($company != "")){
            $data['clients'] = ClientAppointmentList::where('uid',$uid)->where('first_name', 'like', '%' .$first_name. '%')->where('company', 'like', '%' .$company. '%')->get();
             $data['affiliates'] = AffiliateRegistration::where('first_name', 'like', '%' .$first_name. '%')->get();
            $data['users'] = DB::table('user_access_role')->where('first_name', 'like', '%' .$first_name. '%')->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where('first_name', 'like', '%' .$first_name. '%')->where('company', 'like', '%' .$company. '%')->get();
            $data['searchf'] = "Search for ".$first_name.", ".$company;
        }
        elseif(($first_name != "") && ($last_name == "") && ($company == "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where('first_name', 'like', '%' .$first_name. '%')->get();
             $data['affiliates'] = AffiliateRegistration::where('first_name', 'like', '%' .$first_name. '%')->get();
            $data['users'] = DB::table('user_access_role')->where('first_name', 'like', '%' .$first_name. '%')->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where('first_name', 'like', '%' .$first_name. '%')->get();
            $data['searchf'] = "Search for ".$first_name;
        }
        elseif(($first_name != "") && ($last_name != "") && ($company == "")){
            $data['clients'] = ClientAppointmentList::where('uid', $uid)->where('first_name', 'like', '%' .$first_name. '%')->where('last_name', 'like', '%' .$last_name. '%')->get();
             $data['affiliates'] = AffiliateRegistration::where('first_name', 'like', '%' .$first_name. '%')->where('last_name', 'like', '%' .$last_name. '%')->get();
            $data['users'] = DB::table('user_access_role')->where('first_name', 'like', '%' .$first_name. '%')->where('last_name', 'like', '%' .$last_name. '%')->get();
            $data['clients2'] = ClientAppointmentList::where('uid', '!=', $uid)->where('first_name', 'like', '%' .$first_name. '%')->where('last_name', 'like', '%' .$last_name. '%')->get();
            $data['searchf'] = "Search for ".$first_name.", ".$last_name;
        }
        // $data['clients'] = ClientAppointmentList::where('first_name', 'like', '%' .$first_name. '%')->orWhere('last_name', 'like', '%' .$last_name. '%')->orWhere('company', 'like', '%' .$company. '%')->get();
        // print_r($data['clients']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('appointment_step2')->with($data);
    }
    public function appointment_steppp2(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        $category = $request->category;
        Session::put('category', $category);
        return redirect('appointment_steppp2_detail');
    }
    public function appointment_steppp2_detail(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = AppointmentBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $category = Session::get('category');
        $data['clients'] = ClientAppointmentList::select('client_appointment_lists.first_name as first_name', 'client_appointment_lists.last_name as last_name', 'client_appointment_lists.email as email', 'client_appointment_lists.company as company', 'client_appointment_lists.address as address', 'client_appointment_lists.state as state','client_appointment_lists.country as country', 'client_appointment_lists.zip_code as zip', 'client_appointment_lists.city as city', 'client_appointment_lists.cell_phone as phone', 'client_appointment_lists.image as image')
                ->join('users', 'users.id', '=', 'client_appointment_lists.uid')
                ->join('affiliate_registrations', 'affiliate_registrations.email', '=', 'users.email')
                ->where('affiliate_registrations.business_category', $category)
                ->where('client_appointment_lists.uid', $uid)
                ->get();
        $data['affiliates'] = AffiliateRegistration::where('business_category', $category)->get();
        $data['clients2'] = ClientAppointmentList::select('client_appointment_lists.first_name as first_name', 'client_appointment_lists.last_name as last_name', 'client_appointment_lists.email as email', 'client_appointment_lists.company as company', 'client_appointment_lists.address as address', 'client_appointment_lists.state as state','client_appointment_lists.country as country', 'client_appointment_lists.zip_code as zip', 'client_appointment_lists.city as city', 'client_appointment_lists.cell_phone as phone', 'client_appointment_lists.image as image')
                ->join('users', 'users.id', '=', 'client_appointment_lists.uid')
                ->join('affiliate_registrations', 'affiliate_registrations.email', '=', 'users.email')
                ->where('affiliate_registrations.business_category', $category)
                ->where('client_appointment_lists.uid', '!=', $uid)
                ->get();
        $data['users'] = DB::table('user_access_role')
                ->join('users', 'users.id', '=', 'user_access_role.sponsor_id')
                ->join('affiliate_registrations', 'affiliate_registrations.email', '=', 'users.email')
                ->where('affiliate_registrations.business_category', $category)
                ->get();
        $category_name = BusinessCategory::where('id', $category)->first();
        $data['searchf'] = "Search for ".$category_name->category;
        // print_r($data['clients']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('appointment_step2')->with($data);
    }
    public function appointment_step1()
    {
        if(Auth::id() == NULL){
            return redirect('appointment_login');
            // return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "client")){
            return redirect('/member_appointment_step1');
        }
        if(Auth::user()->role == "admin"){
            return redirect('/')->with('status',"Admin can't access this page.");
        }
        if((Auth::user()->role == "temp_user")){
            return redirect('/user_appointment_step1');
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = AppointmentBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['category'] = BusinessCategory::get();
        $data['religion'] = Religion::get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('appointment_step1')->with($data);
    }
    public function appointment_step4()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = AppointmentBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['appointment_date'] = Session::get('appointment_date');
        $data['appointment_time'] = Session::get('appointment_time');
        $data['appointment_reason'] = Session::get('appointment_reason');
        $data['appointment_id'] = Session::get('appointment_id');
        // print_r($data['appointment_id']);die();
        $data['day'] =  Carbon::parse($data['appointment_date'])->format('l');
        $data['client'] = DB::table('client_appointment_lists')
                ->select('client_appointment_lists.first_name as client_first_name', 'client_appointment_lists.last_name as client_last_name', 'client_appointment_lists.email as client_email', 'client_appointment_lists.company as client_company', 'client_appointment_lists.address as client_address', 'client_appointment_lists.state as client_state','client_appointment_lists.country as client_country', 'client_appointment_lists.zip_code as client_zip', 'client_appointment_lists.city as client_city', 'client_appointment_lists.cell_phone as client_phone', 'affiliate_registrations.first_name as affiliate_first_name', 'affiliate_registrations.last_name as affiliate_last_name', 'affiliate_registrations.email as affiliate_email', 'affiliate_registrations.image as affiliate_image', 'affiliate_registrations.cellphone as affiliate_phone', 'affiliate_registrations.address as affiliate_address', 'affiliate_registrations.state as affiliate_state', 'affiliate_registrations.country as affiliate_country', 'affiliate_registrations.city as affiliate_city', 'affiliate_registrations.zip_code as affiliate_zip', 'affiliate_registrations.company as affiliate_company')
                ->join('users', 'users.id', '=', 'client_appointment_lists.uid')
                ->join('affiliate_registrations', 'affiliate_registrations.email', '=', 'users.email')
                ->where('client_appointment_lists.id', $data['appointment_id'])
                ->first();
        //print_r($data['top_banners']);die();
        $data['user'] = DB::table('affiliate_registrations')->where('email',Auth::user()->email)->first();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('appointment_step4')->with($data);
    }
    public function appointment_step5()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = AppointmentBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->get();
        $data['contacts'] = Contacts::where('uid', $uid)->where('status', 1)->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $changeappointmentid = Session::get('changeappointmentid');
        if($changeappointmentid != ""){
            return redirect('confirm_appointment');
        }
        else{
            return view('appointment_step5')->with($data);
        }
    }
    public function confirm_appointment()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = AppointmentBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['appointment_date'] = Session::get('appointment_date');
        $data['appointment_time'] = Session::get('appointment_time');
        $data['appointment_reason'] = Session::get('appointment_reason');
        $data['appointment_id'] = Session::get('appointment_id');
        $data['day'] =  Carbon::parse($data['appointment_date'])->format('l');
        $data['client'] = DB::table('client_appointment_lists')
                ->select('client_appointment_lists.first_name as client_first_name', 'client_appointment_lists.last_name as client_last_name', 'client_appointment_lists.email as client_email', 'client_appointment_lists.company as client_company', 'client_appointment_lists.address as client_address', 'client_appointment_lists.state as client_state','client_appointment_lists.country as client_country', 'client_appointment_lists.zip_code as client_zip', 'client_appointment_lists.city as client_city', 'client_appointment_lists.cell_phone as client_phone', 'affiliate_registrations.first_name as affiliate_first_name', 'affiliate_registrations.last_name as affiliate_last_name', 'affiliate_registrations.email as affiliate_email', 'affiliate_registrations.image as affiliate_image', 'affiliate_registrations.cellphone as affiliate_phone', 'affiliate_registrations.address as affiliate_address', 'affiliate_registrations.state as affiliate_state', 'affiliate_registrations.country as affiliate_country', 'affiliate_registrations.city as affiliate_city', 'affiliate_registrations.zip_code as affiliate_zip', 'affiliate_registrations.company as affiliate_company')
                ->join('users', 'users.id', '=', 'client_appointment_lists.uid')
                ->join('affiliate_registrations', 'affiliate_registrations.email', '=', 'users.email')
                ->where('client_appointment_lists.id', $data['appointment_id'])
                ->first();
        //print_r($data['top_banners']);die();
        $data['user'] = DB::table('affiliate_registrations')->where('email',Auth::user()->email)->first();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('confirm_appointment')->with($data);
    }
    public function final_appointment()
    {
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $uemail = "";
        if((Auth::user()->role) == "affiliate"){
            $uemail = Auth::user()->email;
        }
        else{
            $uemail = Auth::user()->affiliate_user_email;
        }
        $changeappointmentid = Session::get('changeappointmentid');
        if($changeappointmentid == ""){
            $slot = DB::table('appointment_settings')->where('uemail', $uemail)->first();
            $start = Session::get('appointment_time');
            $end = date("H:i", strtotime('+'.$slot->receive_time.' minutes', strtotime($start)));
            $values = array(
                'appointment_id' => Session::get('appointment_id'),
                'appointment_date' => date('Y-m-d', strtotime(Session::get('appointment_date'))),
                'appointment_time' => Session::get('appointment_time'),
                'appointment_end' => $end,
                'appointment_reason' => Session::get('appointment_reason'),
                'additional_comment' => Session::get('additional_comment'),
                'name1' => Session::get('name1'),
                'name2' => Session::get('name2'),
                'name3' => Session::get('name3'),
                'email1' => Session::get('email1'),
                'email2' => Session::get('email2'),
                'email3' => Session::get('email3'),
                'uid'   => $uid
            );
            DB::table('appointments')->insert($values);
            $adate=date('Y-m-d', strtotime(Session::get('appointment_date')));
            $atime=Session::get('appointment_time');
            $notification  = getNotificationMessage(3);
            $message = $notification;
            $subject = "Appointment Booked";
             addUserActivity($subject,'add',$notification,$message);
        }
        else{
            $slot = DB::table('appointment_settings')->where('uemail', $uemail)->first();
            $start = Session::get('appointment_time');
            $end = date("H:i", strtotime('+'.$slot->receive_time.' minutes', strtotime($start)));
            $values = array(
                'appointment_id' => Session::get('appointment_id'),
                'appointment_date' => date('Y-m-d', strtotime(Session::get('appointment_date'))),
                'appointment_time' => Session::get('appointment_time'),
                'appointment_end' => $end,
                'appointment_reason' => Session::get('appointment_reason'),
                'uid'   => $uid
            );
            $appointmentdet = DB::table('appointments')->where('appointments.cstatus', "on")->where('id', $changeappointmentid)->first();
                $prevdate = date('d F Y', strtotime($appointmentdet->appointment_date));
                $prevtime = date('H:i a', strtotime($appointmentdet->appointment_time));
                $newdate = date('d F Y', strtotime(Session::get('appointment_date')));
                $newtime = date('H:i a', strtotime(Session::get('appointment_time')));
                $notification  = getNotificationMessage(4);
            $message = $notification;
            $subject = "Appointment Changed";
            addUserActivity($subject,'update',$notification,$message);
            DB::table('appointments')->where('appointments.cstatus', "on")->where('id', $changeappointmentid)->update($values);
            DB::table('change_appointment')->insert($values);
            Session::put('changeappointmentid', "");
        }
        return redirect('print_appointment');
    }
    public function print_appointment()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $uemail = "";
        if((Auth::user()->role) == "affiliate"){
            $uemail = Auth::user()->email;
        }
        else{
            $uemail = Auth::user()->affiliate_user_email;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = AppointmentBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['appointment_id'] = Session::get('appointment_id');
        $data['appointment_date'] = date('d F Y', strtotime(Session::get('appointment_date')));
        $data['appointment_time'] = Session::get('appointment_time');
        $data['day'] =  Carbon::parse($data['appointment_date'])->format('l');
        $data['banner1'] = DB::table('affiliate_banner')->where('affiliate_email', $uemail)->first();
        $data['banner'] = $data['banner1']->preview;
        $data['client'] = DB::table('client_appointment_lists')
                ->select('client_appointment_lists.first_name as client_first_name', 'client_appointment_lists.last_name as client_last_name', 'client_appointment_lists.email as client_email', 'client_appointment_lists.company as client_company', 'client_appointment_lists.address as client_address', 'client_appointment_lists.state as client_state','client_appointment_lists.country as client_country', 'client_appointment_lists.zip_code as client_zip', 'client_appointment_lists.city as client_city', 'client_appointment_lists.cell_phone as client_phone', 'affiliate_registrations.first_name as affiliate_first_name', 'affiliate_registrations.last_name as affiliate_last_name', 'affiliate_registrations.email as affiliate_email', 'affiliate_registrations.image as affiliate_image', 'affiliate_registrations.cellphone as affiliate_phone', 'affiliate_registrations.address as affiliate_address', 'affiliate_registrations.state as affiliate_state', 'affiliate_registrations.country as affiliate_country', 'affiliate_registrations.city as affiliate_city', 'affiliate_registrations.zip_code as affiliate_zip', 'affiliate_registrations.company as affiliate_company')
                ->join('users', 'users.id', '=', 'client_appointment_lists.uid')
                ->join('affiliate_registrations', 'affiliate_registrations.email', '=', 'users.email')
                ->where('client_appointment_lists.id', $data['appointment_id'])
                ->first();
        //print_r($data['top_banners']);die();
       $data['user'] = DB::table('affiliate_registrations')->where('email',Auth::user()->email)->first();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('print_appointment')->with($data);
    }
    public function add_client()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = ClientManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['category'] = BusinessCategory::get();
        $data['religion'] = Religion::get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $data['communes'] = Comune::get();

        return view('add_client')->with($data);
    }
    public function balancesheet_template2()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
          $admin = User::where('role', 'admin')->first();
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['uid']=$uid;
        $affiliate=AffiliateRegistration::where('email',Auth::user()->email)->first();
        $category=$affiliate->business_category;
         $data['balancesheet_assets'] = DB::table('balancesheet_account')->where(['uid'=>$uid,'category'=>$category,'main_category'=>'assets'])->get();
         $data['balancesheet_nonassets'] = DB::table('balancesheet_account')->where(['uid'=>$uid,'category'=>$category,'main_category'=>'non_assets'])->get();
         $data['balancesheet_liability'] = DB::table('balancesheet_account')->where(['uid'=>$uid,'category'=>$category,'main_category'=>'liability'])->get();
        // echo "<pre>";print_r($data['balancesheet_liability']);die;
         $data['balancesheet_nonliability'] = DB::table('balancesheet_account')->where(['uid'=>$uid,'category'=>$category,'main_category'=>'non_liability'])->get();
         $data['balancesheet_equity'] = DB::table('balancesheet_account')->where(['uid'=>$uid,'category'=>$category,'main_category'=>'equity'])->get();
        $data['years']=DB::table('current_asset_balancesheet')->orderBy('created_at','desc')
         ->groupBy(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"))
        ->get(array(DB::raw('Year(created_at) as created_at')));
        // $data['record2']=DB::table('noncurrent_asset_balancesheet')->orderBy('created_at','desc')
        //  ->groupBy(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"))
        // ->get(array(DB::raw('Year(created_at) as created_at')));
        // $data['record3']=DB::table('current_liability_balancesheet')->orderBy('created_at','desc')
        //  ->groupBy(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"))
        // ->get(array(DB::raw('Year(created_at) as created_at')));
        // $data['record4']=DB::table('noncurrent_liability_balancesheet')->orderBy('created_at','desc')
        //  ->groupBy(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"))
        // ->get(array(DB::raw('Year(created_at) as created_at')));
        // $data['record5']=DB::table('equity_balancesheet')->orderBy('created_at','desc')
        //  ->groupBy(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"))
        // ->get(array(DB::raw('Year(created_at) as created_at')));
        return view('balancesheet_template2')->with($data);
    }
    public function balancesheet_settings()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $admin = User::where('role', 'admin')->first();
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $usr = User::where('id', $uid)->first();
        $affiliate = AffiliateRegistration::where('email', $usr->email)->first();
        $business_category = BusinessCategory::where('id', $affiliate->business_category)->first();
        $category1 = DB::table('financial_template_categories')->where('category', $business_category->category)->first();
        $category2 = "";
        $data['balancesheet_assets'] = "";
        $data['balancesheet_liability'] = "";
        $data['balancesheet_equity'] = "";
        if($affiliate->lead_category != ""){
            $lead_category = LeadsCategory::where('id', $affiliate->lead_category)->first();
            $category2 = DB::table('financial_template_categories')->where('category', $lead_category->category)->first();
        }
    $data['balancesheet_assets'] = DB::table('balancesheet_account')->where(['uid'=>$admin->id,'category'=> $business_category->id,'main_category'=>'assets'])->get();
    $data['balancesheet_nonassets'] = DB::table('balancesheet_account')->where(['uid'=>$admin->id,'category'=> $business_category->id,'main_category'=>'non_assets'])->get();
    $data['balancesheet_liability'] = DB::table('balancesheet_account')->where(['uid'=>$admin->id,'category'=>$business_category->id,'main_category'=>'liability'])->get();
      $data['balancesheet_nonliability'] = DB::table('balancesheet_account')->where(['uid'=>$admin->id,'category'=>$business_category->id,'main_category'=>'non_liability'])->get();
    $data['balancesheet_equity'] = DB::table('balancesheet_account')->where(['uid'=>$admin->id,'category'=>$business_category->id,'main_category'=>'equity'])->get();
        // if(($category1 != "") && ($category2 != "")){
        //     $data['balancesheet_assets'] = DB::table('balancesheet_account')->where(['uid'=>$admin->id,'category'=> $category1->id,'main_category'=>'assets'])->orWhere('category', $category2->id)->get();
        //     $data['balancesheet_nonassets'] = DB::table('balancesheet_account')->where(['uid'=>$admin->id,'category'=> $category1->id,'main_category'=>'non_assets'])->orWhere('category', $category2->id)->get();
        //     $data['balancesheet_liability'] = DB::table('balancesheet_account')->where(['uid'=>$admin->id,'category'=>$category1->id,'main_category'=>'liability'])->orWhere('category', $category2->id)->get();
        //       $data['balancesheet_nonliability'] = DB::table('balancesheet_account')->where(['uid'=>$admin->id,'category'=>$category1->id,'main_category'=>'non_liability'])->orWhere('category', $category2->id)->get();
        //     $data['balancesheet_equity'] = DB::table('balancesheet_account')->where(['uid'=>$admin->id,'category'=>$category1->id,'main_category'=>'equity'])->orWhere('category', $category2->id)->get();
        // }
        // elseif(($category1 != "") && ($category2 == "")){
        //     $data['balancesheet_assets'] = DB::table('balancesheet_account')->where(['uid'=>$admin->id,'category'=> $category1->id,'main_category'=>'assets'])->get();
        //     $data['balancesheet_nonassets'] = DB::table('balancesheet_account')->where(['uid'=>$admin->id,'category'=> $category1->id,'main_category'=>'non_assets'])->get();
        //     $data['balancesheet_liability'] = DB::table('balancesheet_account')->where(['uid'=>$admin->id,'category'=> $category1->id,'main_category'=>'liability'])->get();
        //     $data['balancesheet_nonliability'] = DB::table('balancesheet_account')->where(['uid'=>$admin->id,'category'=> $category1->id,'main_category'=>'non_liability'])->get();
        //     $data['balancesheet_equity'] = DB::table('balancesheet_account')->where(['uid'=>$admin->id,'category'=> $category1->id,'main_category'=>'equity'])->get();
        // }
        // elseif(($category1 == "") && ($category2 != "")){
        //     $data['balancesheet_assets'] = DB::table('balancesheet_account')->where(['uid'=> $admin->id,'category'=> $category2->id,'main_category'=>'assets'])->get();
        //     $data['balancesheet_nonassets'] = DB::table('balancesheet_account')->where(['uid'=> $admin->id,'category'=> $category2->id,'main_category'=>'non_assets'])->get();
        //     $data['balancesheet_liability'] = DB::table('balancesheet_account')->where(['uid'=> $admin->id,'category'=> $category2->id,'main_category'=>'liability'])->get();
        //     $data['balancesheet_nonliability'] = DB::table('balancesheet_account')->where(['uid'=> $admin->id,'category'=> $category2->id,'main_category'=>'non_liability'])->get();
        //     $data['balancesheet_equity'] = DB::table('balancesheet_account')->where(['uid'=> $admin->id,'category'=> $category2->id,'main_category'=>'equity'])->get();
        // }
        return view('balancesheet_settings')->with($data);
    }
    public function create_expense_account()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('create_expense_account')->with($data);
    }
    public function create_revenue_account()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('create_revenue_account')->with($data);
    }
    public function invoice_setup()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('invoice_setup')->with($data);
    }
    public function client_access()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('client_access')->with($data);
    }
    public function chart_account()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('chart_account')->with($data);
    }
    public function templates()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('templates')->with($data);
    }
    public function setting_tutorials()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['tutorials'] = SettingTutorial::get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('setting_tutorials')->with($data);
    }

    public function introduction_videos()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        // if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
        //     return redirect('/')->with('status', "You can't access this page.");
        // }
        // if(Auth::user()->role == "admin"){
        //         return redirect('/')->with('status',"Admin can't access this page.");
        //     }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['tutorials'] = IntroVideo::get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('introduction_videos')->with($data);
    }
    public function profile_info()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
         $data['is_medical_user'] = BusinessCategory::is_medical_user($aaid);
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $af=AffiliateRegistration::where('email',Auth::user()->email)->first();
       $data["business_category"]=$af->business_category;
       $data['clients'] = ClientAppointmentList::where('uid', $uid)->groupBy('email')->get();
        return view('profile_info')->with($data);
    }
    public function tasks()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['is_medical_user'] = BusinessCategory::is_medical_user($aaid);
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
       // $data['clients'] = ClientAppointmentList::where('uid', $uid)->groupBy('email')->get();
        $data['clients'] = DB::table('user_access_role')->get();
        return view('tasks')->with($data);
    }
    public function forms_library()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
         return redirect('/')->with('status',"Admin can't access this page.");
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = SettingBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        //print_r($data['top_banners']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
         $data['general_forms']=LibraryForm::get_library_forms(1);
         $data['dentist_forms']=LibraryForm::get_library_forms(2);
         $data['medical_forms']=LibraryForm::get_library_forms(3);;
         $data['pedriatric_forms']=LibraryForm::get_library_forms(4);
        return view('forms_library')->with($data);
    }
    public function change_appointment_step(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        $changeappointmentid = $request->id;
        Session::put('changeappointmentid', $changeappointmentid);
        $data = DB::table('appointments')->join('client_appointment_lists', 'appointments.appointment_id', 'client_appointment_lists.id')->where('appointments.id', $request->id)->where('appointments.cstatus', "on")->first();
        $first_name = $data->first_name;
        $last_name = $data->last_name;
        $company = $data->company;
        Session::put('first_name', $first_name);
        Session::put('last_name', $last_name);
        Session::put('company', $company);
        Session::put('clientid', $data->appointment_id);
        return redirect('appointment_step3');
    }


    public function change_appointment_view(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = AppointmentBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $changeappointmentid = $request->id;
        // $data['appointments'] = DB::table('appointments')->join('client_appointment_lists', 'appointments.appointment_id', 'client_appointment_lists.id')->where('appointments.id', $changeappointmentid)->first();
        $data['appointments'] = DB::table('appointments')
                ->select('client_appointment_lists.first_name as client_first_name', 'client_appointment_lists.last_name as client_last_name', 'client_appointment_lists.email as client_email', 'client_appointment_lists.company as client_company', 'client_appointment_lists.address as client_address', 'client_appointment_lists.state as client_state','client_appointment_lists.country as client_country', 'client_appointment_lists.zip_code as client_zip', 'client_appointment_lists.city as client_city', 'client_appointment_lists.cell_phone as client_phone', 'appointments.appointment_date as appointment_date', 'appointments.appointment_time as appointment_time', 'appointments.appointment_end as appointment_end', 'appointments.appointment_reason as appointment_reason', 'affiliate_registrations.first_name as affiliate_first_name', 'affiliate_registrations.last_name as affiliate_last_name', 'affiliate_registrations.email as affiliate_email', 'affiliate_registrations.image as affiliate_image', 'affiliate_registrations.cellphone as affiliate_phone', 'affiliate_registrations.address as affiliate_address', 'affiliate_registrations.state as affiliate_state', 'affiliate_registrations.country as affiliate_country', 'affiliate_registrations.city as affiliate_city', 'affiliate_registrations.zip_code as affiliate_zip', 'affiliate_registrations.religion as affiliate_religion', 'affiliate_registrations.business_category as affiliate_category', 'affiliate_registrations.company as affiliate_company')
                ->join('users', 'users.id', '=', 'appointments.uid')
                ->join('affiliate_registrations', 'affiliate_registrations.email', '=', 'users.email')
                ->join('client_appointment_lists', 'appointments.appointment_id', '=', 'client_appointment_lists.id')
                ->where('appointments.id', $changeappointmentid)
                ->where('appointments.cstatus', "on")
                ->first();
                $data['appointment_date'] = date('d F Y', strtotime(Session::get('appointment_date')));
        // print_r($data['appointments']);
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('change_appointment_view')->with($data);
    }
    public function change_appointment()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "client")){
            return redirect('/member_change_appointment');
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        if(Auth::user()->role == "temp_user"){
            return redirect('user_change_appointment');
        }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $uemail = "";
        if((Auth::user()->role) == "affiliate"){
            $uemail = Auth::user()->email;
        }
        else{
            $uemail = Auth::user()->affiliate_user_email;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = AppointmentBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['change_details'] = DB::table('appointment_settings')->where('uemail', $uemail)->first();
        $data['appointments'] = DB::table('appointments')->select('*', 'appointments.id AS aid')->join('client_appointment_lists', 'appointments.appointment_id', 'client_appointment_lists.id')->where('appointments.cstatus', "on")->where('appointments.uid', $uid)->orderBy('appointments.id', 'desc')->get();
        $month = Carbon::now()->format('m');
        $year = Carbon::now()->format('Y');
        $textdt=$year."-".$month."-01";
        // $textdt = "2021-02-02";
        $dt= strtotime( $textdt);
        $currdt=$dt;
        $nextmonth=strtotime($textdt."+1 month");
        $i=0;
        $weeklycnt = [];
        do
        {
            $weekday= date("w",$currdt);
            $nextday=7-$weekday;
            $endday=abs($weekday-6);
            $startarr[$i]=$currdt;
            $endarr[$i]=strtotime(date("Y-m-d",$currdt)."+$endday day");
            $currdt=strtotime(date("Y-m-d",$endarr[$i])."+1 day");
            // echo date("Y-m-d",$startarr[$i])." ".date("Y-m-d",$endarr[$i]);
            // $countweek = DB::table('change_appointment')->whereBetween('created_at', [date("Y-m-d",$startarr[$i]), date("Y-m-d",$endarr[$i])])->get();
            $countweek = DB::table('change_appointment')->whereDate('created_at', '>=', date("Y-m-d",$startarr[$i]))->whereDate('created_at', '<=', date("Y-m-d",$endarr[$i]))->where('uid', $uid)->count();
            // print_r($countweek);
            array_push($weeklycnt, $countweek);
            $i++;
        }while($endarr[$i-1]<$nextmonth);
        $data['week1'] = $weeklycnt[0];
        $data['week2'] = $weeklycnt[1];
        $data['week3'] = $weeklycnt[2];
        $data['week4'] = $weeklycnt[3];
        $data['week5'] = $weeklycnt[4];
        $data['weekcnt'] = $i;
        $data['jancount'] = DB::table('change_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '01')->where('uid', $uid)->count();
        $data['febcount'] = DB::table('change_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '02')->where('uid', $uid)->count();
        $data['marcount'] = DB::table('change_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '03')->where('uid', $uid)->count();
        $data['aprcount'] = DB::table('change_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '04')->where('uid', $uid)->count();
        $data['maycount'] = DB::table('change_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '05')->where('uid', $uid)->count();
        $data['juncount'] = DB::table('change_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '06')->where('uid', $uid)->count();
        $data['julcount'] = DB::table('change_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '07')->where('uid', $uid)->count();
        $data['augcount'] = DB::table('change_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '08')->where('uid', $uid)->count();
        $data['sepcount'] = DB::table('change_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '09')->where('uid', $uid)->count();
        $data['octcount'] = DB::table('change_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '10')->where('uid', $uid)->count();
        $data['novcount'] = DB::table('change_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '11')->where('uid', $uid)->count();
        $data['deccount'] = DB::table('change_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '12')->where('uid', $uid)->count();
        $data['janmarcount'] = DB::table('change_appointment')->whereYear('created_at', $year)->whereMonth('created_at', '>=', '01')->whereMonth('created_at', '<=', '03')->where('uid', $uid)->count();
        $data['aprjuncount'] = DB::table('change_appointment')->whereYear('created_at', $year)->whereMonth('created_at', '>=', '04')->whereMonth('created_at', '<=', '06')->where('uid', $uid)->count();
        $data['julsepcount'] = DB::table('change_appointment')->whereYear('created_at', $year)->whereMonth('created_at', '>=', '07')->whereMonth('created_at', '<=', '09')->where('uid', $uid)->count();
        $data['octdeccount'] = DB::table('change_appointment')->whereYear('created_at', $year)->whereMonth('created_at', '>=', '10')->whereMonth('created_at', '<=', '12')->where('uid', $uid)->count();
        // print_r($data['jancount']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('change_appointment')->with($data);
    }
    public function cancel_appointment()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if(Auth::user()->role == "temp_user"){
            return redirect('/user_cancel_appointment');
        }
        if((Auth::user()->role == "client")){
            return redirect('/member_cancel_appointment');
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $uemail = "";
        if((Auth::user()->role) == "affiliate"){
            $uemail = Auth::user()->email;
        }
        else{
            $uemail = Auth::user()->affiliate_user_email;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = AppointmentBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['change_details'] = DB::table('appointment_settings')->where('uemail', $uemail)->first();
        $data['appointments'] = DB::table('appointments')->select('*', 'appointments.id AS aid')->join('client_appointment_lists', 'appointments.appointment_id', 'client_appointment_lists.id')->where('appointments.uid', $uid)->orderBy('appointments.id', 'desc')->get();
        // print_r($data['appointments']);die();
        $month = Carbon::now()->format('m');
        $year = Carbon::now()->format('Y');
        $textdt=$year."-".$month."-01";
        // $textdt = "2021-02-02";
        $dt= strtotime( $textdt);
        $currdt=$dt;
        $nextmonth=strtotime($textdt."+1 month");
        $i=0;
        $weeklycnt = [];
        do
        {
            $weekday= date("w",$currdt);
            $nextday=7-$weekday;
            $endday=abs($weekday-6);
            $startarr[$i]=$currdt;
            $endarr[$i]=strtotime(date("Y-m-d",$currdt)."+$endday day");
            $currdt=strtotime(date("Y-m-d",$endarr[$i])."+1 day");
            // echo date("Y-m-d",$startarr[$i])." ".date("Y-m-d",$endarr[$i]);
            // $countweek = DB::table('cancel_appointment')->whereBetween('created_at', [date("Y-m-d",$startarr[$i]), date("Y-m-d",$endarr[$i])])->get();
            $countweek = DB::table('cancel_appointment')->whereDate('created_at', '>=', date("Y-m-d",$startarr[$i]))->whereDate('created_at', '<=', date("Y-m-d",$endarr[$i]))->where('uid', $uid)->count();
            // print_r($countweek);
            array_push($weeklycnt, $countweek);
            $i++;
        }while($endarr[$i-1]<$nextmonth);
        $data['week1'] = $weeklycnt[0];
        $data['week2'] = $weeklycnt[1];
        $data['week3'] = $weeklycnt[2];
        $data['week4'] = $weeklycnt[3];
        $data['week5'] = $weeklycnt[4];
        $data['weekcnt'] = $i;
        $data['jancount'] = DB::table('cancel_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '01')->where('uid', $uid)->count();
        $data['febcount'] = DB::table('cancel_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '02')->where('uid', $uid)->count();
        $data['marcount'] = DB::table('cancel_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '03')->where('uid', $uid)->count();
        $data['aprcount'] = DB::table('cancel_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '04')->where('uid', $uid)->count();
        $data['maycount'] = DB::table('cancel_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '05')->where('uid', $uid)->count();
        $data['juncount'] = DB::table('cancel_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '06')->where('uid', $uid)->count();
        $data['julcount'] = DB::table('cancel_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '07')->where('uid', $uid)->count();
        $data['augcount'] = DB::table('cancel_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '08')->where('uid', $uid)->count();
        $data['sepcount'] = DB::table('cancel_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '09')->where('uid', $uid)->count();
        $data['octcount'] = DB::table('cancel_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '10')->where('uid', $uid)->count();
        $data['novcount'] = DB::table('cancel_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '11')->where('uid', $uid)->count();
        $data['deccount'] = DB::table('cancel_appointment')->whereYear('created_at', '=', $year)->whereMonth('created_at', '=', '12')->where('uid', $uid)->count();
        $data['janmarcount'] = DB::table('cancel_appointment')->whereYear('created_at', $year)->whereMonth('created_at', '>=', '01')->whereMonth('created_at', '<=', '03')->where('uid', $uid)->count();
        $data['aprjuncount'] = DB::table('cancel_appointment')->whereYear('created_at', $year)->whereMonth('created_at', '>=', '04')->whereMonth('created_at', '<=', '06')->where('uid', $uid)->count();
        $data['julsepcount'] = DB::table('cancel_appointment')->whereYear('created_at', $year)->whereMonth('created_at', '>=', '07')->whereMonth('created_at', '<=', '09')->where('uid', $uid)->count();
        $data['octdeccount'] = DB::table('cancel_appointment')->whereYear('created_at', $year)->whereMonth('created_at', '>=', '10')->whereMonth('created_at', '<=', '12')->where('uid', $uid)->count();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('cancel_appointment')->with($data);
    }
    public function delete_appointment(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $id = explode('delete', $request->id);
        $det = DB::table('appointments')->where('id', $id[1])->first();
        $values = array(
                'appointment_id' => $det->appointment_id,
                'appointment_date' => $det->appointment_date,
                'appointment_time' => $det->appointment_time,
                'appointment_end' => $det->appointment_end,
                'appointment_reason' => $det->appointment_reason,
                'additional_comment' => $det->additional_comment,
                'name1' => $det->name1,
                'name2' => $det->name2,
                'name3' => $det->name3,
                'email1' => $det->email1,
                'email2' => $det->email2,
                'email3' => $det->email3,
                'cancel_reason' => $request->delete_reason,
                'uid'   => $uid
            );
        $values2 = array('cstatus'  => "off");
        DB::table('cancel_appointment')->insert($values);
            $prevdate = date('d F Y', strtotime($det->appointment_date));
            $prevtime = date('H:i a', strtotime($det->appointment_time));

            $notification  = getNotificationMessage(5);
            $message = $notification;
            $subject="Appointment Cacelled";
          addUserActivity($subject,'cancel',$notification,$message);
        DB::table('appointments')->where('appointments.cstatus', "on")->where('id', $id[1])->update($values2);
    }
    public function comparison_appointment()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = AppointmentBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['clients'] = DB::table('client_appointment_lists')->join('appointments', 'client_appointment_lists.id', 'appointments.appointment_id')->groupBy('appointments.appointment_id')->get();
        $data['changedappointments'] = DB::table('client_appointment_lists')->join('change_appointment', 'client_appointment_lists.id', 'change_appointment.appointment_id')->groupBy('change_appointment.appointment_id')->get();
        // $clientarr = [];
        // foreach($clients as $value){
        //     array_push($clientarr, $value->id);
        // }
        // $data['client'] = DB::table('appointments')->join('client_appointment_lists', 'appointments.id', 'client_appointment_lists.id')->groupBy('appointments.appointment_id')->get();
        // print_r($data['client']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $data['years'] = [];
        for($i = 0; $i < 10; $i++){
            $lastYear = date("Y", strtotime("-$i years"));
            if($lastYear > 2019){
                array_push($data['years'], $lastYear);
            }
        }
        return view('comparison_appointment')->with($data);
    }
    public function comparison_appointment2()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = AppointmentBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['clients'] = DB::table('client_appointment_lists')->join('appointments', 'client_appointment_lists.id', 'appointments.appointment_id')->groupBy('appointments.appointment_id')->get();
        $data['changedappointments'] = DB::table('client_appointment_lists')->join('change_appointment', 'client_appointment_lists.id', 'change_appointment.appointment_id')->groupBy('change_appointment.appointment_id')->get();
        // $clientarr = [];
        // foreach($clients as $value){
        //     array_push($clientarr, $value->id);
        // }
        // $data['client'] = DB::table('appointments')->join('client_appointment_lists', 'appointments.id', 'client_appointment_lists.id')->groupBy('appointments.appointment_id')->get();
        // print_r($data['client']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $data['years'] = [];
        for($i = 0; $i < 10; $i++){
            $lastYear = date("Y", strtotime("-$i years"));
            if($lastYear > 2019){
                array_push($data['years'], $lastYear);
            }
        }
        return view('comparison_appointment2')->with($data);
    }
    public function comparison_appointment3()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = AppointmentBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['clients'] = DB::table('client_appointment_lists')->join('appointments', 'client_appointment_lists.id', 'appointments.appointment_id')->groupBy('appointments.appointment_id')->get();
        $data['changedappointments'] = DB::table('client_appointment_lists')->join('change_appointment', 'client_appointment_lists.id', 'change_appointment.appointment_id')->groupBy('change_appointment.appointment_id')->get();
        // $clientarr = [];
        // foreach($clients as $value){
        //     array_push($clientarr, $value->id);
        // }
        // $data['client'] = DB::table('appointments')->join('client_appointment_lists', 'appointments.id', 'client_appointment_lists.id')->groupBy('appointments.appointment_id')->get();
        // print_r($data['client']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $data['years'] = [];
        for($i = 0; $i < 10; $i++){
            $lastYear = date("Y", strtotime("-$i years"));
            if($lastYear > 2019){
                array_push($data['years'], $lastYear);
            }
        }
        return view('comparison_appointment3')->with($data);
    }

    public function manage_appointment(Request $request)
    {

        $data['mode']='';
       $daily=$request->input('daily');
       $sdate=$request->input('sdate');
       $edate=$request->input('edate');
       $monthly=$request->input('monthly');
       $year=@$request->year;

        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = AppointmentBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['category'] = CardCategory::orderBy('category','desc')->get();
        $data['cards'] = UploadCard::groupBy('category')->get();
        // $data['appointments'] = DB::table('appointments')->select('*', 'appointments.id AS aid')->join('client_appointment_lists', 'appointments.appointment_id', 'client_appointment_lists.id')->where('appointments.uid', Auth::id())->orderBy('appointments.id', 'desc')->get();


if(!empty($daily)){
         $data['mode']='daily';

          $data['appointments'] = DB::table('appointments')
                        ->select('appointments.id AS aid', 'appointments.appointment_date AS appointment_date', 'appointments.appointment_time AS appointment_time', 'appointments.cstatus AS cstatus', 'appointments.appointment_reason as appointment_reason',  'client_appointment_lists.first_name as client_first_name', 'client_appointment_lists.last_name as client_last_name', 'client_appointment_lists.email as client_email', 'client_appointment_lists.company as client_company', 'client_appointment_lists.address as client_address', 'client_appointment_lists.state as client_state','client_appointment_lists.country as client_country', 'client_appointment_lists.zip_code as client_zip', 'client_appointment_lists.city as client_city', 'client_appointment_lists.cell_phone as client_phone', 'client_appointment_lists.id as cid', 'appointments.appointment_date as appointment_date', 'appointments.appointment_time as appointment_time', 'appointments.appointment_end as appointment_end', 'appointments.appointment_reason as appointment_reason', 'affiliate_registrations.first_name as affiliate_first_name', 'affiliate_registrations.last_name as affiliate_last_name', 'affiliate_registrations.email as affiliate_email', 'affiliate_registrations.image as affiliate_image', 'affiliate_registrations.cellphone as affiliate_phone', 'affiliate_registrations.address as affiliate_address', 'affiliate_registrations.state as affiliate_state', 'affiliate_registrations.country as affiliate_country', 'affiliate_registrations.city as affiliate_city', 'affiliate_registrations.zip_code as affiliate_zip', 'affiliate_registrations.religion as affiliate_religion', 'affiliate_registrations.business_category as affiliate_category', 'affiliate_registrations.company as affiliate_company')
                        ->join('users', 'users.id', '=', 'appointments.uid')
                        ->join('affiliate_registrations', 'affiliate_registrations.email', '=', 'users.email')
                        ->join('client_appointment_lists', 'appointments.appointment_id', '=', 'client_appointment_lists.id')
                        ->where('appointments.uid', Auth::id())
                        ->whereDate('appointments.appointment_date', '=', $daily)
                        ->orderBy('appointments.id', 'desc')
                        ->get();
        }elseif(!empty($monthly)){

          $data['mode']='monthly';

           $data['appointments'] = DB::table('appointments')
                        ->select('appointments.id AS aid', 'appointments.appointment_date AS appointment_date', 'appointments.appointment_time AS appointment_time', 'appointments.cstatus AS cstatus', 'appointments.appointment_reason as appointment_reason',  'client_appointment_lists.first_name as client_first_name', 'client_appointment_lists.last_name as client_last_name', 'client_appointment_lists.email as client_email', 'client_appointment_lists.company as client_company', 'client_appointment_lists.address as client_address', 'client_appointment_lists.state as client_state','client_appointment_lists.country as client_country', 'client_appointment_lists.zip_code as client_zip', 'client_appointment_lists.city as client_city', 'client_appointment_lists.cell_phone as client_phone', 'client_appointment_lists.id as cid', 'appointments.appointment_date as appointment_date', 'appointments.appointment_time as appointment_time', 'appointments.appointment_end as appointment_end', 'appointments.appointment_reason as appointment_reason', 'affiliate_registrations.first_name as affiliate_first_name', 'affiliate_registrations.last_name as affiliate_last_name', 'affiliate_registrations.email as affiliate_email', 'affiliate_registrations.image as affiliate_image', 'affiliate_registrations.cellphone as affiliate_phone', 'affiliate_registrations.address as affiliate_address', 'affiliate_registrations.state as affiliate_state', 'affiliate_registrations.country as affiliate_country', 'affiliate_registrations.city as affiliate_city', 'affiliate_registrations.zip_code as affiliate_zip', 'affiliate_registrations.religion as affiliate_religion', 'affiliate_registrations.business_category as affiliate_category', 'affiliate_registrations.company as affiliate_company')
                        ->join('users', 'users.id', '=', 'appointments.uid')
                        ->join('affiliate_registrations', 'affiliate_registrations.email', '=', 'users.email')
                        ->join('client_appointment_lists', 'appointments.appointment_id', '=', 'client_appointment_lists.id')
                        ->where('appointments.uid', Auth::id())
                        ->whereMonth('appointments.appointment_date', '=', $monthly)
                        ->orderBy('appointments.id', 'desc')
                        ->get();
        }elseif (!empty($sdate) && !empty($edate)) {
           $data['mode']='weekly';

            $data['appointments'] = DB::table('appointments')
                        ->select('appointments.id AS aid', 'appointments.appointment_date AS appointment_date', 'appointments.appointment_time AS appointment_time', 'appointments.cstatus AS cstatus', 'appointments.appointment_reason as appointment_reason',  'client_appointment_lists.first_name as client_first_name', 'client_appointment_lists.last_name as client_last_name', 'client_appointment_lists.email as client_email', 'client_appointment_lists.company as client_company', 'client_appointment_lists.address as client_address', 'client_appointment_lists.state as client_state','client_appointment_lists.country as client_country', 'client_appointment_lists.zip_code as client_zip', 'client_appointment_lists.city as client_city', 'client_appointment_lists.cell_phone as client_phone', 'client_appointment_lists.id as cid', 'appointments.appointment_date as appointment_date', 'appointments.appointment_time as appointment_time', 'appointments.appointment_end as appointment_end', 'appointments.appointment_reason as appointment_reason', 'affiliate_registrations.first_name as affiliate_first_name', 'affiliate_registrations.last_name as affiliate_last_name', 'affiliate_registrations.email as affiliate_email', 'affiliate_registrations.image as affiliate_image', 'affiliate_registrations.cellphone as affiliate_phone', 'affiliate_registrations.address as affiliate_address', 'affiliate_registrations.state as affiliate_state', 'affiliate_registrations.country as affiliate_country', 'affiliate_registrations.city as affiliate_city', 'affiliate_registrations.zip_code as affiliate_zip', 'affiliate_registrations.religion as affiliate_religion', 'affiliate_registrations.business_category as affiliate_category', 'affiliate_registrations.company as affiliate_company')
                        ->join('users', 'users.id', '=', 'appointments.uid')
                        ->join('affiliate_registrations', 'affiliate_registrations.email', '=', 'users.email')
                        ->join('client_appointment_lists', 'appointments.appointment_id', '=', 'client_appointment_lists.id')
                        ->where('appointments.uid', Auth::id())
                        ->whereBetween('appointments.appointment_date', [$sdate, $edate])
                        ->orderBy('appointments.id', 'desc')
                        ->get();
        }elseif (!empty($year)) {

            $data['appointments'] = DB::table('appointments')
                        ->select('appointments.id AS aid', 'appointments.appointment_date AS appointment_date', 'appointments.appointment_time AS appointment_time', 'appointments.cstatus AS cstatus', 'appointments.appointment_reason as appointment_reason',  'client_appointment_lists.first_name as client_first_name', 'client_appointment_lists.last_name as client_last_name', 'client_appointment_lists.email as client_email', 'client_appointment_lists.company as client_company', 'client_appointment_lists.address as client_address', 'client_appointment_lists.state as client_state','client_appointment_lists.country as client_country', 'client_appointment_lists.zip_code as client_zip', 'client_appointment_lists.city as client_city', 'client_appointment_lists.cell_phone as client_phone', 'client_appointment_lists.id as cid', 'appointments.appointment_date as appointment_date', 'appointments.appointment_time as appointment_time', 'appointments.appointment_end as appointment_end', 'appointments.appointment_reason as appointment_reason', 'affiliate_registrations.first_name as affiliate_first_name', 'affiliate_registrations.last_name as affiliate_last_name', 'affiliate_registrations.email as affiliate_email', 'affiliate_registrations.image as affiliate_image', 'affiliate_registrations.cellphone as affiliate_phone', 'affiliate_registrations.address as affiliate_address', 'affiliate_registrations.state as affiliate_state', 'affiliate_registrations.country as affiliate_country', 'affiliate_registrations.city as affiliate_city', 'affiliate_registrations.zip_code as affiliate_zip', 'affiliate_registrations.religion as affiliate_religion', 'affiliate_registrations.business_category as affiliate_category', 'affiliate_registrations.company as affiliate_company')
                        ->join('users', 'users.id', '=', 'appointments.uid')
                        ->join('affiliate_registrations', 'affiliate_registrations.email', '=', 'users.email')
                        ->join('client_appointment_lists', 'appointments.appointment_id', '=', 'client_appointment_lists.id')
                        ->where('appointments.uid', Auth::id())
                        ->where( DB::raw('YEAR(appointments.appointment_date)'), '=', $year )
                        ->orderBy('appointments.id', 'desc')
                        ->get();
        }else{
            $querey = DB::table('appointments')
            ->select('appointments.id AS aid', 'appointments.appointment_date AS appointment_date', 'appointments.appointment_time AS appointment_time', 'appointments.cstatus AS cstatus', 'appointments.appointment_reason as appointment_reason',  'client_appointment_lists.first_name as client_first_name', 'client_appointment_lists.last_name as client_last_name', 'client_appointment_lists.email as client_email', 'client_appointment_lists.company as client_company', 'client_appointment_lists.address as client_address', 'client_appointment_lists.state as client_state','client_appointment_lists.country as client_country', 'client_appointment_lists.zip_code as client_zip', 'client_appointment_lists.city as client_city', 'client_appointment_lists.cell_phone as client_phone', 'client_appointment_lists.id as cid', 'appointments.appointment_date as appointment_date', 'appointments.appointment_time as appointment_time', 'appointments.appointment_end as appointment_end', 'appointments.appointment_reason as appointment_reason', 'affiliate_registrations.first_name as affiliate_first_name', 'affiliate_registrations.last_name as affiliate_last_name', 'affiliate_registrations.email as affiliate_email', 'affiliate_registrations.image as affiliate_image', 'affiliate_registrations.cellphone as affiliate_phone', 'affiliate_registrations.address as affiliate_address', 'affiliate_registrations.state as affiliate_state', 'affiliate_registrations.country as affiliate_country', 'affiliate_registrations.city as affiliate_city', 'affiliate_registrations.zip_code as affiliate_zip', 'affiliate_registrations.religion as affiliate_religion', 'affiliate_registrations.business_category as affiliate_category', 'affiliate_registrations.company as affiliate_company')
            ->join('users', 'users.id', '=', 'appointments.uid')
            ->join('affiliate_registrations', 'affiliate_registrations.email', '=', 'users.email')
            ->join('client_appointment_lists', 'appointments.appointment_id', '=', 'client_appointment_lists.id')
            ->where('appointments.uid', Auth::id())
            ->orderBy('appointments.id', 'desc');


            if(request()->has('client')) {
                // dd(request()->client);
                if(request()->client != '') {
                    $querey = $querey->where('appointments.appointment_id', request()->client);
                }
            }
            if(request()->has('month')) {
                if(request()->month != '' && request()->month != "all" && request()->month != "graph") {
                    $querey = $querey->whereMonth('appointments.appointment_date', request()->month);
                }
                elseif(request()->month == "graph") {
                    $y = date('Y');
                    $b_q = DB::table('appointments')->whereYear('appointment_date',$y)->get();

                    // dd($b_q);



                    $graph_data = [];

                    for($m = 1; $m <= 12; $m++) {
                        // $b_q = null;
                        if($m == 1) {
                            $temp_val = $this->grph_data($m);
                            // dd($temp_val);
                            $graph_data_vals[] = $temp_val;
                            $graph_data['Jan'] = array('val'=>$this->grph_data($m), 'month' => "Jan");
                            // dd($graph_data['Jan']);
                        }
                        elseif($m == 2) {
                            $temp_val = $this->grph_data($m);
                            $graph_data_vals[] = $temp_val;
                            $graph_data['Feb'] = array('val'=>$this->grph_data($m), 'month' => "Feb");
                        }
                        elseif($m == 3) {
                            $temp_val = $this->grph_data($m);
                            $graph_data_vals[] = $temp_val;
                            $graph_data['Mar'] = array('val'=>$this->grph_data($m), 'month' => "Mar");
                        }
                        elseif($m == 4) {
                            $temp_val = $this->grph_data($m);
                            $graph_data_vals[] = $temp_val;
                            $graph_data['Apr'] = array('val'=>$this->grph_data($m), 'month' => "Apr");
                        }
                        elseif($m == 5) {
                            $temp_val = $this->grph_data($m);
                            $graph_data_vals[] = $temp_val;
                            $graph_data['May'] = array('val'=>$this->grph_data($m), 'month' => "May");
                        }
                        elseif($m == 6) {
                            $temp_val = $this->grph_data($m);
                            $graph_data_vals[] = $temp_val;
                            $graph_data['Jun'] = array('val'=>$temp_val, 'month' => "Jun");
                        }
                        elseif($m == 7) {
                            $temp_val = $this->grph_data($m);
                            $graph_data_vals[] = $temp_val;
                            $graph_data['Jul'] = array('val'=>$this->grph_data($m), 'month' => "Jul");
                        }
                        elseif($m == 8) {
                            $temp_val = $this->grph_data($m);
                            $graph_data_vals[] = $temp_val;
                            // dd($this->grph_data(8));
                            $graph_data['Aug'] = array('val'=>$this->grph_data($m), 'month' => "Aug");
                        }
                        elseif($m == 9) {
                            $temp_val = $this->grph_data($m);
                            $graph_data_vals[] = $temp_val;
                            $graph_data['Sep'] = array('val'=>$this->grph_data($m), 'month' => "Sep");
                            // dd($graph_data['Sep']);

                        }
                        elseif($m == 10) {
                            $temp_val = $this->grph_data($m);
                            $graph_data_vals[] = $temp_val;
                            $graph_data['Oct'] = array('val'=>$this->grph_data($m), 'month' => "Oct");
                        }
                        elseif($m == 11) {
                            $temp_val = $this->grph_data($m);
                            $graph_data_vals[] = $temp_val;
                            $graph_data['Nov'] = array('val'=>$this->grph_data($m), 'month' => "Nov");
                        }
                        elseif($m == 12) {
                            $temp_val = $this->grph_data($m);
                            $graph_data_vals[] = $temp_val;
                            $graph_data['Dec'] = array('val'=>$this->grph_data($m), 'month' => "Dec");
                        }

                    }
                    // $a = rsort($graph_data);
                    $data['graph_data'] = collect($graph_data)->sortByDesc('val');
                    $data['graph_data_vals'] = $graph_data_vals;

                }

            }
        $data['appointments'] = $querey->get();




        }

        // dd($data['appointments']->appointment_date);
        // $graph = $data['appointments'];
        // $graph_counts = $graph->count();

        // for ($i=0; $i < $graph_counts; $i++) {
        //     $myMonth = $graph[$i]->appointment_date;
        //     $date1 = Carbon::createFromFormat('Y-m-d', $myMonth);
        //     $monthName = $date1->format('M');

        //     $monthGrapg = $date1->format('M');

            // dd($graph->where('appointment_date', $myMonth)->count());

// dd($monthGrapg);

            // $graph_counts2 = $graph->where($graph->appointment_date, $monthName)->count();

            // dd($graph_counts2);

            // $arr = array($i => $monthName);

            // dd($arr);
        // }



        // $graph_month_1 = $graph->where('appointment_date');
        // dd($graph_);

        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('manage_appointment')->with($data);
    }

    public function grph_data($m) {
        $y = date('Y');

        $o_q = $querey = DB::table('appointments')
                    ->select('appointments.id AS aid', 'appointments.appointment_date AS appointment_date', 'appointments.appointment_time AS appointment_time', 'appointments.cstatus AS cstatus', 'appointments.appointment_reason as appointment_reason',  'client_appointment_lists.first_name as client_first_name', 'client_appointment_lists.last_name as client_last_name', 'client_appointment_lists.email as client_email', 'client_appointment_lists.company as client_company', 'client_appointment_lists.address as client_address', 'client_appointment_lists.state as client_state','client_appointment_lists.country as client_country', 'client_appointment_lists.zip_code as client_zip', 'client_appointment_lists.city as client_city', 'client_appointment_lists.cell_phone as client_phone', 'client_appointment_lists.id as cid', 'appointments.appointment_date as appointment_date', 'appointments.appointment_time as appointment_time', 'appointments.appointment_end as appointment_end', 'appointments.appointment_reason as appointment_reason', 'affiliate_registrations.first_name as affiliate_first_name', 'affiliate_registrations.last_name as affiliate_last_name', 'affiliate_registrations.email as affiliate_email', 'affiliate_registrations.image as affiliate_image', 'affiliate_registrations.cellphone as affiliate_phone', 'affiliate_registrations.address as affiliate_address', 'affiliate_registrations.state as affiliate_state', 'affiliate_registrations.country as affiliate_country', 'affiliate_registrations.city as affiliate_city', 'affiliate_registrations.zip_code as affiliate_zip', 'affiliate_registrations.religion as affiliate_religion', 'affiliate_registrations.business_category as affiliate_category', 'affiliate_registrations.company as affiliate_company')
                    ->join('users', 'users.id', '=', 'appointments.uid')
                    ->join('affiliate_registrations', 'affiliate_registrations.email', '=', 'users.email')
                    ->join('client_appointment_lists', 'appointments.appointment_id', '=', 'client_appointment_lists.id')
                    ->where('appointments.uid', Auth::id())
                    ->orderBy('appointments.id', 'desc')->whereYear('appointment_date',$y)->whereMonth('appointment_date',$m)->count();

                // $o_q = DB::table('appointments')->whereYear('appointment_date',$y)->whereMonth('appointment_date',$m)->count();
                return $o_q;
    }
    public function appointment_tutorials()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = AppointmentBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['tutorials'] = AppointmentTutorial::get();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('appointment_tutorials')->with($data);
    }
    public function schedule_birthday()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = ClientManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['clients'] = ClientAppointmentList::where('uid', $uid)->get();
        $data['category'] = CardCategory::orderBy('category','desc')->get();
        $data['cards'] = UploadCard::groupBy('category')->get();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('schedule_birthday')->with($data);
    }
    public function schedule_holiday()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = ClientManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['holidays'] = DB::table('holiday')->get();
        $data['clients'] = ClientAppointmentList::where('uid', $uid)->get();
        $data['category'] = CardCategory::orderBy('category','desc')->get();
        $data['cards'] = UploadCard::groupBy('category')->get();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('schedule_holiday')->with($data);
    }
    public function comparison_client()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = ClientManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('comparison_client')->with($data);
    }
    public function view_holiday()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = ClientManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('view_holiday')->with($data);
    }
    public function view_birthday()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = ClientManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('view_birthday')->with($data);
    }
    public function client_tutorials()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = ClientManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['tutorials'] = ClientTutorial::get();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('client_tutorials')->with($data);
    }
    public function email_campaign()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
         }
         // $isActivePlan=ActivePlan::is_active_plan();
         // if($isActivePlan==0){
         // return redirect('/')->with('status',"Your plan has been expired please renew your plan");
         // }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $uemail = "";
        if((Auth::user()->role) == "affiliate"){
            $uemail = Auth::user()->email;
        }
        else{
            $uemail = Auth::user()->affiliate_user_email;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = EmailManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        // $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->get();
        $data['folders'] = "";
        $data['contacts'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->where('folder_name', '!=', "Basket 1")->where('folder_name', '!=', "Basket 2")->orderBy('id', 'desc')->get();
            $data['contacts'] = Contacts::where('uid', $uid)->where('folder', '!=', '12')->where('folder', '!=', '13')->where('status', 1)->get();
        }
        else{
            $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->where('folder_name', '!=', "Basket X")->orderBy('id', 'desc')->get();
            $data['contacts'] = Contacts::where('uid', $uid)->where('folder', '!=', '11')->where('status', 1)->get();
        }
        $data['scripts'] = ScriptCategory::get();
        $data['greetings'] = DB::table('personalised_greeting')->get();
        $data['titles'] = EmailCampaign::where('uid', $uid)
        ->orderBy('id', 'desc')
        ->groupBy('subject')
        ->get();
        // print_r($data['titles'][1]->subject);die();
        $data['user_banner'] = DB::table('affiliate_banner')->where('affiliate_email', $uemail)->first();
        // print_r($data['titles'][0]->subject);die();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $data['colors'] = DB::table('background_color')->get();
        $aff_data=AffiliateRegistration::where('email',Auth::user()->email)->first();
        $data['my_referral_link'] ='';
        $data['my_profile_link'] ='';
        if(!empty($aff_data->code)){
            $sponsor_link=AffiliateRegistration::get_user_referral_link($aff_data->code,$aff_data->email);
            $data['my_referral_link'] =$sponsor_link;
            $data['my_profile_link']=url('user/'.$aff_data->username);
        }
        return view('email_campaign')->with($data);
    }
    public function monthly_email_campaign_chart()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = EmailManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmail'] = EmailCampaign::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '01')->count();
        $data['febmail'] = EmailCampaign::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '02')->count();
        $data['marmail'] = EmailCampaign::where('uid',$uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '03')->count();
        $data['aprmail'] = EmailCampaign::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '04')->count();
        $data['maymail'] = EmailCampaign::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '05')->count();
        $data['junmail'] = EmailCampaign::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '06')->count();
        $data['julmail'] = EmailCampaign::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '07')->count();
        $data['augmail'] = EmailCampaign::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '08')->count();
        $data['sepmail'] = EmailCampaign::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '09')->count();
        $data['octmail'] = EmailCampaign::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '10')->count();
        $data['novmail'] = EmailCampaign::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '11')->count();
        $data['decmail'] = EmailCampaign::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '12')->count();
        $data['pgtitle'] = "Email Campaign";
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('monthly_email_campaign_chart')->with($data);
    }
    public function monthly_send_email_chart()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = EmailManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '01')->count();
        $data['febmail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '02')->count();
        $data['marmail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '03')->count();
        $data['aprmail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '04')->count();
        $data['maymail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '05')->count();
        $data['junmail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '06')->count();
        $data['julmail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '07')->count();
        $data['augmail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '08')->count();
        $data['sepmail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '09')->count();
        $data['octmail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '10')->count();
        $data['novmail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '11')->count();
        $data['decmail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '12')->count();
        $data['pgtitle'] = "Send Email";
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('monthly_email_campaign_chart')->with($data);
    }
    public function monthly_send_card_chart()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = EmailManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmail'] = SendCard::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '01')->count();
        $data['febmail'] = SendCard::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '02')->count();
        $data['marmail'] = SendCard::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '03')->count();
        $data['aprmail'] = SendCard::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '04')->count();
        $data['maymail'] = SendCard::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '05')->count();
        $data['junmail'] = SendCard::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '06')->count();
        $data['julmail'] = SendCard::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '07')->count();
        $data['augmail'] = SendCard::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '08')->count();
        $data['sepmail'] = SendCard::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '09')->count();
        $data['octmail'] = SendCard::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '10')->count();
        $data['novmail'] = SendCard::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '11')->count();
        $data['decmail'] = SendCard::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '12')->count();
        $data['pgtitle'] = "Send Card";
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('monthly_email_campaign_chart')->with($data);
    }
    public function monthly_send_video_chart()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = EmailManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '01')->count();
        $data['febmail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '02')->count();
        $data['marmail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '03')->count();
        $data['aprmail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '04')->count();
        $data['maymail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '05')->count();
        $data['junmail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '06')->count();
        $data['julmail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '07')->count();
        $data['augmail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '08')->count();
        $data['sepmail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '09')->count();
        $data['octmail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '10')->count();
        $data['novmail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '11')->count();
        $data['decmail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '12')->count();
        $data['pgtitle'] = "Send Video";
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('monthly_email_campaign_chart')->with($data);
    }
    public function monthly_send_sms_chart()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = EmailManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '01')->count();
        $data['febmail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '02')->count();
        $data['marmail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '03')->count();
        $data['aprmail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '04')->count();
        $data['maymail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '05')->count();
        $data['junmail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '06')->count();
        $data['julmail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '07')->count();
        $data['augmail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '08')->count();
        $data['sepmail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '09')->count();
        $data['octmail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '10')->count();
        $data['novmail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '11')->count();
        $data['decmail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '12')->count();
        $data['pgtitle'] = "Send Sms";
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('monthly_email_campaign_chart')->with($data);
    }
    public function monthly_email_campaign_chartt(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = EmailManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmail'] = EmailCampaign::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '01')->where('email', $request->id)->count();
        $data['febmail'] = EmailCampaign::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '02')->where('email', $request->id)->count();
        $data['marmail'] = EmailCampaign::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '03')->where('email', $request->id)->count();
        $data['aprmail'] = EmailCampaign::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '04')->where('email', $request->id)->count();
        $data['maymail'] = EmailCampaign::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '05')->where('email', $request->id)->count();
        $data['junmail'] = EmailCampaign::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '06')->where('email', $request->id)->count();
        $data['julmail'] = EmailCampaign::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '07')->where('email', $request->id)->count();
        $data['augmail'] = EmailCampaign::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '08')->where('email', $request->id)->count();
        $data['sepmail'] = EmailCampaign::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '09')->where('email', $request->id)->count();
        $data['octmail'] = EmailCampaign::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '10')->where('email', $request->id)->count();
        $data['novmail'] = EmailCampaign::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '11')->where('email', $request->id)->count();
        $data['decmail'] = EmailCampaign::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '12')->where('email', $request->id)->count();
        $data['pgtitle'] = "Email Campaign";
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('monthly_email_campaign_chart')->with($data);
    }
    public function monthly_send_email_chartt(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = EmailManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '01')->where('email', $request->id)->count();
        $data['febmail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '02')->where('email', $request->id)->count();
        $data['marmail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '03')->where('email', $request->id)->count();
        $data['aprmail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '04')->where('email', $request->id)->count();
        $data['maymail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '05')->where('email', $request->id)->count();
        $data['junmail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '06')->where('email', $request->id)->count();
        $data['julmail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '07')->where('email', $request->id)->count();
        $data['augmail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '08')->where('email', $request->id)->count();
        $data['sepmail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '09')->where('email', $request->id)->count();
        $data['octmail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '10')->where('email', $request->id)->count();
        $data['novmail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '11')->where('email', $request->id)->count();
        $data['decmail'] = SendEmail::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '12')->where('email', $request->id)->count();
        $data['pgtitle'] = "Send Email";
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('monthly_email_campaign_chart')->with($data);
    }
    public function monthly_send_card_chartt(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = EmailManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmail'] = SendCard::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '01')->where('email', $request->id)->count();
        $data['febmail'] = SendCard::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '02')->where('email', $request->id)->count();
        $data['marmail'] = SendCard::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '03')->where('email', $request->id)->count();
        $data['aprmail'] = SendCard::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '04')->where('email', $request->id)->count();
        $data['maymail'] = SendCard::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '05')->where('email', $request->id)->count();
        $data['junmail'] = SendCard::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '06')->where('email', $request->id)->count();
        $data['julmail'] = SendCard::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '07')->where('email', $request->id)->count();
        $data['augmail'] = SendCard::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '08')->where('email', $request->id)->count();
        $data['sepmail'] = SendCard::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '09')->where('email', $request->id)->count();
        $data['octmail'] = SendCard::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '10')->where('email', $request->id)->count();
        $data['novmail'] = SendCard::where('uid',$uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '11')->where('email', $request->id)->count();
        $data['decmail'] = SendCard::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '12')->where('email', $request->id)->count();
        $data['pgtitle'] = "Send Card";
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('monthly_email_campaign_chart')->with($data);
    }
    public function monthly_client_appointment_chartt(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = AppointmentBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmail'] = DB::table('appointments')->where('appointments.cstatus', "on")->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '01')->where('appointment_id', $request->id)->count();
        $data['febmail'] = DB::table('appointments')->where('appointments.cstatus', "on")->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '02')->where('appointment_id', $request->id)->count();
        $data['marmail'] = DB::table('appointments')->where('appointments.cstatus', "on")->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '03')->where('appointment_id', $request->id)->count();
        $data['aprmail'] = DB::table('appointments')->where('appointments.cstatus', "on")->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '04')->where('appointment_id', $request->id)->count();
        $data['maymail'] = DB::table('appointments')->where('appointments.cstatus', "on")->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '05')->where('appointment_id', $request->id)->count();
        $data['junmail'] = DB::table('appointments')->where('appointments.cstatus', "on")->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '06')->where('appointment_id', $request->id)->count();
        $data['julmail'] = DB::table('appointments')->where('appointments.cstatus', "on")->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '07')->where('appointment_id', $request->id)->count();
        $data['augmail'] = DB::table('appointments')->where('appointments.cstatus', "on")->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '08')->where('appointment_id', $request->id)->count();
        $data['sepmail'] = DB::table('appointments')->where('appointments.cstatus', "on")->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '09')->where('appointment_id', $request->id)->count();
        $data['octmail'] = DB::table('appointments')->where('appointments.cstatus', "on")->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '10')->where('appointment_id', $request->id)->count();
        $data['novmail'] = DB::table('appointments')->where('appointments.cstatus', "on")->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '11')->where('appointment_id', $request->id)->count();
        $data['decmail'] = DB::table('appointments')->where('appointments.cstatus', "on")->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '12')->where('appointment_id', $request->id)->count();
        $data['pgtitle'] = "Appointment Comparison";
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('monthly_client_appointment_chartt')->with($data);
    }
    public function monthly_asset_chartt(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = ArchivesBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmail'] = DB::table('asset_record')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '01')->where('description', $request->desc)->sum('price');
        $data['febmail'] = DB::table('asset_record')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '02')->where('description', $request->desc)->sum('price');
        $data['marmail'] = DB::table('asset_record')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '03')->where('description', $request->desc)->sum('price');
        $data['aprmail'] = DB::table('asset_record')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '04')->where('description', $request->desc)->sum('price');
        $data['maymail'] = DB::table('asset_record')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '05')->where('description', $request->desc)->sum('price');
        $data['junmail'] = DB::table('asset_record')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '06')->where('description', $request->desc)->sum('price');
        $data['julmail'] = DB::table('asset_record')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '07')->where('description', $request->desc)->sum('price');
        $data['augmail'] = DB::table('asset_record')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '08')->where('description', $request->desc)->sum('price');
        $data['sepmail'] = DB::table('asset_record')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '09')->where('description', $request->desc)->sum('price');
        $data['octmail'] = DB::table('asset_record')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '10')->where('description', $request->desc)->sum('price');
        $data['novmail'] = DB::table('asset_record')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '11')->where('description', $request->desc)->sum('price');
        $data['decmail'] = DB::table('asset_record')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '12')->where('description', $request->desc)->sum('price');
        $data['pgtitle'] = "Manage Assets";
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('monthly_client_appointment_chartt')->with($data);
    }
    public function monthly_new_appointment_chartt(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = AppointmentBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmail'] = count(DB::table('appointments')->select(DB::raw('count(*) as user_count, email1'))->where('email1', '<=', 1)->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '01')->where('appointment_id', $request->id)->where('appointments.cstatus', "on")->groupBy('email1')->get());
        $data['febmail'] = count(DB::table('appointments')->select(DB::raw('count(*) as user_count, email1'))->where('email1', '<=', 1)->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '02')->where('appointment_id', $request->id)->where('appointments.cstatus', "on")->groupBy('email1')->get());
        $data['marmail'] = count(DB::table('appointments')->select(DB::raw('count(*) as user_count, email1'))->where('email1', '<=', 1)->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '03')->where('appointment_id', $request->id)->where('appointments.cstatus', "on")->groupBy('email1')->get());
        $data['aprmail'] = count(DB::table('appointments')->select(DB::raw('count(*) as user_count, email1'))->where('email1', '<=', 1)->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '04')->where('appointment_id', $request->id)->where('appointments.cstatus', "on")->groupBy('email1')->get());
        $data['maymail'] = count(DB::table('appointments')->select(DB::raw('count(*) as user_count, email1'))->where('email1', '<=', 1)->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '05')->where('appointment_id', $request->id)->where('appointments.cstatus', "on")->groupBy('email1')->get());
        $data['junmail'] = count(DB::table('appointments')->select(DB::raw('count(*) as user_count, email1'))->where('email1', '<=', 1)->where('uid',$uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '06')->where('appointment_id', $request->id)->where('appointments.cstatus', "on")->groupBy('email1')->get());
        $data['julmail'] = count(DB::table('appointments')->select(DB::raw('count(*) as user_count, email1'))->where('email1', '<=', 1)->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '07')->where('appointment_id', $request->id)->where('appointments.cstatus', "on")->groupBy('email1')->get());
        $data['augmail'] = count(DB::table('appointments')->select(DB::raw('count(*) as user_count, email1'))->where('email1', '<=', 1)->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '08')->where('appointment_id', $request->id)->where('appointments.cstatus', "on")->groupBy('email1')->get());
        $data['sepmail'] = count(DB::table('appointments')->select(DB::raw('count(*) as user_count, email1'))->where('email1', '<=', 1)->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '09')->where('appointment_id', $request->id)->where('appointments.cstatus', "on")->groupBy('email1')->get());
        $data['octmail'] = count(DB::table('appointments')->select(DB::raw('count(*) as user_count, email1'))->where('email1', '<=', 1)->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '10')->where('appointment_id', $request->id)->where('appointments.cstatus', "on")->groupBy('email1')->get());
        $data['novmail'] = count(DB::table('appointments')->select(DB::raw('count(*) as user_count, email1'))->where('email1', '<=', 1)->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '11')->where('appointment_id', $request->id)->where('appointments.cstatus', "on")->groupBy('email1')->get());
        $data['decmail'] = count(DB::table('appointments')->select(DB::raw('count(*) as user_count, email1'))->where('email1', '<=', 1)->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '12')->where('appointment_id', $request->id)->where('appointments.cstatus', "on")->groupBy('email1')->get());
        $data['pgtitle'] = "New Appointment Comparison";
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('monthly_client_appointment_chartt')->with($data);
    }
    public function monthly_change_appointment_chartt(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = AppointmentBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmail'] = DB::table('change_appointment')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '01')->where('appointment_id', $request->id)->count();
        $data['febmail'] = DB::table('change_appointment')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '02')->where('appointment_id', $request->id)->count();
        $data['marmail'] = DB::table('change_appointment')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '03')->where('appointment_id', $request->id)->count();
        $data['aprmail'] = DB::table('change_appointment')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '04')->where('appointment_id', $request->id)->count();
        $data['maymail'] = DB::table('change_appointment')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '05')->where('appointment_id', $request->id)->count();
        $data['junmail'] = DB::table('change_appointment')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '06')->where('appointment_id', $request->id)->count();
        $data['julmail'] = DB::table('change_appointment')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '07')->where('appointment_id', $request->id)->count();
        $data['augmail'] = DB::table('change_appointment')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '08')->where('appointment_id', $request->id)->count();
        $data['sepmail'] = DB::table('change_appointment')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '09')->where('appointment_id', $request->id)->count();
        $data['octmail'] = DB::table('change_appointment')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '10')->where('appointment_id', $request->id)->count();
        $data['novmail'] = DB::table('change_appointment')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '11')->where('appointment_id', $request->id)->count();
        $data['decmail'] = DB::table('change_appointment')->where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '12')->where('appointment_id', $request->id)->count();
        $data['pgtitle'] = "Change Appointment";
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('monthly_client_appointment_chartt')->with($data);
    }
    public function monthly_send_video_chartt(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = EmailManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '01')->where('email', $request->id)->count();
        $data['febmail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '02')->where('email', $request->id)->count();
        $data['marmail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '03')->where('email', $request->id)->count();
        $data['aprmail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '04')->where('email', $request->id)->count();
        $data['maymail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '05')->where('email', $request->id)->count();
        $data['junmail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '06')->where('email', $request->id)->count();
        $data['julmail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '07')->where('email', $request->id)->count();
        $data['augmail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '08')->where('email', $request->id)->count();
        $data['sepmail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '09')->where('email', $request->id)->count();
        $data['octmail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '10')->where('email', $request->id)->count();
        $data['novmail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '11')->where('email', $request->id)->count();
        $data['decmail'] = SendVideo::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '12')->where('email', $request->id)->count();
        $data['pgtitle'] = "Send Video";
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('monthly_email_campaign_chart')->with($data);
    }
    public function monthly_send_sms_chartt(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = EmailManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '01')->where('email', $request->id)->count();
        $data['febmail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '02')->where('email', $request->id)->count();
        $data['marmail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '03')->where('email', $request->id)->count();
        $data['aprmail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '04')->where('email', $request->id)->count();
        $data['maymail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '05')->where('email', $request->id)->count();
        $data['junmail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '06')->where('email', $request->id)->count();
        $data['julmail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '07')->where('email', $request->id)->count();
        $data['augmail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '08')->where('email', $request->id)->count();
        $data['sepmail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '09')->where('email', $request->id)->count();
        $data['octmail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '10')->where('email', $request->id)->count();
        $data['novmail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '11')->where('email', $request->id)->count();
        $data['decmail'] = SendSms::where('uid', $uid)->whereYear('created_at', date('Y'))->whereMonth('created_at', '12')->where('email', $request->id)->count();
        $data['pgtitle'] = "Send Sms";
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('monthly_email_campaign_chart')->with($data);
    }
    public function send_email($id="")
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = EmailManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        // $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->get();
        $data['folders'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->where('folder_name', '!=', "Basket 1")->where('folder_name', '!=', "Basket 2")->orderBy('id', 'desc')->get();
        }
        else{
            $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->where('folder_name', '!=', "Basket X")->orderBy('id', 'desc')->get();
        }
         $data['contacts'] ="";
         $data['id'] =$id;
        if(!empty($id))
        {
            $data['contacts'] = Contacts::where('uid', $uid)->where('folder',$id)->where('status', 1)->get();
        }

        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $data['scripts'] = ScriptCategory::get();
        $data['greetings'] = DB::table('personalised_greeting')->get();
        $data['titles'] = EmailCampaign::where('uid', $uid)
        ->orderBy('id', 'desc')
        ->groupBy('subject')
        ->get();
        $data['colors'] = DB::table('background_color')->get();
        $aff_data=AffiliateRegistration::where('email',Auth::user()->email)->first();
        $data['my_referral_link'] ='';
        $data['my_profile_link'] ='';
        if(!empty($aff_data->code)){
            $sponsor_link=AffiliateRegistration::get_user_referral_link($aff_data->code,$aff_data->email);
            $data['my_referral_link'] =$sponsor_link;
            $data['my_profile_link']=url('user/'.$aff_data->username);
        }
        return view('send_email')->with($data);
    }
    public function send_cards()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = EmailManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['scripts'] = ScriptCategory::get();
        $data['greetings'] = DB::table('personalised_greeting')->get();
        $data['category'] = CardCategory::orderBy('category','desc')->get();
        $data['cards'] = UploadCard::groupBy('category')->get();

        $data['titles'] = EmailCampaign::where('uid', $uid)
        ->orderBy('id', 'desc')
        ->groupBy('subject')
        ->get();
        // print_r($data['cards']);die();
        // $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->get();
        $data['folders'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->where('folder_name', '!=', "Basket 1")->where('folder_name', '!=', "Basket 2")->orderBy('id', 'desc')->get();
        }
        else{
            $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->where('folder_name', '!=', "Basket X")->orderBy('id', 'desc')->get();
        }
        $data['contacts'] = Contacts::where('uid', $uid)->where('status', 1)->get();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $data['colors'] = DB::table('background_color')->get();
        $aff_data=AffiliateRegistration::where('email',Auth::user()->email)->first();
        $data['my_referral_link'] ='';
        $data['my_profile_link'] ='';
        if(!empty($aff_data->code)){
            $sponsor_link=AffiliateRegistration::get_user_referral_link($aff_data->code,$aff_data->email);
            $data['my_referral_link'] =$sponsor_link;
            $data['my_profile_link']=url('user/'.$aff_data->username);
        }
        return view('send_cards')->with($data);
    }
    public static function get_card_image($category){
        $images = UploadCard::where('category', $category)->get();
        return $images;
    }
    public static function get_scripts_image($category){
        $images = UploadScript::where('category', $category)->get();
        return $images;
    }
    public function send_video()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = EmailManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['scripts'] = ScriptCategory::get();
        $data['greetings'] = DB::table('personalised_greeting')->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        // $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->get();

        $data['titles'] = EmailCampaign::where('uid', $uid)
        ->orderBy('id', 'desc')
        ->groupBy('subject')
        ->get();
        $data['folders'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->where('folder_name', '!=', "Basket 1")->where('folder_name', '!=', "Basket 2")->orderBy('id', 'desc')->get();
        }
        else{
            $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->where('folder_name', '!=', "Basket X")->orderBy('id', 'desc')->get();
        }
        $data['contacts'] = Contacts::where('uid', $uid)->where('status', 1)->get();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $data['colors'] = DB::table('background_color')->get();
        $aff_data=AffiliateRegistration::where('email',Auth::user()->email)->first();
        $data['my_referral_link'] ='';
        $data['my_profile_link'] ='';
        if(!empty($aff_data->code)){
            $sponsor_link=AffiliateRegistration::get_user_referral_link($aff_data->code,$aff_data->email);
            $data['my_referral_link'] =$sponsor_link;
            $data['my_profile_link']=url('user/'.$aff_data->username);
        }
        return view('send_video')->with($data);
    }
 public function test_send_sms()
    {
        $receiverNumber = "+91 1234567890";
        $message = "This is testing from mafama.com";

        try {

            $account_sid = getenv("TWILIO_SID");
            $auth_token = getenv("TWILIO_TOKEN");
            $twilio_number = getenv("TWILIO_FROM");

            $client = new Client($account_sid, $auth_token);
            $client->messages->create($receiverNumber, [
                'from' => $twilio_number,
                'body' => $message]);

            dd('SMS Sent Successfully.');

        } catch (Exception $e) {
            dd("Error: ". $e->getMessage());
        }
    }
    public function send_sms()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = EmailManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        // $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->get();
        $data['folders'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->where('folder_name', '!=', "Basket 1")->where('folder_name', '!=', "Basket 2")->orderBy('id', 'desc')->get();
        }
        else{
            $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->where('folder_name', '!=', "Basket X")->orderBy('id', 'desc')->get();
        }
        $data['contacts'] = Contacts::where('uid', $uid)->where('status', 1)->get();
        $data['scripts'] = ScriptCategory::get();
        $data['greetings'] = DB::table('personalised_greeting')->get();
        $data['titles'] = SendSms::where('uid', $uid)->orderBy('id', 'desc')->groupBy('subject')->get();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $aff_data=AffiliateRegistration::where('email',Auth::user()->email)->first();
        $data['my_referral_link'] ='';
        $data['my_profile_link'] ='';
        if(!empty($aff_data->code)){
            $sponsor_link=AffiliateRegistration::get_user_referral_link($aff_data->code,$aff_data->email);
            $data['my_referral_link'] =$sponsor_link;
            $data['my_profile_link']=url('user/'.$aff_data->username);
        }
        return view('send_sms')->with($data);
    }
    public function comparison_email()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = EmailManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['email_campaigns'] = EmailCampaign::groupBy('email')->where('uid', $uid)->orderBy('id', 'desc')->get();
        $data['send_email'] = SendEmail::groupBy('email')->where('uid', $uid)->orderBy('id', 'desc')->get();
        $data['send_card'] = SendCard::groupBy('email')->where('uid', $uid)->orderBy('id', 'desc')->get();
        $data['send_video'] = SendVideo::groupBy('email')->where('uid', $uid)->orderBy('id', 'desc')->get();
        $data['send_sms'] = SendSms::groupBy('email')->where('uid', $uid)->orderBy('id', 'desc')->get();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $data['years'] = [];
        for($i = 0; $i < 10; $i++){
            $lastYear = date("Y", strtotime("-$i years"));
            if($lastYear > 2019){
                array_push($data['years'], $lastYear);
            }
        }
        $aff_data=AffiliateRegistration::where('email',Auth::user()->email)->first();
        $data['my_referral_link'] ='';
        $data['my_profile_link'] ='';
        if(!empty($aff_data->code)){
            $sponsor_link=AffiliateRegistration::get_user_referral_link($aff_data->code,$aff_data->email);
            $data['my_referral_link'] =$sponsor_link;
            $data['my_profile_link']=url('user/'.$aff_data->username);
        }
        return view('comparison_email')->with($data);
    }
    public function comparison_email2()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = EmailManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['email_campaigns'] = EmailCampaign::groupBy('email')->where('uid', $uid)->orderBy('id', 'desc')->get();
        $data['send_email'] = SendEmail::groupBy('email')->where('uid', $uid)->orderBy('id', 'desc')->get();
        $data['send_card'] = SendCard::groupBy('email')->where('uid', $uid)->orderBy('id', 'desc')->get();
        $data['send_video'] = SendVideo::groupBy('email')->where('uid', $uid)->orderBy('id', 'desc')->get();
        $data['send_sms'] = SendSms::groupBy('email')->where('uid', $uid)->orderBy('id', 'desc')->get();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $data['years'] = [];
        for($i = 0; $i < 10; $i++){
            $lastYear = date("Y", strtotime("-$i years"));
            if($lastYear > 2019){
                array_push($data['years'], $lastYear);
            }
        }
        return view('comparison_email2')->with($data);
    }
    public function comparison_email3()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = EmailManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['email_campaigns'] = EmailCampaign::groupBy('email')->where('uid', $uid)->orderBy('id', 'desc')->get();
        $data['send_email'] = SendEmail::groupBy('email')->where('uid', $uid)->orderBy('id', 'desc')->get();
        $data['send_card'] = SendCard::groupBy('email')->where('uid', $uid)->orderBy('id', 'desc')->get();
        $data['send_video'] = SendVideo::groupBy('email')->where('uid', $uid)->orderBy('id', 'desc')->get();
        $data['send_sms'] = SendSms::groupBy('email')->where('uid', $uid)->orderBy('id', 'desc')->get();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $data['years'] = [];
        for($i = 0; $i < 10; $i++){
            $lastYear = date("Y", strtotime("-$i years"));
            if($lastYear > 2019){
                array_push($data['years'], $lastYear);
            }
        }
        return view('comparison_email3')->with($data);
    }
    public function manage_folders()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = EmailManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        // $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->get();
        $data['folders'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->where('folder_name', '!=', "Basket 1")->where('folder_name', '!=', "Basket 2")->orderBy('id', 'desc')->get();
        }
        else{
            $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->where('folder_name', '!=', "Basket X")->orderBy('id', 'desc')->get();
        }
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $aff_data=AffiliateRegistration::where('email',Auth::user()->email)->first();
        $data['my_referral_link'] ='';
        $data['my_profile_link'] ='';
        if(!empty($aff_data->code)){
            $sponsor_link=AffiliateRegistration::get_user_referral_link($aff_data->code,$aff_data->email);
            $data['my_referral_link'] =$sponsor_link;
            $data['my_profile_link']=url('user/'.$aff_data->username);
        }
        return view('manage_folders')->with($data);
    }
    public function manage_contacts()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = EmailManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        // $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->get();
        // $data['folders'] = "";
        // if(Auth::user()->role == "user"){
        //     $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->where('folder_name', '!=', "Basket X")->orderBy('id', 'desc')->get();
        // }
        // else{
        //     $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->where('folder_name', '!=', "Basket 1")->where('folder_name', '!=', "Basket 2")->where('folder_name', '!=', "Basket X")->where('folder_name', '!=', "Family")->where('folder_name', '!=', "Friends")->where('folder_name', '!=', "Client")->where('folder_name', '!=', "VIP client")get();
        // }
        // $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->where('folder_name', '!=', "Basket 1")->where('folder_name', '!=', "Basket 2")->where('folder_name', '!=', "Basket X")->where('folder_name', '!=', "Family")->where('folder_name', '!=', "Friends")->where('folder_name', '!=', "Client")->where('folder_name', '!=', "VIP client")->get();
        $data['folders'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->where('folder_name', '!=', "Basket 1")->where('folder_name', '!=', "Basket 2")->orderBy('id', 'desc')->get();
        }
        else{
            $data['folders'] = Folders::where('uid', $uid)->orWhere('uid', "default")->where('folder_name', '!=', "Basket X")->orderBy('id', 'desc')->get();
        }
        $data['contacts'] = DB::table('folders')->join('contacts', 'folders.id', '=', 'contacts.folder')->where('contacts.uid', Auth::id())->orderBy('contacts.id', 'desc')->get();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('manage_contacts')->with($data);
    }
    public function manage_emails()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = EmailManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['emails'] = Contacts::where('uid', $uid)->orderBy('id', 'desc')->where('status', 1)->get();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('manage_emails')->with($data);
    }
    public function uploads()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = EmailManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['category'] = UploadCard::groupBy('category')->orderBy('category','desc')->get();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('uploads')->with($data);
    }
    public function email_tutorials()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = EmailManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
         $data['tutorials'] = EmailTutorial::get();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $aff_data=AffiliateRegistration::where('email',Auth::user()->email)->first();
        $data['my_referral_link'] ='';
        $data['my_profile_link'] ='';
        if(!empty($aff_data->code)){
            $sponsor_link=AffiliateRegistration::get_user_referral_link($aff_data->code,$aff_data->email);
            $data['my_referral_link'] =$sponsor_link;
            $data['my_profile_link']=url('user/'.$aff_data->username);
        }
        return view('email_tutorials')->with($data);
    }
    public function revenue_records(Request $request)
    {
       $data['mode']='';
       $data['cmonth']=date('m');
       $daily=$request->input('daily');
       $sdate=$request->input('sdate');
       $edate=$request->input('edate');
       $monthly=$request->input('monthly');



        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $uemail = "";
        if((Auth::user()->role) == "affiliate"){
            $uemail = Auth::user()->email;
        }
        else{
            $uemail = Auth::user()->affiliate_user_email;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['clients'] = DB::table('client_appointment_lists')->where('uid', $uid)->get();
        $data['revenue_account'] = DB::table('revenue_account')->where('uid', $uid)->where('account_name', '!=', "Sales Tax Collected")->where('account_name', '!=', "Shipping Collected")->orderBy('id', 'desc')->get();


        if(!empty($daily)){
         $data['mode']='daily';
         $data['cmonth']=date('m',strtotime($daily));
         $data['revenue_records'] = DB::table('revenue_record')->where('account_description', '!=', "Sales Tax Collected")->where('account_description', '!=', "Shipping Collected")->where('uid', $uid)->whereDate('transaction_date', '=', $daily)->orderBy('transaction_date', 'desc')->get();
        }elseif(!empty($monthly)){
          $data['mode']='monthly';
           $data['cmonth']=$monthly;
          $data['revenue_records'] = DB::table('revenue_record')->where('account_description', '!=', "Sales Tax Collected")->where('account_description', '!=', "Shipping Collected")->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', $monthly)->orderBy('transaction_date', 'desc')->get();
        }elseif (!empty($sdate) && !empty($edate)) {
           $data['mode']='weekly';
            $data['cmonth']=date('m',strtotime($sdate));
           $data['revenue_records'] = DB::table('revenue_record')->where('account_description', '!=', "Sales Tax Collected")->where('account_description', '!=', "Shipping Collected")->where('uid', $uid)->whereBetween('transaction_date', [$sdate, $edate])->orderBy('transaction_date', 'desc')->get();
        }else{
        $data['revenue_records'] = DB::table('revenue_record')->where('account_description', '!=', "Sales Tax Collected")->where('account_description', '!=', "Shipping Collected")->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', date('m'))->orderBy('transaction_date', 'desc')->get();
        }


        $data['banner'] = DB::table('affiliate_banner')->where('affiliate_email', $uemail)->first();
        $data['invoice_setup'] = FinancialInvoiceSetup::where('uid', $uid)->first();
        $data['chat'] = "";
        $data['tools'] = "";
        $data['upload_files'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
            if($cdet->upload_files == "on"){
                $data['upload_files'] = "on";
            }
            else{
                $data['upload_files'] = "off";
            }
        }

        $uid123 = Auth::id();
        $data['disc'] = Discount::where('uid', $uid123)->first();

        // if(empty($data['disc'])){
        //     $data['disc'] = null;
        // }
        return view('revenue_records')->with($data);
    }

    public function revenue_records_neg(Request $request)
    {
        $client = $request->client;
       $data['mode']='';
       $data['cmonth']=date('m');
       $daily=$request->input('daily');
       $sdate=$request->input('sdate');
       $edate=$request->input('edate');
       $monthly=$request->input('monthly');




        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $uemail = "";
        if((Auth::user()->role) == "affiliate"){
            $uemail = Auth::user()->email;
        }
        else{
            $uemail = Auth::user()->affiliate_user_email;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['clients'] = DB::table('client_appointment_lists')->where('uid', $uid)->get();
        $data['client_data'] = DB::table('client_appointment_lists')->where('id', $client)->get();
        $data['revenue_account'] = DB::table('revenue_account')->where('uid', $uid)->where('account_name', '!=', "Sales Tax Collected")->where('account_name', '!=', "Shipping Collected")->orderBy('id', 'desc')->get();


        if(!empty($daily)){
         $data['mode']='daily';
         $data['cmonth']=date('m',strtotime($daily));
         $data['revenue_records'] = DB::table('revenue_record')->where('account_description', '!=', "Sales Tax Collected")->where('account_description', '!=', "Shipping Collected")->where('uid', $uid)->whereDate('transaction_date', '=', $daily)->orderBy('transaction_date', 'desc')->get();
        }elseif(!empty($monthly)){
          $data['mode']='monthly';
           $data['cmonth']=$monthly;
          $data['revenue_records'] = DB::table('revenue_record')->where('account_description', '!=', "Sales Tax Collected")->where('account_description', '!=', "Shipping Collected")->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', $monthly)->orderBy('transaction_date', 'desc')->get();
        }elseif (!empty($sdate) && !empty($edate)) {
           $data['mode']='weekly';
            $data['cmonth']=date('m',strtotime($sdate));
           $data['revenue_records'] = DB::table('revenue_record')->where('account_description', '!=', "Sales Tax Collected")->where('account_description', '!=', "Shipping Collected")->where('uid', $uid)->whereBetween('transaction_date', [$sdate, $edate])->orderBy('transaction_date', 'desc')->get();
        }else{
        $data['revenue_records'] = DB::table('revenue_record')->where('account_description', '!=', "Sales Tax Collected")->where('account_description', '!=', "Shipping Collected")->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', date('m'))->orderBy('transaction_date', 'desc')->get();
        }


        $data['banner'] = DB::table('affiliate_banner')->where('affiliate_email', $uemail)->first();
        $data['invoice_setup'] = FinancialInvoiceSetup::where('uid', $uid)->first();
        $data['chat'] = "";
        $data['tools'] = "";
        $data['upload_files'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
            if($cdet->upload_files == "on"){
                $data['upload_files'] = "on";
            }
            else{
                $data['upload_files'] = "off";
            }
        }
        return view('revenue_records_neg')->with($data);
    }

    public function revenue_records_pos(Request $request)
    {
        $client = $request->client;
       $data['mode']='';
       $data['cmonth']=date('m');
       $daily=$request->input('daily');
       $sdate=$request->input('sdate');
       $edate=$request->input('edate');
       $monthly=$request->input('monthly');

       $client_data = DB::table('client_appointment_lists')->where('id', $client)->get();

        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $uemail = "";
        if((Auth::user()->role) == "affiliate"){
            $uemail = Auth::user()->email;
        }
        else{
            $uemail = Auth::user()->affiliate_user_email;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['clients'] = DB::table('client_appointment_lists')->where('uid', $uid)->get();
        $data['revenue_account'] = DB::table('revenue_account')->where('uid', $uid)->where('account_name', '!=', "Sales Tax Collected")->where('account_name', '!=', "Shipping Collected")->orderBy('id', 'desc')->get();


        if(!empty($daily)){
         $data['mode']='daily';
         $data['cmonth']=date('m',strtotime($daily));
         $data['revenue_records'] = DB::table('revenue_record')->where('account_description', '!=', "Sales Tax Collected")->where('account_description', '!=', "Shipping Collected")->where('uid', $uid)->whereDate('transaction_date', '=', $daily)->orderBy('transaction_date', 'desc')->get();
        }elseif(!empty($monthly)){
          $data['mode']='monthly';
           $data['cmonth']=$monthly;
          $data['revenue_records'] = DB::table('revenue_record')->where('account_description', '!=', "Sales Tax Collected")->where('account_description', '!=', "Shipping Collected")->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', $monthly)->orderBy('transaction_date', 'desc')->get();
        }elseif (!empty($sdate) && !empty($edate)) {
           $data['mode']='weekly';
            $data['cmonth']=date('m',strtotime($sdate));
           $data['revenue_records'] = DB::table('revenue_record')->where('account_description', '!=', "Sales Tax Collected")->where('account_description', '!=', "Shipping Collected")->where('uid', $uid)->whereBetween('transaction_date', [$sdate, $edate])->orderBy('transaction_date', 'desc')->get();
        }else{
        $data['revenue_records'] = DB::table('revenue_record')->where('account_description', '!=', "Sales Tax Collected")->where('account_description', '!=', "Shipping Collected")->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', date('m'))->orderBy('transaction_date', 'desc')->get();
        }


        $data['banner'] = DB::table('affiliate_banner')->where('affiliate_email', $uemail)->first();
        $data['invoice_setup'] = FinancialInvoiceSetup::where('uid', $uid)->first();
        $data['chat'] = "";
        $data['tools'] = "";
        $data['upload_files'] = "";
        $data['client_data'] = $client_data;
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
            if($cdet->upload_files == "on"){
                $data['upload_files'] = "on";
            }
            else{
                $data['upload_files'] = "off";
            }
        }
        return view('revenue_records_pos')->with($data);
    }

    public function edit_revenue_record(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        Session::put('revenue_id', $request->id);
        return redirect('up_revenue_record');
    }
    public function up_revenue_record()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $revenue_id = Session::get('revenue_id');
        if($revenue_id == ""){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        $uid = "";
        $uemail = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
            $uemail = Auth::user()->email;
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
            $uemail = Auth::user()->affiliate_user_email;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['clients'] = DB::table('client_appointment_lists')->where('uid', $uid)->get();
        $data['revenue_records'] = DB::table('revenue_record')->where('id', $revenue_id)->first();
        $data['account_revenue'] = "";
        $account_revenue = DB::table('revenue_account')->where('account_name', $data['revenue_records']->account_description)->first();
        if($account_revenue != ""){
            $data['account_revenue'] = $account_revenue->amount;
        }
        $data['revenue_account'] = DB::table('revenue_account')->where('uid', $uid)->orderBy('id', 'desc')->get();
        $data['banner'] = DB::table('affiliate_banner')->where('affiliate_email', $uemail)->first();
        $data['invoice_setup'] = FinancialInvoiceSetup::where('uid', $uid)->first();
        // print_r($data['account_revenue']);die();
        $data['chat'] = "";
        $data['tools'] = "";
        $data['upload_files'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
            if($cdet->upload_files == "on"){
                $data['upload_files'] = "on";
            }
            else{
                $data['upload_files'] = "off";
            }
        }

        $data['disc'] = Discount::where('uid', $uid)->first();
        return view('edit_revenue_record')->with($data);
    }
    public function expenses_reord(Request $request)
    {
        $data['mode']='';
         $data['cmonth']=date('m');
       $daily=$request->input('daily');
       $sdate=$request->input('sdate');
       $edate=$request->input('edate');
       $monthly=$request->input('monthly');
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['expenses_account'] = DB::table('expenses_account')->where('uid', $uid)->orderBy('id', 'desc')->get();


if(!empty($daily)){
         $data['mode']='daily';
           $data['cmonth']=date('m',strtotime($daily));
          $data['expense_record'] = DB::table('expense_record')->where('uid',$uid)->whereDate('transaction_date', '=', $daily)->orderBy('transaction_date', 'desc')->get();
        }elseif(!empty($monthly)){
          $data['mode']='monthly';
            $data['cmonth']=$monthly;
          $data['expense_record'] = DB::table('expense_record')->where('uid',$uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', $monthly)->orderBy('transaction_date', 'desc')->get();
        }elseif (!empty($sdate) && !empty($edate)) {
           $data['mode']='weekly';
            $data['cmonth']=date('m',strtotime($sdate));
           $data['expense_record'] = DB::table('expense_record')->where('uid',$uid)->whereBetween('transaction_date', [$sdate, $edate])->orderBy('transaction_date', 'desc')->get();
        }else{
        $data['expense_record'] = DB::table('expense_record')->where('uid',$uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', date('m'))->orderBy('transaction_date', 'desc')->get();
        }
        $data['chat'] = "";
        $data['tools'] = "";
        $data['upload_files'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
            if($cdet->upload_files == "on"){
                $data['upload_files'] = "on";
            }
            else{
                $data['upload_files'] = "off";
            }
        }
        return view('expenses_reord')->with($data);
    }
    public function edit_expense_record(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['expense_record'] = DB::table('expense_record')->where('id', $request->id)->first();
        $data['expenses_account'] = DB::table('expenses_account')->where('uid', $uid)->orderBy('id', 'desc')->get();
        $data['account_expense'] = DB::table('expenses_account')->where('account_name', $data['expense_record']->account_description)->first();
        $data['chat'] = "";
        $data['tools'] = "";
        $data['upload_files'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
            if($cdet->upload_files == "on"){
                $data['upload_files'] = "on";
            }
            else{
                $data['upload_files'] = "off";
            }
        }
        return view('edit_expense_record')->with($data);
    }
    public function manage_assets()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['record'] = DB::table('asset_record')->get();
        $data['chat'] = "";
        $data['tools'] = "";
        $data['upload_files'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
            if($cdet->upload_files == "on"){
                $data['upload_files'] = "on";
            }
            else{
                $data['upload_files'] = "off";
            }
        }
        return view('manage_assets')->with($data);
    }
    public function manage_assets_edit(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        Session::put('manage_assets_id', $request->id);
        return redirect('up_assets_edit');
    }
    public function up_assets_edit()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $id = Session::get('manage_assets_id');
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['record'] = DB::table('asset_record')->where('id', $id)->first();
        $data['chat'] = "";
        $data['tools'] = "";
        $data['upload_files'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
            if($cdet->upload_files == "on"){
                $data['upload_files'] = "on";
            }
            else{
                $data['upload_files'] = "off";
            }
        }
        return view('manage_assets_edit')->with($data);
    }
    public function manage_assets_delete(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $val = DB::table('asset_record')->where('id', $request->id)->first();
         $notification  = getNotificationMessage(8);
            $message = $notification;
            $subject = "Asset Record Deletion";
           addUserActivity($subject,'delete',$notification,$message);
        $values2 = array(
            'purchase_date'         => $val->purchase_date,
            'quantity'              => $val->quantity,
            'price'                 => $val->price,
            'description'           => $val->description,
            'updated_at'            => date('Y-m-d H:i:s'),
            'uid'                   => $uid,
            'reason'                => $request->reason,
            'asset_id'              => $request->id,
            'user_email'            => Auth::user()->email
        );
        DB::table('asset_record_delete')->insert($values2);
        DB::table('asset_record')->where('id', $request->id)->delete();
        DB::table('asset_record_update')->where('asset_id', $request->id)->delete();
        return redirect('manage_assets');
    }
    public function upload_files_delete(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $val = DB::table('upload_files')->where('id', $request->id)->first();
          $notification  = getNotificationMessage(26);
            $message = $notification;
        $subject = "File Deletion";
        addUserActivity($subject,'delete',$notification,$message);
        $values2 = array(
            'file'      => $val->file,
            'uid'       => $uid,
            'reason'    => $request->reason,
        );
        DB::table('upload_files_delete')->insert($values2);
        DB::table('upload_files')->where('id', $request->id)->delete();
        return redirect('upload_files');
    }
    public function delete_revenue_record(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $revenuee = DB::table('revenue_record')->where('id', $request->id)->first();
         $notification  = getNotificationMessage(14);
            $message = $notification;
        $subject = "Record Revenue Deletion";
       addUserActivity($subject,'delete',$notification,$message);
        $revenue_id = $request->id;
        $val = DB::table('revenue_record')->where('id', $revenue_id)->first();
        $values2 = array(
            'client_name'           => $val->client_name,
            'client_email'          => $val->client_email,
            'transaction_date'      => $val->transaction_date,
            'account_description'   => $val->account_description,
            'bill'                  => $val->bill,
            'tax'                   => $val->tax,
            'shipping'              => $val->shipping,
            'total'                 => $val->total,
            'amount_paid'           => $val->amount_paid,
            'balance'               => $val->balance,
            'created_at'            => date('Y-m-d H:i:s'),
            'reason'                => $request->reason,
            'uid'                   => $uid,
            'user_email'            => Auth::user()->email
        );
        DB::table('revenue_record_delete')->insert($values2);
        DB::table('revenue_record')->where('id', $revenue_id)->delete();
        DB::table('revenue_record_update')->where('rev_id', $revenue_id)->delete();
        $data['years'] = [];
            for($i = 0; $i < 10; $i++){
                $lastYear = date("Y", strtotime("-$i years"));
                if($lastYear > 2019){
                    array_push($data['years'], $lastYear);
                }
            }
            $months = ['01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12'];
            $invoice_setup = FinancialInvoiceSetup::where('uid', $uid)->first();
            foreach($data['years'] as $year){
                foreach($months as $month){
                    if($invoice_setup->is_tax == 1){
                        $tax = DB::table('revenue_record')->where('account_description', '!=', 'Sales Tax Collected')->where('account_description', '!=', 'Shipping Collected')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', $month)->sum('tax');
                        $revrecrd1 = DB::table('revenue_record')->where('account_description', 'Sales Tax Collected')->whereYear('transaction_date', $year)->whereMonth('transaction_date', $month)->where('uid', $uid)->get();
                        if(count($revrecrd1) > 0){
                            DB::table('revenue_record')->where('account_description', 'Sales Tax Collected')->whereYear('transaction_date', $year)->whereMonth('transaction_date', $month)->where('uid', $uid)->update([
                                'bill'                  => $tax,
                                'total'                 => $tax,
                                'amount_paid'           => $tax,
                            ]);
                        }else{
                            DB::table('revenue_record')->insert([
                                'transaction_date'      => $year."-".$month."-01",
                                'account_description'   => "Sales Tax Collected",
                                'bill'                  => $tax,
                                'tax'                   => "0",
                                'shipping'              => "0",
                                'total'                 => $tax,
                                'amount_paid'           => $tax,
                                'balance'               => "0",
                                'created_at'            => $year."-".$month."-01",
                                'uid'                   => $uid
                            ]);
                        }
                    }
                    if($invoice_setup->shipping_cost == 1){
                        $shipping = DB::table('revenue_record')->where('account_description', '!=', 'Sales Tax Collected')->where('account_description', '!=', 'Shipping Collected')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', $month)->sum('shipping');
                        $revrecrd2 = DB::table('revenue_record')->where('account_description', 'Shipping Collected')->whereYear('transaction_date', $year)->whereMonth('transaction_date', $month)->where('uid', $uid)->get();
                        if(count($revrecrd2) > 0){
                            DB::table('revenue_record')->where('account_description', 'Shipping Collected')->whereYear('transaction_date', $year)->whereMonth('transaction_date', $month)->where('uid', $uid)->update([
                                'bill'                  => $shipping,
                                'total'                 => $shipping,
                                'amount_paid'           => $shipping,
                            ]);
                        }else{
                            DB::table('revenue_record')->insert([
                                'transaction_date'      => $year."-".$month."-01",
                                'account_description'   => "Shipping Collected",
                                'bill'                  => $shipping,
                                'tax'                   => "0",
                                'shipping'              => "0",
                                'total'                 => $shipping,
                                'amount_paid'           => $shipping,
                                'balance'               => "0",
                                'created_at'            => $year."-".$month."-01",
                                'uid'                   => $uid
                            ]);
                        }
                    }
                }
            }
    }
    public function delete_expense_record(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $expense = DB::table('expense_record')->where('id', $request->id)->first();
        $notification  = getNotificationMessage(11);
            $message = $notification;
        $subject = "Expense Record Deletion";
        addUserActivity($subject,'delete',$notification,$message);
        $revenue_id = $request->id;
        $val = DB::table('expense_record')->where('id', $revenue_id)->first();
        $values2 = array(
            'transaction_date'      => $val->transaction_date,
            'account_description'   => $val->account_description,
            'total'                 => $val->total,
            'amount_paid'           => $val->amount_paid,
            'balance'               => $val->balance,
            'created_at'            => date('Y-m-d H:i:s'),
            'reason'                => $request->reason,
            'uid'                   => $uid,
            'user_email'            => Auth::user()->email
        );
        DB::table('expense_record_delete')->insert($values2);
        DB::table('expense_record')->where('id', $revenue_id)->delete();
        DB::table('expense_record_update')->where('exp_id', $revenue_id)->delete();
    }
    public function balancesheet()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('balancesheet')->with($data);
    }
    public function monthly_budget_chart(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['value'] = DB::table('revenue_budget')->where('id', $request->id)->first();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('monthly_budget_chart')->with($data);
    }
    public function monthly_expense_chart(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['value'] = DB::table('expense_budget')->where('id', $request->id)->first();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('monthly_expense_chart')->with($data);
    }
    public function monthly_projection_chart(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['value'] = DB::table('revenue_projection')->where('id', $request->id)->first();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('monthly_projection_chart')->with($data);
    }
    public function monthly_projectionexp_chart(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['value'] = DB::table('expense_projection')->where('id', $request->id)->first();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('monthly_projectionexp_chart')->with($data);
    }
    public function quarterly_budget_chart(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['value'] = DB::table('revenue_quaterly_budget')->where('id', $request->id)->first();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('quarterly_budget_chart')->with($data);
    }
    public function quarterly_expense_chart(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['value'] = DB::table('expense_quaterly_budget')->where('id', $request->id)->first();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('quarterly_expense_chart')->with($data);
    }
    public function quarterly_projection_chart(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['value'] = DB::table('revenue_quaterly_projection')->where('id', $request->id)->first();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('quarterly_projection_chart')->with($data);
    }
    public function quarterly_projectionexp_chart(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['value'] = DB::table('expense_quaterly_projection')->where('id', $request->id)->first();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('quarterly_projectionexp_chart')->with($data);
    }
    public function total_monthly_budget_chart()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['jantotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jan');
        $data['febtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('feb');
        $data['martotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('mar');
        $data['aprtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('apr');
        $data['maytotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('may');
        $data['juntotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jun');
        $data['jultotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jul');
        $data['augtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aug');
        $data['septotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('sep');
        $data['octtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('oct');
        $data['novtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('nov');
        $data['dectotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('decem');
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('total_monthly_budget_chart')->with($data);
    }
    public function total_monthly_expense_chart()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['jantotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jan');
        $data['febtotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('feb');
        $data['martotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('mar');
        $data['aprtotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('apr');
        $data['maytotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('may');
        $data['juntotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jun');
        $data['jultotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jul');
        $data['augtotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aug');
        $data['septotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('sep');
        $data['octtotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('oct');
        $data['novtotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('nov');
        $data['dectotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('decem');
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('total_monthly_expense_chart')->with($data);
    }
    public function total_monthly_projection_chart()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['jantotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jan');
        $data['febtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('feb');
        $data['martotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('mar');
        $data['aprtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('apr');
        $data['maytotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('may');
        $data['juntotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jun');
        $data['jultotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jul');
        $data['augtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aug');
        $data['septotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('sep');
        $data['octtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('oct');
        $data['novtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('nov');
        $data['dectotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('decem');
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('total_monthly_projection_chart')->with($data);
    }
    public function total_monthly_projectionexp_chart()
    {
         if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['jantotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jan');
        $data['febtotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('feb');
        $data['martotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('mar');
        $data['aprtotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('apr');
        $data['maytotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('may');
        $data['juntotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jun');
        $data['jultotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jul');
        $data['augtotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aug');
        $data['septotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('sep');
        $data['octtotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('oct');
        $data['novtotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('nov');
        $data['dectotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('decem');
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('total_monthly_projectionexp_chart')->with($data);
    }
    public function total_quarterly_budget_chart()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmartotal'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('janmar');
        $data['aprjuntotal'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aprjun');
        $data['julseptotal'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('julsep');
        $data['octdectotal'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('octdec');
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('total_quarterly_budget_chart')->with($data);
    }
    public function total_quarterly_expense_chart()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmartotal'] = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('janmar');
        $data['aprjuntotal'] = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aprjun');
        $data['julseptotal'] = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('julsep');
        $data['octdectotal'] = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('octdec');
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('total_quarterly_expense_chart')->with($data);
    }
    public function total_quarterly_projection_chart()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmartotal'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('janmar');
        $data['aprjuntotal'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aprjun');
        $data['julseptotal'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('julsep');
        $data['octdectotal'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('octdec');
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('total_quarterly_projection_chart')->with($data);
    }
    public function total_quarterly_projectionexp_chart()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmartotal'] = DB::table('expense_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('janmar');
        $data['aprjuntotal'] = DB::table('expense_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aprjun');
        $data['julseptotal'] = DB::table('expense_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('julsep');
        $data['octdectotal'] = DB::table('expense_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('octdec');
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('total_quarterly_projectionexp_chart')->with($data);
    }

    public function create_budget_year(Request $request)
    {
        $year=$request->year;

        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['revenue']= DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->orderBy('id', 'desc')->get();

        $existrevenue = [];
        foreach ($data['revenue'] as $value) {
            array_push($existrevenue, $value->name);
        }
        $data['revenue_account'] = DB::table('revenue_account')->whereNotIn('account_name', $existrevenue)->get();
        if(count($data['revenue']) > 0){
            $data['revenue_count'] = $data['revenue'][0]->id;
        }else{
            $data['revenue_count'] = 0;
        }
        $data['jantotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('jan');
        $data['febtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('feb');
        $data['martotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('mar');
        $data['aprtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('apr');
        $data['maytotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('may');
        $data['juntotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('jun');
        $data['jultotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('jul');
        $data['augtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('aug');
        $data['septotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('sep');
        $data['octtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('oct');
        $data['novtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('nov');
        $data['dectotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('decem');
        $data['monthtotal'] = $data['jantotal'] + $data['febtotal'] + $data['martotal'] + $data['aprtotal'] + $data['maytotal'] + $data['juntotal'] + $data['jultotal'] + $data['augtotal'] + $data['septotal'] + $data['octtotal'] + $data['novtotal'] + $data['dectotal'];
        $data['revenue_quaterly'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->orderBy('id', 'desc')->get();
        if(count($data['revenue_quaterly']) > 0){
            $data['revenue_quaterly_count'] = $data['revenue_quaterly'][0]->id;
        }else{
            $data['revenue_quaterly_count'] = 0;
        }
        $data['janmartotal'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('janmar');
        $data['aprjuntotal'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aprjun');
        $data['julseptotal'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('julsep');
        $data['octdectotal'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('octdec');
        $data['quaterlytotal'] = $data['janmartotal'] + $data['aprjuntotal'] + $data['julseptotal'] + $data['octdectotal'];
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }

     ob_start();
        $rev=$data['revenue'];
     $revenue_count=$data['revenue_count'];

     $jantotal=$data['jantotal'];
        $febtotal=$data['febtotal'];
        $martotal=$data['martotal'];
        $aprtotal=$data['aprtotal'];
        $maytotal=$data['maytotal'];
        $juntotal=$data['juntotal'];
        $jultotal=$data['jultotal'];
        $augtotal=$data['augtotal'];
        $septotal=$data['septotal'];
        $octtotal=$data['octtotal'];
        $novtotal=$data['novtotal'];
        $dectotal=$data['dectotal'] ;
        $monthtotal=$data['monthtotal'];
        $revenue_quaterly=$data['revenue_quaterly'];
        $janmartotal=$data['janmartotal'];
        $aprjuntotal=$data['aprjuntotal'];
        $julseptotal=$data['julseptotal'];
        $octdectotal=$data['octdectotal'];
        $quaterlytotal=$data['quaterlytotal'];
        $chat=$data['chat'] = "";
        $tools=$data['tools'] = "";



?>

<div class="table-wrap">
    <table class="table table-striped table-bordered table-hover main-table" id="">
        <thead>
            <tr>
                <th></th>
                <th>Jan</th>
                <th>Feb</th>
                <th>Mar</th>
                <th>Apr</th>
                <th>May</th>
                <th>Jun</th>
                <th>Jul</th>
                <th>Aug</th>
                <th>Sep</th>
                <th>Oct</th>
                <th>Nov</th>
                <th>Dec</th>
                <th>Total</th>
                <th>Graph</th>
            </tr>
            <tr>
                <th class="">
                    <!-- <a href="javascript:void(0);" class="add_button" title="Add field">
                                                   <span class="glyphicon glyphicon-plus" style="text-align: center; color: white; font-size: 20px; font-weight: bold"></span>
                                                   </a> -->
                </th>
                <th>Budget</th>
                <th>Budget</th>
                <th>Budget</th>
                <th>Budget</th>
                <th>Budget</th>
                <th>Budget</th>
                <th>Budget</th>
                <th>Budget</th>
                <th>Budget</th>
                <th>Budget</th>
                <th>Budget</th>
                <th>Budget</th>
                <th>Budget</th>
                <th></th>
            </tr>
        </thead>
        <tbody class="field_wrapper">
            <?php

                                          if(count($rev)==0){
                                            ?>
            <tr class="odd gradeX monthly">
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td>No data found</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            <?php
                                          }else{
                                             $currmon = date('m');
                                             $curryear=date('y');


                                             foreach ($rev as $value) {

if($curryear > date('y',strtotime($value->created_at))){
    $readonly="readonly";
    $disabled="disabled";
}else{
      $readonly="";
        $disabled="";

    }


                                                 ?>
            <tr class="odd gradeX monthly" id="row<?= $value->id ?>">
                <td class="budget_name">
                    <!-- <select class="form-control" required disabled>
                                                   <option value="<?= $value->name ?>"><?= $value->name ?></option>
                                                   </select>
                                                   <p style="color: red; text-align: left; margin-bottom: 2px; display: none">*required</p> -->
                    <b style="padding: 0 10px" class="bname"><?= $value->name ?></b>
                </td>
                <td class="jan">
                    <input type="number" class="form-control" value="<?= $value->jan ?>" id="jan<?= $value->id ?>"
                        <?php if($currmon >= "01"){ echo  "readonly"; }else{ echo $readonly;} ?>>
                </td>
                <td class="feb">
                    <input type="number" class="form-control" value="<?= $value->feb ?>" id="feb<?= $value->id ?>"
                        <?php if($currmon >= "02"){ echo  "readonly"; }else{ echo $readonly;} ?>>
                </td>
                <td class="mar">
                    <input type="number" class="form-control" value="<?= $value->mar ?>" id="mar<?= $value->id ?>"
                        <?php if($currmon >= "03"){ echo  "readonly"; }else{ echo $readonly;} ?>>
                </td>
                <td class="apr">
                    <input type="number" class="form-control" value="<?= $value->apr ?>" id="apr<?= $value->id ?>"
                        <?php if($currmon >= "04"){ echo  "readonly"; }else{ echo $readonly;} ?>>
                </td>
                <td class="may">
                    <input type="number" class="form-control" value="<?= $value->may ?>" id="may<?= $value->id ?>"
                        <?php if($currmon >= "05"){ echo  "readonly"; }else{ echo $readonly;} ?>>
                </td>
                <td class="jun">
                    <input type="number" class="form-control" value="<?= $value->jun ?>" id="jun<?= $value->id ?>"
                        <?php if($currmon >= "06"){ echo  "readonly"; }else{ echo $readonly;} ?>>
                </td>
                <td class="jul">
                    <input type="number" class="form-control" value="<?= $value->jul ?>" id="jul<?= $value->id ?>"
                        <?php if($currmon >= "07"){ echo  "readonly"; }else{ echo $readonly;} ?>>
                </td>
                <td class="aug">
                    <input type="number" class="form-control" value="<?= $value->aug ?>" id="aug<?= $value->id ?>"
                        <?php if($currmon >= "08"){ echo  "readonly"; }else{ echo $readonly;} ?>>
                </td>
                <td class="sep">
                    <input type="number" class="form-control" value="<?= $value->sep ?>" id="sep<?= $value->id ?>"
                        <?php if($currmon >= "09"){ echo  "readonly"; }else{ echo $readonly;} ?>>
                </td>
                <td class="oct">
                    <input type="number" class="form-control" value="<?= $value->oct ?>" id="oct<?= $value->id ?>"
                        <?php if($currmon >= "10"){ echo  "readonly"; }else{ echo $readonly;} ?>>
                </td>
                <td class="nov">
                    <input type="number" class="form-control" value="<?= $value->nov ?>" id="nov<?= $value->id ?>"
                        <?php if($currmon >= "11"){ echo  "readonly"; }else{ echo $readonly;} ?>>
                </td>
                <td class="dec">
                    <input type="number" class="form-control" value="<?= $value->decem ?>" id="dec<?= $value->id ?>"
                        <?php if($currmon >= "12"){ echo  "readonly"; }else{ echo $readonly;} ?>>
                </td>
                <td class="budg_total">
                    <?= ($value->jan + $value->feb + $value->mar + $value->apr + $value->may + $value->jun + $value->jul + $value->aug + $value->sep + $value->oct + $value->nov + $value->decem) ?>
                </td>
                <td class="showgraph" id="showgraph<?= $value->id ?>">
                    <a href="<?php echo url('monthly_budget_chart')."/".$value->id ?>">
                        <div id="bar-chart<?= $value->id ?>" style="height: 20px; width: 50px"></div>
                    </a>
                    <script type="text/javascript">
                    $(function() {
                        "use strict";

                        //BAR CHART
                        var bar = new Morris.Bar({
                            element: 'bar-chart<?= $value->id ?>',
                            resize: true,
                            data: [{
                                    y: '',
                                    a: <?= $value->jan ?>
                                },
                                {
                                    y: '',
                                    a: <?= $value->feb ?>
                                },
                                {
                                    y: '',
                                    a: <?= $value->mar ?>
                                },
                                {
                                    y: '',
                                    a: <?= $value->apr ?>
                                },
                                {
                                    y: '',
                                    a: <?= $value->may ?>
                                },
                                {
                                    y: '',
                                    a: <?= $value->jun ?>
                                },
                                {
                                    y: '',
                                    a: <?= $value->jul ?>
                                },
                                {
                                    y: '',
                                    a: <?= $value->aug ?>
                                },
                                {
                                    y: '',
                                    a: <?= $value->sep ?>
                                },
                                {
                                    y: '',
                                    a: <?= $value->oct ?>
                                },
                                {
                                    y: '',
                                    a: <?= $value->nov ?>
                                },
                                {
                                    y: '',
                                    a: <?= $value->decem ?>
                                }
                            ],
                            barColors: ['#da291c'],
                            xkey: 'y',
                            ykeys: ['a'],
                            labels: ['', ''],
                            hideHover: 'auto',
                            padding: 1,
                        });
                    });
                    </script>
                </td>
            </tr>
            <?php
                                             }
                                             ?>
        </tbody>
        <?php if($revenue_count == 0){ $style = "style='display:none'"; }else{ $style = "style=''"; } ?>
        <tbody class="sectbody" <?= $style ?>>
            <tr class="odd gradeX">
                <td style="text-align:left; color:#da291c; padding: 10px; font-weight: bold">Total</td>
                <td id="jantotal"><?= $jantotal ?></td>
                <td id="febtotal"><?= $febtotal ?></td>
                <td id="martotal"><?= $martotal ?></td>
                <td id="aprtotal"><?= $aprtotal ?></td>
                <td id="maytotal"><?= $maytotal ?></td>
                <td id="juntotal"><?= $juntotal ?></td>
                <td id="jultotal"><?= $jultotal ?></td>
                <td id="augtotal"><?= $augtotal ?></td>
                <td id="septotal"><?= $septotal ?></td>
                <td id="octtotal"><?= $octtotal ?></td>
                <td id="novtotal"><?= $novtotal ?></td>
                <td id="dectotal"><?= $dectotal ?></td>
                <td id="budget_total"><?= $monthtotal ?></td>
                <td class="chart_monthly">
                    <a href="<?php echo url('total_monthly_budget_chart') ?>">
                        <div id="bar-chart_total" style="height: 20px; width: 50px"></div>
                    </a>
                    <script type="text/javascript">
                    $(function() {
                        "use strict";

                        //BAR CHART
                        var bar = new Morris.Bar({
                            element: 'bar-chart_total',
                            resize: true,
                            data: [{
                                    y: '',
                                    a: <?= $jantotal ?>
                                },
                                {
                                    y: '',
                                    a: <?= $febtotal ?>
                                },
                                {
                                    y: '',
                                    a: <?= $martotal ?>
                                },
                                {
                                    y: '',
                                    a: <?= $aprtotal ?>
                                },
                                {
                                    y: '',
                                    a: <?= $maytotal ?>
                                },
                                {
                                    y: '',
                                    a: <?= $juntotal ?>
                                },
                                {
                                    y: '',
                                    a: <?= $jultotal ?>
                                },
                                {
                                    y: '',
                                    a: <?= $augtotal ?>
                                },
                                {
                                    y: '',
                                    a: <?= $septotal ?>
                                },
                                {
                                    y: '',
                                    a: <?= $octtotal ?>
                                },
                                {
                                    y: '',
                                    a: <?= $novtotal ?>
                                },
                                {
                                    y: '',
                                    a: <?= $dectotal ?>
                                }
                            ],
                            barColors: ['#da291c'],
                            xkey: 'y',
                            ykeys: ['a'],
                            labels: ['', ''],
                            hideHover: 'auto',
                            padding: 1,
                        });
                    });
                    </script>
                </td>
            </tr>
            <tr class="odd gradeX">
                <!-- <td></td> -->
                <td></td>
                <td>
                    <a id="jansave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                        <?php if($currmon >= "01"){ echo  "disabled"; }else{ echo $disabled;} ?>>Save</a><br>
                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                </td>
                <td>
                    <a id="febsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                        <?php if($currmon >= "02"){ echo  "disabled"; }else{ echo $disabled;} ?>>Save</a><br>
                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                </td>
                <td>
                    <a id="marsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                        <?php if($currmon >= "03"){ echo  "disabled"; }else{ echo $disabled;} ?>>Save</a><br>
                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                </td>
                <td>
                    <a id="aprsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                        <?php if($currmon >= "04"){ echo  "disabled"; }else{ echo $disabled;} ?>>Save</a><br>
                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                </td>
                <td>
                    <a id="maysave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                        <?php if($currmon >= "05"){ echo  "disabled"; }else{ echo $disabled;} ?>>Save</a><br>
                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                </td>
                <td>
                    <a id="junsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                        <?php if($currmon >= "06"){ echo  "disabled"; }else{ echo $disabled;} ?>>Save</a><br>
                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                </td>
                <td>
                    <a id="julsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                        <?php if($currmon >= "07"){ echo  "disabled"; }else{ echo $disabled;} ?>>Save</a><br>
                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                </td>
                <td>
                    <a id="augsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                        <?php if($currmon >= "08"){ echo  "disabled"; }else{ echo $disabled;} ?>>Save</a><br>
                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                </td>
                <td>
                    <a id="sepsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                        <?php if($currmon >= "09"){ echo  "disabled"; }else{ echo $disabled;} ?>>Save</a><br>
                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                </td>
                <td>
                    <a id="octsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                        <?php if($currmon >= "10"){ echo  "disabled"; }else{ echo $disabled;} ?>>Save</a><br>
                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                </td>
                <td>
                    <a id="novsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                        <?php if($currmon >= "11"){ echo  "disabled"; }else{ echo $disabled;} ?>>Save</a><br>
                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                </td>
                <td>
                    <a id="decsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                        <?php if($currmon >= "12"){ echo  "disabled"; }else{ echo $disabled;} ?>>Save</a><br>
                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                </td>
                <td></td>
                <td></td>
            </tr>
            <?php  } ?>
        </tbody>
    </table>
</div>
<?php
$html=ob_get_clean();
echo $html;





    }
    public function create_budget()
    {
            $year=Carbon::now()->format('Y');

        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['revenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date("".$year.""))->orderBy('id', 'desc')->get();
        $existrevenue = [];
        foreach ($data['revenue'] as $value) {
            array_push($existrevenue, $value->name);
        }
        $data['revenue_account'] = DB::table('revenue_account')->whereNotIn('account_name', $existrevenue)->get();
        if(count($data['revenue']) > 0){
            $data['revenue_count'] = $data['revenue'][0]->id;
        }else{
            $data['revenue_count'] = 0;
        }
        $data['jantotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jan');
        $data['febtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('feb');
        $data['martotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('mar');
        $data['aprtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('apr');
        $data['maytotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('may');
        $data['juntotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jun');
        $data['jultotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jul');
        $data['augtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aug');
        $data['septotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('sep');
        $data['octtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('oct');
        $data['novtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('nov');
        $data['dectotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('decem');
        $data['monthtotal'] = $data['jantotal'] + $data['febtotal'] + $data['martotal'] + $data['aprtotal'] + $data['maytotal'] + $data['juntotal'] + $data['jultotal'] + $data['augtotal'] + $data['septotal'] + $data['octtotal'] + $data['novtotal'] + $data['dectotal'];
        $data['revenue_quaterly'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->orderBy('id', 'desc')->get();
        if(count($data['revenue_quaterly']) > 0){
            $data['revenue_quaterly_count'] = $data['revenue_quaterly'][0]->id;
        }else{
            $data['revenue_quaterly_count'] = 0;
        }
        $data['janmartotal'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('janmar');
        $data['aprjuntotal'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aprjun');
        $data['julseptotal'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('julsep');
        $data['octdectotal'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('octdec');
        $data['quaterlytotal'] = $data['janmartotal'] + $data['aprjuntotal'] + $data['julseptotal'] + $data['octdectotal'];
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $data['years'] = [];
        for($i = 0; $i < 10; $i++){
            $lastYear = date("Y", strtotime("-$i years"));
            if($lastYear > 2019){
                array_push($data['years'], $lastYear);
            }
        }

        return view('create_budget')->with($data);

    }


    public function create_budget_quaterly_year(Request $request)
    {
        $year=$request->year;
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['revenue_quaterly']=$revenue_quaterly = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->orderBy('id', 'desc')->get();
        if(count($data['revenue_quaterly']) > 0){
            $data['revenue_quaterly_count']=$revenue_quaterly_count = $data['revenue_quaterly'][0]->id;
        }else{
            $data['revenue_quaterly_count']=$revenue_quaterly_count = 0;
        }
        $data['janmartotal']=$janmartotal = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('janmar');
        $data['aprjuntotal']=$aprjuntotal = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('aprjun');
        $data['julseptotal']=$julseptotal = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('julsep');
        $data['octdectotal']=$octdectotal = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('octdec');
        $data['quaterlytotal']=$quaterlytotal = $data['janmartotal'] + $data['aprjuntotal'] + $data['julseptotal'] + $data['octdectotal'];
        $data['chat']=$chat = "";
        $data['tools']=$tools = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }


        ob_start();
               ?>
<table class="table table-striped table-bordered table-hover" id="">
    <thead>
        <tr>
            <th></th>
            <th>Jan - Mar</th>
            <th>Apr - Jun</th>
            <th>Jul - Sep</th>
            <th>Oct - Dec</th>
            <th>Total</th>
            <th>Graph</th>
        </tr>
        <tr>
            <th class="">
                <!-- <a href="javascript:void(0);" class="add_button2" title="Add field">
                                             <span class="glyphicon glyphicon-plus" style="text-align: center; color: white; font-size: 20px; font-weight: bold"></span>
                                             </a> -->
            </th>
            <th>Budget</th>
            <th>Budget</th>
            <th>Budget</th>
            <th>Budget</th>
            <th>Budget</th>
            <th></th>
        </tr>
    </thead>
    <tbody class="field_wrapper2">
        <?php
                                       foreach ($revenue_quaterly as $value) {
                                           ?>
        <tr class="odd gradeX quarterly" id="roww<?= $value->id ?>">
            <!-- <td class=""></td> -->
            <td class="budget_name">
                <!-- <select class="form-control" required disabled>
                                             <option value="<?= $value->name ?>"><?= $value->name ?></option>
                                             </select>
                                             <p style="color: red; text-align: left; margin-bottom: 2px; display: none">*required</p> -->
                <b style="padding: 0 10px" class="bname"><?= $value->name ?></b>
            </td>
            <td class="janmar">
                <input type="number" class="form-control" value="<?= $value->janmar ?>" id="janmar<?= $value->id ?>"
                    readonly>
            </td>
            <td class="aprjun">
                <input type="number" class="form-control" value="<?= $value->aprjun ?>" id="aprjun<?= $value->id ?>"
                    readonly>
            </td>
            <td class="julsep">
                <input type="number" class="form-control" value="<?= $value->julsep ?>" id="julsep<?= $value->id ?>"
                    readonly>
            </td>
            <td class="octdec">
                <input type="number" class="form-control" value="<?= $value->octdec ?>" id="octdec<?= $value->id ?>"
                    readonly>
            </td>
            <td class="budg_total2">
                <?= ($value->janmar + $value->aprjun + $value->julsep + $value->octdec) ?>
            </td>
            <td class="showgraphq" id="showgraphq<?= $value->id ?>">
                <a href="<?php echo url('quarterly_budget_chart')."/".$value->id ?>">
                    <div id="bar-chartq<?= $value->id ?>" style="height: 20px; width: 30px"></div>
                </a>
                <script type="text/javascript">
                $(function() {
                    "use strict";

                    //BAR CHART
                    var bar = new Morris.Bar({
                        element: 'bar-chartq<?= $value->id ?>',
                        resize: true,
                        data: [{
                                y: '',
                                a: <?= $value->janmar ?>
                            },
                            {
                                y: '',
                                a: <?= $value->aprjun ?>
                            },
                            {
                                y: '',
                                a: <?= $value->julsep ?>
                            },
                            {
                                y: '',
                                a: <?= $value->octdec ?>
                            }
                        ],
                        barColors: ['#da291c'],
                        xkey: 'y',
                        ykeys: ['a'],
                        labels: ['', ''],
                        hideHover: 'auto',
                        padding: 1,
                    });
                });
                </script>
            </td>
        </tr>
        <?php
                                       }
                                       ?>
    </tbody>
    <?php if($revenue_quaterly_count == 0){ $style2 = "style='display:none'"; }else{ $style2 = "style=''"; } ?>
    <tbody class="sectbody2" <?= $style2 ?>>
        <tr class="odd gradeX">
            <!-- <td></td> -->
            <td style="text-align:left; color:#da291c;  padding: 10px; font-weight: bold">Total</td>
            <td id="janmartotal"><?= $janmartotal ?></td>
            <td id="aprjuntotal"><?= $aprjuntotal ?></td>
            <td id="julseptotal"><?= $julseptotal ?></td>
            <td id="octdectotal"><?= $octdectotal ?></td>
            <td id="budget_total"><?= $quaterlytotal ?></td>
            <td class="chart_quarterly">
                <a href="<?php echo url('total_quarterly_budget_chart') ?>">
                    <div id="bar-chart_totalq" style="height: 20px; width: 30px"></div>
                </a>
                <script type="text/javascript">
                $(function() {
                    "use strict";

                    //BAR CHART
                    var bar = new Morris.Bar({
                        element: 'bar-chart_totalq',
                        resize: true,
                        data: [{
                                y: '',
                                a: <?= $janmartotal ?>
                            },
                            {
                                y: '',
                                a: <?= $aprjuntotal ?>
                            },
                            {
                                y: '',
                                a: <?= $julseptotal ?>
                            },
                            {
                                y: '',
                                a: <?= $octdectotal ?>
                            }
                        ],
                        barColors: ['#da291c'],
                        xkey: 'y',
                        ykeys: ['a'],
                        labels: ['', ''],
                        hideHover: 'auto',
                        padding: 1,
                    });
                });
                </script>
            </td>
        </tr>
        <!--  <tr class="odd gradeX">
                                       <td></td>
                                       <td>
                                           <a id="janmarsave" class="btn btn-info btn-xs savebtnquarter" style="width:60px;">Save</a><br>
                                       </td>
                                       <td>
                                           <a id="aprjunsave" class="btn btn-info btn-xs savebtnquarter" style="width:60px;">Save</a><br>
                                       </td>
                                       <td>
                                           <a id="julsepsave" class="btn btn-info btn-xs savebtnquarter" style="width:60px;">Save</a><br>
                                       </td>
                                       <td>
                                           <a id="octdecsave" class="btn btn-info btn-xs savebtnquarter" style="width:60px;">Save</a><br>
                                       </td>
                                       <td></td>
                                       <td></td>

                                       </tr> -->
    </tbody>
</table>
<?php

        $html=ob_get_clean();
        echo $html;
}

public function tab3_quaterly_year(Request $request)
    {
        $year=$request->year;

        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner']=$aabanner = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners']=$top_banners = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime']=$slidetime = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmartotal']=$janmartotal = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('janmar');
        $data['aprjuntotal']=$aprjuntotal = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('aprjun');
        $data['julseptotal']=$julseptotal = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('julsep');
        $data['octdectotal']=$octdectotal = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('octdec');
        $data['monthtotal']=$monthtotal = $data['janmartotal'] + $data['aprjuntotal'] + $data['julseptotal'] + $data['octdectotal'];
        $data['janmargrosstotal2'] =$janmargrosstotal2= DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('janmar');
        $data['aprjungrosstotal2'] =$aprjungrosstotal2= DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('aprjun');
        $data['julsepgrosstotal2'] =$julsepgrosstotal2= DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('julsep');
        $data['octdecgrosstotal2'] =$octdecgrosstotal2= DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('octdec');
        $data['monthgrosstotal2'] =$monthgrosstotal2= $data['janmargrosstotal2'] + $data['aprjungrosstotal2'] + $data['julsepgrosstotal2'] + $data['octdecgrosstotal2'];
        $data['jangrossactual'] =$jangrossactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '01')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['febgrossactual'] =$febgrossactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '02')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['margrossactual'] =$margrossactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '03')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['aprgrossactual'] =$aprgrossactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '04')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['maygrossactual'] =$maygrossactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '05')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['jungrossactual'] =$jungrossactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '06')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['julgrossactual'] =$julgrossactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '07')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['auggrossactual'] =$auggrossactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '08')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['sepgrossactual'] =$sepgrossactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '09')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['octgrossactual']=$octgrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '10')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['novgrossactual']=$novgrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '11')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['decgrossactual']=$decgrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '12')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['janmargrossactual']=$janmargrossactual = $data['jangrossactual'] + $data['febgrossactual'] + $data['margrossactual'];
        $data['aprjungrossactual']=$aprjungrossactual = $data['aprgrossactual'] + $data['maygrossactual'] + $data['jungrossactual'];
        $data['julsepgrossactual']=$julsepgrossactual = $data['julgrossactual'] + $data['auggrossactual'] + $data['sepgrossactual'];
        $data['octdecgrossactual']=$octdecgrossactual = $data['octgrossactual'] + $data['novgrossactual'] + $data['decgrossactual'];
        $data['monthgrossactual']=$monthgrossactual = $data['janmargrossactual'] + $data['aprjungrossactual'] + $data['julsepgrossactual'] + $data['octdecgrossactual'];
        $data['jantotalactual'] =$jantotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '01')->sum('bill');
        $data['febtotalactual'] =$febtotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '02')->sum('bill');
        $data['martotalactual'] =$martotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '03')->sum('bill');
        $data['aprtotalactual'] =$aprtotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '04')->sum('bill');
        $data['maytotalactual'] =$maytotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '05')->sum('bill');
        $data['juntotalactual'] =$juntotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '06')->sum('bill');
        $data['jultotalactual'] =$jultotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '07')->sum('bill');
        $data['augtotalactual'] =$augtotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '08')->sum('bill');
        $data['septotalactual']=$septotalactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '09')->sum('bill');
        $data['octtotalactual']=$octtotalactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '10')->sum('bill');
        $data['novtotalactual']=$novtotalactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '11')->sum('bill');
        $data['dectotalactual']=$dectotalactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '12')->sum('bill');
        $data['janmartotalactual']=$janmartotalactual = $data['jantotalactual'] + $data['febtotalactual'] + $data['martotalactual'];
        $data['aprjuntotalactual']=$aprjuntotalactual = $data['aprtotalactual'] + $data['maytotalactual'] + $data['juntotalactual'];
        $data['julseptotalactual']=$julseptotalactual = $data['jultotalactual'] + $data['augtotalactual'] + $data['septotalactual'];
        $data['octdectotalactual']=$octdectotalactual = $data['octtotalactual'] + $data['novtotalactual'] + $data['dectotalactual'];
        $data['monthtotalactual']=$monthtotalactual = $data['janmartotalactual'] + $data['aprjuntotalactual'] + $data['julseptotalactual'] + $data['octdectotalactual'];
        $data['janmarothrevenue']=$janmarothrevenue = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('janmar');
        $data['aprjunothrevenue']=$aprjunothrevenue = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('aprjun');
        $data['julsepothrevenue']=$julsepothrevenue = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('julsep');
        $data['octdecothrevenue']=$octdecothrevenue = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('octdec');
        $data['monthothrevenue']=$monthothrevenue = $data['janmarothrevenue'] + $data['aprjunothrevenue'] + $data['julsepothrevenue'] + $data['octdecothrevenue'];
        $data['janotherrevenue']=$janotherrevenue = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '01')->where('account_description', 'Other Revenue')->sum('bill');
        $data['febotherrevenue']=$febotherrevenue = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '02')->where('account_description', 'Other Revenue')->sum('bill');
        $data['marotherrevenue']=$marotherrevenue = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '03')->where('account_description', 'Other Revenue')->sum('bill');
        $data['aprotherrevenue']=$aprotherrevenue = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '04')->where('account_description', 'Other Revenue')->sum('bill');
        $data['mayotherrevenue']=$mayotherrevenue = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '05')->where('account_description', 'Other Revenue')->sum('bill');
        $data['junotherrevenue']=$junotherrevenue = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '06')->where('account_description', 'Other Revenue')->sum('bill');
        $data['julotherrevenue']=$julotherrevenue = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '07')->where('account_description', 'Other Revenue')->sum('bill');
        $data['augotherrevenue']=$augotherrevenue = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '08')->where('account_description', 'Other Revenue')->sum('bill');
        $data['sepotherrevenue']=$sepotherrevenue = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '09')->where('account_description', 'Other Revenue')->sum('bill');
        $data['octotherrevenue']=$octotherrevenue = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '10')->where('account_description', 'Other Revenue')->sum('bill');
        $data['novotherrevenue']=$novotherrevenue = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '11')->where('account_description', 'Other Revenue')->sum('bill');
        $data['decotherrevenue']=$decotherrevenue = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '12')->where('account_description', 'Other Revenue')->sum('bill');
        $data['janmarotherrevenue']=$janmarotherrevenue = $data['janotherrevenue'] + $data['febotherrevenue'] + $data['marotherrevenue'];
        $data['aprjunotherrevenue']=$aprjunotherrevenue = $data['aprotherrevenue'] + $data['mayotherrevenue'] + $data['junotherrevenue'];
        $data['julsepotherrevenue']=$julsepotherrevenue = $data['julotherrevenue'] + $data['augotherrevenue'] + $data['sepotherrevenue'];
        $data['octdecotherrevenue']=$octdecotherrevenue = $data['octotherrevenue'] + $data['novotherrevenue'] + $data['decotherrevenue'];
        $data['monthotherrevenue']=$monthotherrevenue = $data['janmarotherrevenue'] + $data['aprjunotherrevenue'] + $data['julsepotherrevenue'] + $data['octdecotherrevenue'];
        $data['expense']=$expense = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->get();
        $data['janmartotal2']=$janmartotal2 = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('janmar');
        $data['aprjuntotal2']=$aprjuntotal2 = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('aprjun');
        $data['julseptotal2']=$julseptotal2 = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('julsep');
        $data['octdectotal2']=$octdectotal2 = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('octdec');
        $data['monthtotal2']=$monthtotal2 = $data['janmartotal2'] + $data['aprjuntotal2'] + $data['julseptotal2'] + $data['octdectotal2'];
        $data['jantotal2actual']=$jantotal2actual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '01')->sum('amount_paid');
        $data['febtotal2actual']=$febtotal2actual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '02')->sum('amount_paid');
        $data['martotal2actual']=$martotal2actual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '03')->sum('amount_paid');
        $data['aprtotal2actual']=$aprtotal2actual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '04')->sum('amount_paid');
        $data['maytotal2actual']=$maytotal2actual= DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '05')->sum('amount_paid');
        $data['juntotal2actual'] =$juntotal2actual= DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '06')->sum('amount_paid');
        $data['jultotal2actual'] =$jultotal2actual= DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '07')->sum('amount_paid');
        $data['augtotal2actual'] =$augtotal2actual= DB::table('expense_record')->where('uid',$uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '08')->sum('amount_paid');
        $data['septotal2actual'] =$septotal2actual= DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '09')->sum('amount_paid');
        $data['octtotal2actual'] =$octtotal2actual= DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date',$year)->whereMonth('transaction_date', '10')->sum('amount_paid');
        $data['novtotal2actual'] =$novtotal2actual= DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '11')->sum('amount_paid');
        $data['dectotal2actual'] =$dectotal2actual= DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '12')->sum('amount_paid');
        $data['janmartotal2actual'] =$janmartotal2actual= $data['jantotal2actual'] + $data['febtotal2actual'] + $data['martotal2actual'];
        $data['aprjuntotal2actual'] =$aprjuntotal2actual= $data['aprtotal2actual'] + $data['maytotal2actual'] + $data['juntotal2actual'];
        $data['julseptotal2actual'] =$julseptotal2actual= $data['jultotal2actual'] + $data['augtotal2actual'] + $data['septotal2actual'];
        $data['octdectotal2actual'] =$octdectotal2actual= $data['octtotal2actual'] + $data['novtotal2actual'] + $data['dectotal2actual'];
        $data['monthtotal2actual'] =$monthtotal2actual= $data['janmartotal2actual'] + $data['aprjuntotal2actual'] + $data['julseptotal2actual'] + $data['octdectotal2actual'];
        $data['chat']=$chat = "";
        $data['tools']=$tools = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        ob_start();
               ?>

<div class="table-wrap">
    <table class="table table-striped table-bordered table-hover main-table" id="">
        <thead>
            <tr class="top-tr">
                <th class="fixed-side"></th>
                <th colspan="3">Jan-Mar</th>
                <th colspan="3">Apr-Jun</th>
                <th colspan="3">Jul-Sep</th>
                <th colspan="3">Oct-Dec</th>
                <th colspan="3">Total</th>
                <th>Graph</th>
            </tr>
            <tr>
                <th class="fixed-side"></th>
                <th>Budget</th>
                <th>Actual</th>
                <th>Variance</th>
                <th>Budget</th>
                <th>Actual</th>
                <th>Variance</th>
                <th>Budget</th>
                <th>Actual</th>
                <th>Variance</th>
                <th>Budget</th>
                <th>Actual</th>
                <th>Variance</th>
                <th>Budget</th>
                <th>Actual</th>
                <th>Variance</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td class="fixed-side" style="text-align: left; color: #da291c;"><b>Revenue</b></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            <tr class="odd gradeX">
                <td class="fixed-side">Gross Revenue</td>
                <td><?= $janmargrosstotal2 ?></td>
                <td><?= $janmargrossactual ?></td>
                <td><?= ($janmargrosstotal2-$janmargrossactual) ?></td>
                <td><?= $aprjungrosstotal2 ?></td>
                <td><?= $aprjungrossactual ?></td>
                <td><?= ($aprjungrosstotal2-$aprjungrossactual) ?></td>
                <td><?= $julsepgrosstotal2 ?></td>
                <td><?= $julsepgrossactual ?></td>
                <td><?= ($julsepgrosstotal2-$julsepgrossactual) ?></td>
                <td><?= $octdecgrosstotal2 ?></td>
                <td><?= $octdecgrossactual ?></td>
                <td><?= ($octdecgrosstotal2-$octdecgrossactual) ?></td>
                <td><?= $monthgrosstotal2 ?></td>
                <td><?= $monthgrossactual ?></td>
                <td><?= ($monthgrosstotal2-$monthgrossactual) ?></td>
                <td>
                    <a href="<?php echo url('gross_quarter_revenue_chart') ?>"><i class="fa fa-bar-chart"></i></a>
                </td>
            </tr>
            <!-- .nk-tb-item  -->
            <tr class="odd gradeX">
                <td class="fixed-side">Other Revenue</td>
                <td><?= $janmarothrevenue ?></td>
                <td><?= $janmarotherrevenue ?></td>
                <td><?= ($janmarothrevenue-$janmarotherrevenue) ?></td>
                <td><?= $aprjunothrevenue ?></td>
                <td><?= $aprjunotherrevenue ?></td>
                <td><?= ($aprjunothrevenue-$aprjunotherrevenue) ?></td>
                <td><?= $julsepothrevenue ?></td>
                <td><?= $julsepotherrevenue ?></td>
                <td><?= ($julsepothrevenue-$julsepotherrevenue) ?></td>
                <td><?= $octdecothrevenue ?></td>
                <td><?= $octdecotherrevenue ?></td>
                <td><?= ($octdecothrevenue-$octdecotherrevenue) ?></td>
                <td><?= $monthothrevenue ?></td>
                <td><?= $monthotherrevenue ?></td>
                <td><?= ($monthothrevenue-$monthotherrevenue) ?></td>
                <td>
                    <a href="<?php echo url('other_quarter_revenue_chart') ?>"><i class="fa fa-bar-chart"></i></a>
                </td>
            </tr>
            <!-- .nk-tb-item  -->
            <tr class="total-tr">
                <td class="fixed-side" style=""><b>Total Revenue</b></td>
                <td><?= $janmartotal ?></td>
                <td><?= $janmartotalactual ?></td>
                <td><?= ($janmartotal-$janmartotalactual) ?></td>
                <td><?= $aprjuntotal ?></td>
                <td><?= $aprjuntotalactual ?></td>
                <td><?= ($aprjuntotal-$aprjuntotalactual) ?></td>
                <td><?= $julseptotal ?></td>
                <td><?= $julseptotalactual ?></td>
                <td><?= ($julseptotal-$julseptotalactual) ?></td>
                <td><?= $octdectotal ?></td>
                <td><?= $octdectotalactual ?></td>
                <td><?= ($octdectotal-$octdectotalactual) ?></td>
                <td><?= $monthtotal ?></td>
                <td><?= $monthtotalactual ?></td>
                <td><?= ($monthtotal-$monthtotalactual) ?></td>
                <td>
                    <a href="<?php echo url('all_quarter_revenue_chart') ?>"><i class="fa fa-bar-chart"></i></a>
                </td>
            </tr>
            <!-- .nk-tb-item  -->

            <tr>
                <td class="fixed-side" style="text-align: left; color: #da291c;"><b>Expenses</b></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            <?php
                                                        foreach($expense as $value){
                                                        ?>
            <tr class="odd gradeX">
                <td class="fixed-side"><?= $value->name ?></td>
                <td><?= $value->janmar ?></td>
                <td><?php echo $actual_janmar =HomeController::getjanmaractualexp($value->name); ?></td>
                <td><?= ($value->janmar - $actual_janmar) ?></td>
                <td><?= $value->aprjun ?></td>
                <td><?php echo $actual_aprjun = HomeController::getaprjunactualexp($value->name); ?></td>
                <td><?= ($value->aprjun - $actual_aprjun) ?></td>
                <td><?= $value->julsep ?></td>
                <td><?php echo $actual_julsep = HomeController::getjulsepactualexp($value->name); ?></td>
                <td><?= ($value->julsep - $actual_julsep) ?></td>
                <td><?= $value->octdec ?></td>
                <td><?php echo $actual_octdec = HomeController::getoctdecactualexp($value->name); ?></td>
                <td><?= ($value->octdec - $actual_octdec) ?></td>

                <td> <?= $tot = ($value->janmar + $value->aprjun + $value->julsep + $value->octdec) ?></td>
                <td><?php echo $actual_total2 = HomeController::gettotalactualexp($value->name); ?></td>
                <td><?= ($tot-$actual_total2) ?></td>
                <td>
                    <a href="<?php echo url('expense_variance_quarterly_graph') ."/".$value->name ?>"><i
                            class="fa fa-bar-chart"></i></a>
                </td>
            </tr>
            <?php } ?>
            <tr class="total2-tr">
                <td class="fixed-side" style=""><b>Total Expenses</b></td>
                <td><?= $janmartotal2 ?></td>
                <td><?= $janmartotal2actual ?></td>
                <td><?= ($janmartotal2-$janmartotal2actual) ?></td>
                <td><?= $aprjuntotal2 ?></td>
                <td><?= $aprjuntotal2actual ?></td>
                <td><?= ($aprjuntotal2-$aprjuntotal2actual) ?></td>
                <td><?= $julseptotal2 ?></td>
                <td><?= $julseptotal2actual ?></td>
                <td><?= ($julseptotal2-$julseptotal2actual) ?></td>
                <td><?= $octdectotal2 ?></td>
                <td><?= $octdectotal2actual ?></td>
                <td><?= ($octdectotal2-$octdectotal2actual) ?></td>
                <td><?= $tott = ($janmartotal2 + $aprjuntotal2 + $julseptotal2 + $octdectotal2) ?></td>
                <td><?= $tott2 = ($janmartotal2actual + $aprjuntotal2actual + $julseptotal2actual + $octdectotal2actual) ?>
                </td>
                <td><?= ($tott - $tott2) ?></td>
                <td>
                    <a href="<?php echo  url('expense_quarterly_vary_chart') ?>"><i class="fa fa-bar-chart"></i></a>
                </td>
            </tr>
        </tbody>

        <tbody></tbody>
        <tfoot>
            <tr>
                <td class="fixed-side" style="text-align: left;"><b>Estimated Profit & Loss</b></td>
                <td><?= ($janmartotal-$janmartotal2) ?></td>
                <td><?= ($janmartotalactual-$janmartotal2actual) ?></td>
                <td><?= (($janmartotal-$janmartotal2)-($janmartotalactual-$janmartotal2actual)) ?></td>
                <td><?= ($aprjuntotal-$aprjuntotal2) ?></td>
                <td><?= ($aprjuntotalactual-$aprjuntotal2actual) ?></td>
                <td><?= (($aprjuntotal-$aprjuntotal2)-($aprjuntotalactual-$aprjuntotal2actual)) ?></td>
                <td><?= ($julseptotal-$julseptotal2) ?></td>
                <td><?= ($julseptotalactual-$julseptotal2actual) ?></td>
                <td><?= (($julseptotal-$julseptotal2)-($julseptotalactual-$julseptotal2actual)) ?></td>
                <td><?= ($octdectotal-$octdectotal2) ?></td>
                <td><?= ($octdectotalactual-$octdectotal2actual) ?></td>
                <td><?= (($octdectotal-$octdectotal2)-($octdectotalactual-$octdectotal2actual)) ?></td>
                <td><?= ($monthtotal-$tott) ?></td>
                <td><?= ($monthtotalactual-$tott2) ?></td>
                <td><?= (($monthtotal-$tott)-($monthtotalactual-$tott2)) ?></td>
                <td>
                    <!-- <a href="#"><i class="fa fa-bar-chart"></i></a> -->
                </td>
            </tr>
            <!-- .nk-tb-item  -->
        </tfoot>
    </table>
</div>
</div>
</div>
</div>

<div class="tab-pane fade" id="tab32">
    <div class="">
        <div id="" class="table-scroll">
            <div class="table-wrap">
                <table class="table table-striped table-bordered table-hover" id="">
                    <thead>
                        <tr class="top-tr">
                            <th class="fixed-side"></th>
                            <th colspan="3">Jan - Mar</th>
                            <th colspan="3">Apr - Jun</th>
                            <th colspan="3">Jul - Sep</th>
                            <th colspan="3">Oct - Dec</th>
                            <th colspan="3">Total</th>
                            <th>Graph</th>
                        </tr>
                        <tr>
                            <th class="fixed-side"></th>
                            <th>Budget</th>
                            <th>Actual</th>
                            <th>Variance</th>
                            <th>Budget</th>
                            <th>Actual</th>
                            <th>Variance</th>
                            <th>Budget</th>
                            <th>Actual</th>
                            <th>Variance</th>
                            <th>Budget</th>
                            <th>Actual</th>
                            <th>Variance</th>
                            <th>Budget</th>
                            <th>Actual</th>
                            <th>Variance</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="fixed-side" style="text-align: left; color: #da291c;"><b>Revenue</b></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr class="odd gradeX">
                            <td class="fixed-side">Gross Revenue</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>
                                <a href="#"><i class="fa fa-bar-chart"></i></a>
                            </td>
                        </tr>
                        <!-- .nk-tb-item  -->
                        <tr class="odd gradeX">
                            <td class="fixed-side">Other Revenue</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>
                                <a href="#"><i class="fa fa-bar-chart"></i></a>
                            </td>
                        </tr>
                        <!-- .nk-tb-item  -->
                        <tr class="total-tr">
                            <td class="fixed-side" style=""><b>Total Revenue</b></td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>
                                <a href="#"><i class="fa fa-bar-chart"></i></a>
                            </td>
                        </tr>
                        <!-- .nk-tb-item  -->

                        <tr>
                            <td class="fixed-side" style="text-align: left; color: #da291c;"><b>Expenses</b></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr class="odd gradeX">
                            <td class="fixed-side">Phone</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>
                                <a href="#"><i class="fa fa-bar-chart"></i></a>
                            </td>
                        </tr>
                        <!-- .nk-tb-item  -->
                        <tr class="odd gradeX">
                            <td class="fixed-side">Electricity</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>
                                <a href="#"><i class="fa fa-bar-chart"></i></a>
                            </td>
                        </tr>
                        <!-- .nk-tb-item  -->
                        <tr class="odd gradeX">
                            <td class="fixed-side">Credit Card</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>
                                <a href="#"><i class="fa fa-bar-chart"></i></a>
                            </td>
                        </tr>
                        <!-- .nk-tb-item  -->
                        <tr class="odd gradeX">
                            <td class="fixed-side">Fuel</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>
                                <a href="#"><i class="fa fa-bar-chart"></i></a>
                            </td>
                        </tr>
                        <!-- .nk-tb-item  -->
                        <tr class="odd gradeX">
                            <td class="fixed-side">Materials & Supplies</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>
                                <a href="#"><i class="fa fa-bar-chart"></i></a>
                            </td>
                        </tr>
                        <!-- .nk-tb-item  -->
                        <tr class="odd gradeX">
                            <td class="fixed-side">Oil Purchase</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>
                                <a href="#"><i class="fa fa-bar-chart"></i></a>
                            </td>
                        </tr>
                        <!-- .nk-tb-item  -->
                        <tr class="odd gradeX">
                            <td class="fixed-side">Car Maintenance</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>
                                <a href="#"><i class="fa fa-bar-chart"></i></a>
                            </td>
                        </tr>
                        <!-- .nk-tb-item  -->
                        <tr class="total-tr">
                            <td class="fixed-side"><b>Total Expenses</b></td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>
                                <a href="#"><i class="fa fa-bar-chart"></i></a>
                            </td>
                        </tr>
                        <!-- .nk-tb-item  -->
                    </tbody>
                    <tfoot>
                        <tr>
                            <td class="fixed-side" style="text-align: left;"><b>Estimated Profit & Loss</b></td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>
                                <a href="#"><i class="fa fa-bar-chart"></i></a>
                            </td>
                        </tr>
                        <!-- .nk-tb-item  -->
                    </tfoot>
                </table>
            </div>

            <?php

        $html=ob_get_clean();
        echo $html;
    }



public function tab3_year(Request $request)
    {
        $year=$request->year;

        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status']=$status = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links']=$links = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos']=$top_videos = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner']=$aabanner = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners']=$top_banners = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime']=$slidetime = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['jantotal']=$jantotal = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('jan');
        $data['febtotal']=$febtotal = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('feb');
        $data['martotal']=$martotal = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('mar');
        $data['aprtotal']=$aprtotal = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('apr');
        $data['maytotal']=$maytotal = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('may');
        $data['juntotal']=$juntotal = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('jun');
        $data['jultotal']=$jultotal = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('jul');
        $data['augtotal']=$augtotal = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('aug');
        $data['septotal']=$septotal = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('sep');
        $data['octtotal']=$octtotal = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('oct');
        $data['novtotal']=$novtotal = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('nov');
        $data['dectotal']=$dectotal = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('decem');
        $data['monthtotal']=$monthtotal = $data['jantotal'] + $data['febtotal'] + $data['martotal'] + $data['aprtotal'] + $data['maytotal'] + $data['juntotal'] + $data['jultotal'] + $data['augtotal'] + $data['septotal'] + $data['octtotal'] + $data['novtotal'] + $data['dectotal'];
        $data['jangrosstotal2']=$jangrosstotal2 = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('jan');
        $data['febgrosstotal2']=$febgrosstotal2 = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('feb');
        $data['margrosstotal2']=$margrosstotal2 = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('mar');
        $data['aprgrosstotal2']=$aprgrosstotal2 = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('apr');
        $data['maygrosstotal2']=$maygrosstotal2 = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('may');
        $data['jungrosstotal2']=$jungrosstotal2 = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('jun');
        $data['julgrosstotal2']=$julgrosstotal2 = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('jul');
        $data['auggrosstotal2']=$auggrosstotal2 = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('aug');
        $data['sepgrosstotal2']=$sepgrosstotal2 = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('sep');
        $data['octgrosstotal2']=$octgrosstotal2 = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('oct');
        $data['novgrosstotal2']=$novgrosstotal2 = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('nov');
        $data['decgrosstotal2']=$decgrosstotal2 = DB::table('revenue_budget')->where('uid',$uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('decem');
        $data['monthgrosstotal2']=$monthgrosstotal2 = $data['jangrosstotal2'] + $data['febgrosstotal2'] + $data['margrosstotal2'] + $data['aprgrosstotal2'] + $data['maygrosstotal2'] + $data['jungrosstotal2'] + $data['julgrosstotal2'] + $data['auggrosstotal2'] + $data['sepgrosstotal2'] + $data['octgrosstotal2'] + $data['novgrosstotal2'] + $data['decgrosstotal2'];
        $data['jangrossactual']=$jangrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '01')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['febgrossactual']=$febgrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date',$year)->whereMonth('transaction_date', '02')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['margrossactual']=$margrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date',$year)->whereMonth('transaction_date', '04')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['aprgrossactual'] =$aprgrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date',$year)->whereMonth('transaction_date', '04')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['maygrossactual']=$maygrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '05')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['jungrossactual']=$jungrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '06')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['julgrossactual']=$julgrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '07')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['auggrossactual']=$auggrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '08')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['sepgrossactual']=$sepgrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '09')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['octgrossactual']=$octgrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '10')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['novgrossactual']=$novgrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '11')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['decgrossactual']=$decgrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '12')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['monthgrossactual']=$monthgrossactual = $data['jangrossactual'] + $data['febgrossactual'] + $data['margrossactual'] + $data['aprgrossactual'] + $data['maygrossactual'] + $data['jungrossactual'] + $data['julgrossactual'] + $data['auggrossactual'] + $data['sepgrossactual'] + $data['octgrossactual'] + $data['novgrossactual'] + $data['decgrossactual'];
        $data['jantotalactual']=$jantotalactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '01')->sum('bill');
        $data['febtotalactual']=$febtotalactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '02')->sum('bill');
        $data['martotalactual']=$martotalactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '03')->sum('bill');
        $data['aprtotalactual']=$aprtotalactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '04')->sum('bill');
        $data['maytotalactual']=$maytotalactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '05')->sum('bill');
        $data['juntotalactual']=$juntotalactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date',$year)->whereMonth('transaction_date', '06')->sum('bill');
        $data['jultotalactual']=$jultotalactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '07')->sum('bill');
        $data['augtotalactual'] =$augtotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '08')->sum('bill');
        $data['septotalactual'] =$septotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '09')->sum('bill');
        $data['octtotalactual'] =$octtotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '10')->sum('bill');
        $data['novtotalactual'] =$novtotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '11')->sum('bill');
        $data['dectotalactual'] =$dectotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '12')->sum('bill');
        $data['monthtotalactual'] =$monthtotalactual= $data['jantotalactual'] + $data['febtotalactual'] + $data['martotalactual'] + $data['aprtotalactual'] + $data['maytotalactual'] + $data['juntotalactual'] + $data['jultotalactual'] + $data['augtotalactual'] + $data['septotalactual'] + $data['octtotalactual'] + $data['novtotalactual'] + $data['dectotalactual'];
        $data['janothrevenue'] =$janothrevenue= DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('jan');
        $data['febothrevenue'] =$febothrevenue= DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('feb');
        $data['marothrevenue']=$marothrevenue = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at',$year)->where('name', '==', 'Other Revenue')->sum('mar');
        $data['aprothrevenue']=$aprothrevenue = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('apr');
        $data['mayothrevenue']=$mayothrevenue = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('may');
        $data['junothrevenue']=$junothrevenue = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('jun');
        $data['julothrevenue']=$julothrevenue = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('jul');
        $data['augothrevenue']=$augothrevenue = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('aug');
        $data['sepothrevenue']=$sepothrevenue = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('sep');
        $data['octothrevenue']=$octothrevenue = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('oct');
        $data['novothrevenue']=$novothrevenue = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('nov');
        $data['decothrevenue']=$decothrevenue = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('decem');
        $data['monthothrevenue']=$monthothrevenue = $data['janothrevenue'] + $data['febothrevenue'] + $data['marothrevenue'] + $data['aprothrevenue'] + $data['mayothrevenue'] + $data['junothrevenue'] + $data['julothrevenue'] + $data['augothrevenue'] + $data['sepothrevenue'] + $data['octothrevenue'] + $data['novothrevenue'] + $data['decothrevenue'];
        $data['janotherrevenue']=$janotherrevenue = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '01')->where('account_description', 'Other Revenue')->sum('bill');
        $data['febotherrevenue']=$febotherrevenue = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '02')->where('account_description', 'Other Revenue')->sum('bill');
        $data['marotherrevenue'] =$marotherrevenue= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date',$year)->whereMonth('transaction_date', '03')->where('account_description', 'Other Revenue')->sum('bill');
        $data['aprotherrevenue'] =$aprotherrevenue= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '04')->where('account_description', 'Other Revenue')->sum('bill');
        $data['mayotherrevenue'] =$mayotherrevenue= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '05')->where('account_description', 'Other Revenue')->sum('bill');
        $data['junotherrevenue'] =$junotherrevenue= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '06')->where('account_description', 'Other Revenue')->sum('bill');
        $data['julotherrevenue'] =$julotherrevenue= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date',$year)->whereMonth('transaction_date', '07')->where('account_description', 'Other Revenue')->sum('bill');
        $data['augotherrevenue'] =$augotherrevenue= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date',$year)->whereMonth('transaction_date', '08')->where('account_description', 'Other Revenue')->sum('bill');
        $data['sepotherrevenue'] =$sepotherrevenue= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date',$year)->whereMonth('transaction_date', '09')->where('account_description', 'Other Revenue')->sum('bill');
        $data['octotherrevenue'] =$octotherrevenue= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '10')->where('account_description', 'Other Revenue')->sum('bill');
        $data['novotherrevenue']=$novotherrevenue = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '11')->where('account_description', 'Other Revenue')->sum('bill');
        $data['decotherrevenue']=$decotherrevenue = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '12')->where('account_description', 'Other Revenue')->sum('bill');
        $data['monthotherrevenue']=$monthotherrevenue = $data['janotherrevenue'] + $data['febotherrevenue'] + $data['marotherrevenue'] + $data['aprotherrevenue'] + $data['mayotherrevenue'] + $data['junotherrevenue'] + $data['julotherrevenue'] + $data['augotherrevenue'] + $data['sepotherrevenue'] + $data['octotherrevenue'] + $data['novotherrevenue'] + $data['decotherrevenue'];
        $data['expense']=$expense = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at',$year)->get();
        $data['jantotal2']=$jantotal2 = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at',$year)->sum('jan');
        $data['febtotal2']=$febtotal2 = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('feb');
        $data['martotal2']=$martotal2 = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('mar');
        $data['aprtotal2']=$aprtotal2 = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('apr');
        $data['maytotal2']=$maytotal2 = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('may');
        $data['juntotal2']=$juntotal2 = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('jun');
        $data['jultotal2']=$jultotal2 = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('jul');
        $data['augtotal2']=$augtotal2 = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('aug');
        $data['septotal2']=$septotal2 = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('sep');
        $data['octtotal2']=$octtotal2 = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at',$year)->sum('oct');
        $data['novtotal2']=$novtotal2 = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('nov');
        $data['dectotal2']=$dectotal2 = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at',$year)->sum('decem');
        $data['monthtotal2']=$monthtotal2 = $data['jantotal2'] + $data['febtotal2'] + $data['martotal2'] + $data['aprtotal2'] + $data['maytotal2'] + $data['juntotal2'] + $data['jultotal2'] + $data['augtotal2'] + $data['septotal2'] + $data['octtotal2'] + $data['novtotal2'] + $data['dectotal2'];
        $data['jantotal2actual']=$jantotal2actual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '01')->sum('amount_paid');
        $data['febtotal2actual']=$febtotal2actual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '02')->sum('amount_paid');
        $data['martotal2actual']=$martotal2actual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '03')->sum('amount_paid');
        $data['aprtotal2actual']=$aprtotal2actual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '04')->sum('amount_paid');
        $data['maytotal2actual']=$maytotal2actual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '05')->sum('amount_paid');
        $data['juntotal2actual']=$juntotal2actual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '06')->sum('amount_paid');
        $data['jultotal2actual']=$jultotal2actual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '07')->sum('amount_paid');
        $data['augtotal2actual']=$augtotal2actual = DB::table('expense_record')->where('uid',$uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '08')->sum('amount_paid');
        $data['septotal2actual']=$septotal2actual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '09')->sum('amount_paid');
        $data['octtotal2actual']=$octtotal2actual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '10')->sum('amount_paid');
        $data['novtotal2actual']=$novtotal2actual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '11')->sum('amount_paid');
        $data['dectotal2actual']=$dectotal2actual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '12')->sum('amount_paid');
        $data['monthtotal2actual']=$monthtotal2actual = $data['jantotal2actual'] + $data['febtotal2actual'] + $data['martotal2actual'] + $data['aprtotal2actual'] + $data['maytotal2actual'] + $data['juntotal2actual'] + $data['jultotal2actual'] + $data['augtotal2actual'] + $data['septotal2actual'] + $data['octtotal2actual'] + $data['novtotal2actual'] + $data['dectotal2actual'];
        $data['chat']=$chat = "";
        $data['tools']=$tools = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }

        ob_start();
               ?>
            <div class="table-wrap">
                <table class="table table-striped table-bordered table-hover main-table" id="">
                    <thead>
                        <tr class="top-tr">
                            <th class="fixed-side"></th>
                            <th colspan="3">Jan</th>
                            <th colspan="3">Feb</th>
                            <th colspan="3">Mar</th>
                            <th colspan="3">Apr</th>
                            <th colspan="3">May</th>
                            <th colspan="3">Jun</th>
                            <th colspan="3">Jul</th>
                            <th colspan="3">Aug</th>
                            <th colspan="3">Sep</th>
                            <th colspan="3">Oct</th>
                            <th colspan="3">Nov</th>
                            <th colspan="3">Dec</th>
                            <th colspan="3">Total</th>
                            <th>Graph</th>
                        </tr>
                        <tr>
                            <th class="fixed-side"></th>
                            <th>Budget</th>
                            <th>Actual</th>
                            <th>Variance</th>
                            <th>Budget</th>
                            <th>Actual</th>
                            <th>Variance</th>
                            <th>Budget</th>
                            <th>Actual</th>
                            <th>Variance</th>
                            <th>Budget</th>
                            <th>Actual</th>
                            <th>Variance</th>
                            <th>Budget</th>
                            <th>Actual</th>
                            <th>Variance</th>
                            <th>Budget</th>
                            <th>Actual</th>
                            <th>Variance</th>
                            <th>Budget</th>
                            <th>Actual</th>
                            <th>Variance</th>
                            <th>Budget</th>
                            <th>Actual</th>
                            <th>Variance</th>
                            <th>Budget</th>
                            <th>Actual</th>
                            <th>Variance</th>
                            <th>Budget</th>
                            <th>Actual</th>
                            <th>Variance</th>
                            <th>Budget</th>
                            <th>Actual</th>
                            <th>Variance</th>
                            <th>Budget</th>
                            <th>Actual</th>
                            <th>Variance</th>
                            <th>Budget</th>
                            <th>Actual</th>
                            <th>Variance</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="fixed-side" style="text-align: left; color: #da291c;"><b>Revenue</b></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr class="odd gradeX">
                            <td class="fixed-side">Gross Revenue</td>
                            <td><?= $jangrosstotal2 ?></td>
                            <td><?= $jangrossactual ?></td>
                            <td><?= ($jangrosstotal2-$jangrossactual) ?></td>
                            <td><?= $febgrosstotal2 ?></td>
                            <td><?= $febgrossactual ?></td>
                            <td><?= ($febgrosstotal2-$febgrossactual) ?></td>
                            <td><?= $margrosstotal2 ?></td>
                            <td><?= $margrossactual ?></td>
                            <td><?= ($margrosstotal2-$margrossactual) ?></td>
                            <td><?= $aprgrosstotal2 ?></td>
                            <td><?= $aprgrossactual ?></td>
                            <td><?= ($aprgrosstotal2-$aprgrossactual) ?></td>
                            <td><?= $maygrosstotal2 ?></td>
                            <td><?= $maygrossactual ?></td>
                            <td><?= ($maygrosstotal2-$maygrossactual) ?></td>
                            <td><?= $jungrosstotal2 ?></td>
                            <td><?= $jungrossactual ?></td>
                            <td><?= ($jungrosstotal2-$jungrossactual) ?></td>
                            <td><?= $julgrosstotal2 ?></td>
                            <td><?= $julgrossactual ?></td>
                            <td><?= ($julgrosstotal2-$julgrossactual) ?></td>
                            <td><?= $auggrosstotal2 ?></td>
                            <td><?= $auggrossactual ?></td>
                            <td><?= ($auggrosstotal2-$auggrossactual) ?></td>
                            <td><?= $sepgrosstotal2 ?></td>
                            <td><?= $sepgrossactual ?></td>
                            <td><?= ($sepgrosstotal2-$sepgrossactual) ?></td>
                            <td><?= $octgrosstotal2 ?></td>
                            <td><?= $octgrossactual ?></td>
                            <td><?= ($octgrosstotal2-$octgrossactual) ?></td>
                            <td><?= $novgrosstotal2 ?></td>
                            <td><?= $novgrossactual ?></td>
                            <td><?= ($novgrosstotal2-$novgrossactual) ?></td>
                            <td><?= $decgrosstotal2 ?></td>
                            <td><?= $decgrossactual ?></td>
                            <td><?= ($decgrosstotal2-$decgrossactual) ?></td>
                            <td><?= $monthgrosstotal2 ?></td>
                            <td><?= $monthgrossactual ?></td>
                            <td><?= ($monthgrosstotal2-$monthgrossactual) ?></td>
                            <td>
                                <a href="<?php echo url('gross_revenue_chart') ?>"><i class="fa fa-bar-chart"></i></a>
                            </td>
                        </tr>
                        <!-- .nk-tb-item  -->
                        <tr class="odd gradeX">
                            <td class="fixed-side">Other Revenue</td>
                            <td><?= $janothrevenue ?></td>
                            <td><?= $janotherrevenue ?></td>
                            <td><?= ($janothrevenue-$janotherrevenue) ?></td>
                            <td><?= $febothrevenue ?></td>
                            <td><?= $febotherrevenue ?></td>
                            <td><?= ($febothrevenue-$febotherrevenue) ?></td>
                            <td><?= $marothrevenue ?></td>
                            <td><?= $marotherrevenue ?></td>
                            <td><?= ($marothrevenue-$marotherrevenue) ?></td>
                            <td><?= $aprothrevenue ?></td>
                            <td><?= $aprotherrevenue ?></td>
                            <td><?= ($aprothrevenue-$aprotherrevenue) ?></td>
                            <td><?= $mayothrevenue ?></td>
                            <td><?= $mayotherrevenue ?></td>
                            <td><?= ($mayothrevenue-$mayotherrevenue) ?></td>
                            <td><?= $junothrevenue ?></td>
                            <td><?= $junotherrevenue ?></td>
                            <td><?= ($junothrevenue-$junotherrevenue) ?></td>
                            <td><?= $julothrevenue ?></td>
                            <td><?= $julotherrevenue ?></td>
                            <td><?= ($julothrevenue-$julotherrevenue) ?></td>
                            <td><?= $augothrevenue ?></td>
                            <td><?= $augotherrevenue ?></td>
                            <td><?= ($augothrevenue-$augotherrevenue) ?></td>
                            <td><?= $sepothrevenue ?></td>
                            <td><?= $sepotherrevenue ?></td>
                            <td><?= ($sepothrevenue-$sepotherrevenue) ?></td>
                            <td><?= $octothrevenue ?></td>
                            <td><?= $octotherrevenue ?></td>
                            <td><?= ($octothrevenue-$octotherrevenue) ?></td>
                            <td><?= $novothrevenue ?></td>
                            <td><?= $novotherrevenue ?></td>
                            <td><?= ($novothrevenue-$novotherrevenue) ?></td>
                            <td><?= $decothrevenue ?></td>
                            <td><?= $decotherrevenue ?></td>
                            <td><?= ($decothrevenue-$decotherrevenue) ?></td>
                            <td><?= $monthothrevenue ?></td>
                            <td><?= $monthotherrevenue ?></td>
                            <td><?= ($monthothrevenue-$monthotherrevenue) ?></td>
                            <td>
                                <a href="<?php echo url('other_revenue_chart') ?>"><i class="fa fa-bar-chart"></i></a>
                            </td>
                        </tr>
                        <!-- .nk-tb-item  -->
                        <tr class="total-tr">
                            <td class="fixed-side" style=""><b>Total Revenue</b></td>
                            <td><?= $jantotal ?></td>
                            <td><?= $jantotalactual ?></td>
                            <td><?= ($jantotal-$jantotalactual) ?></td>
                            <td><?= $febtotal ?></td>
                            <td><?= $febtotalactual ?></td>
                            <td><?= ($febtotal-$febtotalactual) ?></td>
                            <td><?= $martotal ?></td>
                            <td><?= $martotalactual ?></td>
                            <td><?= ($martotal-$martotalactual) ?></td>
                            <td><?= $aprtotal ?></td>
                            <td><?= $aprtotalactual ?></td>
                            <td><?= ($aprtotal-$aprtotalactual) ?></td>
                            <td><?= $maytotal ?></td>
                            <td><?= $maytotalactual ?></td>
                            <td><?= ($maytotal-$maytotalactual) ?></td>
                            <td><?= $juntotal ?></td>
                            <td><?= $juntotalactual ?></td>
                            <td><?= ($juntotal-$juntotalactual) ?></td>
                            <td><?= $jultotal ?></td>
                            <td><?= $jultotalactual ?></td>
                            <td><?= ($jultotal-$jultotalactual) ?></td>
                            <td><?= $augtotal ?></td>
                            <td><?= $augtotalactual ?></td>
                            <td><?= ($augtotal-$augtotalactual) ?></td>
                            <td><?= $septotal ?></td>
                            <td><?= $septotalactual ?></td>
                            <td><?= ($septotal-$septotalactual) ?></td>
                            <td><?= $octtotal ?></td>
                            <td><?= $octtotalactual ?></td>
                            <td><?= ($octtotal-$octtotalactual) ?></td>
                            <td><?= $novtotal ?></td>
                            <td><?= $novtotalactual ?></td>
                            <td><?= ($novtotal-$novtotalactual) ?></td>
                            <td><?= $dectotal ?></td>
                            <td><?= $dectotalactual ?></td>
                            <td><?= ($dectotal-$dectotalactual) ?></td>
                            <td><?= $monthtotal ?></td>
                            <td><?= $monthtotalactual ?></td>
                            <td><?= ($monthtotal-$monthtotalactual) ?></td>
                            <td>
                                <a href="<?php echo url('all_revenue_chart') ?>"><i class="fa fa-bar-chart"></i></a>
                            </td>
                        </tr>
                        <!-- .nk-tb-item  -->

                        <tr>
                            <td class="fixed-side" style="text-align: left; color: #da291c;"><b>Expenses</b></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <?php
                                                        foreach($expense as $value){
                                                        ?>
                        <tr class="odd gradeX">
                            <td class="fixed-side"><?= $value->name ?></td>
                            <td><?= $value->jan ?></td>
                            <td><?php echo $actual_jan = HomeController::getjanactualexp($value->name); ?></td>
                            <td><?= ($value->jan - $actual_jan) ?></td>
                            <td><?= $value->feb ?></td>
                            <td><?php echo $actual_feb = HomeController::getfebactualexp($value->name); ?></td>
                            <td><?= ($value->feb - $actual_feb) ?></td>
                            <td><?= $value->mar ?></td>
                            <td><?php echo $actual_mar = HomeController::getmaractualexp($value->name); ?></td>
                            <td><?= ($value->mar - $actual_mar) ?></td>
                            <td><?= $value->apr ?></td>
                            <td><?php echo $actual_apr = HomeController::getapractualexp($value->name); ?></td>
                            <td><?= ($value->apr - $actual_apr) ?></td>
                            <td><?= $value->may ?></td>
                            <td><?php echo $actual_may = HomeController::getmayactualexp($value->name); ?></td>
                            <td><?= ($value->may - $actual_may) ?></td>
                            <td><?= $value->jun ?></td>
                            <td><?php echo $actual_jun = HomeController::getjunactualexp($value->name); ?></td>
                            <td><?= ($value->jun - $actual_jun) ?></td>
                            <td><?= $value->jul ?></td>
                            <td><?php echo $actual_jul = HomeController::getjulactualexp($value->name); ?></td>
                            <td><?= ($value->jul - $actual_jul) ?></td>
                            <td><?= $value->aug ?></td>
                            <td><?php echo $actual_aug = HomeController::getaugactualexp($value->name); ?></td>
                            <td><?= ($value->aug - $actual_aug) ?></td>
                            <td><?= $value->sep ?></td>
                            <td><?php echo $actual_sep = HomeController::getsepactualexp($value->name); ?></td>
                            <td><?= ($value->sep - $actual_sep) ?></td>
                            <td><?= $value->oct ?></td>
                            <td><?php echo $actual_oct = HomeController::getoctactualexp($value->name); ?></td>
                            <td><?= ($value->oct - $actual_oct) ?></td>
                            <td><?= $value->nov ?></td>
                            <td><?php echo $actual_nov = HomeController::getnovactualexp($value->name); ?></td>
                            <td><?= ($value->nov - $actual_nov) ?></td>
                            <td><?= $value->decem ?></td>
                            <td><?php echo $actual_decem = HomeController::getdecemactualexp($value->name); ?></td>
                            <td><?= ($value->decem - $actual_decem) ?></td>
                            <td> <?= $tot = ($value->jan + $value->feb + $value->mar + $value->apr + $value->may + $value->jun + $value->jul + $value->aug + $value->sep + $value->oct + $value->nov + $value->decem) ?>
                            </td>
                            <td><?php echo $actual_total2 = HomeController::gettotalactualexp($value->name); ?></td>
                            <td><?= ($tot-$actual_total2) ?></td>
                            <td>
                                <a href="<?php echo  url('expense_variance_monthly_graph')."/". $value->name ?>"><i
                                        class="fa fa-bar-chart"></i></a>
                            </td>
                        </tr>
                        <?php } ?>
                        <tr class="total2-tr">
                            <td class="fixed-side" style=""><b>Total Expenses</b></td>
                            <td><?= $jantotal2 ?></td>
                            <td><?= $jantotal2actual ?></td>
                            <td><?= ($jantotal2-$jantotal2actual) ?></td>
                            <td><?= $febtotal2 ?></td>
                            <td><?= $febtotal2actual ?></td>
                            <td><?= ($febtotal2-$febtotal2actual) ?></td>
                            <td><?= $martotal2 ?></td>
                            <td><?= $martotal2actual ?></td>
                            <td><?= ($martotal2-$martotal2actual) ?></td>
                            <td><?= $aprtotal2 ?></td>
                            <td><?= $aprtotal2actual ?></td>
                            <td><?= ($aprtotal2-$aprtotal2actual) ?></td>
                            <td><?= $maytotal2 ?></td>
                            <td><?= $maytotal2actual ?></td>
                            <td><?= ($maytotal2-$maytotal2actual) ?></td>
                            <td><?= $juntotal2 ?></td>
                            <td><?= $juntotal2actual ?></td>
                            <td><?= ($juntotal2-$juntotal2actual) ?></td>
                            <td><?= $jultotal2 ?></td>
                            <td><?= $jultotal2actual ?></td>
                            <td><?= ($jultotal2-$jultotal2actual) ?></td>
                            <td><?= $augtotal2 ?></td>
                            <td><?= $augtotal2actual ?></td>
                            <td><?= ($augtotal2-$augtotal2actual) ?></td>
                            <td><?= $septotal2 ?></td>
                            <td><?= $septotal2actual ?></td>
                            <td><?= ($septotal2-$septotal2actual) ?></td>
                            <td><?= $octtotal2 ?></td>
                            <td><?= $octtotal2actual ?></td>
                            <td><?= ($octtotal2-$octtotal2actual) ?></td>
                            <td><?= $novtotal2 ?></td>
                            <td><?= $novtotal2actual ?></td>
                            <td><?= ($novtotal2-$novtotal2actual) ?></td>
                            <td><?= $dectotal2 ?></td>
                            <td><?= $dectotal2actual ?></td>
                            <td><?= ($dectotal2-$dectotal2actual) ?></td>
                            <td><?= $tott = ($jantotal2 + $febtotal2 + $martotal2 + $aprtotal2 + $maytotal2 + $juntotal2 + $jultotal2 + $augtotal2 + $septotal2 + $octtotal2 + $novtotal2 + $dectotal2) ?>
                            </td>
                            <td><?= $tott2 = ($jantotal2actual + $febtotal2actual + $martotal2actual + $aprtotal2actual + $maytotal2actual + $juntotal2actual + $jultotal2actual + $augtotal2actual + $septotal2actual + $octtotal2actual + $novtotal2actual + $dectotal2actual) ?>
                            </td>
                            <td><?= ($tott - $tott2) ?></td>
                            <td>
                                <a href="<?php echo url('expense_monthly_vary_chart')?>"><i
                                        class="fa fa-bar-chart"></i></a>
                            </td>
                        </tr>
                    </tbody>

                    <tbody></tbody>
                    <tfoot>
                        <tr>
                            <td class="fixed-side" style="text-align: left;"><b>Estimated Profit & Loss</b></td>
                            <td><?= ($jantotal-$jantotal2) ?></td>
                            <td><?= ($jantotalactual-$jantotal2actual) ?></td>
                            <td><?= (($jantotal-$jantotal2)-($jantotalactual-$jantotal2actual)) ?></td>
                            <td><?= ($febtotal-$febtotal2) ?></td>
                            <td><?= ($febtotalactual-$febtotal2actual) ?></td>
                            <td><?= (($febtotal-$febtotal2)-($febtotalactual-$febtotal2actual)) ?></td>
                            <td><?= ($martotal-$martotal2) ?></td>
                            <td><?= ($martotalactual-$martotal2actual) ?></td>
                            <td><?= (($martotal-$martotal2)-($martotalactual-$martotal2actual)) ?></td>
                            <td><?= ($aprtotal-$aprtotal2) ?></td>
                            <td><?= ($aprtotalactual-$aprtotal2actual) ?></td>
                            <td><?= (($aprtotal-$aprtotal2)-($aprtotalactual-$aprtotal2actual)) ?></td>
                            <td><?= ($maytotal-$maytotal2) ?></td>
                            <td><?= ($maytotalactual-$maytotal2actual) ?></td>
                            <td><?= (($maytotal-$maytotal2)-($maytotalactual-$maytotal2actual)) ?></td>
                            <td><?= ($juntotal-$juntotal2) ?></td>
                            <td><?= ($juntotalactual-$juntotal2actual) ?></td>
                            <td><?= (($juntotal-$juntotal2)-($juntotalactual-$juntotal2actual)) ?></td>
                            <td><?= ($jultotal-$jultotal2) ?></td>
                            <td><?= ($jultotalactual-$jultotal2actual) ?></td>
                            <td><?= (($jultotal-$jultotal2)-($jultotalactual-$jultotal2actual)) ?></td>
                            <td><?= ($augtotal-$augtotal2) ?></td>
                            <td><?= ($augtotalactual-$augtotal2actual) ?></td>
                            <td><?= (($augtotal-$augtotal2)-($augtotalactual-$augtotal2actual)) ?></td>
                            <td><?= ($septotal-$septotal2) ?></td>
                            <td><?= ($septotalactual-$septotal2actual) ?></td>
                            <td><?= (($septotal-$septotal2)-($septotalactual-$septotal2actual)) ?></td>
                            <td><?= ($octtotal-$octtotal2) ?></td>
                            <td><?= ($octtotalactual-$octtotal2actual) ?></td>
                            <td><?= (($octtotal-$octtotal2)-($octtotalactual-$octtotal2actual)) ?></td>
                            <td><?= ($novtotal-$novtotal2) ?></td>
                            <td><?= ($novtotalactual-$novtotal2actual) ?></td>
                            <td><?= (($novtotal-$novtotal2)-($novtotalactual-$novtotal2actual)) ?></td>
                            <td><?= ($dectotal-$dectotal2) ?></td>
                            <td><?= ($dectotalactual-$dectotal2actual) ?></td>
                            <td><?= (($dectotal-$dectotal2)-($dectotalactual-$dectotal2actual)) ?></td>
                            <td><?= ($monthtotal-$tott) ?></td>
                            <td><?= ($monthtotalactual-$tott2) ?></td>
                            <td><?= (($monthtotal-$tott)-($monthtotalactual-$tott2)) ?></td>
                            <td>
                                <!-- <a href="#"><i class="fa fa-bar-chart"></i></a> -->
                            </td>
                        </tr>
                        <!-- .nk-tb-item  -->
                    </tfoot>
                </table>
            </div>

            <?php

        $html=ob_get_clean();
        echo $html;
    }





public function tab2_quaterly_year(Request $request)
    {
        $year=$request->year;

        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status']=$status = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links']=$links = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos']=$top_videos = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner']=$aabanner = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners']=$top_banners = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime']=$slidetime = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['revenue']=$revenue = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->orderBy('id', 'desc')->get();
        if(count($data['revenue']) > 0){
            $data['revenue_count']=$revenue_count = $data['revenue'][0]->id;
        }else{
            $data['revenue_count']=$revenue_count = 0;
        }
        $data['jantotal']=$jantotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('jan');
        $data['febtotal']=$febtotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('feb');
        $data['martotal']=$martotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('mar');
        $data['aprtotal']=$aprtotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('apr');
        $data['maytotal']=$maytotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('may');
        $data['juntotal']=$juntotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('jun');
        $data['jultotal']=$jultotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('jul');
        $data['augtotal']=$augtotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('aug');
        $data['septotal']=$septotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('sep');
        $data['octtotal']=$octtotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('oct');
        $data['novtotal']=$novtotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('nov');
        $data['dectotal']=$dectotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('decem');
        $data['monthtotal']=$monthtotal = $data['jantotal'] + $data['febtotal'] + $data['martotal'] + $data['aprtotal'] + $data['maytotal'] + $data['juntotal'] + $data['jultotal'] + $data['augtotal'] + $data['septotal'] + $data['octtotal'] + $data['novtotal'] + $data['dectotal'];
        $data['revenue_quaterly']=$revenue_quaterly = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->orderBy('id', 'desc')->get();

        if(count($data['revenue_quaterly']) > 0){
            $data['revenue_quaterly_count']=$revenue_quaterly_count = $data['revenue_quaterly'][0]->id;
        }else{
            $data['revenue_quaterly_count']=$revenue_quaterly_count = 0;
        }

        $data['janmartotal']=$janmartotal = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('janmar');
        $data['aprjuntotal']=$aprjuntotal = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('aprjun');
        $data['julseptotal']=$julseptotal = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('julsep');
        $data['octdectotal']=$octdectotal = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('octdec');
        $data['quaterlytotal']=$quaterlytotal = $data['janmartotal'] + $data['aprjuntotal'] + $data['julseptotal'] + $data['octdectotal'];
        $data['chat']=$chat = "";
        $data['tools']=$tools = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }

        ob_start();
               ?>

            <div class="table-responsive" style="overflow-x: hidden; overflow-y: hidden">
                <table class="table table-striped table-bordered table-hover" id="">
                    <thead>
                        <tr>
                            <th></th>
                            <th>Jan - Mar</th>
                            <th>Apr - Jun</th>
                            <th>Jul - Sep</th>
                            <th>Oct - Dec</th>
                            <th>Total</th>
                            <th>Graph</th>
                        </tr>
                        <tr>
                            <th class="">
                                <!-- <a href="javascript:void(0);" class="add_button2" title="Add field">
                  <span class="glyphicon glyphicon-plus" style="text-align: center; color: white; font-size: 20px; font-weight: bold"></span>
                  </a> -->
                            </th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody class="field_wrapper2">
                        <?php
            foreach ($revenue_quaterly as $value) {
            ?>
                        <tr class="odd gradeX quarterly" id="roww<?= $value->id ?>">
                            <!-- <td class=""></td> -->
                            <td class="budget_name">
                                <!-- <select class="form-control" required disabled>
                  <option value="<?= $value->name ?>"><?= $value->name ?></option>
                  </select>
                  <p style="color: red; text-align: left; margin-bottom: 2px; display: none">*required</p> -->
                                <b style="padding: 0 10px" class="bname"><?= $value->name ?></b>
                            </td>
                            <td class="janmar">
                                <input type="number" class="form-control" value="<?= $value->janmar ?>"
                                    id="janmar<?= $value->id ?>" readonly>
                            </td>
                            <td class="aprjun">
                                <input type="number" class="form-control" value="<?= $value->aprjun ?>"
                                    id="aprjun<?= $value->id ?>" readonly>
                            </td>
                            <td class="julsep">
                                <input type="number" class="form-control" value="<?= $value->julsep ?>"
                                    id="julsep<?= $value->id ?>" readonly>
                            </td>
                            <td class="octdec">
                                <input type="number" class="form-control" value="<?= $value->octdec ?>"
                                    id="octdec<?= $value->id ?>" readonly>
                            </td>
                            <td class="budg_total2">
                                <?= ($value->janmar + $value->aprjun + $value->julsep + $value->octdec) ?>
                            </td>
                            <td class="showgraphq" id="showgraphq<?= $value->id ?>">
                                <a href="<?= url('quarterly_expense_chart')."/".$value->id ?>">
                                    <div id="bar-chartq<?= $value->id ?>" style="height: 20px; width: 30px"></div>
                                </a>
                                <script type="text/javascript">
                                $(function() {
                                    "use strict";

                                    //BAR CHART
                                    var bar = new Morris.Bar({
                                        element: 'bar-chartq<?= $value->id ?>',
                                        resize: true,
                                        data: [{
                                                y: '',
                                                a: <?= $value->janmar ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->aprjun ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->julsep ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->octdec ?>
                                            }
                                        ],
                                        barColors: ['#da291c'],
                                        xkey: 'y',
                                        ykeys: ['a'],
                                        labels: ['', ''],
                                        hideHover: 'auto',
                                        padding: 1,
                                    });
                                });
                                </script>
                            </td>
                        </tr>
                        <?php
            }
            ?>
                    </tbody>
                    <?php if($revenue_quaterly_count == 0){ $style2 = "style='display:none'"; }else{ $style2 = "style=''"; } ?>
                    <tbody class="sectbody2" <?= $style2 ?>>
                        <tr class="odd gradeX">
                            <!-- <td></td> -->
                            <td style="text-align:left; color:#da291c; padding: 10px; font-weight: bold">Total</td>
                            <td id="janmartotal"><?= $janmartotal ?></td>
                            <td id="aprjuntotal"><?= $aprjuntotal ?></td>
                            <td id="julseptotal"><?= $julseptotal ?></td>
                            <td id="octdectotal"><?= $octdectotal ?></td>
                            <td id="budget_total"><?= $quaterlytotal ?></td>
                            <td class="chart_quarterly">
                                <a href="<?= url('total_quarterly_expense_chart') ?>">
                                    <div id="bar-chart_totalq" style="height: 20px; width: 30px"></div>
                                </a>
                                <script type="text/javascript">
                                $(function() {
                                    "use strict";

                                    //BAR CHART
                                    var bar = new Morris.Bar({
                                        element: 'bar-chart_totalq',
                                        resize: true,
                                        data: [{
                                                y: '',
                                                a: <?= $janmartotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $aprjuntotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $julseptotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $octdectotal ?>
                                            }
                                        ],
                                        barColors: ['#da291c'],
                                        xkey: 'y',
                                        ykeys: ['a'],
                                        labels: ['', ''],
                                        hideHover: 'auto',
                                        padding: 1,
                                    });
                                });
                                </script>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <?php

        $html=ob_get_clean();
        echo $html;
    }



public function tab2_year(Request $request)
    {
        $year=$request->year;

        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status']=$status = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links']=$links = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos']=$top_videos = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner']=$aabanner = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners']=$top_banners = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime']=$slidetime = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['revenue']=$revenue = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->orderBy('id', 'desc')->get();
        if(count($data['revenue']) > 0){
            $data['revenue_count']=$revenue_count = $data['revenue'][0]->id;
        }else{
            $data['revenue_count']=$revenue_count = 0;
        }
        $data['jantotal']=$jantotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('jan');
        $data['febtotal']=$febtotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('feb');
        $data['martotal']=$martotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('mar');
        $data['aprtotal']=$aprtotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('apr');
        $data['maytotal']=$maytotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('may');
        $data['juntotal']=$juntotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('jun');
        $data['jultotal']=$jultotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('jul');
        $data['augtotal']=$augtotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('aug');
        $data['septotal']=$septotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('sep');
        $data['octtotal']=$octtotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('oct');
        $data['novtotal']=$novtotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('nov');
        $data['dectotal']=$dectotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('decem');
        $data['monthtotal']=$monthtotal = $data['jantotal'] + $data['febtotal'] + $data['martotal'] + $data['aprtotal'] + $data['maytotal'] + $data['juntotal'] + $data['jultotal'] + $data['augtotal'] + $data['septotal'] + $data['octtotal'] + $data['novtotal'] + $data['dectotal'];
        $data['revenue_quaterly']=$revenue_quaterly = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->orderBy('id', 'desc')->get();

        if(count($data['revenue_quaterly']) > 0){
            $data['revenue_quaterly_count']=$revenue_quaterly_count = $data['revenue_quaterly'][0]->id;
        }else{
            $data['revenue_quaterly_count']=$revenue_quaterly_count = 0;
        }

        $data['janmartotal']=$janmartotal = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('janmar');
        $data['aprjuntotal']=$aprjuntotal = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('aprjun');
        $data['julseptotal']=$julseptotal = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('julsep');
        $data['octdectotal']=$octdectotal = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('octdec');
        $data['quaterlytotal']=$quaterlytotal = $data['janmartotal'] + $data['aprjuntotal'] + $data['julseptotal'] + $data['octdectotal'];
        $data['chat']=$chat = "";
        $data['tools']=$tools = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }

        ob_start();
               ?>

            <div id="table-scroll" class="table-scroll">
                <div class="table-wrap">
                    <table class="table table-striped table-bordered table-hover main-table" id="">
                        <thead>
                            <tr>
                                <th class=""></th>
                                <th>Jan</th>
                                <th>Feb</th>
                                <th>Mar</th>
                                <th>Apr</th>
                                <th>May</th>
                                <th>Jun</th>
                                <th>Jul</th>
                                <th>Aug</th>
                                <th>Sep</th>
                                <th>Oct</th>
                                <th>Nov</th>
                                <th>Dec</th>
                                <th>Total</th>
                                <th>Graph</th>
                            </tr>
                            <tr>
                                <th class="">
                                    <!-- <a href="javascript:void(0);" class="add_button" title="Add field">
                     <span class="glyphicon glyphicon-plus" style="text-align: center; color: white; font-size: 20px; font-weight: bold"></span>
                     </a> -->
                                </th>
                                <th>Budget</th>
                                <th>Budget</th>
                                <th>Budget</th>
                                <th>Budget</th>
                                <th>Budget</th>
                                <th>Budget</th>
                                <th>Budget</th>
                                <th>Budget</th>
                                <th>Budget</th>
                                <th>Budget</th>
                                <th>Budget</th>
                                <th>Budget</th>
                                <th>Budget</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody class="field_wrapper">

                            <?php
if(count($revenue)==0){
                                            ?>
                            <tr class="odd gradeX monthly">
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td>No data found</td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            <?php
                                          }else{

               $currmon = date('m');
               $curryear=date('y');
               foreach ($revenue as $value) {
               ?>
                            <tr class="odd gradeX monthly" id="row<?= $value->id ?>">
                                <!-- <td class=""></td> -->
                                <td class="budget_name">
                                    <!-- <select class="form-control" required disabled>
                     <option value="<?= $value->name ?>"><?= $value->name ?></option>
                     </select>
                     <p style="color: red; text-align: left; margin-bottom: 2px; display: none">*required</p> -->
                                    <b style="padding: 0 10px" class="bname"><?= $value->name ?></b>
                                </td>


                                <?php
//|| (($curryear == date('y',strtotime($value->created_at))) && ())
if($curryear > date('y',strtotime($value->created_at))){
    $readonly="readonly";
    $disabled="disabled";
}else{
      $readonly="";
        $disabled="";

    }

?>
                                <td class="jan">

                                    <input type="number" class="form-control" value="<?= $value->jan ?>"
                                        id="jan<?= $value->id ?>" <?php if($currmon >= "01"){ ?> readonly
                                        <?php }else{ echo $readonly; } ?>>
                                </td>
                                <td class="feb">
                                    <input type="number" class="form-control" value="<?= $value->feb ?>"
                                        id="feb<?= $value->id ?>" <?php if($currmon >= "02"){ ?> readonly
                                        <?php }else{ echo $readonly; } ?>>
                                </td>
                                <td class="mar">
                                    <input type="number" class="form-control" value="<?= $value->mar ?>"
                                        id="mar<?= $value->id ?>" <?php if($currmon >= "03"){ ?> readonly
                                        <?php }else{ echo $readonly; } ?>>
                                </td>
                                <td class="apr">
                                    <input type="number" class="form-control" value="<?= $value->apr ?>"
                                        id="apr<?= $value->id ?>" <?php if($currmon >= "04"){ ?> readonly
                                        <?php }else{ echo $readonly; } ?>>
                                </td>
                                <td class="may">
                                    <input type="number" class="form-control" value="<?= $value->may ?>"
                                        id="may<?= $value->id ?>" <?php if($currmon >= "05"){ ?> readonly
                                        <?php }else{ echo $readonly; } ?>>
                                </td>
                                <td class="jun">
                                    <input type="number" class="form-control" value="<?= $value->jun ?>"
                                        id="jun<?= $value->id ?>" <?php if($currmon >= "06"){ ?> readonly
                                        <?php }else{ echo $readonly; } ?>>
                                </td>
                                <td class="jul">
                                    <input type="number" class="form-control" value="<?= $value->jul ?>"
                                        id="jul<?= $value->id ?>" <?php if($currmon >= "07"){ ?> readonly
                                        <?php }else{ echo $readonly; } ?>>
                                </td>
                                <td class="aug">
                                    <input type="number" class="form-control" value="<?= $value->aug ?>"
                                        id="aug<?= $value->id ?>" <?php if($currmon >= "08"){ ?> readonly
                                        <?php }else{ echo $readonly; } ?>>
                                </td>
                                <td class="sep">
                                    <input type="number" class="form-control" value="<?= $value->sep ?>"
                                        id="sep<?= $value->id ?>" <?php if($currmon >= "09"){ ?> readonly
                                        <?php }else{ echo $readonly; } ?>>
                                </td>
                                <td class="oct">
                                    <input type="number" class="form-control" value="<?= $value->oct ?>"
                                        id="oct<?= $value->id ?>" <?php if($currmon >= "10"){ ?> readonly
                                        <?php }else{ echo $readonly; } ?>>
                                </td>
                                <td class="nov">
                                    <input type="number" class="form-control" value="<?= $value->nov ?>"
                                        id="nov<?= $value->id ?>" <?php if($currmon >= "11"){ ?> readonly
                                        <?php }else{ echo $readonly; } ?>>
                                </td>
                                <td class="dec">
                                    <input type="number" class="form-control" value="<?= $value->decem ?>"
                                        id="dec<?= $value->id ?>" <?php if($currmon >= "12"){ ?> readonly
                                        <?php }else{ echo $readonly; } ?>>
                                </td>
                                <td class="budg_total">
                                    <?= ($value->jan + $value->feb + $value->mar + $value->apr + $value->may + $value->jun + $value->jul + $value->aug + $value->sep + $value->oct + $value->nov + $value->decem) ?>
                                </td>
                                <td class="showgraph" id="showgraph<?= $value->id ?>">
                                    <a href="<?= url('monthly_expense_chart')."/".$value->id ?>">
                                        <div id="bar-chart<?= $value->id ?>" style="height: 20px; width: 50px"></div>
                                    </a>
                                    <script type="text/javascript">
                                    $(function() {
                                        "use strict";

                                        //BAR CHART
                                        var bar = new Morris.Bar({
                                            element: 'bar-chart<?= $value->id ?>',
                                            resize: true,
                                            data: [{
                                                    y: '',
                                                    a: <?= $value->jan ?>
                                                },
                                                {
                                                    y: '',
                                                    a: <?= $value->feb ?>
                                                },
                                                {
                                                    y: '',
                                                    a: <?= $value->mar ?>
                                                },
                                                {
                                                    y: '',
                                                    a: <?= $value->apr ?>
                                                },
                                                {
                                                    y: '',
                                                    a: <?= $value->may ?>
                                                },
                                                {
                                                    y: '',
                                                    a: <?= $value->jun ?>
                                                },
                                                {
                                                    y: '',
                                                    a: <?= $value->jul ?>
                                                },
                                                {
                                                    y: '',
                                                    a: <?= $value->aug ?>
                                                },
                                                {
                                                    y: '',
                                                    a: <?= $value->sep ?>
                                                },
                                                {
                                                    y: '',
                                                    a: <?= $value->oct ?>
                                                },
                                                {
                                                    y: '',
                                                    a: <?= $value->nov ?>
                                                },
                                                {
                                                    y: '',
                                                    a: <?= $value->decem ?>
                                                }
                                            ],
                                            barColors: ['#da291c'],
                                            xkey: 'y',
                                            ykeys: ['a'],
                                            labels: ['', ''],
                                            hideHover: 'auto',
                                            padding: 1,
                                        });
                                    });
                                    </script>
                                </td>
                            </tr>
                            <?php
               }
               ?>
                        </tbody>
                        <?php if($revenue_count == 0){ $style = "style='display:none'"; }else{ $style = "style=''"; } ?>
                        <tbody class="sectbody" <?= $style ?>>
                            <tr class="odd gradeX">
                                <!-- <td></td> -->
                                <td style="text-align:left; color:#da291c; padding: 10px; font-weight: bold">Total</td>
                                <td id="jantotal"><?= $jantotal ?></td>
                                <td id="febtotal"><?= $febtotal ?></td>
                                <td id="martotal"><?= $martotal ?></td>
                                <td id="aprtotal"><?= $aprtotal ?></td>
                                <td id="maytotal"><?= $maytotal ?></td>
                                <td id="juntotal"><?= $juntotal ?></td>
                                <td id="jultotal"><?= $jultotal ?></td>
                                <td id="augtotal"><?= $augtotal ?></td>
                                <td id="septotal"><?= $septotal ?></td>
                                <td id="octtotal"><?= $octtotal ?></td>
                                <td id="novtotal"><?= $novtotal ?></td>
                                <td id="dectotal"><?= $dectotal ?></td>
                                <td id="budget_total"><?= $monthtotal ?></td>
                                <td class="chart_monthly">
                                    <a href="<?= url('total_monthly_expense_chart') ?>">
                                        <div id="bar-chart_total" style="height: 20px; width: 50px"></div>
                                    </a>
                                    <script type="text/javascript">
                                    $(function() {
                                        "use strict";

                                        //BAR CHART
                                        var bar = new Morris.Bar({
                                            element: 'bar-chart_total',
                                            resize: true,
                                            data: [{
                                                    y: '',
                                                    a: <?= $jantotal ?>
                                                },
                                                {
                                                    y: '',
                                                    a: <?= $febtotal ?>
                                                },
                                                {
                                                    y: '',
                                                    a: <?= $martotal ?>
                                                },
                                                {
                                                    y: '',
                                                    a: <?= $aprtotal ?>
                                                },
                                                {
                                                    y: '',
                                                    a: <?= $maytotal ?>
                                                },
                                                {
                                                    y: '',
                                                    a: <?= $juntotal ?>
                                                },
                                                {
                                                    y: '',
                                                    a: <?= $jultotal ?>
                                                },
                                                {
                                                    y: '',
                                                    a: <?= $augtotal ?>
                                                },
                                                {
                                                    y: '',
                                                    a: <?= $septotal ?>
                                                },
                                                {
                                                    y: '',
                                                    a: <?= $octtotal ?>
                                                },
                                                {
                                                    y: '',
                                                    a: <?= $novtotal ?>
                                                },
                                                {
                                                    y: '',
                                                    a: <?= $dectotal ?>
                                                }
                                            ],
                                            barColors: ['#da291c'],
                                            xkey: 'y',
                                            ykeys: ['a'],
                                            labels: ['', ''],
                                            hideHover: 'auto',
                                            padding: 1,
                                        });
                                    });
                                    </script>
                                </td>
                            </tr>
                            <tr class="odd gradeX">
                                <!-- <td></td> -->
                                <td></td>
                                <td>
                                    <a id="jansave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                        <?php if($currmon >= "01"){ echo "disabled"; }else{ echo $disabled; }?>>Save</a><br>
                                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                                </td>
                                <td>
                                    <a id="febsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                        <?php if($currmon >= "02"){ echo "disabled"; }else{ echo $disabled; }?>>Save</a><br>
                                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                                </td>
                                <td>
                                    <a id="marsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                        <?php if($currmon >= "03"){ echo "disabled"; }else{ echo $disabled; }?>>Save</a><br>
                                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                                </td>
                                <td>
                                    <a id="aprsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                        <?php if($currmon >= "04"){ echo "disabled"; }else{ echo $disabled; }?>>Save</a><br>
                                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                                </td>
                                <td>
                                    <a id="maysave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                        <?php if($currmon >= "05"){ echo "disabled"; }else{ echo $disabled; }?>>Save</a><br>
                                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                                </td>
                                <td>
                                    <a id="junsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                        <?php if($currmon >= "06"){ echo "disabled"; }else{ echo $disabled; }?>>Save</a><br>
                                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                                </td>
                                <td>
                                    <a id="julsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                        <?php if($currmon >= "07"){ echo "disabled"; }else{ echo $disabled; }?>>Save</a><br>
                                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                                </td>
                                <td>
                                    <a id="augsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                        <?php if($currmon >= "08"){ echo "disabled"; }else{ echo $disabled; }?>>Save</a><br>
                                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                                </td>
                                <td>
                                    <a id="sepsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                        <?php if($currmon >= "09"){ echo "disabled"; }else{ echo $disabled; }?>>Save</a><br>
                                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                                </td>
                                <td>
                                    <a id="octsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                        <?php if($currmon >= "10"){ echo "disabled"; }else{ echo $disabled; }?>>Save</a><br>
                                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                                </td>
                                <td>
                                    <a id="novsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                        <?php if($currmon >= "11"){ echo "disabled"; }else{ echo $disabled; }?>>Save</a><br>
                                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                                </td>
                                <td>
                                    <a id="decsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                        <?php if($currmon >= "12"){ echo "disabled"; }else{ echo $disabled; }?>>Save</a><br>
                                    <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                                </td>
                                <td></td>
                                <td></td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <?php

        $html=ob_get_clean();
        echo $html;
    }



    public function tab2()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['revenue'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->orderBy('id', 'desc')->get();

        if(count($data['revenue']) > 0){
            $data['revenue_count'] = $data['revenue'][0]->id;
        }else{
            $data['revenue_count'] = 0;
        }
        $data['jantotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jan');
        $data['febtotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('feb');
        $data['martotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('mar');
        $data['aprtotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('apr');
        $data['maytotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('may');
        $data['juntotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jun');
        $data['jultotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jul');
        $data['augtotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aug');
        $data['septotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('sep');
        $data['octtotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('oct');
        $data['novtotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('nov');
        $data['dectotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('decem');
        $data['monthtotal'] = $data['jantotal'] + $data['febtotal'] + $data['martotal'] + $data['aprtotal'] + $data['maytotal'] + $data['juntotal'] + $data['jultotal'] + $data['augtotal'] + $data['septotal'] + $data['octtotal'] + $data['novtotal'] + $data['dectotal'];
        $data['revenue_quaterly'] = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->orderBy('id', 'desc')->get();

        if(count($data['revenue_quaterly']) > 0){
            $data['revenue_quaterly_count'] = $data['revenue_quaterly'][0]->id;
        }else{
            $data['revenue_quaterly_count'] = 0;
        }

        $data['janmartotal'] = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('janmar');
        $data['aprjuntotal'] = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aprjun');
        $data['julseptotal'] = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('julsep');
        $data['octdectotal'] = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('octdec');
        $data['quaterlytotal'] = $data['janmartotal'] + $data['aprjuntotal'] + $data['julseptotal'] + $data['octdectotal'];
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }

        $data['years'] = [];
        for($i = 0; $i < 10; $i++){
            $lastYear = date("Y", strtotime("-$i years"));
            if($lastYear > 2019){
                array_push($data['years'], $lastYear);
            }
        }

        return view('tab2')->with($data);
    }
    public function tab3()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['jantotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jan');
        $data['febtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('feb');
        $data['martotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('mar');
        $data['aprtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('apr');
        $data['maytotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('may');
        $data['juntotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jun');
        $data['jultotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jul');
        $data['augtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aug');
        $data['septotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('sep');
        $data['octtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('oct');
        $data['novtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('nov');
        $data['dectotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('decem');
        $data['monthtotal'] = $data['jantotal'] + $data['febtotal'] + $data['martotal'] + $data['aprtotal'] + $data['maytotal'] + $data['juntotal'] + $data['jultotal'] + $data['augtotal'] + $data['septotal'] + $data['octtotal'] + $data['novtotal'] + $data['dectotal'];
        $data['jangrosstotal2'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('jan');
        $data['febgrosstotal2'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('feb');
        $data['margrosstotal2'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('mar');
        $data['aprgrosstotal2'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('apr');
        $data['maygrosstotal2'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('may');
        $data['jungrosstotal2'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('jun');
        $data['julgrosstotal2'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('jul');
        $data['auggrosstotal2'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('aug');
        $data['sepgrosstotal2'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('sep');
        $data['octgrosstotal2'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('oct');
        $data['novgrosstotal2'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('nov');
        $data['decgrosstotal2'] = DB::table('revenue_budget')->where('uid',$uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('decem');
        $data['monthgrosstotal2'] = $data['jangrosstotal2'] + $data['febgrosstotal2'] + $data['margrosstotal2'] + $data['aprgrosstotal2'] + $data['maygrosstotal2'] + $data['jungrosstotal2'] + $data['julgrosstotal2'] + $data['auggrosstotal2'] + $data['sepgrosstotal2'] + $data['octgrosstotal2'] + $data['novgrosstotal2'] + $data['decgrosstotal2'];
        $data['jangrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['febgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['margrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['aprgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['maygrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['jungrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['julgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['auggrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['sepgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['octgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['novgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['decgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['monthgrossactual'] = $data['jangrossactual'] + $data['febgrossactual'] + $data['margrossactual'] + $data['aprgrossactual'] + $data['maygrossactual'] + $data['jungrossactual'] + $data['julgrossactual'] + $data['auggrossactual'] + $data['sepgrossactual'] + $data['octgrossactual'] + $data['novgrossactual'] + $data['decgrossactual'];
        $data['jantotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->sum('bill');
        $data['febtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->sum('bill');
        $data['martotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->sum('bill');
        $data['aprtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->sum('bill');
        $data['maytotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->sum('bill');
        $data['juntotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->sum('bill');
        $data['jultotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->sum('bill');
        $data['augtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->sum('bill');
        $data['septotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->sum('bill');
        $data['octtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->sum('bill');
        $data['novtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->sum('bill');
        $data['dectotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->sum('bill');
        $data['monthtotalactual'] = $data['jantotalactual'] + $data['febtotalactual'] + $data['martotalactual'] + $data['aprtotalactual'] + $data['maytotalactual'] + $data['juntotalactual'] + $data['jultotalactual'] + $data['augtotalactual'] + $data['septotalactual'] + $data['octtotalactual'] + $data['novtotalactual'] + $data['dectotalactual'];
        $data['janothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('jan');
        $data['febothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('feb');
        $data['marothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('mar');
        $data['aprothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('apr');
        $data['mayothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('may');
        $data['junothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('jun');
        $data['julothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('jul');
        $data['augothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('aug');
        $data['sepothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('sep');
        $data['octothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('oct');
        $data['novothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('nov');
        $data['decothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('decem');
        $data['monthothrevenue'] = $data['janothrevenue'] + $data['febothrevenue'] + $data['marothrevenue'] + $data['aprothrevenue'] + $data['mayothrevenue'] + $data['junothrevenue'] + $data['julothrevenue'] + $data['augothrevenue'] + $data['sepothrevenue'] + $data['octothrevenue'] + $data['novothrevenue'] + $data['decothrevenue'];
        $data['janotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->where('account_description', 'Other Revenue')->sum('bill');
        $data['febotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->where('account_description', 'Other Revenue')->sum('bill');
        $data['marotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->where('account_description', 'Other Revenue')->sum('bill');
        $data['aprotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->where('account_description', 'Other Revenue')->sum('bill');
        $data['mayotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->where('account_description', 'Other Revenue')->sum('bill');
        $data['junotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->where('account_description', 'Other Revenue')->sum('bill');
        $data['julotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->where('account_description', 'Other Revenue')->sum('bill');
        $data['augotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->where('account_description', 'Other Revenue')->sum('bill');
        $data['sepotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->where('account_description', 'Other Revenue')->sum('bill');
        $data['octotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->where('account_description', 'Other Revenue')->sum('bill');
        $data['novotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->where('account_description', 'Other Revenue')->sum('bill');
        $data['decotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->where('account_description', 'Other Revenue')->sum('bill');
        $data['monthotherrevenue'] = $data['janotherrevenue'] + $data['febotherrevenue'] + $data['marotherrevenue'] + $data['aprotherrevenue'] + $data['mayotherrevenue'] + $data['junotherrevenue'] + $data['julotherrevenue'] + $data['augotherrevenue'] + $data['sepotherrevenue'] + $data['octotherrevenue'] + $data['novotherrevenue'] + $data['decotherrevenue'];
        $data['expense'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->get();
        $data['jantotal2'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jan');
        $data['febtotal2'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('feb');
        $data['martotal2'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('mar');
        $data['aprtotal2'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('apr');
        $data['maytotal2'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('may');
        $data['juntotal2'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jun');
        $data['jultotal2'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jul');
        $data['augtotal2'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aug');
        $data['septotal2'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('sep');
        $data['octtotal2'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('oct');
        $data['novtotal2'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('nov');
        $data['dectotal2'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('decem');
        $data['monthtotal2'] = $data['jantotal2'] + $data['febtotal2'] + $data['martotal2'] + $data['aprtotal2'] + $data['maytotal2'] + $data['juntotal2'] + $data['jultotal2'] + $data['augtotal2'] + $data['septotal2'] + $data['octtotal2'] + $data['novtotal2'] + $data['dectotal2'];
        $data['jantotal2actual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->sum('amount_paid');
        $data['febtotal2actual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->sum('amount_paid');
        $data['martotal2actual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->sum('amount_paid');
        $data['aprtotal2actual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->sum('amount_paid');
        $data['maytotal2actual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->sum('amount_paid');
        $data['juntotal2actual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->sum('amount_paid');
        $data['jultotal2actual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->sum('amount_paid');
        $data['augtotal2actual'] = DB::table('expense_record')->where('uid',$uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->sum('amount_paid');
        $data['septotal2actual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->sum('amount_paid');
        $data['octtotal2actual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->sum('amount_paid');
        $data['novtotal2actual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->sum('amount_paid');
        $data['dectotal2actual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->sum('amount_paid');
        $data['monthtotal2actual'] = $data['jantotal2actual'] + $data['febtotal2actual'] + $data['martotal2actual'] + $data['aprtotal2actual'] + $data['maytotal2actual'] + $data['juntotal2actual'] + $data['jultotal2actual'] + $data['augtotal2actual'] + $data['septotal2actual'] + $data['octtotal2actual'] + $data['novtotal2actual'] + $data['dectotal2actual'];
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }

        $data['years'] = [];
        for($i = 0; $i < 10; $i++){
            $lastYear = date("Y", strtotime("-$i years"));
            if($lastYear > 2019){
                array_push($data['years'], $lastYear);
            }
        }

        return view('tab3')->with($data);
    }
    public function tab4()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['revenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->get();
        $data['jantotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jan');
        $data['febtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('feb');
        $data['martotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('mar');
        $data['aprtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('apr');
        $data['maytotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('may');
        $data['juntotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jun');
        $data['jultotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jul');
        $data['augtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aug');
        $data['septotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('sep');
        $data['octtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('oct');
        $data['novtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('nov');
        $data['dectotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('decem');
        $data['monthtotal'] = $data['jantotal'] + $data['febtotal'] + $data['martotal'] + $data['aprtotal'] + $data['maytotal'] + $data['juntotal'] + $data['jultotal'] + $data['augtotal'] + $data['septotal'] + $data['octtotal'] + $data['novtotal'] + $data['dectotal'];
        $data['jantotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['febtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['martotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['aprtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['maytotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['juntotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['jultotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['augtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['septotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['octtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['novtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['dectotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['monthtotalactual'] = $data['jantotalactual'] + $data['febtotalactual'] + $data['martotalactual'] + $data['aprtotalactual'] + $data['maytotalactual'] + $data['juntotalactual'] + $data['jultotalactual'] + $data['augtotalactual'] + $data['septotalactual'] + $data['octtotalactual'] + $data['novtotalactual'] + $data['dectotalactual'];
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }

        $data['years'] = [];
        for($i = 0; $i < 10; $i++){
            $lastYear = date("Y", strtotime("-$i years"));
            if($lastYear > 2019){
                array_push($data['years'], $lastYear);
            }
        }

        return view('tab4')->with($data);
    }


    public function tab4_year(Request $request)
    {
        $year=$request->year;

        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status']=$status = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links']=$links = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos']=$top_videos = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner']=$aabanner = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners']=$top_banners = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime']=$slidetime = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['revenue']=$revenue = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at',$year)->get();
        $data['jantotal']=$jantotal = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('jan');
        $data['febtotal']=$febtotal = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('feb');
        $data['martotal']=$martotal = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('mar');
        $data['aprtotal']=$aprtotal = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('apr');
        $data['maytotal']=$maytotal = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('may');
        $data['juntotal']=$juntotal = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('jun');
        $data['jultotal']=$jultotal = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('jul');
        $data['augtotal'] =$augtotal= DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('aug');
        $data['septotal'] =$septotal= DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('sep');
        $data['octtotal'] =$octtotal= DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at',$year)->sum('oct');
        $data['novtotal'] =$novtotal= DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at',$year)->sum('nov');
        $data['dectotal'] =$dectotal= DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at',$year)->sum('decem');
        $data['monthtotal'] =$monthtotal= $data['jantotal'] + $data['febtotal'] + $data['martotal'] + $data['aprtotal'] + $data['maytotal'] + $data['juntotal'] + $data['jultotal'] + $data['augtotal'] + $data['septotal'] + $data['octtotal'] + $data['novtotal'] + $data['dectotal'];
        $data['jantotalactual'] =$jantotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '01')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['febtotalactual'] =$febtotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date',$year)->whereMonth('transaction_date', '02')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['martotalactual'] =$martotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['aprtotalactual']=$aprtotalactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '04')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['maytotalactual']=$maytotalactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '05')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['juntotalactual']=$juntotalactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '06')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['jultotalactual']=$jultotalactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '07')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['augtotalactual']=$augtotalactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '08')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['septotalactual']=$septotalactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '09')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['octtotalactual']=$octtotalactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date',$year)->whereMonth('transaction_date', '10')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['novtotalactual']=$novtotalactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '11')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['dectotalactual']=$dectotalactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '12')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['monthtotalactual']=$monthtotalactual = $data['jantotalactual'] + $data['febtotalactual'] + $data['martotalactual'] + $data['aprtotalactual'] + $data['maytotalactual'] + $data['juntotalactual'] + $data['jultotalactual'] + $data['augtotalactual'] + $data['septotalactual'] + $data['octtotalactual'] + $data['novtotalactual'] + $data['dectotalactual'];
        $data['chat']=$chat = "";
        $data['tools']=$tools = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }

        ob_start();
               ?>


            <table class="table table-striped table-bordered table-hover main-table" id="">
                <thead>
                    <tr class="top-tr">
                        <th class="fixed-side"></th>
                        <th colspan="3">Jan</th>
                        <th colspan="3">Feb</th>
                        <th colspan="3">Mar</th>
                        <th colspan="3">Apr</th>
                        <th colspan="3">May</th>
                        <th colspan="3">Jun</th>
                        <th colspan="3">Jul</th>
                        <th colspan="3">Aug</th>
                        <th colspan="3">Sep</th>
                        <th colspan="3">Oct</th>
                        <th colspan="3">Nov</th>
                        <th colspan="3">Dec</th>
                        <th colspan="3">Total</th>
                        <th>Graph</th>
                    </tr>
                    <tr>
                        <th class="fixed-side"></th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="fixed-side" style="text-align: left; color: #da291c;"><b>Revenue</b></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>
                    <?php
                                                        foreach($revenue as $value){
                                                        ?>
                    <tr class="odd gradeX">
                        <td class="fixed-side"><?= $value->name ?></td>
                        <td><?= $value->jan ?></td>
                        <td><?php echo $actual_jan = HomeController::getjanactual($value->name); ?></td>
                        <td><?= ($value->jan - $actual_jan) ?></td>
                        <td><?= $value->feb ?></td>
                        <td><?php echo $actual_feb = HomeController::getfebactual($value->name); ?></td>
                        <td><?= ($value->feb - $actual_feb) ?></td>
                        <td><?= $value->mar ?></td>
                        <td><?php echo $actual_mar = HomeController::getmaractual($value->name); ?></td>
                        <td><?= ($value->mar - $actual_mar) ?></td>
                        <td><?= $value->apr ?></td>
                        <td><?php echo $actual_apr = HomeController::getapractual($value->name); ?></td>
                        <td><?= ($value->apr - $actual_apr) ?></td>
                        <td><?= $value->may ?></td>
                        <td><?php echo $actual_may = HomeController::getmayactual($value->name); ?></td>
                        <td><?= ($value->may - $actual_may) ?></td>
                        <td><?= $value->jun ?></td>
                        <td><?php echo $actual_jun = HomeController::getjunactual($value->name); ?></td>
                        <td><?= ($value->jun - $actual_jun) ?></td>
                        <td><?= $value->jul ?></td>
                        <td><?php echo $actual_jul = HomeController::getjulactual($value->name); ?></td>
                        <td><?= ($value->jul - $actual_jul) ?></td>
                        <td><?= $value->aug ?></td>
                        <td><?php echo $actual_aug = HomeController::getaugactual($value->name); ?></td>
                        <td><?= ($value->aug - $actual_aug) ?></td>
                        <td><?= $value->sep ?></td>
                        <td><?php echo $actual_sep = HomeController::getsepactual($value->name); ?></td>
                        <td><?= ($value->sep - $actual_sep) ?></td>
                        <td><?= $value->oct ?></td>
                        <td><?php echo $actual_oct =HomeController::getoctactual($value->name); ?></td>
                        <td><?= ($value->oct - $actual_oct) ?></td>
                        <td><?= $value->nov ?></td>
                        <td><?php echo $actual_nov = HomeController::getnovactual($value->name); ?></td>
                        <td><?= ($value->nov - $actual_nov) ?></td>
                        <td><?= $value->decem ?></td>
                        <td><?php echo $actual_decem =HomeController::getdecemactual($value->name); ?></td>
                        <td><?= ($value->decem - $actual_decem) ?></td>
                        <td> <?= $tot = ($value->jan + $value->feb + $value->mar + $value->apr + $value->may + $value->jun + $value->jul + $value->aug + $value->sep + $value->oct + $value->nov + $value->decem) ?>
                        </td>
                        <td><?php echo $actual_total =HomeController::gettotalactual($value->name); ?></td>
                        <td><?= ($tot-$actual_total) ?></td>
                        <td>
                            <a href="<?php echo  url('revenue_variance_monthly_graph')."/".$value->name ?>"><i
                                    class="fa fa-bar-chart"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                    <tr class="total-tr">
                        <td class="fixed-side" style=""><b>Total Revenue</b></td>
                        <td><?= $jantotal ?></td>
                        <td><?= $jantotalactual ?></td>
                        <td><?= ($jantotal-$jantotalactual) ?></td>
                        <td><?= $febtotal ?></td>
                        <td><?= $febtotalactual ?></td>
                        <td><?= ($febtotal-$febtotalactual) ?></td>
                        <td><?= $martotal ?></td>
                        <td><?= $martotalactual ?></td>
                        <td><?= ($martotal-$martotalactual) ?></td>
                        <td><?= $aprtotal ?></td>
                        <td><?= $aprtotalactual ?></td>
                        <td><?= ($aprtotal-$aprtotalactual) ?></td>
                        <td><?= $maytotal ?></td>
                        <td><?= $maytotalactual ?></td>
                        <td><?= ($maytotal-$maytotalactual) ?></td>
                        <td><?= $juntotal ?></td>
                        <td><?= $juntotalactual ?></td>
                        <td><?= ($juntotal-$juntotalactual) ?></td>
                        <td><?= $jultotal ?></td>
                        <td><?= $jultotalactual ?></td>
                        <td><?= ($jultotal-$jultotalactual) ?></td>
                        <td><?= $augtotal ?></td>
                        <td><?= $augtotalactual ?></td>
                        <td><?= ($augtotal-$augtotalactual) ?></td>
                        <td><?= $septotal ?></td>
                        <td><?= $septotalactual ?></td>
                        <td><?= ($septotal-$septotalactual) ?></td>
                        <td><?= $octtotal ?></td>
                        <td><?= $octtotalactual ?></td>
                        <td><?= ($octtotal-$octtotalactual) ?></td>
                        <td><?= $novtotal ?></td>
                        <td><?= $novtotalactual ?></td>
                        <td><?= ($novtotal-$novtotalactual) ?></td>
                        <td><?= $dectotal ?></td>
                        <td><?= $dectotalactual ?></td>
                        <td><?= ($dectotal-$dectotalactual) ?></td>
                        <td><?= $tott = ($jantotal + $febtotal + $martotal + $aprtotal + $maytotal + $juntotal + $jultotal + $augtotal + $septotal + $octtotal + $novtotal + $dectotal) ?>
                        </td>
                        <td><?= $tott2 = ($jantotalactual + $febtotalactual + $martotalactual + $aprtotalactual + $maytotalactual + $juntotalactual + $jultotalactual + $augtotalactual + $septotalactual + $octtotalactual + $novtotalactual + $dectotalactual) ?>
                        </td>
                        <td><?= ($tott - $tott2) ?></td>
                        <td>
                            <a href="<?php echo url('revenue_monthly_vary_chart') ?>"><i
                                    class="fa fa-bar-chart"></i></a>
                        </td>
                    </tr>
                </tbody>
            </table>

            <?php $html=ob_get_clean();
        echo $html;

    }


 public function tab4_quaterly_year(Request $request)
    {
        $year=$request->year;


        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner']=$aabanner = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners']=$top_banners = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime']=$slidetime = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['revenue']=$revenue = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->get();
        $data['janmartotal']=$janmartotal = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('janmar');
        $data['aprjuntotal']=$aprjuntotal = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('aprjun');
        $data['julseptotal']=$julseptotal = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('julsep');
        $data['octdectotal']=$octdectotal = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('octdec');
        $data['monthtotal'] =$monthtotal= $data['janmartotal'] + $data['aprjuntotal'] + $data['julseptotal'] + $data['octdectotal'];
        $data['jantotalactual'] =$jantotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '01')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['febtotalactual'] =$febtotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '02')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['martotalactual'] =$martotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '03')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['aprtotalactual'] =$aprtotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '04')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['maytotalactual'] =$maytotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '05')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['juntotalactual'] =$juntotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '06')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['jultotalactual'] =$jultotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date',$year)->whereMonth('transaction_date', '07')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['augtotalactual'] =$augtotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '08')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['septotalactual'] =$septotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '09')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['octtotalactual'] =$octtotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '10')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['novtotalactual'] =$novtotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '11')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['dectotalactual'] =$dectotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '12')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['janmartotalactual']=$janmartotalactual = $data['jantotalactual'] + $data['febtotalactual'] + $data['martotalactual'];
        $data['aprjuntotalactual']=$aprjuntotalactual = $data['aprtotalactual'] + $data['maytotalactual'] + $data['juntotalactual'];
        $data['julseptotalactual']=$julseptotalactual = $data['jultotalactual'] + $data['augtotalactual'] + $data['septotalactual'];
        $data['octdectotalactual']=$octdectotalactual = $data['octtotalactual'] + $data['novtotalactual'] + $data['dectotalactual'];
        $data['monthtotalactual']=$monthtotalactual = $data['janmartotalactual'] + $data['aprjuntotalactual'] + $data['julseptotalactual'] + $data['octdectotalactual'];
        $data['chat']=$chat = "";
        $data['tools']=$tools = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat']=$chat = "on";
            }
            else{
                $data['chat']=$chat = "off";
            }
            if($cdet->tools == "on"){
                $data['tools']=$tools = "on";
            }
            else{
                $data['tools']=$tools = "off";
            }
        }

        ob_start();
               ?>
            <table class="table table-striped table-bordered table-hover main-table" id="">
                <thead>
                    <tr class="top-tr">
                        <th class="fixed-side"></th>
                        <th colspan="3">Jan-Mar</th>
                        <th colspan="3">Apr-Jun</th>
                        <th colspan="3">Jul-Sep</th>
                        <th colspan="3">Oct-Dec</th>
                        <th colspan="3">Total</th>
                        <th>Graph</th>
                    </tr>
                    <tr>
                        <th class="fixed-side"></th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="fixed-side" style="text-align: left; color: #da291c;"><b>Revenue</b></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>
                    <?php
                                                        foreach($revenue as $value){
                                                        ?>
                    <tr class="odd gradeX">
                        <td class="fixed-side"><?= $value->name ?></td>
                        <td><?= $value->janmar ?></td>
                        <td><?php echo $actual_janmar =HomeController::getjanmaractual($value->name); ?></td>
                        <td><?= ($value->janmar - $actual_janmar) ?></td>
                        <td><?= $value->aprjun ?></td>
                        <td><?php echo $actual_aprjun = HomeController::getaprjunactual($value->name); ?></td>
                        <td><?= ($value->aprjun - $actual_aprjun) ?></td>
                        <td><?= $value->julsep ?></td>
                        <td><?php echo $actual_julsep = HomeController::getjulsepactual($value->name); ?></td>
                        <td><?= ($value->julsep - $actual_julsep) ?></td>
                        <td><?= $value->octdec ?></td>
                        <td><?php echo $actual_octdec = HomeController::getoctdecactual($value->name); ?></td>
                        <td><?= ($value->octdec - $actual_octdec) ?></td>

                        <td> <?= $tot = ($value->janmar + $value->aprjun + $value->julsep + $value->octdec) ?></td>
                        <td><?php echo $actual_total =HomeController::gettotalactual($value->name); ?></td>
                        <td><?= ($tot-$actual_total) ?></td>
                        <td>
                            <a href="<?php echo  url('revenue_variance_quarterly_graph')."/".$value->name ?>"><i
                                    class="fa fa-bar-chart"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                    <tr class="total-tr">
                        <td class="fixed-side" style=""><b>Total Revenue</b></td>
                        <td><?= $janmartotal ?></td>
                        <td><?= $janmartotalactual ?></td>
                        <td><?= ($janmartotal-$janmartotalactual) ?></td>
                        <td><?= $aprjuntotal ?></td>
                        <td><?= $aprjuntotalactual ?></td>
                        <td><?= ($aprjuntotal-$aprjuntotalactual) ?></td>
                        <td><?= $julseptotal ?></td>
                        <td><?= $julseptotalactual ?></td>
                        <td><?= ($julseptotal-$julseptotalactual) ?></td>
                        <td><?= $octdectotal ?></td>
                        <td><?= $octdectotalactual ?></td>
                        <td><?= ($octdectotal-$octdectotalactual) ?></td>
                        <td><?= $tott = ($janmartotal + $aprjuntotal + $julseptotal + $octdectotal) ?></td>
                        <td><?= $tott2 = ($janmartotalactual + $aprjuntotalactual + $julseptotalactual + $octdectotalactual) ?>
                        </td>
                        <td><?= ($tott - $tott2) ?></td>
                        <td>
                            <a href="<?php echo url('revenue_quarterly_vary_chart') ?>"><i
                                    class="fa fa-bar-chart"></i></a>
                        </td>
                    </tr>
                </tbody>
            </table>

            <?php $html=ob_get_clean();
        echo $html;

    }

    public function revenue_variance_monthly_graph(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['value'] = DB::table('revenue_account')->where('uid', $uid)->where('account_name', $request->id)->get();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }

        return view('revenue_variance_monthly_graph')->with($data);
    }
    public function revenue_variance_quarterly_graph(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['value'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', $request->id)->first();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('revenue_variance_quarterly_graph')->with($data);
    }
    public function revenue_variance_quarterly_graph2(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['value'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', $request->id)->first();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('revenue_variance_quarterly_graph')->with($data);
    }
    public function gross_revenue_chart(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['jangrosstotal2'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('jan');
        $data['febgrosstotal2'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('feb');
        $data['margrosstotal2'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('mar');
        $data['aprgrosstotal2'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('apr');
        $data['maygrosstotal2'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('may');
        $data['jungrosstotal2'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('jun');
        $data['julgrosstotal2'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('jul');
        $data['auggrosstotal2'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('aug');
        $data['sepgrosstotal2'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('sep');
        $data['octgrosstotal2'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('oct');
        $data['novgrosstotal2'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('nov');
        $data['decgrosstotal2'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('decem');
        $data['jangrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['febgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['margrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['aprgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['maygrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['jungrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['julgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['auggrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['sepgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['octgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['novgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['decgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('gross_revenue_chart')->with($data);
    }
    public function gross_quarter_revenue_chart(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmargrosstotal2'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('janmar');
        $data['aprjungrosstotal2'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('aprjun');
        $data['julsepgrosstotal2'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('julsep');
        $data['octdecgrosstotal2'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('octdec');
        $data['jangrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['febgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['margrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['aprgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['maygrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['jungrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['julgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['auggrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['sepgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['octgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['novgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['decgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['janmargrossactual'] = $data['jangrossactual'] + $data['febgrossactual'] + $data['margrossactual'];
        $data['aprjungrossactual'] = $data['aprgrossactual'] + $data['maygrossactual'] + $data['jungrossactual'];
        $data['julsepgrossactual'] = $data['julgrossactual'] + $data['auggrossactual'] + $data['sepgrossactual'];
        $data['octdecgrossactual'] = $data['octgrossactual'] + $data['novgrossactual'] + $data['decgrossactual'];
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('gross_quarter_revenue_chart')->with($data);
    }
    public function gross_quarter_revenue_chart2()
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmargrosstotal2'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('janmar');
        $data['aprjungrosstotal2'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('aprjun');
        $data['julsepgrosstotal2'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('julsep');
        $data['octdecgrosstotal2'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('octdec');
        $data['jangrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['febgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['margrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['aprgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['maygrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['jungrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['julgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['auggrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['sepgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['octgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['novgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['decgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['janmargrossactual'] = $data['jangrossactual'] + $data['febgrossactual'] + $data['margrossactual'];
        $data['aprjungrossactual'] = $data['aprgrossactual'] + $data['maygrossactual'] + $data['jungrossactual'];
        $data['julsepgrossactual'] = $data['julgrossactual'] + $data['auggrossactual'] + $data['sepgrossactual'];
        $data['octdecgrossactual'] = $data['octgrossactual'] + $data['novgrossactual'] + $data['decgrossactual'];
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('gross_quarter_revenue_chart')->with($data);
    }
    public function other_revenue_chart(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('jan');
        $data['febothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('feb');
        $data['marothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('mar');
        $data['aprothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('apr');
        $data['mayothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('may');
        $data['junothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('jun');
        $data['julothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('jul');
        $data['augothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('aug');
        $data['sepothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('sep');
        $data['octothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('oct');
        $data['novothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('nov');
        $data['decothrevenue'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('decem');
        $data['janotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->where('account_description', 'Other Revenue')->sum('bill');
        $data['febotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->where('account_description', 'Other Revenue')->sum('bill');
        $data['marotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->where('account_description', 'Other Revenue')->sum('bill');
        $data['aprotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->where('account_description', 'Other Revenue')->sum('bill');
        $data['mayotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->where('account_description', 'Other Revenue')->sum('bill');
        $data['junotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->where('account_description', 'Other Revenue')->sum('bill');
        $data['julotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->where('account_description', 'Other Revenue')->sum('bill');
        $data['augotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->where('account_description', 'Other Revenue')->sum('bill');
        $data['sepotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->where('account_description', 'Other Revenue')->sum('bill');
        $data['octotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->where('account_description', 'Other Revenue')->sum('bill');
        $data['novotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->where('account_description', 'Other Revenue')->sum('bill');
        $data['decotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->where('account_description', 'Other Revenue')->sum('bill');
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('other_revenue_chart')->with($data);
    }
    public function other_quarter_revenue_chart()
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmarothrevenue'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('janmar');
        $data['aprjunothrevenue'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('aprjun');
        $data['julsepothrevenue'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('julsep');
        $data['octdecothrevenue'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('octdec');
        $data['janotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->where('account_description', 'Other Revenue')->sum('bill');
        $data['febotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->where('account_description', 'Other Revenue')->sum('bill');
        $data['marotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->where('account_description', 'Other Revenue')->sum('bill');
        $data['aprotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->where('account_description', 'Other Revenue')->sum('bill');
        $data['mayotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->where('account_description', 'Other Revenue')->sum('bill');
        $data['junotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->where('account_description', 'Other Revenue')->sum('bill');
        $data['julotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->where('account_description', 'Other Revenue')->sum('bill');
        $data['augotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->where('account_description', 'Other Revenue')->sum('bill');
        $data['sepotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->where('account_description', 'Other Revenue')->sum('bill');
        $data['octotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->where('account_description', 'Other Revenue')->sum('bill');
        $data['novotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->where('account_description', 'Other Revenue')->sum('bill');
        $data['decotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->where('account_description', 'Other Revenue')->sum('bill');
        $data['janmarotherrevenue'] = $data['janotherrevenue'] + $data['febotherrevenue'] + $data['marotherrevenue'];
        $data['aprjunotherrevenue'] = $data['aprotherrevenue'] + $data['mayotherrevenue'] + $data['junotherrevenue'];
        $data['julsepotherrevenue'] = $data['julotherrevenue'] + $data['augotherrevenue'] + $data['sepotherrevenue'];
        $data['octdecotherrevenue'] = $data['octotherrevenue'] + $data['novotherrevenue'] + $data['decotherrevenue'];
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('other_quarter_revenue_chart')->with($data);
    }
    public function other_quarter_revenue_chart2()
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmarothrevenue'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('janmar');
        $data['aprjunothrevenue'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('aprjun');
        $data['julsepothrevenue'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('julsep');
        $data['octdecothrevenue'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('octdec');
        $data['janotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->where('account_description', 'Other Revenue')->sum('bill');
        $data['febotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->where('account_description', 'Other Revenue')->sum('bill');
        $data['marotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->where('account_description', 'Other Revenue')->sum('bill');
        $data['aprotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->where('account_description', 'Other Revenue')->sum('bill');
        $data['mayotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->where('account_description', 'Other Revenue')->sum('bill');
        $data['junotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->where('account_description', 'Other Revenue')->sum('bill');
        $data['julotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->where('account_description', 'Other Revenue')->sum('bill');
        $data['augotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->where('account_description', 'Other Revenue')->sum('bill');
        $data['sepotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->where('account_description', 'Other Revenue')->sum('bill');
        $data['octotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->where('account_description', 'Other Revenue')->sum('bill');
        $data['novotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->where('account_description', 'Other Revenue')->sum('bill');
        $data['decotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->where('account_description', 'Other Revenue')->sum('bill');
        $data['janmarotherrevenue'] = $data['janotherrevenue'] + $data['febotherrevenue'] + $data['marotherrevenue'];
        $data['aprjunotherrevenue'] = $data['aprotherrevenue'] + $data['mayotherrevenue'] + $data['junotherrevenue'];
        $data['julsepotherrevenue'] = $data['julotherrevenue'] + $data['augotherrevenue'] + $data['sepotherrevenue'];
        $data['octdecotherrevenue'] = $data['octotherrevenue'] + $data['novotherrevenue'] + $data['decotherrevenue'];
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('other_quarter_revenue_chart')->with($data);
    }
    public function gross_revenue_chart2(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['jangrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('jan');
        $data['febgrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('feb');
        $data['margrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('mar');
        $data['aprgrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('apr');
        $data['maygrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('may');
        $data['jungrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('jun');
        $data['julgrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('jul');
        $data['auggrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('aug');
        $data['sepgrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('sep');
        $data['octgrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('oct');
        $data['novgrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('nov');
        $data['decgrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('decem');
        $data['jangrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['febgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['margrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['aprgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['maygrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['jungrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['julgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['auggrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['sepgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['octgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['novgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['decgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('gross_revenue_chart')->with($data);
    }
    public function other_revenue_chart2(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('jan');
        $data['febothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('feb');
        $data['marothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('mar');
        $data['aprothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('apr');
        $data['mayothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('may');
        $data['junothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('jun');
        $data['julothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('jul');
        $data['augothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('aug');
        $data['sepothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('sep');
        $data['octothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('oct');
        $data['novothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('nov');
        $data['decothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('decem');
        $data['janotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->where('account_description', 'Other Revenue')->sum('bill');
        $data['febotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->where('account_description', 'Other Revenue')->sum('bill');
        $data['marotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->where('account_description', 'Other Revenue')->sum('bill');
        $data['aprotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->where('account_description', 'Other Revenue')->sum('bill');
        $data['mayotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->where('account_description', 'Other Revenue')->sum('bill');
        $data['junotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->where('account_description', 'Other Revenue')->sum('bill');
        $data['julotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->where('account_description', 'Other Revenue')->sum('bill');
        $data['augotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->where('account_description', 'Other Revenue')->sum('bill');
        $data['sepotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->where('account_description', 'Other Revenue')->sum('bill');
        $data['octotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->where('account_description', 'Other Revenue')->sum('bill');
        $data['novotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->where('account_description', 'Other Revenue')->sum('bill');
        $data['decotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->where('account_description', 'Other Revenue')->sum('bill');
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('other_revenue_chart')->with($data);
    }
    public function expense_variance_monthly_graph(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['value'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', $request->id)->first();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('expense_variance_monthly_graph')->with($data);
    }
    public function expense_variance_quarterly_graph(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['value'] = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', $request->id)->first();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('expense_variance_quarterly_graph')->with($data);
    }
    public function expense_variance_quarterly_graph2(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['value'] = DB::table('expense_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', $request->id)->first();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('expense_variance_quarterly_graph')->with($data);
    }
    public function revenue_variance_monthly_graph2(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['value'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', $request->id)->first();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('revenue_variance_monthly_graph2')->with($data);
    }
    public function expense_variance_monthly_graph2(Request $request)
    {
        //\LogActivity::addToLog('visited profile','view',Auth::user());
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['value'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', $request->id)->first();
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('expense_variance_monthly_graph2')->with($data);
    }
    public function projection_monthly_vary_chart()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
         $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['jantotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jan');
        $data['febtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('feb');
        $data['martotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('mar');
        $data['aprtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('apr');
        $data['maytotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('may');
        $data['juntotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jun');
        $data['jultotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jul');
        $data['augtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aug');
        $data['septotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('sep');
        $data['octtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('oct');
        $data['novtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('nov');
        $data['dectotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('decem');
        $data['jantotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['febtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['martotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['aprtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['maytotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['juntotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['jultotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['augtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['septotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['octtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['novtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['dectotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('projection_monthly_vary_chart')->with($data);
    }
    public function projectionexp_monthly_vary_chart()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['jantotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jan');
        $data['febtotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('feb');
        $data['martotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('mar');
        $data['aprtotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('apr');
        $data['maytotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('may');
        $data['juntotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jun');
        $data['jultotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jul');
        $data['augtotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aug');
        $data['septotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('sep');
        $data['octtotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('oct');
        $data['novtotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('nov');
        $data['dectotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('decem');
        $data['jantotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['febtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['martotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['aprtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['maytotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['juntotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['jultotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['augtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['septotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['octtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['novtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['dectotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('projectionexp_monthly_vary_chart')->with($data);
    }
    public function all_revenue_chart()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['jantotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jan');
        $data['febtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('feb');
        $data['martotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('mar');
        $data['aprtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('apr');
        $data['maytotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('may');
        $data['juntotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jun');
        $data['jultotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jul');
        $data['augtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aug');
        $data['septotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('sep');
        $data['octtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('oct');
        $data['novtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('nov');
        $data['dectotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('decem');
        $data['jantotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->sum('bill');
        $data['febtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->sum('bill');
        $data['martotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->sum('bill');
        $data['aprtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->sum('bill');
        $data['maytotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->sum('bill');
        $data['juntotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->sum('bill');
        $data['jultotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->sum('bill');
        $data['augtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->sum('bill');
        $data['septotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->sum('bill');
        $data['octtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->sum('bill');
        $data['novtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->sum('bill');
        $data['dectotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->sum('bill');
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('all_revenue_chart')->with($data);
    }

    public function est_chart()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();





        $data['jantotalactual5'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['febtotalactual5'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['martotalactual5'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['aprtotalactual5'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['maytotalactual5'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['juntotalactual5'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['jultotalactual5'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['augtotalactual5'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['septotalactual5'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['octtotalactual5'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['novtotalactual5'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['dectotalactual5'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');


        $data['jantotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jan');
        $data['febtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('feb');
        $data['martotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('mar');
        $data['aprtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('apr');
        $data['maytotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('may');
        $data['juntotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jun');
        $data['jultotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jul');
        $data['augtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aug');
        $data['septotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('sep');
        $data['octtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('oct');
        $data['novtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('nov');
        $data['dectotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('decem');
        $data['jantotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->sum('amount_paid') - $data['jantotalactual5'];
        $data['febtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->sum('amount_paid') - $data['febtotalactual5'];
        $data['martotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->sum('amount_paid') - $data['martotalactual5'];
        $data['aprtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->sum('amount_paid') - $data['aprtotalactual5'];
        $data['maytotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->sum('amount_paid') - $data['maytotalactual5'];
        $data['juntotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->sum('amount_paid') - $data['juntotalactual5'];
        $data['jultotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->sum('amount_paid') - $data['jultotalactual5'];
        $data['augtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->sum('amount_paid') - $data['augtotalactual5'];
        $data['septotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->sum('amount_paid') - $data['septotalactual5'];
        $data['octtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->sum('amount_paid') - $data['octtotalactual5'];
        $data['novtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->sum('amount_paid') - $data['novtotalactual5'];
        $data['dectotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->sum('amount_paid') - $data['dectotalactual5'];
        $data['chat'] = "";
        $data['tools'] = "";


        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('est')->with($data);
    }
    public function all_quarter_revenue_chart()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmartotal'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('janmar');
        $data['aprjuntotal'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aprjun');
        $data['julseptotal'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('julsep');
        $data['octdectotal'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('octdec');
        $data['jantotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->sum('bill');
        $data['febtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->sum('bill');
        $data['martotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->sum('bill');
        $data['aprtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->sum('bill');
        $data['maytotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->sum('bill');
        $data['juntotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->sum('bill');
        $data['jultotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->sum('bill');
        $data['augtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->sum('bill');
        $data['septotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->sum('bill');
        $data['octtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->sum('bill');
        $data['novtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->sum('bill');
        $data['dectotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->sum('bill');
        $data['janmartotalactual'] = $data['jantotalactual'] + $data['febtotalactual'] + $data['martotalactual'];
        $data['aprjuntotalactual'] = $data['aprtotalactual'] + $data['maytotalactual'] + $data['juntotalactual'];
        $data['julseptotalactual'] = $data['jultotalactual'] + $data['augtotalactual'] + $data['septotalactual'];
        $data['octdectotalactual'] = $data['octtotalactual'] + $data['novtotalactual'] + $data['dectotalactual'];
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('all_quarter_revenue_chart')->with($data);
    }
    public function all_quarter_revenue_chart2()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmartotal'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('janmar');
        $data['aprjuntotal'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aprjun');
        $data['julseptotal'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('julsep');
        $data['octdectotal'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('octdec');
        $data['jantotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->sum('bill');
        $data['febtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->sum('bill');
        $data['martotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->sum('bill');
        $data['aprtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->sum('bill');
        $data['maytotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->sum('bill');
        $data['juntotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->sum('bill');
        $data['jultotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->sum('bill');
        $data['augtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->sum('bill');
        $data['septotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->sum('bill');
        $data['octtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->sum('bill');
        $data['novtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->sum('bill');
        $data['dectotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->sum('bill');
        $data['janmartotalactual'] = $data['jantotalactual'] + $data['febtotalactual'] + $data['martotalactual'];
        $data['aprjuntotalactual'] = $data['aprtotalactual'] + $data['maytotalactual'] + $data['juntotalactual'];
        $data['julseptotalactual'] = $data['jultotalactual'] + $data['augtotalactual'] + $data['septotalactual'];
        $data['octdectotalactual'] = $data['octtotalactual'] + $data['novtotalactual'] + $data['dectotalactual'];
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('all_quarter_revenue_chart')->with($data);
    }
    public function all_revenue_chart2()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['jantotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jan');
        $data['febtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('feb');
        $data['martotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('mar');
        $data['aprtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('apr');
        $data['maytotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('may');
        $data['juntotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jun');
        $data['jultotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jul');
        $data['augtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aug');
        $data['septotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('sep');
        $data['octtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('oct');
        $data['novtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('nov');
        $data['dectotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('decem');
        $data['jantotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->sum('bill');
        $data['febtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->sum('bill');
        $data['martotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->sum('bill');
        $data['aprtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->sum('bill');
        $data['maytotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->sum('bill');
        $data['juntotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->sum('bill');
        $data['jultotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->sum('bill');
        $data['augtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->sum('bill');
        $data['septotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->sum('bill');
        $data['octtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->sum('bill');
        $data['novtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->sum('bill');
        $data['dectotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->sum('bill');
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('all_revenue_chart')->with($data);
    }
    public function revenue_monthly_vary_chart()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['jantotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jan');
        $data['febtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('feb');
        $data['martotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('mar');
        $data['aprtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('apr');
        $data['maytotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('may');
        $data['juntotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jun');
        $data['jultotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jul');
        $data['augtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aug');
        $data['septotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('sep');
        $data['octtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('oct');
        $data['novtotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('nov');
        $data['dectotal'] = DB::table('revenue_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('decem');
        $data['jantotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['febtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['martotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['aprtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['maytotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['juntotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['jultotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['augtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['septotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['octtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['novtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['dectotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('revenue_monthly_vary_chart')->with($data);
    }
    public function revenue_quarterly_vary_chart()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmartotal'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('janmar');
        $data['aprjuntotal'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aprjun');
        $data['julseptotal'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('julsep');
        $data['octdectotal'] = DB::table('revenue_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('octdec');
        $data['jantotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['febtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['martotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['aprtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['maytotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['juntotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['jultotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['augtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['septotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['octtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['novtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['dectotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['janmartotalactual'] = $data['jantotalactual'] + $data['febtotalactual'] + $data['martotalactual'];
        $data['aprjuntotalactual'] = $data['aprtotalactual'] + $data['maytotalactual'] + $data['juntotalactual'];
        $data['julseptotalactual'] = $data['jultotalactual'] + $data['augtotalactual'] + $data['septotalactual'];
        $data['octdectotalactual'] = $data['octtotalactual'] + $data['novtotalactual'] + $data['dectotalactual'];
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('revenue_quarterly_vary_chart')->with($data);
    }
    public function revenue_quarterly_vary_chart2()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmartotal'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('janmar');
        $data['aprjuntotal'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aprjun');
        $data['julseptotal'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('julsep');
        $data['octdectotal'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('octdec');
        $data['jantotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['febtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['martotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['aprtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['maytotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['juntotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['jultotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['augtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['septotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['octtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['novtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['dectotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['janmartotalactual'] = $data['jantotalactual'] + $data['febtotalactual'] + $data['martotalactual'];
        $data['aprjuntotalactual'] = $data['aprtotalactual'] + $data['maytotalactual'] + $data['juntotalactual'];
        $data['julseptotalactual'] = $data['jultotalactual'] + $data['augtotalactual'] + $data['septotalactual'];
        $data['octdectotalactual'] = $data['octtotalactual'] + $data['novtotalactual'] + $data['dectotalactual'];
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('revenue_quarterly_vary_chart')->with($data);
    }
    public function expense_monthly_vary_chart()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['jantotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jan');
        $data['febtotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('feb');
        $data['martotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('mar');
        $data['aprtotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('apr');
        $data['maytotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('may');
        $data['juntotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jun');
        $data['jultotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jul');
        $data['augtotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aug');
        $data['septotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('sep');
        $data['octtotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('oct');
        $data['novtotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('nov');
        $data['dectotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('decem');
        $data['jantotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['febtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['martotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['aprtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['maytotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['juntotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['jultotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['augtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['septotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['octtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['novtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['dectotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('expense_monthly_vary_chart')->with($data);
    }
    public function expense_quarterly_vary_chart()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmartotal'] = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('janmar');
        $data['aprjuntotal'] = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aprjun');
        $data['julseptotal'] = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('julsep');
        $data['octdectotal'] = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('octdec');
        $data['jantotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['febtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['martotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['aprtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['maytotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['juntotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['jultotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['augtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['septotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['octtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['novtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['dectotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['janmartotalactual'] = $data['jantotalactual'] + $data['febtotalactual'] + $data['martotalactual'];
        $data['aprjuntotalactual'] = $data['aprtotalactual'] + $data['maytotalactual'] + $data['juntotalactual'];
        $data['julseptotalactual'] = $data['jultotalactual'] + $data['augtotalactual'] + $data['septotalactual'];
        $data['octdectotalactual'] = $data['octtotalactual'] + $data['novtotalactual'] + $data['dectotalactual'];
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('expense_quarterly_vary_chart')->with($data);
    }
    public function expense_quarterly_vary_chart2()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['janmartotal'] = DB::table('expense_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('janmar');
        $data['aprjuntotal'] = DB::table('expense_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aprjun');
        $data['julseptotal'] = DB::table('expense_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('julsep');
        $data['octdectotal'] = DB::table('expense_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('octdec');
        $data['jantotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['febtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['martotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['aprtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['maytotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['juntotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['jultotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['augtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['septotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['octtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['novtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['dectotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->where('account_description', '!=', 'Other Revenue')->sum('amount_paid');
        $data['janmartotalactual'] = $data['jantotalactual'] + $data['febtotalactual'] + $data['martotalactual'];
        $data['aprjuntotalactual'] = $data['aprtotalactual'] + $data['maytotalactual'] + $data['juntotalactual'];
        $data['julseptotalactual'] = $data['jultotalactual'] + $data['augtotalactual'] + $data['septotalactual'];
        $data['octdectotalactual'] = $data['octtotalactual'] + $data['novtotalactual'] + $data['dectotalactual'];
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        return view('expense_quarterly_vary_chart')->with($data);
    }
    public function tab5()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
         $data['revenue'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->get();
        $data['jantotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jan');
        $data['febtotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('feb');
        $data['martotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('mar');
        $data['aprtotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('apr');
        $data['maytotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('may');
        $data['juntotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jun');
        $data['jultotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jul');
        $data['augtotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aug');
        $data['septotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('sep');
        $data['octtotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('oct');
        $data['novtotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('nov');
        $data['dectotal'] = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('decem');
        $data['monthtotal'] = $data['jantotal'] + $data['febtotal'] + $data['martotal'] + $data['aprtotal'] + $data['maytotal'] + $data['juntotal'] + $data['jultotal'] + $data['augtotal'] + $data['septotal'] + $data['octtotal'] + $data['novtotal'] + $data['dectotal'];
        $data['jantotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->sum('amount_paid');
        $data['febtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->sum('amount_paid');
        $data['martotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->sum('amount_paid');
        $data['aprtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->sum('amount_paid');
        $data['maytotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->sum('amount_paid');
        $data['juntotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->sum('amount_paid');
        $data['jultotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->sum('amount_paid');
        $data['augtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->sum('amount_paid');
        $data['septotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->sum('amount_paid');
        $data['octtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->sum('amount_paid');
        $data['novtotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->sum('amount_paid');
        $data['dectotalactual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->sum('amount_paid');
        $data['monthtotalactual'] = $data['jantotalactual'] + $data['febtotalactual'] + $data['martotalactual'] + $data['aprtotalactual'] + $data['maytotalactual'] + $data['juntotalactual'] + $data['jultotalactual'] + $data['augtotalactual'] + $data['septotalactual'] + $data['octtotalactual'] + $data['novtotalactual'] + $data['dectotalactual'];
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }

        $data['years'] = [];
        for($i = 0; $i < 10; $i++){
            $lastYear = date("Y", strtotime("-$i years"));
            if($lastYear > 2019){
                array_push($data['years'], $lastYear);
            }
        }
        return view('tab5')->with($data);
    }


    public function tab5_year(Request $request)
    {
        $year=$request->year;
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status']=$status = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links']=$links = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos']=$top_videos = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner']=$aabanner = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners']=$top_banners = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime']=$slidetime = DB::table('carouselplaytime')->where('id', 1)->get();
         $data['revenue']=$revenue = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->get();
        $data['jantotal']=$jantotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('jan');
        $data['febtotal']=$febtotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('feb');
        $data['martotal']=$martotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('mar');
        $data['aprtotal']=$aprtotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('apr');
        $data['maytotal']=$maytotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('may');
        $data['juntotal']=$juntotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('jun');
        $data['jultotal']=$jultotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('jul');
        $data['augtotal']=$augtotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('aug');
        $data['septotal']=$septotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('sep');
        $data['octtotal']=$octtotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at',$year)->sum('oct');
        $data['novtotal']=$novtotal = DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('nov');
        $data['dectotal'] =$dectotal= DB::table('expense_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('decem');
        $data['monthtotal'] =$monthtotal= $data['jantotal'] + $data['febtotal'] + $data['martotal'] + $data['aprtotal'] + $data['maytotal'] + $data['juntotal'] + $data['jultotal'] + $data['augtotal'] + $data['septotal'] + $data['octtotal'] + $data['novtotal'] + $data['dectotal'];
        $data['jantotalactual'] =$jantotalactual= DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '01')->sum('amount_paid');
        $data['febtotalactual'] =$febtotalactual= DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '02')->sum('amount_paid');
        $data['martotalactual'] =$martotalactual= DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date',$year)->whereMonth('transaction_date', '03')->sum('amount_paid');
        $data['aprtotalactual'] =$aprtotalactual= DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '04')->sum('amount_paid');
        $data['maytotalactual'] =$maytotalactual= DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '05')->sum('amount_paid');
        $data['juntotalactual'] =$juntotalactual= DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '06')->sum('amount_paid');
        $data['jultotalactual'] =$jultotalactual= DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '07')->sum('amount_paid');
        $data['augtotalactual'] =$augtotalactual= DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '08')->sum('amount_paid');
        $data['septotalactual'] =$septotalactual= DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '09')->sum('amount_paid');
        $data['octtotalactual'] =$octtotalactual= DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '10')->sum('amount_paid');
        $data['novtotalactual'] =$novtotalactual= DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '11')->sum('amount_paid');
        $data['dectotalactual'] =$dectotalactual= DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '12')->sum('amount_paid');
        $data['monthtotalactual'] =$monthtotalactual= $data['jantotalactual'] + $data['febtotalactual'] + $data['martotalactual'] + $data['aprtotalactual'] + $data['maytotalactual'] + $data['juntotalactual'] + $data['jultotalactual'] + $data['augtotalactual'] + $data['septotalactual'] + $data['octtotalactual'] + $data['novtotalactual'] + $data['dectotalactual'];
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] =$chat= "on";
            }
            else{
                $data['chat'] =$chat= "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] =$tools= "on";
            }
            else{
                $data['tools'] =$tools= "off";
            }
        }

        ob_start();
               ?>
            <table class="table table-striped table-bordered table-hover main-table" id="">
                <thead>
                    <tr class="top-tr">
                        <th class="fixed-side"></th>
                        <th colspan="3">Jan</th>
                        <th colspan="3">Feb</th>
                        <th colspan="3">Mar</th>
                        <th colspan="3">Apr</th>
                        <th colspan="3">May</th>
                        <th colspan="3">Jun</th>
                        <th colspan="3">Jul</th>
                        <th colspan="3">Aug</th>
                        <th colspan="3">Sep</th>
                        <th colspan="3">Oct</th>
                        <th colspan="3">Nov</th>
                        <th colspan="3">Dec</th>
                        <th colspan="3">Total</th>
                        <th>Graph</th>
                    </tr>
                    <tr>
                        <th class="fixed-side"></th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th>Budget</th>
                        <th>Actual</th>
                        <th>Variance</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="fixed-side" style="text-align: left; color: #da291c;"><b>Expenses</b></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>
                    <?php
                                                        foreach($revenue as $value){
                                                        ?>
                    <tr class="odd gradeX">
                        <td class="fixed-side"><?= $value->name ?></td>
                        <td><?= $value->jan ?></td>
                        <td><?php echo $actual_jan = HomeController::getjanactualexp($value->name); ?></td>
                        <td><?= ($value->jan - $actual_jan) ?></td>
                        <td><?= $value->feb ?></td>
                        <td><?php echo $actual_feb = HomeController::getfebactualexp($value->name); ?></td>
                        <td><?= ($value->feb - $actual_feb) ?></td>
                        <td><?= $value->mar ?></td>
                        <td><?php echo $actual_mar = HomeController::getmaractualexp($value->name); ?></td>
                        <td><?= ($value->mar - $actual_mar) ?></td>
                        <td><?= $value->apr ?></td>
                        <td><?php echo $actual_apr = HomeController::getapractualexp($value->name); ?></td>
                        <td><?= ($value->apr - $actual_apr) ?></td>
                        <td><?= $value->may ?></td>
                        <td><?php echo $actual_may = HomeController::getmayactualexp($value->name); ?></td>
                        <td><?= ($value->may - $actual_may) ?></td>
                        <td><?= $value->jun ?></td>
                        <td><?php echo $actual_jun = HomeController::getjunactualexp($value->name); ?></td>
                        <td><?= ($value->jun - $actual_jun) ?></td>
                        <td><?= $value->jul ?></td>
                        <td><?php echo $actual_jul =HomeController::getjulactualexp($value->name); ?></td>
                        <td><?= ($value->jul - $actual_jul) ?></td>
                        <td><?= $value->aug ?></td>
                        <td><?php echo $actual_aug = HomeController::getaugactualexp($value->name); ?></td>
                        <td><?= ($value->aug - $actual_aug) ?></td>
                        <td><?= $value->sep ?></td>
                        <td><?php echo $actual_sep =HomeController::getsepactualexp($value->name); ?></td>
                        <td><?= ($value->sep - $actual_sep) ?></td>
                        <td><?= $value->oct ?></td>
                        <td><?php echo $actual_oct = HomeController::getoctactualexp($value->name); ?></td>
                        <td><?= ($value->oct - $actual_oct) ?></td>
                        <td><?= $value->nov ?></td>
                        <td><?php echo $actual_nov = HomeController::getnovactualexp($value->name); ?></td>
                        <td><?= ($value->nov - $actual_nov) ?></td>
                        <td><?= $value->decem ?></td>
                        <td><?php echo $actual_decem = HomeController::getdecemactualexp($value->name); ?></td>
                        <td><?= ($value->decem - $actual_decem) ?></td>
                        <td> <?= $tot = ($value->jan + $value->feb + $value->mar + $value->apr + $value->may + $value->jun + $value->jul + $value->aug + $value->sep + $value->oct + $value->nov + $value->decem) ?>
                        </td>
                        <td><?php echo $actual_total = HomeController::gettotalactualexp($value->name); ?></td>
                        <td><?= ($tot-$actual_total) ?></td>
                        <td>
                            <a href="<?php echo  url('expense_variance_monthly_graph') ."/".$value->name ?>"><i
                                    class="fa fa-bar-chart"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                    <tr class="total-tr">
                        <td class="fixed-side" style=""><b>Total Expenses</b></td>
                        <td><?= $jantotal ?></td>
                        <td><?= $jantotalactual ?></td>
                        <td><?= ($jantotal-$jantotalactual) ?></td>
                        <td><?= $febtotal ?></td>
                        <td><?= $febtotalactual ?></td>
                        <td><?= ($febtotal-$febtotalactual) ?></td>
                        <td><?= $martotal ?></td>
                        <td><?= $martotalactual ?></td>
                        <td><?= ($martotal-$martotalactual) ?></td>
                        <td><?= $aprtotal ?></td>
                        <td><?= $aprtotalactual ?></td>
                        <td><?= ($aprtotal-$aprtotalactual) ?></td>
                        <td><?= $maytotal ?></td>
                        <td><?= $maytotalactual ?></td>
                        <td><?= ($maytotal-$maytotalactual) ?></td>
                        <td><?= $juntotal ?></td>
                        <td><?= $juntotalactual ?></td>
                        <td><?= ($juntotal-$juntotalactual) ?></td>
                        <td><?= $jultotal ?></td>
                        <td><?= $jultotalactual ?></td>
                        <td><?= ($jultotal-$jultotalactual) ?></td>
                        <td><?= $augtotal ?></td>
                        <td><?= $augtotalactual ?></td>
                        <td><?= ($augtotal-$augtotalactual) ?></td>
                        <td><?= $septotal ?></td>
                        <td><?= $septotalactual ?></td>
                        <td><?= ($septotal-$septotalactual) ?></td>
                        <td><?= $octtotal ?></td>
                        <td><?= $octtotalactual ?></td>
                        <td><?= ($octtotal-$octtotalactual) ?></td>
                        <td><?= $novtotal ?></td>
                        <td><?= $novtotalactual ?></td>
                        <td><?= ($novtotal-$novtotalactual) ?></td>
                        <td><?= $dectotal ?></td>
                        <td><?= $dectotalactual ?></td>
                        <td><?= ($dectotal-$dectotalactual) ?></td>
                        <td><?= $tott = ($jantotal + $febtotal + $martotal + $aprtotal + $maytotal + $juntotal + $jultotal + $augtotal + $septotal + $octtotal + $novtotal + $dectotal) ?>
                        </td>
                        <td><?= $tott2 = ($jantotalactual + $febtotalactual + $martotalactual + $aprtotalactual + $maytotalactual + $juntotalactual + $jultotalactual + $augtotalactual + $septotalactual + $octtotalactual + $novtotalactual + $dectotalactual) ?>
                        </td>
                        <td><?= ($tott - $tott2) ?></td>
                        <td>
                            <a href="<?php echo  url('expense_monthly_vary_chart') ?>"><i
                                    class="fa fa-bar-chart"></i></a>
                        </td>
                    </tr>
                </tbody>
            </table>
            <?php $html=ob_get_clean();
        echo $html;

    }


public function tab5_quaterly_year(Request $request)
    {
        $year=$request->year;
if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] =$status= DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] =$links= Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] =$top_videos= HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner']=$aabanner = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners']=$top_banners = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime']=$slidetime = DB::table('carouselplaytime')->where('id', 1)->get();
         $data['revenue']=$revenue = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->get();
        $data['janmartotal']=$janmartotal = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('janmar');
        $data['aprjuntotal']=$aprjuntotal = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('aprjun');
        $data['julseptotal']=$julseptotal = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('julsep');
        $data['octdectotal']=$octdectotal = DB::table('expense_quaterly_budget')->where('uid', $uid)->whereYear('created_at', $year)->sum('octdec');
        $data['monthtotal']=$monthtotal = $data['janmartotal'] + $data['aprjuntotal'] + $data['julseptotal'] + $data['octdectotal'];
        $data['jantotalactual']=$jantotalactual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date',$year)->whereMonth('transaction_date', '01')->sum('amount_paid');
        $data['febtotalactual']=$febtotalactual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '02')->sum('amount_paid');
        $data['martotalactual']=$martotalactual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '03')->sum('amount_paid');
        $data['aprtotalactual']=$aprtotalactual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '04')->sum('amount_paid');
        $data['maytotalactual']=$maytotalactual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '05')->sum('amount_paid');
        $data['juntotalactual']=$juntotalactual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '06')->sum('amount_paid');
        $data['jultotalactual']=$jultotalactual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date',$year)->whereMonth('transaction_date', '07')->sum('amount_paid');
        $data['augtotalactual']=$augtotalactual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '08')->sum('amount_paid');
        $data['septotalactual']=$septotalactual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '09')->sum('amount_paid');
        $data['octtotalactual']=$octtotalactual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '10')->sum('amount_paid');
        $data['novtotalactual']=$novtotalactual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '11')->sum('amount_paid');
        $data['dectotalactual']=$dectotalactual = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '12')->sum('amount_paid');
        $data['janmartotalactual']=$janmartotalactual = $data['jantotalactual'] + $data['febtotalactual'] + $data['martotalactual'];
        $data['aprjuntotalactual']=$aprjuntotalactual = $data['aprtotalactual'] + $data['maytotalactual'] + $data['juntotalactual'];
        $data['julseptotalactual']=$julseptotalactual = $data['jultotalactual'] + $data['augtotalactual'] + $data['septotalactual'];
        $data['octdectotalactual']=$octdectotalactual = $data['octtotalactual'] + $data['novtotalactual'] + $data['dectotalactual'];
        $data['monthtotalactual']=$monthtotalactual = $data['janmartotalactual'] + $data['aprjuntotalactual'] + $data['julseptotalactual'] + $data['octdectotalactual'];
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat']=$chat = "on";
            }
            else{
                $data['chat']=$chat = "off";
            }
            if($cdet->tools == "on"){
                $data['tools']=$tools = "on";
            }
            else{
                $data['tools']=$tools = "off";
            }
        }

        ob_start();
               ?>
            <div class="table-wrap">
                <table class="table table-striped table-bordered table-hover main-table" id="">
                    <thead>
                        <tr class="top-tr">
                            <th class="fixed-side"></th>
                            <th colspan="3">Jan - Mar</th>
                            <th colspan="3">Apr - Jun</th>
                            <th colspan="3">Jul - Sep</th>
                            <th colspan="3">Oct - Dec</th>
                            <th colspan="3">Total</th>
                            <th>Graph</th>
                        </tr>
                        <tr>
                            <th class="fixed-side"></th>
                            <th>Budget</th>
                            <th>Actual</th>
                            <th>Variance</th>
                            <th>Budget</th>
                            <th>Actual</th>
                            <th>Variance</th>
                            <th>Budget</th>
                            <th>Actual</th>
                            <th>Variance</th>
                            <th>Budget</th>
                            <th>Actual</th>
                            <th>Variance</th>
                            <th>Budget</th>
                            <th>Actual</th>
                            <th>Variance</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="fixed-side" style="text-align: left; color: #da291c;"><b>Expenses</b></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <?php
                                                        foreach($revenue as $value){
                                                        ?>
                        <tr class="odd gradeX">
                            <td class="fixed-side"><?= $value->name ?></td>
                            <td><?= $value->janmar ?></td>
                            <td><?php echo $actual_janmar =HomeController::getjanmaractualexp($value->name); ?></td>
                            <td><?= ($value->janmar - $actual_janmar) ?></td>
                            <td><?= $value->aprjun ?></td>
                            <td><?php echo $actual_aprjun =HomeController::getaprjunactualexp($value->name); ?></td>
                            <td><?= ($value->aprjun - $actual_aprjun) ?></td>
                            <td><?= $value->julsep ?></td>
                            <td><?php echo $actual_julsep =HomeController::getjulsepactualexp($value->name); ?></td>
                            <td><?= ($value->julsep - $actual_julsep) ?></td>
                            <td><?= $value->octdec ?></td>
                            <td><?php echo $actual_octdec = HomeController::getoctdecactualexp($value->name); ?></td>
                            <td><?= ($value->octdec - $actual_octdec) ?></td>

                            <td> <?= $tot = ($value->janmar + $value->aprjun + $value->julsep + $value->octdec) ?></td>
                            <td><?php echo $actual_total =HomeController::gettotalactualexp($value->name); ?></td>
                            <td><?= ($tot-$actual_total) ?></td>
                            <td>
                                <a href="<?php echo url('expense_variance_quarterly_graph') ."/".$value->name ?>"><i
                                        class="fa fa-bar-chart"></i></a>
                            </td>
                        </tr>
                        <?php } ?>
                        <tr class="total-tr">
                            <td class="fixed-side" style=""><b>Total Expenses</b></td>
                            <td><?= $janmartotal ?></td>
                            <td><?= $janmartotalactual ?></td>
                            <td><?= ($janmartotal-$janmartotalactual) ?></td>
                            <td><?= $aprjuntotal ?></td>
                            <td><?= $aprjuntotalactual ?></td>
                            <td><?= ($aprjuntotal-$aprjuntotalactual) ?></td>
                            <td><?= $julseptotal ?></td>
                            <td><?= $julseptotalactual ?></td>
                            <td><?= ($julseptotal-$julseptotalactual) ?></td>
                            <td><?= $octdectotal ?></td>
                            <td><?= $octdectotalactual ?></td>
                            <td><?= ($octdectotal-$octdectotalactual) ?></td>

                            <td><?= $tott = ($janmartotal + $aprjuntotal + $julseptotal + $octdectotal) ?></td>
                            <td><?= $tott2 = ($janmartotalactual + $aprjuntotalactual + $julseptotalactual + $octdectotalactual) ?>
                            </td>
                            <td><?= ($tott - $tott2) ?></td>
                            <td>
                                <a href="<?php echo  url('expense_quarterly_vary_chart') ?>"><i
                                        class="fa fa-bar-chart"></i></a>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <?php $html=ob_get_clean();
        echo $html;

    }

    public function create_projection()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['revenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->orderBy('id', 'desc')->get();
        if(count($data['revenue']) > 0){
            $data['revenue_count'] = $data['revenue'][0]->id;
        }else{
            $data['revenue_count'] = 0;
        }
        $data['jantotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jan');
        $data['febtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('feb');
        $data['martotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('mar');
        $data['aprtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('apr');
        $data['maytotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('may');
        $data['juntotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jun');
        $data['jultotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jul');
        $data['augtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aug');
        $data['septotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('sep');
        $data['octtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('oct');
        $data['novtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('nov');
        $data['dectotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('decem');
        $data['monthtotal'] = $data['jantotal'] + $data['febtotal'] + $data['martotal'] + $data['aprtotal'] + $data['maytotal'] + $data['juntotal'] + $data['jultotal'] + $data['augtotal'] + $data['septotal'] + $data['octtotal'] + $data['novtotal'] + $data['dectotal'];
        $data['revenue_quaterly'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->orderBy('id', 'desc')->get();
        if(count($data['revenue_quaterly']) > 0){
            $data['revenue_quaterly_count'] = $data['revenue_quaterly'][0]->id;
        }else{
            $data['revenue_quaterly_count'] = 0;
        }
        $data['janmartotal'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('janmar');
        $data['aprjuntotal'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aprjun');
        $data['julseptotal'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('julsep');
        $data['octdectotal'] = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('octdec');
        $data['quaterlytotal'] = $data['janmartotal'] + $data['aprjuntotal'] + $data['julseptotal'] + $data['octdectotal'];
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $data['years'] = [];
        for($i = 0; $i < 10; $i++){
            $lastYear = date("Y", strtotime("-$i years"));
            if($lastYear > 2019){
                array_push($data['years'], $lastYear);
            }
        }
        return view('create_projection')->with($data);
    }
    public function create_projection_year(Request $request){
        $year=$request->year;
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status']=$status = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links']=$links = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos']=$top_videos = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner']=$aabanner = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners']=$top_banners = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime']=$slidetime = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['revenue']=$revenue = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->orderBy('id', 'desc')->get();
        if(count($data['revenue']) > 0){
            $data['revenue_count']=$revenue_count = $data['revenue'][0]->id;
        }else{
            $data['revenue_count']=$revenue_count = 0;
        }
        $data['jantotal']=$jantotal = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('jan');
        $data['febtotal']=$febtotal = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('feb');
        $data['martotal']=$martotal = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('mar');
        $data['aprtotal']=$aprtotal = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('apr');
        $data['maytotal']=$maytotal = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('may');
        $data['juntotal']=$juntotal = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('jun');
        $data['jultotal']=$jultotal = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('jul');
        $data['augtotal']=$augtotal = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('aug');
        $data['septotal']=$septotal = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('sep');
        $data['octtotal']=$octtotal = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('oct');
        $data['novtotal'] =$novtotal= DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('nov');
        $data['dectotal'] =$dectotal= DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('decem');
        $data['monthtotal'] =$monthtotal= $data['jantotal'] + $data['febtotal'] + $data['martotal'] + $data['aprtotal'] + $data['maytotal'] + $data['juntotal'] + $data['jultotal'] + $data['augtotal'] + $data['septotal'] + $data['octtotal'] + $data['novtotal'] + $data['dectotal'];

        $data['chat']=$chat = "";
        $data['tools']=$tools = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat']=$chat = "on";
            }
            else{
                $data['chat']=$chat = "off";
            }
            if($cdet->tools == "on"){
                $data['tools']=$tools = "on";
            }
            else{
                $data['tools']=$tools = "off";
            }
        }
        ob_start();
        ?>
            <div class="table-wrap">

                <table class="table table-striped table-bordered table-hover main-table" id="">
                    <thead>
                        <tr>
                            <th class=""></th>
                            <th>Jan</th>
                            <th>Feb</th>
                            <th>Mar</th>
                            <th>Apr</th>
                            <th>May</th>
                            <th>Jun</th>
                            <th>Jul</th>
                            <th>Aug</th>
                            <th>Sep</th>
                            <th>Oct</th>
                            <th>Nov</th>
                            <th>Dec</th>
                            <th>Total</th>
                            <th>Graph</th>
                        </tr>
                        <tr>
                            <th class="">
                                <!-- <a href="javascript:void(0);" class="add_button" title="Add field">
                                                   <span class="glyphicon glyphicon-plus" style="text-align: center; color: white; font-size: 20px; font-weight: bold"></span>
                                                   </a> -->
                            </th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th></th>
                        </tr>
                    </thead>
                    <?php
                                       if(count($data['revenue']) > 0){
                                       ?>
                    <tbody class="field_wrapper">
                        <?php
                                          $currmon = date('m');
                                          $curryear=date('y');


                                             foreach ($revenue as $value) {

                                            if($curryear > date('y',strtotime($value->created_at))){
                                                $readonly="readonly";
                                                $disabled="disabled";
                                            }else{
                                                  $readonly="";
                                                    $disabled="";

                                                }
                                             ?>
                        <tr class="odd gradeX monthly" id="row<?= $value->id ?>">
                            <!-- <td class=""></td> -->
                            <td class="budget_name">
                                <!-- <select class="form-control" required disabled>
                                                   <option value="<?= $value->name ?>"><?= $value->name ?></option>
                                                   </select>
                                                   <p style="color: red; text-align: left; margin-bottom: 2px; display: none">*required</p> -->
                                <b style="padding: 0 10px" class="bname"><?= $value->name ?></b>
                            </td>
                            <td class="jan">
                                <input type="number" class="form-control" value="<?= $value->jan ?>"
                                    id="jan<?= $value->id ?>" <?php if($currmon >= "01"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="feb">
                                <input type="number" class="form-control" value="<?= $value->feb ?>"
                                    id="feb<?= $value->id ?>" <?php if($currmon >= "02"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="mar">
                                <input type="number" class="form-control" value="<?= $value->mar ?>"
                                    id="mar<?= $value->id ?>" <?php if($currmon >= "03"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="apr">
                                <input type="number" class="form-control" value="<?= $value->apr ?>"
                                    id="apr<?= $value->id ?>" <?php if($currmon >= "04"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="may">
                                <input type="number" class="form-control" value="<?= $value->may ?>"
                                    id="may<?= $value->id ?>" <?php if($currmon >= "05"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="jun">
                                <input type="number" class="form-control" value="<?= $value->jun ?>"
                                    id="jun<?= $value->id ?>" <?php if($currmon >= "06"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="jul">
                                <input type="number" class="form-control" value="<?= $value->jul ?>"
                                    id="jul<?= $value->id ?>" <?php if($currmon >= "07"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="aug">
                                <input type="number" class="form-control" value="<?= $value->aug ?>"
                                    id="aug<?= $value->id ?>" <?php if($currmon >= "08"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="sep">
                                <input type="number" class="form-control" value="<?= $value->sep ?>"
                                    id="sep<?= $value->id ?>" <?php if($currmon >= "09"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="oct">
                                <input type="number" class="form-control" value="<?= $value->oct ?>"
                                    id="oct<?= $value->id ?>" <?php if($currmon >= "10"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="nov">
                                <input type="number" class="form-control" value="<?= $value->nov ?>"
                                    id="nov<?= $value->id ?>" <?php if($currmon >= "11"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="dec">
                                <input type="number" class="form-control" value="<?= $value->decem ?>"
                                    id="dec<?= $value->id ?>" <?php if($currmon >= "12"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="budg_total">
                                <?= ($value->jan + $value->feb + $value->mar + $value->apr + $value->may + $value->jun + $value->jul + $value->aug + $value->sep + $value->oct + $value->nov + $value->decem) ?>
                            </td>
                            <td class="showgraph" id="showgraph<?= $value->id ?>">
                                <a href="<?php echo url('monthly_projection_chart')."/". $value->id ?>">
                                    <div id="bar-chart<?= $value->id ?>" style="height: 20px; width: 50px"></div>
                                </a>
                                <script type="text/javascript">
                                $(function() {
                                    "use strict";

                                    //BAR CHART
                                    var bar = new Morris.Bar({
                                        element: 'bar-chart<?= $value->id ?>',
                                        resize: true,
                                        data: [{
                                                y: '',
                                                a: <?= $value->jan ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->feb ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->mar ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->apr ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->may ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->jun ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->jul ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->aug ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->sep ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->oct ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->nov ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->decem ?>
                                            }
                                        ],
                                        barColors: ['#da291c'],
                                        xkey: 'y',
                                        ykeys: ['a'],
                                        labels: ['', ''],
                                        hideHover: 'auto',
                                        padding: 1,
                                    });
                                });
                                </script>
                            </td>
                        </tr>
                        <?php
                                             }
                                             ?>
                    </tbody>
                    <?php if($revenue_count == 0){ $style = "style='display:none'"; }else{ $style = "style=''"; } ?>
                    <tbody class="sectbody" <?= $style ?>>
                        <tr class="odd gradeX">
                            <!-- <td></td> -->
                            <td style="text-align:left; color:#da291c; padding: 10px; font-weight: bold">Total</td>
                            <td id="jantotal"><?= $jantotal ?></td>
                            <td id="febtotal"><?= $febtotal ?></td>
                            <td id="martotal"><?= $martotal ?></td>
                            <td id="aprtotal"><?= $aprtotal ?></td>
                            <td id="maytotal"><?= $maytotal ?></td>
                            <td id="juntotal"><?= $juntotal ?></td>
                            <td id="jultotal"><?= $jultotal ?></td>
                            <td id="augtotal"><?= $augtotal ?></td>
                            <td id="septotal"><?= $septotal ?></td>
                            <td id="octtotal"><?= $octtotal ?></td>
                            <td id="novtotal"><?= $novtotal ?></td>
                            <td id="dectotal"><?= $dectotal ?></td>
                            <td id="budget_total"><?= $monthtotal ?></td>
                            <td class="chart_monthly">
                                <a href="<?php echo url('total_monthly_projection_chart') ?>">
                                    <div id="bar-chart_total" style="height: 20px; width: 50px"></div>
                                </a>
                                <script type="text/javascript">
                                $(function() {
                                    "use strict";

                                    //BAR CHART
                                    var bar = new Morris.Bar({
                                        element: 'bar-chart_total',
                                        resize: true,
                                        data: [{
                                                y: '',
                                                a: <?= $jantotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $febtotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $martotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $aprtotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $maytotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $juntotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $jultotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $augtotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $septotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $octtotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $novtotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $dectotal ?>
                                            }
                                        ],
                                        barColors: ['#da291c'],
                                        xkey: 'y',
                                        ykeys: ['a'],
                                        labels: ['', ''],
                                        hideHover: 'auto',
                                        padding: 1,
                                    });
                                });
                                </script>
                            </td>
                        </tr>
                        <tr class="odd gradeX">
                            <!-- <td></td> -->
                            <td></td>
                            <td>
                                <a id="jansave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "01"){ ?> disabled
                                    <?php }else{ echo $disabled;} ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td>
                                <a id="febsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "02"){ ?> disabled
                                    <?php }else{ echo $disabled;} ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td>
                                <a id="marsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "03"){ ?> disabled
                                    <?php }else{ echo $disabled;} ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td>
                                <a id="aprsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "04"){ ?> disabled
                                    <?php }else{ echo $disabled;} ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td>
                                <a id="maysave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "05"){ ?> disabled
                                    <?php }else{ echo $disabled;} ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td>
                                <a id="junsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "06"){ ?> disabled
                                    <?php }else{ echo $disabled;} ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td>
                                <a id="julsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "07"){ ?> disabled
                                    <?php }else{ echo $disabled;} ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td>
                                <a id="augsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "08"){ ?> disabled
                                    <?php }else{ echo $disabled;} ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td>
                                <a id="sepsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "09"){ ?> disabled
                                    <?php }else{ echo $disabled;} ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td>
                                <a id="octsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "10"){ ?> disabled
                                    <?php }else{ echo $disabled;} ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td>
                                <a id="novsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "11"){ ?> disabled
                                    <?php }else{ echo $disabled;} ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td>
                                <a id="decsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "12"){ ?> disabled
                                    <?php }else{ echo $disabled;} ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td></td>
                            <td></td>
                        </tr>
                    </tbody>
                    <?php }else{
                                    ?>
                    <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td>No data found</td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>
                    <?php
                                   } ?>
                </table>
            </div>
            <?php
        $html=ob_get_clean();
        echo $html;
    }

    public function create_projection_quaterly_year(Request $request){
        $year=$request->year;
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status']=$status = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links']=$links = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos']=$top_videos = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner']=$aabanner = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners']=$top_banners = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime']=$slidetime = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['revenue_quaterly']=$revenue_quaterly = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', $year)->orderBy('id', 'desc')->get();
        if(count($data['revenue_quaterly']) > 0){
            $data['revenue_quaterly_count']=$revenue_quaterly_count = $data['revenue_quaterly'][0]->id;
        }else{
            $data['revenue_quaterly_count']=$revenue_quaterly_count = 0;
        }
        $data['janmartotal']=$janmartotal = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('janmar');
        $data['aprjuntotal']=$aprjuntotal = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('aprjun');
        $data['julseptotal']=$julseptotal = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('julsep');
        $data['octdectotal']=$octdectotal = DB::table('revenue_quaterly_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('octdec');
        $data['quaterlytotal']=$quaterlytotal = $data['janmartotal'] + $data['aprjuntotal'] + $data['julseptotal'] + $data['octdectotal'];
        $data['chat']=$chat = "";
        $data['tools']=$tools = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat']=$chat = "on";
            }
            else{
                $data['chat']=$chat = "off";
            }
            if($cdet->tools == "on"){
                $data['tools']=$tools = "on";
            }
            else{
                $data['tools']=$tools = "off";
            }
        }
        ob_start();
        ?>
            <table class="table table-striped table-bordered table-hover" id="">
                <thead>
                    <tr>
                        <th></th>
                        <th>Jan - Mar</th>
                        <th>Apr - Jun</th>
                        <th>Jul - Sep</th>
                        <th>Oct - Dec</th>
                        <th>Total</th>
                        <th>Graph</th>
                    </tr>
                    <tr>
                        <th></th>
                        <th>Budget</th>
                        <th>Budget</th>
                        <th>Budget</th>
                        <th>Budget</th>
                        <th>Budget</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody class="field_wrapper2">
                    <?php
        if(count($data['revenue_quaterly']) > 0){

                   foreach ($revenue_quaterly as $value) {
                   ?>
                    <tr class="odd gradeX quarterly" id="roww<?= $value->id ?>">
                        <td class="budget_name">
                            <b style="padding: 0 10px" class="bname"><?= $value->name ?></b>
                        </td>
                        <td class="janmar">
                            <input type="number" class="form-control" value="<?= $value->janmar ?>"
                                id="janmar<?= $value->id ?>" readonly>
                        </td>
                        <td class="aprjun">
                            <input type="number" class="form-control" value="<?= $value->aprjun ?>"
                                id="aprjun<?= $value->id ?>" readonly>
                        </td>
                        <td class="julsep">
                            <input type="number" class="form-control" value="<?= $value->julsep ?>"
                                id="julsep<?= $value->id ?>" readonly>
                        </td>
                        <td class="octdec">
                            <input type="number" class="form-control" value="<?= $value->octdec ?>"
                                id="octdec<?= $value->id ?>" readonly>
                        </td>
                        <td class="budg_total2">
                            <?= ($value->janmar + $value->aprjun + $value->julsep + $value->octdec) ?>
                        </td>
                        <td class="showgraphq" id="showgraphq<?= $value->id ?>">
                            <a href="<?php echo url('quarterly_projection_chart')."/".$value->id ?>">
                                <div id="bar-chartq<?= $value->id ?>" style="height: 20px; width: 30px"></div>
                            </a>
                            <script type="text/javascript">
                            $(function() {
                                "use strict";

                                //BAR CHART
                                var bar = new Morris.Bar({
                                    element: 'bar-chartq<?= $value->id ?>',
                                    resize: true,
                                    data: [{
                                            y: '',
                                            a: <?= $value->janmar ?>
                                        },
                                        {
                                            y: '',
                                            a: <?= $value->aprjun ?>
                                        },
                                        {
                                            y: '',
                                            a: <?= $value->julsep ?>
                                        },
                                        {
                                            y: '',
                                            a: <?= $value->octdec ?>
                                        }
                                    ],
                                    barColors: ['#da291c'],
                                    xkey: 'y',
                                    ykeys: ['a'],
                                    labels: ['', ''],
                                    hideHover: 'auto',
                                    padding: 1,
                                });
                            });
                            </script>
                        </td>
                    </tr>
                    <?php
                   }
                   ?>
                </tbody>
                <?php if($revenue_quaterly_count == 0){ $style2 = "style='display:none'"; }else{ $style2 = "style=''"; } ?>
                <tbody class="sectbody2" <?= $style2 ?>>
                    <tr class="odd gradeX">
                        <!-- <td></td> -->
                        <td style="text-align:left; color:#da291c; padding: 10px; font-weight: bold">Total</td>
                        <td id="janmartotal"><?= $janmartotal ?></td>
                        <td id="aprjuntotal"><?= $aprjuntotal ?></td>
                        <td id="julseptotal"><?= $julseptotal ?></td>
                        <td id="octdectotal"><?= $octdectotal ?></td>
                        <td id="budget_total"><?= $quaterlytotal ?></td>
                        <td class="chart_quarterly">
                            <a href="<?php url('total_quarterly_projection_chart') ?>">
                                <div id="bar-chart_totalq" style="height: 20px; width: 30px"></div>
                            </a>
                            <script type="text/javascript">
                            $(function() {
                                "use strict";

                                //BAR CHART
                                var bar = new Morris.Bar({
                                    element: 'bar-chart_totalq',
                                    resize: true,
                                    data: [{
                                            y: '',
                                            a: <?= $janmartotal ?>
                                        },
                                        {
                                            y: '',
                                            a: <?= $aprjuntotal ?>
                                        },
                                        {
                                            y: '',
                                            a: <?= $julseptotal ?>
                                        },
                                        {
                                            y: '',
                                            a: <?= $octdectotal ?>
                                        }
                                    ],
                                    barColors: ['#da291c'],
                                    xkey: 'y',
                                    ykeys: ['a'],
                                    labels: ['', ''],
                                    hideHover: 'auto',
                                    padding: 1,
                                });
                            });
                            </script>
                        </td>
                    </tr>
                    <?php }else{
                ?>
                    <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td>No data found</td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>
                    <?php
            } ?>
                </tbody>
            </table>
            <?php
        $html=ob_get_clean();
        echo $html;
    }
    public function tab22()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['revenue'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->orderBy('id', 'desc')->get();
        if(count($data['revenue']) > 0){
            $data['revenue_count'] = $data['revenue'][0]->id;
        }else{
            $data['revenue_count'] = 0;
        }
        $data['jantotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jan');
        $data['febtotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('feb');
        $data['martotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('mar');
        $data['aprtotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('apr');
        $data['maytotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('may');
        $data['juntotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jun');
        $data['jultotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jul');
        $data['augtotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aug');
        $data['septotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('sep');
        $data['octtotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('oct');
        $data['novtotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('nov');
        $data['dectotal'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('decem');
        $data['monthtotal'] = $data['jantotal'] + $data['febtotal'] + $data['martotal'] + $data['aprtotal'] + $data['maytotal'] + $data['juntotal'] + $data['jultotal'] + $data['augtotal'] + $data['septotal'] + $data['octtotal'] + $data['novtotal'] + $data['dectotal'];
        $data['revenue_quaterly'] = DB::table('expense_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->orderBy('id', 'desc')->get();
        if(count($data['revenue_quaterly']) > 0){
            $data['revenue_quaterly_count'] = $data['revenue_quaterly'][0]->id;
        }else{
            $data['revenue_quaterly_count'] = 0;
        }
        $data['janmartotal'] = DB::table('expense_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('janmar');
        $data['aprjuntotal'] = DB::table('expense_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aprjun');
        $data['julseptotal'] = DB::table('expense_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('julsep');
        $data['octdectotal'] = DB::table('expense_quaterly_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('octdec');
        $data['quaterlytotal'] = $data['janmartotal'] + $data['aprjuntotal'] + $data['julseptotal'] + $data['octdectotal'];
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $data['years'] = [];
        for($i = 0; $i < 10; $i++){
            $lastYear = date("Y", strtotime("-$i years"));
            if($lastYear > 2019){
                array_push($data['years'], $lastYear);
            }
        }
        return view('tab22')->with($data);
    }
    public function tab22_year(Request $request){
        $year=$request->year;
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status']=$status = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links']=$links = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos']=$top_videos = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner']=$aabanner = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners']=$top_banners = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime']=$slidetime = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['revenue']=$revenue = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', $year)->orderBy('id', 'desc')->get();
        if(count($data['revenue']) > 0){
            $data['revenue_count']=$revenue_count = $data['revenue'][0]->id;
        }else{
            $data['revenue_count']=$revenue_count = 0;
        }
        $data['jantotal']=$jantotal = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('jan');
        $data['febtotal']=$febtotal = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('feb');
        $data['martotal']=$martotal = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('mar');
        $data['aprtotal']=$aprtotal = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('apr');
        $data['maytotal']=$maytotal = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('may');
        $data['juntotal']=$juntotal = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('jun');
        $data['jultotal']=$jultotal = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('jul');
        $data['augtotal']=$augtotal = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('aug');
        $data['septotal']=$septotal = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('sep');
        $data['octtotal']=$octtotal = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('oct');
        $data['novtotal']=$novtotal = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('nov');
        $data['dectotal']=$dectotal = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('decem');
        $data['monthtotal']=$monthtotal = $data['jantotal'] + $data['febtotal'] + $data['martotal'] + $data['aprtotal'] + $data['maytotal'] + $data['juntotal'] + $data['jultotal'] + $data['augtotal'] + $data['septotal'] + $data['octtotal'] + $data['novtotal'] + $data['dectotal'];

        $data['chat']=$chat = "";
        $data['tools']=$tools = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] =$chat= "on";
            }
            else{
                $data['chat'] =$chat= "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] =$tools= "on";
            }
            else{
                $data['tools'] =$tools= "off";
            }
        }
        ob_start();
        ?>
            <div class="table-wrap">
                <table class="table table-striped table-bordered table-hover main-table" id="">
                    <thead>
                        <tr>
                            <th class=""></th>
                            <th>Jan</th>
                            <th>Feb</th>
                            <th>Mar</th>
                            <th>Apr</th>
                            <th>May</th>
                            <th>Jun</th>
                            <th>Jul</th>
                            <th>Aug</th>
                            <th>Sep</th>
                            <th>Oct</th>
                            <th>Nov</th>
                            <th>Dec</th>
                            <th>Total</th>
                            <th>Graph</th>
                        </tr>
                        <tr>
                            <th class="">
                                <!-- <a href="javascript:void(0);" class="add_button" title="Add field">
                                                   <span class="glyphicon glyphicon-plus" style="text-align: center; color: white; font-size: 20px; font-weight: bold"></span>
                                                   </a> -->
                            </th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th>Budget</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody class="field_wrapper">
                        <?php
                                       if(count($data['revenue']) > 0){
                                       ?>
                        <?php

                                             $currmon = date('m');
                                          $curryear=date('y');
                                             foreach ($revenue as $value) {
                                                if($curryear > date('y',strtotime($value->created_at))){
                                                $readonly="readonly";
                                                $disabled="disabled";
                                            }else{
                                                  $readonly="";
                                                    $disabled="";

                                                }
                                             ?>
                        <tr class="odd gradeX monthly" id="row<?= $value->id ?>">
                            <!-- <td class=""></td> -->
                            <td class="budget_name">
                                <!-- <select class="form-control" required disabled>
                                                   <option value="<?= $value->name ?>"><?= $value->name ?></option>
                                                   </select>
                                                   <p style="color: red; text-align: left; margin-bottom: 2px; display: none">*required</p> -->
                                <b style="padding: 0 10px" class="bname"><?= $value->name ?></b>
                            </td>
                            <td class="jan">
                                <input type="number" class="form-control" value="<?= $value->jan ?>"
                                    id="jan<?= $value->id ?>" <?php if($currmon >= "01"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="feb">
                                <input type="number" class="form-control" value="<?= $value->feb ?>"
                                    id="feb<?= $value->id ?>" <?php if($currmon >= "02"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="mar">
                                <input type="number" class="form-control" value="<?= $value->mar ?>"
                                    id="mar<?= $value->id ?>" <?php if($currmon >= "03"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="apr">
                                <input type="number" class="form-control" value="<?= $value->apr ?>"
                                    id="apr<?= $value->id ?>" <?php if($currmon >= "04"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="may">
                                <input type="number" class="form-control" value="<?= $value->may ?>"
                                    id="may<?= $value->id ?>" <?php if($currmon >= "05"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="jun">
                                <input type="number" class="form-control" value="<?= $value->jun ?>"
                                    id="jun<?= $value->id ?>" <?php if($currmon >= "06"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="jul">
                                <input type="number" class="form-control" value="<?= $value->jul ?>"
                                    id="jul<?= $value->id ?>" <?php if($currmon >= "07"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="aug">
                                <input type="number" class="form-control" value="<?= $value->aug ?>"
                                    id="aug<?= $value->id ?>" <?php if($currmon >= "08"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="sep">
                                <input type="number" class="form-control" value="<?= $value->sep ?>"
                                    id="sep<?= $value->id ?>" <?php if($currmon >= "09"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="oct">
                                <input type="number" class="form-control" value="<?= $value->oct ?>"
                                    id="oct<?= $value->id ?>" <?php if($currmon >= "10"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="nov">
                                <input type="number" class="form-control" value="<?= $value->nov ?>"
                                    id="nov<?= $value->id ?>" <?php if($currmon >= "11"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="dec">
                                <input type="number" class="form-control" value="<?= $value->decem ?>"
                                    id="dec<?= $value->id ?>" <?php if($currmon >= "12"){ ?> readonly
                                    <?php }else{ echo $readonly;} ?>>
                            </td>
                            <td class="budg_total">
                                <?= ($value->jan + $value->feb + $value->mar + $value->apr + $value->may + $value->jun + $value->jul + $value->aug + $value->sep + $value->oct + $value->nov + $value->decem) ?>
                            </td>
                            <td class="showgraph" id="showgraph<?= $value->id ?>">
                                <a href="<?php echo  url('monthly_projectionexp_chart')."/".$value->id ?>">
                                    <div id="bar-chart<?= $value->id ?>" style="height: 20px; width: 100%"></div>
                                </a>
                                <script type="text/javascript">
                                $(function() {
                                    "use strict";

                                    //BAR CHART
                                    var bar = new Morris.Bar({
                                        element: 'bar-chart<?= $value->id ?>',
                                        resize: true,
                                        data: [{
                                                y: '',
                                                a: <?= $value->jan ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->feb ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->mar ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->apr ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->may ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->jun ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->jul ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->aug ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->sep ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->oct ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->nov ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $value->decem ?>
                                            }
                                        ],
                                        barColors: ['#da291c'],
                                        xkey: 'y',
                                        ykeys: ['a'],
                                        labels: ['', ''],
                                        hideHover: 'auto',
                                        padding: 1,
                                    });
                                });
                                </script>
                            </td>
                        </tr>
                        <?php
                                             }
                                             ?>
                    </tbody>
                    <?php if($revenue_count == 0){ $style = "style='display:none'"; }else{ $style = "style=''"; } ?>
                    <tbody class="sectbody" <?= $style ?>>
                        <tr class="odd gradeX">
                            <!-- <td></td> -->
                            <td style="text-align:left; color:#da291c; padding: 10px; font-weight: bold">Total</td>
                            <td id="jantotal"><?= $jantotal ?></td>
                            <td id="febtotal"><?= $febtotal ?></td>
                            <td id="martotal"><?= $martotal ?></td>
                            <td id="aprtotal"><?= $aprtotal ?></td>
                            <td id="maytotal"><?= $maytotal ?></td>
                            <td id="juntotal"><?= $juntotal ?></td>
                            <td id="jultotal"><?= $jultotal ?></td>
                            <td id="augtotal"><?= $augtotal ?></td>
                            <td id="septotal"><?= $septotal ?></td>
                            <td id="octtotal"><?= $octtotal ?></td>
                            <td id="novtotal"><?= $novtotal ?></td>
                            <td id="dectotal"><?= $dectotal ?></td>
                            <td id="budget_total"><?= $monthtotal ?></td>
                            <td class="chart_monthly">
                                <a href="<?php echo  url('total_monthly_projectionexp_chart') ?>">
                                    <div id="bar-chart_total" style="height: 20px; width: 100%"></div>
                                </a>
                                <script type="text/javascript">
                                $(function() {
                                    "use strict";

                                    //BAR CHART
                                    var bar = new Morris.Bar({
                                        element: 'bar-chart_total',
                                        resize: true,
                                        data: [{
                                                y: '',
                                                a: <?= $jantotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $febtotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $martotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $aprtotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $maytotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $juntotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $jultotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $augtotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $septotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $octtotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $novtotal ?>
                                            },
                                            {
                                                y: '',
                                                a: <?= $dectotal ?>
                                            }
                                        ],
                                        barColors: ['#da291c'],
                                        xkey: 'y',
                                        ykeys: ['a'],
                                        labels: ['', ''],
                                        hideHover: 'auto',
                                        padding: 1,
                                    });
                                });
                                </script>
                            </td>
                        </tr>
                        <tr class="odd gradeX">
                            <!-- <td></td> -->
                            <td></td>
                            <td>
                                <a id="jansave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "01"){ ?> disabled
                                    <?php }else{ echo $disabled; } ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td>
                                <a id="febsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "02"){ ?> disabled
                                    <?php }else{ echo $disabled; } ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td>
                                <a id="marsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "03"){ ?> disabled
                                    <?php }else{ echo $disabled; } ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td>
                                <a id="aprsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "04"){ ?> disabled
                                    <?php }else{ echo $disabled; } ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td>
                                <a id="maysave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "05"){ ?> disabled
                                    <?php }else{ echo $disabled; } ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td>
                                <a id="junsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "06"){ ?> disabled
                                    <?php }else{ echo $disabled; } ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td>
                                <a id="julsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "07"){ ?> disabled
                                    <?php }else{ echo $disabled; } ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td>
                                <a id="augsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "08"){ ?> disabled
                                    <?php }else{ echo $disabled; } ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td>
                                <a id="sepsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "09"){ ?> disabled
                                    <?php }else{ echo $disabled; } ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td>
                                <a id="octsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "10"){ ?> disabled
                                    <?php }else{ echo $disabled; } ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td>
                                <a id="novsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "11"){ ?> disabled
                                    <?php }else{ echo $disabled; } ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td>
                                <a id="decsave" class="btn btn-info btn-xs savebtnmonth" style="width:60px;"
                                    <?php if($currmon >= "12"){ ?> disabled
                                    <?php }else{ echo $disabled; } ?>>Save</a><br>
                                <!-- <a href="#" class="btn btn-info btn-xs" style="margin-top:5px;width:60px;">Edit</a> -->
                            </td>
                            <td></td>
                            <td></td>
                        </tr>
                        <?php }
                                      else{?>
                        <tr>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td>No data found</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <?php
        $html=ob_get_clean();
        echo $html;
    }

    public function tab22_quaterly_year(Request $request){
        $year=$request->year;
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status']=$status = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links']=$links = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos']=$top_videos = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner']=$aabanner = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners']=$top_banners = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime']=$slidetime = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['revenue_quaterly']=$revenue_quaterly = DB::table('expense_quaterly_projection')->where('uid', $uid)->whereYear('created_at', $year)->orderBy('id', 'desc')->get();
        if(count($data['revenue_quaterly']) > 0){
            $data['revenue_quaterly_count']=$revenue_quaterly_count = $data['revenue_quaterly'][0]->id;
        }else{
            $data['revenue_quaterly_count']=$revenue_quaterly_count = 0;
        }
        $data['janmartotal']=$janmartotal = DB::table('expense_quaterly_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('janmar');
        $data['aprjuntotal']=$aprjuntotal = DB::table('expense_quaterly_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('aprjun');
        $data['julseptotal']=$julseptotal = DB::table('expense_quaterly_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('julsep');
        $data['octdectotal']=$octdectotal = DB::table('expense_quaterly_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('octdec');
        $data['quaterlytotal']=$quaterlytotal = $data['janmartotal'] + $data['aprjuntotal'] + $data['julseptotal'] + $data['octdectotal'];
        $data['chat']=$chat = "";
        $data['tools']=$tools = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] =$chat= "on";
            }
            else{
                $data['chat'] =$chat= "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] =$tools= "on";
            }
            else{
                $data['tools'] =$tools= "off";
            }
        }
        ob_start();
        ?>
            <table class="table table-striped table-bordered table-hover" id="">
                <thead>
                    <tr>
                        <th></th>
                        <th>Jan - Mar</th>
                        <th>Apr - Jun</th>
                        <th>Jul - Sep</th>
                        <th>Oct - Dec</th>
                        <th>Total</th>
                        <th>Graph</th>
                    </tr>
                    <tr>
                        <th class="">
                            <!-- <a href="javascript:void(0);" class="add_button2" title="Add field">
                                                            <span class="glyphicon glyphicon-plus" style="text-align: center; color: white; font-size: 20px; font-weight: bold"></span>
                                                        </a> -->
                        </th>
                        <th>Budget</th>
                        <th>Budget</th>
                        <th>Budget</th>
                        <th>Budget</th>
                        <th>Budget</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody class="field_wrapper2">
                    <?php
                                                    foreach ($revenue_quaterly as $value) {
                                                ?>
                    <tr class="odd gradeX quarterly" id="roww<?= $value->id ?>">
                        <!-- <td class=""></td> -->
                        <td class="budget_name">
                            <!-- <select class="form-control" required disabled>
                                                                    <option value="<?= $value->name ?>"><?= $value->name ?></option>
                                                                </select>
                                                                <p style="color: red; text-align: left; margin-bottom: 2px; display: none">*required</p> -->
                            <b style="padding: 0 10px" class="bname"><?= $value->name ?></b>
                        </td>
                        <td class="janmar">
                            <input type="number" class="form-control" value="<?= $value->janmar ?>"
                                id="janmar<?= $value->id ?>" readonly>
                        </td>
                        <td class="aprjun">
                            <input type="number" class="form-control" value="<?= $value->aprjun ?>"
                                id="aprjun<?= $value->id ?>" readonly>
                        </td>
                        <td class="julsep">
                            <input type="number" class="form-control" value="<?= $value->julsep ?>"
                                id="julsep<?= $value->id ?>" readonly>
                        </td>
                        <td class="octdec">
                            <input type="number" class="form-control" value="<?= $value->octdec ?>"
                                id="octdec<?= $value->id ?>" readonly>
                        </td>

                        <td class="budg_total2">
                            <?= ($value->janmar + $value->aprjun + $value->julsep + $value->octdec) ?>
                        </td>
                        <td class="showgraphq" id="showgraphq<?= $value->id ?>">
                            <a href="<?= url('quarterly_projectionexp_chart')."/".$value->id ?>">
                                <div id="bar-chartq<?= $value->id ?>" style="height: 20px; width: 30px"></div>
                            </a>
                            <script type="text/javascript">
                            $(function() {
                                "use strict";

                                //BAR CHART
                                var bar = new Morris.Bar({
                                    element: 'bar-chartq<?= $value->id ?>',
                                    resize: true,
                                    data: [{
                                            y: '',
                                            a: <?= $value->janmar ?>
                                        },
                                        {
                                            y: '',
                                            a: <?= $value->aprjun ?>
                                        },
                                        {
                                            y: '',
                                            a: <?= $value->julsep ?>
                                        },
                                        {
                                            y: '',
                                            a: <?= $value->octdec ?>
                                        }
                                    ],
                                    barColors: ['#da291c'],
                                    xkey: 'y',
                                    ykeys: ['a'],
                                    labels: ['', ''],
                                    hideHover: 'auto',
                                    padding: 1,
                                });
                            });
                            </script>
                        </td>
                    </tr>
                    <?php
                                                    }
                                                ?>
                </tbody>
                <?php if($revenue_quaterly_count == 0){ $style2 = "style='display:none'"; }else{ $style2 = "style=''"; } ?>
                <tbody class="sectbody2" <?= $style2 ?>>
                    <tr class="odd gradeX">

                        <!-- <td></td> -->
                        <td style="text-align:left; color:#da291c; padding: 10px; font-weight: bold">Total</td>
                        <td id="janmartotal"><?= $janmartotal ?></td>
                        <td id="aprjuntotal"><?= $aprjuntotal ?></td>
                        <td id="julseptotal"><?= $julseptotal ?></td>
                        <td id="octdectotal"><?= $octdectotal ?></td>
                        <td id="budget_total"><?= $quaterlytotal ?></td>

                        <td class="chart_quarterly">
                            <a href="<?=url('total_quarterly_projectionexp_chart')?>">
                                <div id="bar-chart_totalq" style="height: 20px; width: 30px"></div>
                            </a>
                            <script type="text/javascript">
                            $(function() {
                                "use strict";

                                //BAR CHART
                                var bar = new Morris.Bar({
                                    element: 'bar-chart_totalq',
                                    resize: true,
                                    data: [{
                                            y: '',
                                            a: <?= $janmartotal ?>
                                        },
                                        {
                                            y: '',
                                            a: <?= $aprjuntotal ?>
                                        },
                                        {
                                            y: '',
                                            a: <?= $julseptotal ?>
                                        },
                                        {
                                            y: '',
                                            a: <?= $octdectotal ?>
                                        }
                                    ],
                                    barColors: ['#da291c'],
                                    xkey: 'y',
                                    ykeys: ['a'],
                                    labels: ['', ''],
                                    hideHover: 'auto',
                                    padding: 1,
                                });
                            });
                            </script>
                        </td>

                    </tr>
                    <!-- <tr class="odd gradeX">
                                                    <td></td>
                                                    <td>
                                                        <a id="janmarsave" class="btn btn-info btn-xs savebtnquarter" style="width:60px;">Save</a><br>
                                                    </td>
                                                    <td>
                                                        <a id="aprjunsave" class="btn btn-info btn-xs savebtnquarter" style="width:60px;">Save</a><br>
                                                    </td>
                                                    <td>
                                                        <a id="julsepsave" class="btn btn-info btn-xs savebtnquarter" style="width:60px;">Save</a><br>
                                                    </td>
                                                    <td>
                                                        <a id="octdecsave" class="btn btn-info btn-xs savebtnquarter" style="width:60px;">Save</a><br>
                                                    </td>
                                                    <td></td>
                                                    <td></td>

                                                </tr> -->
                </tbody>
            </table>
            <?php
        $html=ob_get_clean();
        echo $html;
    }
    public function tab33()
    {
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status'] = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links'] = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos'] = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner'] = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners'] = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime'] = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['jantotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jan');
        $data['febtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('feb');
        $data['martotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('mar');
        $data['aprtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('apr');
        $data['maytotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('may');
        $data['juntotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jun');
        $data['jultotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jul');
        $data['augtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aug');
        $data['septotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('sep');
        $data['octtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('oct');
        $data['novtotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('nov');
        $data['dectotal'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('decem');
        $data['monthtotal'] = $data['jantotal'] + $data['febtotal'] + $data['martotal'] + $data['aprtotal'] + $data['maytotal'] + $data['juntotal'] + $data['jultotal'] + $data['augtotal'] + $data['septotal'] + $data['octtotal'] + $data['novtotal'] + $data['dectotal'];
        $data['jangrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('jan');
        $data['febgrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('feb');
        $data['margrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('mar');
        $data['aprgrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('apr');
        $data['maygrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('may');
        $data['jungrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('jun');
        $data['julgrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('jul');
        $data['auggrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('aug');
        $data['sepgrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('sep');
        $data['octgrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('oct');
        $data['novgrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('nov');
        $data['decgrosstotal2'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '!=', 'Other Revenue')->sum('decem');
        $data['monthgrosstotal2'] = $data['jangrosstotal2'] + $data['febgrosstotal2'] + $data['margrosstotal2'] + $data['aprgrosstotal2'] + $data['maygrosstotal2'] + $data['jungrosstotal2'] + $data['julgrosstotal2'] + $data['auggrosstotal2'] + $data['sepgrosstotal2'] + $data['octgrosstotal2'] + $data['novgrosstotal2'] + $data['decgrosstotal2'];
        $data['jangrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['febgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['margrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['aprgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['maygrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['jungrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['julgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['auggrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['sepgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['octgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['novgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['decgrossactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['monthgrossactual'] = $data['jangrossactual'] + $data['febgrossactual'] + $data['margrossactual'] + $data['aprgrossactual'] + $data['maygrossactual'] + $data['jungrossactual'] + $data['julgrossactual'] + $data['auggrossactual'] + $data['sepgrossactual'] + $data['octgrossactual'] + $data['novgrossactual'] + $data['decgrossactual'];
        $data['jantotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->sum('bill');
        $data['febtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->sum('bill');
        $data['martotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->sum('bill');
        $data['aprtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->sum('bill');
        $data['maytotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->sum('bill');
        $data['juntotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->sum('bill');
        $data['jultotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->sum('bill');
        $data['augtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->sum('bill');
        $data['septotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->sum('bill');
        $data['octtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->sum('bill');
        $data['novtotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->sum('bill');
        $data['dectotalactual'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->sum('bill');
        $data['monthtotalactual'] = $data['jantotalactual'] + $data['febtotalactual'] + $data['martotalactual'] + $data['aprtotalactual'] + $data['maytotalactual'] + $data['juntotalactual'] + $data['jultotalactual'] + $data['augtotalactual'] + $data['septotalactual'] + $data['octtotalactual'] + $data['novtotalactual'] + $data['dectotalactual'];
        $data['janothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('jan');
        $data['febothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('feb');
        $data['marothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('mar');
        $data['aprothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('apr');
        $data['mayothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('may');
        $data['junothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('jun');
        $data['julothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('jul');
        $data['augothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('aug');
        $data['sepothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('sep');
        $data['octothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('oct');
        $data['novothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('nov');
        $data['decothrevenue'] = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->where('name', '==', 'Other Revenue')->sum('decem');
        $data['monthothrevenue'] = $data['janothrevenue'] + $data['febothrevenue'] + $data['marothrevenue'] + $data['aprothrevenue'] + $data['mayothrevenue'] + $data['junothrevenue'] + $data['julothrevenue'] + $data['augothrevenue'] + $data['sepothrevenue'] + $data['octothrevenue'] + $data['novothrevenue'] + $data['decothrevenue'];
        $data['janotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->where('account_description', 'Other Revenue')->sum('bill');
        $data['febotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->where('account_description', 'Other Revenue')->sum('bill');
        $data['marotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->where('account_description', 'Other Revenue')->sum('bill');
        $data['aprotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->where('account_description', 'Other Revenue')->sum('bill');
        $data['mayotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->where('account_description', 'Other Revenue')->sum('bill');
        $data['junotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->where('account_description', 'Other Revenue')->sum('bill');
        $data['julotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->where('account_description', 'Other Revenue')->sum('bill');
        $data['augotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->where('account_description', 'Other Revenue')->sum('bill');
        $data['sepotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->where('account_description', 'Other Revenue')->sum('bill');
        $data['octotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->where('account_description', 'Other Revenue')->sum('bill');
        $data['novotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->where('account_description', 'Other Revenue')->sum('bill');
        $data['decotherrevenue'] = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->where('account_description', 'Other Revenue')->sum('bill');
        $data['monthotherrevenue'] = $data['janotherrevenue'] + $data['febotherrevenue'] + $data['marotherrevenue'] + $data['aprotherrevenue'] + $data['mayotherrevenue'] + $data['junotherrevenue'] + $data['julotherrevenue'] + $data['augotherrevenue'] + $data['sepotherrevenue'] + $data['octotherrevenue'] + $data['novotherrevenue'] + $data['decotherrevenue'];
        $data['expense'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->get();
        $data['jantotal2'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jan');
        $data['febtotal2'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('feb');
        $data['martotal2'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('mar');
        $data['aprtotal2'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('apr');
        $data['maytotal2'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('may');
        $data['juntotal2'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jun');
        $data['jultotal2'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('jul');
        $data['augtotal2'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('aug');
        $data['septotal2'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('sep');
        $data['octtotal2'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('oct');
        $data['novtotal2'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('nov');
        $data['dectotal2'] = DB::table('expense_projection')->where('uid', $uid)->whereYear('created_at', date('Y'))->sum('decem');
        $data['monthtotal2'] = $data['jantotal2'] + $data['febtotal2'] + $data['martotal2'] + $data['aprtotal2'] + $data['maytotal2'] + $data['juntotal2'] + $data['jultotal2'] + $data['augtotal2'] + $data['septotal2'] + $data['octtotal2'] + $data['novtotal2'] + $data['dectotal2'];
        $data['jantotal2actual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '01')->sum('amount_paid');
        $data['febtotal2actual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '02')->sum('amount_paid');
        $data['martotal2actual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '03')->sum('amount_paid');
        $data['aprtotal2actual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '04')->sum('amount_paid');
        $data['maytotal2actual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '05')->sum('amount_paid');
        $data['juntotal2actual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '06')->sum('amount_paid');
        $data['jultotal2actual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '07')->sum('amount_paid');
        $data['augtotal2actual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '08')->sum('amount_paid');
        $data['septotal2actual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '09')->sum('amount_paid');
        $data['octtotal2actual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '10')->sum('amount_paid');
        $data['novtotal2actual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '11')->sum('amount_paid');
        $data['dectotal2actual'] = DB::table('expense_record')->where('uid', $uid)->whereYear('transaction_date', date('Y'))->whereMonth('transaction_date', '12')->sum('amount_paid');
        $data['monthtotal2actual'] = $data['jantotal2actual'] + $data['febtotal2actual'] + $data['martotal2actual'] + $data['aprtotal2actual'] + $data['maytotal2actual'] + $data['juntotal2actual'] + $data['jultotal2actual'] + $data['augtotal2actual'] + $data['septotal2actual'] + $data['octtotal2actual'] + $data['novtotal2actual'] + $data['dectotal2actual'];
        $data['chat'] = "";
        $data['tools'] = "";
        if(Auth::user()->role == "affiliate_user"){
            $cdet = DB::table('user_menu_access2')->where('uemail', Auth::user()->email)->first();
            if($cdet->chat == "on"){
                $data['chat'] = "on";
            }
            else{
                $data['chat'] = "off";
            }
            if($cdet->tools == "on"){
                $data['tools'] = "on";
            }
            else{
                $data['tools'] = "off";
            }
        }
        $data['years'] = [];
        for($i = 0; $i < 10; $i++){
            $lastYear = date("Y", strtotime("-$i years"));
            if($lastYear > 2019){
                array_push($data['years'], $lastYear);
            }
        }
        return view('tab33')->with($data);
    }


    public function tab33_year(Request $request)
    {
        $year=$request->year;
        if(Auth::id() == NULL){
            return redirect('/')->with('status',"Please login or register to access this page.");
        }
        if((Auth::user()->role == "temp_user") || (Auth::user()->role == "client")){
            return redirect('/')->with('status', "You can't access this page.");
        }
        if(Auth::user()->role == "admin"){
                return redirect('/')->with('status',"Admin can't access this page.");
            }
        $uid = "";
        if((Auth::user()->role) == "affiliate"){
            $uid = Auth::id();
        }
        else{
            $uid = Auth::user()->affiliate_user_id;
        }
        $data['status']=$status = DB::table('affiliatebtn')->where('id', 1)->get();
        $data['links']=$links = Menulinks::get();
        $now = date('Y-m-d');
        $data['top_videos']=$top_videos = HomeTopVideo::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now], ['display', "show"]])->get();
        $aaid = "";
        if((Auth::user()->role) == "affiliate"){
            $aaid = Auth::user()->email;
        }
        else{
            $aaid = Auth::user()->affiliate_user_email;
        }
        $data['aabanner']=$aabanner = DB::table('affiliate_banner')->where('affiliate_email', $aaid)->get();
        $data['top_banners']=$top_banners = FinancialManagementBanner::select('*')->where([['status', "on"], ['startdate', '<=', $now], ['enddate', '>=', $now]])->get();
        $data['slidetime']=$slidetime = DB::table('carouselplaytime')->where('id', 1)->get();
        $data['jantotal']=$jantotal = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('jan');
        $data['febtotal']=$febtotal = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('feb');
        $data['martotal']=$martotal = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('mar');
        $data['aprtotal']=$aprtotal = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('apr');
        $data['maytotal']=$maytotal = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('may');
        $data['juntotal']=$juntotal = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('jun');
        $data['jultotal']=$jultotal = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('jul');
        $data['augtotal']=$augtotal = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('aug');
        $data['septotal']=$septotal = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('sep');
        $data['octtotal']=$octtotal = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('oct');
        $data['novtotal']=$novtotal = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('nov');
        $data['dectotal']=$dectotal = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->sum('decem');
        $data['monthtotal']=$monthtotal = $data['jantotal'] + $data['febtotal'] + $data['martotal'] + $data['aprtotal'] + $data['maytotal'] + $data['juntotal'] + $data['jultotal'] + $data['augtotal'] + $data['septotal'] + $data['octtotal'] + $data['novtotal'] + $data['dectotal'];
        $data['jangrosstotal2']=$jangrosstotal2 = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('jan');
        $data['febgrosstotal2']=$febgrosstotal2 = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('feb');
        $data['margrosstotal2']=$margrosstotal2 = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('mar');
        $data['aprgrosstotal2']=$aprgrosstotal2 = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('apr');
        $data['maygrosstotal2']=$maygrosstotal2 = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('may');
        $data['jungrosstotal2']=$jungrosstotal2 = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('jun');
        $data['julgrosstotal2']=$julgrosstotal2 = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('jul');
        $data['auggrosstotal2']=$auggrosstotal2 = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('aug');
        $data['sepgrosstotal2']=$sepgrosstotal2 = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('sep');
        $data['octgrosstotal2']=$octgrosstotal2 = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('oct');
        $data['novgrosstotal2']=$novgrosstotal2 = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('nov');
        $data['decgrosstotal2']=$decgrosstotal2 = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '!=', 'Other Revenue')->sum('decem');
        $data['monthgrosstotal2']=$monthgrosstotal2 = $data['jangrosstotal2'] + $data['febgrosstotal2'] + $data['margrosstotal2'] + $data['aprgrosstotal2'] + $data['maygrosstotal2'] + $data['jungrosstotal2'] + $data['julgrosstotal2'] + $data['auggrosstotal2'] + $data['sepgrosstotal2'] + $data['octgrosstotal2'] + $data['novgrosstotal2'] + $data['decgrosstotal2'];
        $data['jangrossactual']=$jangrossactual=$jangrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '01')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['febgrossactual']=$febgrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '02')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['margrossactual']=$margrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '03')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['aprgrossactual']=$aprgrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '04')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['maygrossactual']=$maygrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '05')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['jungrossactual']=$jungrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '06')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['julgrossactual']=$julgrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '07')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['auggrossactual']=$auggrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '08')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['sepgrossactual']=$sepgrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '09')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['octgrossactual']=$octgrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '10')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['novgrossactual']=$novgrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '11')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['decgrossactual']=$decgrossactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '12')->where('account_description', '!=', 'Other Revenue')->sum('bill');
        $data['monthgrossactual']=$monthgrossactual = $data['jangrossactual'] + $data['febgrossactual'] + $data['margrossactual'] + $data['aprgrossactual'] + $data['maygrossactual'] + $data['jungrossactual'] + $data['julgrossactual'] + $data['auggrossactual'] + $data['sepgrossactual'] + $data['octgrossactual'] + $data['novgrossactual'] + $data['decgrossactual'];
        $data['jantotalactual'] =$jantotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '01')->sum('bill');
        $data['febtotalactual'] =$febtotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '02')->sum('bill');
        $data['martotalactual'] =$martotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '03')->sum('bill');
        $data['aprtotalactual'] =$aprtotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '04')->sum('bill');
        $data['maytotalactual'] =$maytotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '05')->sum('bill');
        $data['juntotalactual'] =$juntotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '06')->sum('bill');
        $data['jultotalactual'] =$jultotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '07')->sum('bill');
        $data['augtotalactual'] =$augtotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '08')->sum('bill');
        $data['septotalactual'] =$septotalactual= DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '09')->sum('bill');
        $data['octtotalactual']=$octtotalactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '10')->sum('bill');
        $data['novtotalactual']=$novtotalactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '11')->sum('bill');
        $data['dectotalactual']=$dectotalactual = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '12')->sum('bill');
        $data['monthtotalactual']=$monthtotalactual = $data['jantotalactual'] + $data['febtotalactual'] + $data['martotalactual'] + $data['aprtotalactual'] + $data['maytotalactual'] + $data['juntotalactual'] + $data['jultotalactual'] + $data['augtotalactual'] + $data['septotalactual'] + $data['octtotalactual'] + $data['novtotalactual'] + $data['dectotalactual'];
        $data['janothrevenue']=$janothrevenue = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('jan');
        $data['febothrevenue']=$febothrevenue = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('feb');
        $data['marothrevenue']=$marothrevenue = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('mar');
        $data['aprothrevenue']=$aprothrevenue = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('apr');
        $data['mayothrevenue'] =$mayothrevenue = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('may');
        $data['junothrevenue'] =$junothrevenue = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('jun');
        $data['julothrevenue'] =$julothrevenue = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('jul');
        $data['augothrevenue'] =$augothrevenue = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('aug');
        $data['sepothrevenue'] =$sepothrevenue = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('sep');
        $data['octothrevenue'] =$octothrevenue = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('oct');
        $data['novothrevenue'] =$novothrevenue = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('nov');
        $data['decothrevenue'] =$decothrevenue = DB::table('revenue_projection')->where('uid', $uid)->whereYear('created_at', $year)->where('name', '==', 'Other Revenue')->sum('decem');
        $data['monthothrevenue']=$monthothrevenue = $data['janothrevenue'] + $data['febothrevenue'] + $data['marothrevenue'] + $data['aprothrevenue'] + $data['mayothrevenue'] + $data['junothrevenue'] + $data['julothrevenue'] + $data['augothrevenue'] + $data['sepothrevenue'] + $data['octothrevenue'] + $data['novothrevenue'] + $data['decothrevenue'];
        $data['janotherrevenue']=$janotherrevenue = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '01')->where('account_description', 'Other Revenue')->sum('bill');
        $data['febotherrevenue']=$febotherrevenue = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '02')->where('account_description', 'Other Revenue')->sum('bill');
        $data['marotherrevenue']=$marotherrevenue = DB::table('revenue_record')->where('uid', $uid)->whereYear('transaction_date', $year)->whereMonth('transaction_date', '03')->where('account_description', 'Other Revenue')->sum('bill');
        $data['aprotherrevenue']=$aprotherrevenue =